/*  hdump.c			letzte nderung: 2.2.2007 */
char *VERSION="1.2";
/*
;ALPHA> cx hdump
;ALPHA> link hdump
Unix> make

29.9.1994 V1.1	Erstellung (RPf)
1.2.2007  V1.2	Anpassung an UTF8
*/

#define DEFAULT_UTF8
//#define DEFAULT_ISOLATIN1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define BREITE 16

#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

int ausgabenwandlung(int i,int c,int *pc1,int *pc2);

main(int argc, char **argv)
{
 FILE *fp;
 char name[200],tab[4*BREITE+1];
 int i,c,c1,c2,adr,j,n,k;
 long maxlaenge= -1;
 name[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   j=0;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
        {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
         else   {if(++j==1) strcpy(name,argv[i]);
                 else if(j==2) sscanf(argv[i],"%ld",&maxlaenge);
        }       }
 if(argflag['?'] || argflag['H'] || j>MAXARG)
	{printf("hdump  Version %s\n",VERSION);
	 printf("Anwendung: hdump [-Flags] Datei [MaxLaenge]\n");
	 printf("  Flags: u=UTF8-Datei\n");
	 printf("         t=UTF8-Ausgabe\n");
	 printf("         i=ISO-LATIN1-Datei\n");
	 printf("         s=ISO-LATIN1-Ausgabe\n");
	 printf("Beispiele:\n");
	 printf("  hdump -ut test1.dat  #UTF8 auf UTF8-System ausgeben\n");
	 printf("  hdump -is test2.dat  #ISO-Latin1 auf ISO-Latin1\n");
	 printf("  hdump -us test1.dat  #UTF8 auf ISO-Latin1 ausgeben\n");
	 printf("  hdump -it test2.dat  #ISO-Latin1 auf UTF8 ausgeben\n");
	 return 0;
	}
#ifdef DEFAULT_UTF8
 if(!argflag['U'] && !argflag['I']) argflag['U']=1;
 if(!argflag['T'] && !argflag['S']) argflag['T']=1;
#else
 if(!argflag['U'] && !argflag['I']) argflag['I']=1;
 if(!argflag['T'] && !argflag['S']) argflag['S']=1;
#endif
 if(name[0]==0) {printf("File:");scanf("%s",name);}
 if((fp=fopen(name,"rb"))==0)
	{printf("'%s' nicht gefunden\n",name); exit(0);}
 k=i=0; printf("%04X: ",adr=0);
 while((c=getc(fp)) != EOF)
	{if(i&1) printf("%02X ",c);
	 else    printf("%02X",c);
	 n=ausgabenwandlung(i,c,&c1,&c2);
	 if(n>=1) tab[k++]=c1;
	 if(n==2) tab[k++]=c2;
	 if(++i == BREITE)
	   {tab[k]=0; k=i=0; printf("%s\n%04X: ",tab,adr += BREITE);}
	 if(maxlaenge>0 && --maxlaenge==0) break;
	}
 tab[k]=0;
 while(i++ < BREITE)
	{printf("  "); if((i&1)==0) printf(" ");}
 printf("%s\n", tab);
 if(maxlaenge==0) printf("...\n");
 fclose(fp);
}	/* end of main */

int ausgabenwandlung(int i,int c,int *pc1,int *pc2)
{
 int n,c1,c2=0;
 static int flag=0,a0=0,a1;
 if(c<' ' && flag==0)
   {c1='.'; n=1;}
 else if(argflag['U'] && argflag['T']) //Ein- und Ausgabe UTF8
   {c1=c; n=1;
    if(a0==1)
      {c1=a1; c2=c; n=2; a0=0;}
    else if(i==BREITE-1 && c&0x80) {a0=1; a1=c; n=0;}
   }
 else if(argflag['I'] && argflag['S']) //Ein- und Ausgabe ISO-Latin1
   {c1=c; n=1;
    //c2=c&0x7F; if(!isprint(c2)) c1='.'; //altes Verhalten
   }
 else if(argflag['I'] && argflag['T']) //Eingabe ISO, Ausgabe UTF8
   {if((c&0x80)==0)
      {c1=c; n=1;}
    else
      {c1=0xC0+((c&0xC0)>>6);
       c2=0x80+(c&0x3F);
       n=2;
      }
   }
 else //if(argflag['U'] && argflag['S']) //Eingabe UTF8, Ausgabe ISO
   {if(a0==1)
      {if((c&0xC0)==0x80)
	{c1=' '; c2=(c&0x3F)+((a1&0x03)<<6);
	 if(i==0) {c1=c2; n=1;} else n=2;
	}
       else
	{c1=a1; c2=c; n=2;}
       a0=0;
      }
    else if(c==0xC2 || c==0xC3)
      {a0=1; a1=c;
       if(i==BREITE-1) {c1=' '; n=1;} else n=0;
      }
    else
      {c1=c; n=1;}
   }
 *pc1=c1;
 *pc2=c2;
 return n;
}
