/* pretty.cc  PostScript Pretty-Printer		letzte nderung:14.6.1996 */
static char *VERSION="0.1";
/*
History:
14.6.1996	Version 0.1 Erstellung (Rolf Pfister)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define MAXARG 1

/************************ Vordeklarationen *******************************/
void pretty(FILE *fp,FILE *fp2);
/*************************************************************************/
/*int istarchiv(char *name) {return strcmp(&name[strlen(name)-3],".ar")==0;}*/

void usage()
{
 printf("pretty Version %s\n",VERSION);
 printf("Anwendung: pretty Name.ps >Ziel.ps\n");
 exit(0);
}

static char argflag['Z'+1];
void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

main(int argc,char *argv[])
{
 FILE *fp;
 int i,j;
 char name[80],*rstring="r",*wstring="w";
 for(name[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(name,argv[i]); break;
        }
 if(j>MAXARG+1 || name[0]=='?' || argflag['?']) usage();
 if(name[0]==0)
   {printf("Quelldatei:"); scanf("%s",name);
   }
 if(!(fp=fopen(name,rstring)))
	{printf("'%s' nicht gefunden\n",name); exit(0);}
 pretty(fp,stdout);
 fclose(fp);
}

static int tab=0;

void neuezeile(FILE *fp2,int c=0)
{
 int i,j;
 putc('\n',fp2);
 for(j=0;j<tab;j++)
   for(i=0;i<2;i++) putc(' ',fp2);
 if(c) putc(c,fp2);
 else if(tab!=0) putc(' ',fp2);
}

void pretty(FILE *fp,FILE *fp2)
{
 int c;
 while((c=getc(fp))!=EOF)
   {if(c=='{') {tab++; neuezeile(fp2,c);}
    else if(c=='}')
      {neuezeile(fp2,c);
       if(--tab<0) {printf("Fehler in PS-Datei: Fehlendes '{'\n"); tab=0;}
//       neuezeile(fp2);
      }
    else if(c=='/') {neuezeile(fp2); putc(c,fp2);}
    else if(c=='\n') neuezeile(fp2);
    else putc(c,fp2);
   }
}

/*************************** kleinkram ***********************************/
