/* umcop.c			letzte nderung: 4.9.1998 */
static char *VERSION="1.3";
/*
;ALPHA> cx umcop
;ALPHA> link umcop
;VAX> ck umcop

History:
30.9.1994	Version 1.1 Erstellung (Rolf Pfister)
2.2.96		Korrektur falls Zielname gleich Quellname ist
4.9.98		als Cod auch SS erlauben, AS fuer automatische FormatErkennung
		neu auch H fuer HTML-Format (AH SH)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define MAXARG 3

/************************ Vordeklarationen *******************************/
char *machgross(char *);
void setzetrenner(char *);
void trenn(int,FILE *);
void umcop(FILE *,FILE *);
void umcop2(FILE *,FILE *);
int copy(char *von,char *nach);
FILE *fopentmp(char *tmpname,char *w);
void deletefile(char *name);
void aktuelles_format_ermitteln(char *cod,char *name);
/*************************************************************************/
/*int istarchiv(char *name) {return strcmp(&name[strlen(name)-3],".ar")==0;}*/

void usage()
{
 printf("UMCOP Version %s\n",VERSION);
 printf("Anwendung: UMCOP Name1.txt [Name2.txt] [Cod] [-Flags]\n");
 printf("  Cod muss aus 2 Buchstaben bestehen:\n");
 printf("      IS = von IBM- auf Standard-Format wandeln\n");
 printf("      MS = von MAC- auf Standard-Format wandeln\n");
 printf("      SH = von Standard- auf HTML-Format wandeln\n");
 printf("      AS = Format Automatisch ermitteln und auf Standard-Format wandeln\n");
 printf("      SS = Keine Wandlung machen (ausser Zeilentrennerzeichen)\n");
 printf("      SI MI SM IM MH IH AI AM AH = entsprechend wandeln\n");
 printf("  Flags:\n");
 printf("      A = nur LF als Zeilentrenner verwenden (Cod-Voreinstellung=IS)\n");
 printf("      I = immer CR LF als Zeilentrenner verwenden (Cod-Voreinst.=SI)\n");
 printf("      C = nur CR als Zeilentrenner verwenden (Cod-Voreinst.=SM)\n");
 printf("      X = Datei im Textmodus ffnen\n");
 exit(0);
}

#define ANZUML 6
char s2i[256],i2s[256],m2s[256],s2m[256],i2m[256],m2i[256],
     s2h[256],h2s[256],s2s[256],m2h[256],i2h[256];
char *wandle;
char STDuml[]={0xE4,0xF6,0xFC,0xC4,0xD6,0xDC},
     IBMuml[]={0x84,0x94,0x81,0x8E,0x99,0x9A},
     MACuml[]={0x8A,0x9A,0x9F,0x80,0x85,0x86},
     HTMuml[]={ 'a', 'o', 'u', 'A', 'O', 'U'};
static int htmlflag=0;

#define istsonderzeichen(c) ((c)>0x7F)

void put_html_sonderzeichen(int c,FILE *fp2)
{
 fprintf(fp2,"&%cuml;",wandle[c]);
}

void init1(char *tab1,char *tab2,char *um1,char *um2)
{
 int i,c1,c2; char *u1,*u2;
 for(i=0,u1=um1,u2=um2;i<ANZUML;i++)
	{c1= *u1++ & 0xFF; c2= *u2++ & 0xFF; tab1[c1]=c2; tab2[c2]=c1;}
}
void initcodtab()
{
 int i;
 for(i=0;i<256;i++)
   s2i[i]=i2s[i]=m2s[i]=s2m[i]=i2m[i]=m2i[i]=
     s2h[i]=h2s[i]=s2s[i]=m2h[i]=i2h[i]=i;
 init1(s2i,i2s,STDuml,IBMuml);
 init1(s2m,m2s,STDuml,MACuml);
 init1(m2i,i2m,MACuml,IBMuml);
 init1(s2h,h2s,STDuml,HTMuml);
 init1(m2h,h2s,MACuml,HTMuml);
 init1(i2h,h2s,IBMuml,HTMuml);
}

static char argflag['Z'+1];
setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

main(int argc,char *argv[])
{
 FILE *fp,*fp2;
 int i,j;
 char name1[80],name2[80],cod[80],tmpname[80],*rstring,*wstring;
 initcodtab();
 tmpname[0]=0;
 for(name1[0]=name2[0]=cod[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(name1,argv[i]); break;
         case 2:strcpy(name2,argv[i]); break;
         case 3:strcpy(cod,argv[i]); break;
        }
 if(j>MAXARG+1 || name1[0]=='?' || argflag['?']) usage();
 if(cod[0]==0 && name1[0]!=0 && name2[0]!=0 && name2[2]==0)
   {if(name2[1]==0) usage();
    strcpy(cod,name2); name2[0]=0;
   }
 if(name1[0]==0)
   {printf("Quelldatei:"); scanf("%s",name1);
    if(name2[0]==0) {printf("Zieldatei:"); scanf("%s",name2);}
   }
 if(name2[0]==0) strcpy(name2,name1); /* Zielname ist Quellname */
 if(cod[0]==0)
	{if(argflag['A']) strcpy(cod,"IS");
	 else if(argflag['I']) strcpy(cod,"SI");
	 else if(argflag['C']) strcpy(cod,"SM");
	 else {printf("Wandlung (z.B. IM fr IBM-->MAC):"); scanf("%s",cod);}
	}
 machgross(cod);
 if(*cod=='A') aktuelles_format_ermitteln(cod,name1);
 if(strcmp(cod,"IS")==0) wandle=i2s;
 else if(strcmp(cod,"SI")==0) wandle=s2i;
 else if(strcmp(cod,"MS")==0) wandle=m2s;
 else if(strcmp(cod,"SM")==0) wandle=s2m;
 else if(strcmp(cod,"IM")==0) wandle=i2m;
 else if(strcmp(cod,"MI")==0) wandle=m2i;
 else if(strcmp(cod,"SH")==0) {wandle=s2h; htmlflag=1;}
 else if(strcmp(cod,"MH")==0) {wandle=m2h; htmlflag=1;}
 else if(strcmp(cod,"IH")==0) {wandle=i2h; htmlflag=1;}
 else if(strcmp(cod,"SS")==0 || *cod=='A') wandle=s2s;
 else usage();
 if(argflag['X']) {rstring="r"; wstring="w";}
 else		 {rstring="rb"; wstring="wb";}
 if(!(fp=fopen(name1,rstring)))
	{printf("'%s' nicht gefunden\n",name1); exit(0);}
 if(strcmp(name1,name2)==0) fp2=fopentmp(tmpname,wstring);
/* else if(istarchiv(name2)) fp2=fopen(name2,"ab"); */
 else fp2=fopen(name2,wstring);
 if(!fp2)
	{printf("kann '%s' nicht ffnen\n",name2); fclose(fp); exit(0);}
 if(argflag['I']) {setzetrenner("\015\012");/* CR LF */ umcop2(fp,fp2);}
 else if(argflag['A']) {setzetrenner("\012");/* LF */ umcop2(fp,fp2);}
 else if(argflag['C']) {setzetrenner("\015");/* CR */ umcop2(fp,fp2);}
 else umcop(fp,fp2);
 fclose(fp); fclose(fp2);
 if(tmpname[0]) {if(copy(tmpname,name2)) deletefile(tmpname);}
}

void umcop(FILE *fp,FILE *fp2)
{
 int c;
 if(htmlflag)
   while((c=getc(fp))!=EOF)
     {if(istsonderzeichen(c)) put_html_sonderzeichen(c,fp2);
      else putc(c,fp2);
     }
 else
   {while((c=getc(fp))!=EOF) putc(wandle[c],fp2);}
}
void umcop2(FILE *fp,FILE *fp2)
{
 int c;
 while((c=getc(fp))!=EOF) trenn(wandle[c],fp2);
 trenn(EOF,fp2);
}

/*************************** kleinkram ***********************************/
#define CR 0x0D
#define LF 0x0A

static char *trenner;
void setzetrenner(char *tre) {trenner=tre;}
void puttrenner(FILE *fp)
{
 char* s=trenner; int c;
 while(c= *s++) putc(c,fp);
}

void trenn(int c,FILE *fp)
{
 static int c1=0;
 int x;
 if(c==CR)
	{if(c1==LF) {puttrenner(fp); c1=0;}
	 else if(c1==CR) {puttrenner(fp); c1=c;}
	 else c1=c;
	 return;
	}
 if(c==LF)
	{if(c1==LF) {puttrenner(fp); c1=c;}
	 else if(c1==CR) {puttrenner(fp); c1=0;}
	 else c1=c;
	 return;
	}
 if(c1!=0) {puttrenner(fp); c1=0;}
 if(c!=EOF) putc(c,fp);
}

char *machgross(char *s)
{
 char *t=s;
 int c;
 while(c= *t)  *t++ = toupper(c);
 return s;
}

int copy(char *von,char *nach)
{
 FILE *fp1,*fp2;
 int c;
 if(!(fp1=fopen(von,"r")))
   {printf("kann '%s' nicht mehr finden!\n",von); return 0;}
 if(!(fp2=fopen(nach,"w")))
   {fclose(fp1); printf("konnte '%s' nicht umkopieren!\n",von); return 0;}
 while((c=getc(fp1))!=EOF) putc(c,fp2);
 fclose(fp1); fclose(fp2);
 return 1;
}

FILE *fopentmp(char *tmpname,char *w)
{
 FILE *fp;
 int i;
 for(i=0;;i++)
   {sprintf(tmpname,"tmp%d.dat",i);
    if((fp=fopen(tmpname,"rb"))==NULL) break;
    else fclose(fp);
   }
 fp=fopen(tmpname,w);
 if(!fp) tmpname[0]=0;
 return fp;
}

void deletefile(char *name)
{
 char str[80];
#ifdef VAX
 sprintf(str,"delete %s;",name);
#else
 sprintf(str,"delete %s",name);
#endif
 system(str);
}

/*********************** neu ab Version 1.3 ******************************/
void aktuelles_format_ermitteln(char *cod,char *name)
{
 FILE *fp;
 int c,c1,c0,i;
 char a;
 if(!(fp=fopen(name,"r"))) return;
 c0=0;
 while((c=getc(fp))!=EOF && c0==0)
   if((c &= 0xFF)>0x7F && c!=0x9A)
     {for(a=c,i=0;i<ANZUML && c0==0;i++)
       if(a==STDuml[i]) c0='S';
       else if(a==IBMuml[i]) c0='I';
       else if(a==MACuml[i]) c0='M';
     }
 if(c0!=0) {*cod=c0; printf("Automatisch erkanntes Format von '%s': '%c'\n",
			    name,c0);
	   }
 else printf("umcop konnte Format von '%s' nicht erkennen\n",name);
 fclose(fp);
}
