/* ver.c					letzte Aenderung:2.5.1993 */
#define VERSION "Version 1.2"
/* Kurzbeschreibung: Vergleich von 2 Dateien, und Ausdruck der Unterschiede
Uebersetzen VAX:
 CX ver
@LINK ver,SYS$INPUT/OPT
SYS$SHARE:DECW$DWTLIBSHR/SHARE
Uebersetzen Amiga:
;> c++ ver.cc -o ver -O2

History:
2.5.1993 Version 1.1	Erstellt auf Amiga
10.8.98		 1.2	Anpassungen an MAC
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define MAXARG 2
/*#define CPLUSPLUS */
#define MAXZEIL 120

/** speziell auf MAC: **/
/*#define CDimagesTesten 1*/

/*************************** globale Parameter ************************/
char para1[80],para2[80],argflag['Z'+1];

void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

long adr;
char zeile[MAXZEIL];
int izaehler=0;

/** Vordeklarationen: **/
void ausdrucken(int,int);
void flush();

/******************************* Kleinkram ****************************/
#define getline mygetline

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/***************************** Hauptprogramm **************************/
#ifdef CDimagesTesten
void help()
{
 printf("um CD-images zu vergleichen:\n");
 printf("Alias auf images erstellen, in image1 und image2 umbenennen\n");
 printf("und in aktuelles Verzeichnis legen.\n");
}
#else
void help()
{
}
#endif

char** argslesen(int* argc)
{
 static char argzeile[120],arg1[80],arg2[80],arg3[80];
 static char *myargv[]={"ver",arg1,arg2,arg3,NULL};
#ifdef CDimagesTesten
 strcpy(argzeile,"image1 image2 -CU");
#else
 printf("Argumente:"); getline(stdin,argzeile,120);
#endif
 *argc=1+sscanf(argzeile,"%s %s %s",arg1,arg2,arg3);
 return myargv;
}

main(int argc,char *argv[])
{
 register int c1,c2;
 register long nunterschiede;
 register FILE *fp1,*fp2;
 int i,j;
 if(argc==0)
    argv=argslesen(&argc);
 for(para1[0]=para2[0]=0,i=j=1;i<argc;i++)
    if(*argv[i]=='-') setflags(argv[i]);
    else switch(j++)
        {case 1:strcpy(para1,argv[i]); break;
         case 2:strcpy(para2,argv[i]); break;
        }
 if(j>MAXARG+1 || para1[0]=='?')
	{printf("Ver %s\n",VERSION);
	 printf("Anwendung: VER File1 File2 [-Flags]\n");
	 printf("    Flags: G=gleiche,  U=ungleiche Teile ausdrucken\n");
	 printf("           A=nur ASCII   H=nur Hexdump\n");
	 printf("           C=CD-Images vergleichen\n");
	 exit(0);
	}
 if(para1[0]==0) {printf("File1:"); scanf("%s",para1);}
 if(para2[0]==0) {printf("File2:"); scanf("%s",para2);}
/*** alle Argumente gelesen ***/
 if((fp1=fopen(para1,"r"))==0)
	{printf("'%s' nicht gefunden\n",para1); help(); exit(0);}
 if((fp2=fopen(para2,"r"))==0)
	{fclose(fp1); printf("'%s' nicht gefunden\n",para2); help(); exit(0);}
 nunterschiede=0; zeile[0]=0;
 if(argflag['G']==0 && argflag['U']==0)
   while((c1=getc(fp1))!=EOF && (c2=getc(fp2))!=EOF)
	{if(c1!=c2) nunterschiede++;}
 else
   for(adr=0; (c1=getc(fp1))!=EOF && (c2=getc(fp2))!=EOF; adr++)
	if(c1==c2) {if(argflag['G']) ausdrucken(c1,c2);}
	else	   {nunterschiede++; if(argflag['U']) ausdrucken(c1,c2);}
 if(zeile[0]) flush();
 if(c1==EOF) c2=getc(fp2);
 if(c1!=EOF) printf("'%s' ist laenger\n",para1);
 if(c2!=EOF) printf("'%s' ist laenger\n",para2);
 if(nunterschiede==0)
	{if(c1==EOF && c2==EOF) printf("Die Files sind identisch\n");
	 else printf("der Anfang ist aber gleich\n");
	}
 else	printf("%d Unterschiede\n",nunterschiede);
 fclose(fp1);
 fclose(fp2);
} /* end of main */

#define A2HEX(x) ((c=((x)&0x0F)+'0')<='9'?c:c+'A'-'9'-1)

void ausdrucken(int c1,int c2)
{
 int	n=10,k,c,
	m=21, /* n+n+1 */
	m2=43;/* m+m+1 */
 static int j;
 static long altadr= -1;
 if(argflag['A']) {n=32; m=n+n+1; m2=0;}
 else if(argflag['H']) {n=16; m=n+n+1;}
/** Beispielzeilen:
123456: 61626364656667681213 6A6B3132333435361213  abcdefgh..  ABCDEFGH..
123456: 61626364656667681213141513131516 6A6B3132333435361213141513141516
123456: abcdefgh..1234567890123456789012  ABCDEFGH..1234567890123456789012
**/
 if(altadr>=0 && altadr+1!=adr) flush();
 altadr=adr;
 if(izaehler==0)
	{sprintf(zeile,"%06X: ",adr); izaehler=8;
	 for(j=izaehler;j<MAXZEIL;j++) zeile[j]=' ';
	 j=0;
	}
 if(n!=32)
  {zeile[k=izaehler+j]=A2HEX(c1>>4); zeile[k+1]=A2HEX(c1);
   zeile[k+=m]=A2HEX(c2>>4); zeile[++k]=A2HEX(c2);
  }
 if(n!=16)
  {zeile[k=izaehler+m2]=(isprint(c1))?c1:'.';
   zeile[k+=n+2]=(isprint(c2))?c2:'.';
  }
 zeile[++k]=0; izaehler++;
 if(++j==n) flush();
 return;
}

void flush()
{
 printf("%s\n",zeile); zeile[0]=izaehler=0;
 return;
}
