/* xmultiview.cc */
#define VERSION "Version 0.0"
/*
History:
26.5.1999	Erstellung (RPf)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <ulong.h>

//#define MAXARG 2
#define MAXARG 1
#define MAXZEIL 120

const int POSTSCRIPT=1, IR=2, UV=3, XY=4, EPS=5;

/*************************** globale Parameter ************************/
char para1[80],para2[80],argflag['Z'+1];

void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

/** Vordeklarationen: **/

/******************************* Kleinkram ****************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/***************************** Hauptprogramm **************************/
void error(char* s,void* x)
{
 printf("Error in xmultiview: "); printf(s,x);
 exit(0);
}

main(int argc,char *argv[])
{
 char zeile[MAXZEIL],str[200],*progi;
 int typ=0;
 FILE *fp;
 int i,j;
 for(para1[0]=para2[0]=0,i=j=1;i<argc;i++)
    if(*argv[i]=='-') setflags(argv[i]);
    else switch(j++)
        {case 1:strcpy(para1,argv[i]); break;
         case 2:strcpy(para2,argv[i]); break;
        }
 if(j>MAXARG+1 || j==1 || para1[0]=='?')
	{printf("xmultiview %s\n",VERSION);
	 printf("Anwendung: xmultiview [-Flags] Datei\n");
	 printf("    Flags: D=debug\n");
	 exit(0);
	}
/*** alle Argumente gelesen ***/
 if(!(fp=fopen(para1,"r"))) error("'%s' nicht gefunden\n",para1);
 getline(fp,zeile,MAXZEIL);
 if(*zeile=='%' && zeile[1]=='!')
   {getline(fp,zeile,MAXZEIL);
    if(strncmp(zeile,"%%Creator: Showit",17)==0) typ=EPS; else typ=POSTSCRIPT;
   }
 else if(strncmp(zeile,"IRTRANS",7)==0) typ=IR;
 else if(strncmp(zeile,"UVOD",4)==0) typ=UV;
 else if(strncmp(zeile,"SPEX2",5)==0) typ=UV;
 else if(strncmp(zeile,"XY  ",4)==0) typ=XY;
 else if(*zeile==0 && zeile[1]==0x4B) typ=IR;
 fclose(fp);
 switch(typ)
   {case POSTSCRIPT: progi="gv";
    CASE IR: progi="irshow";
    CASE UV: progi="uvshow";
    CASE XY: progi="xyshow";
    CASE EPS: progi="vectmal -q";
    DEFAULT: progi="xv";
   }
 sprintf(str,"%s %s",progi,para1);
 if(argflag['D']) printf("system(\"%s\")\n",str);
 system(str);
} /* end of main */
