/* uvcheck.c				letzte Aenderung: 18.8.2010

History:
7.4.1998 V0.01	Erstellung (RPf)
6.9.99	 0.02	Flag 'A' um alle Daten zu sehen
6.9.99	 0.03	Verhinderung des berlaufs von
		kopf.period mit SPEX2: bei mehr als 32767 msec
		als negativer Wert in sec gespeichert.
14.5.2002  0.04 Direktes Speichern als xy-Datei (option -x)
10.10.03   0.05	auch SPEX2-Format direckt als xy-Datei speicherbar
		Wieder c (statt c++), damits auch auf Maschinen ohne
		c++-Library geht.
16.8.10   0.07	Erkennung von spc-Dateien vom UV2450 Spektrometer

*/
#define VERSION "0.07"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#ifndef PI
#define PI 3.14159265358979
#endif
#include <ulong.h>
#define MAXARG 2
#define MAXSPEKT 2
#define OD		1
#define EPSILON		2
#define LOGEPSILON	4
#define TRANSMISSION	8
#define EPSILONMASK	6 /* (EPSILON | LOGEPSILON) */
//#define NM ('N'+256*'M')
//#define CM ('C'+256*'M')
//#define IN ('I'+256*'N')

#ifdef __ALPHA
#define VAX_OR_ALPHA
#endif
#ifdef VAX
#define VAX_OR_ALPHA
#endif

#define UVALT	1
#define UVOD2	2
#define SPEX2	3
#define CASE break;case
#define DEFAULT break;default

struct uv_kopf
{       LONG    start,ende,delta,slit;   /* Werte in PicoMeter (0.001nm) */
        WORD    period;	  /* Daempfung in Millisekunden */
        WORD    multi;	  /* Anzahl Multiscans, Daten aber bereits dividiert */
        LONG    conz;     /* Konzentration * Schichtdicke in NanoMol/l*cm    */
	LONG	yfaktor;  /* Die y-Werte sind um diesen Faktor vergroessert  */
};

/*********************** Vordeklarationen ********************************/
double powi(double x,int i);
int hatpunkt(char *s);
void ohnepunkt(char *s);
char *machgross(char *s);
void uvshow(char *filename,char *substanzname);
int wordlesen(FILE *fp);
LONG longlesen(FILE *fp);
int gepacktlesen(FILE *fp,LONG *y);
void uvschreib(char *filename,float *yfeld,WORD *mody,WORD *irev);
void zeilelesen(char *str,int max);
void error(int n);
#define CANT_OPEN_NEW_FILE 1
#define ZU_WENIG_RAM 2
int istvorhanden(char *name);
void funk_anpass();
void spex_parameter_lesen(int c,FILE *fp);

/*************************** globale Parameter ************************/
char filename[80],spename[200];
typedef char STRING[120];
char substanzname[120];
typedef char STRING80[80];
//STRING80 fname2[MAXSPEKT-1];
char zielname[160];
float *hauptfeld=NULL,*hilfsfeld=NULL,*PNULL=NULL;
int feldgroesse;
WORD	mody, /* Darstellungseinheit in y-Richtung (OD TRANSMISSION EPSILON) */
	modp, /* Darstellungseinheit in x-Richtung (CM oder NM) */
	irev; /* Richtung der Darstellung */
LONG modus=4, minus1= -1, npkt;
/* in Fortran: COMMON /ISAM/ ISTART,IEND,DX,PER,SLIT,CONZ,SNAM */
#ifndef unix
#ifndef __ALPHA
extern
#endif
#endif
//struct	{WORD ISTART,IEND; float DX,PER,SLIT,CONZ; char SNAM[20];}
//	ISAM;

static FILE *fp=NULL;/* fuer ausgemessene Punkte und Integrale */
static int uvformat, katalogflag=0, testflag=0;
static int ntesspektrum=3;

/***************************** Hauptprogramm **************************/
char argflag['Z'+1];
void setargflags(char *s)
{int c; while(c= *s++) if((c=toupper(c))<='Z') argflag[c]=1;}
int altkor=0;

main(int argc,char *argv[])
{
 char *p;
 int i,j,c;
 for(*filename= *zielname=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setargflags(argv[i]);
   else switch(j++)
	{case 1:strcpy(filename,argv[i]); break;
	 case 2:strcpy(zielname,argv[i]); break;
	 default:break;
        }
 if(j>MAXARG+1 || filename[0]=='?' || argflag['?'])
	{printf("uvcheck  Version %s\n",VERSION);
	 printf("Anwendung: uvcheck Datei [-flags] [Zieldatei.xy]\n");
	 printf(" flags: a = alle Daten darstellen\n");
	 printf("        x = xy-Datei erstellen\n");
	 printf("        v = verbose, Testausdrucke\n");
	 exit(0);
	}
 if(argflag['V']) testflag++;
 if(*filename==0) {printf("File:"); scanf("%s",filename); getc(stdin);}
 if(!istvorhanden(filename)) exit(0);
 uvshow(filename,substanzname);
}/* ende von main */

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

bool vorhanden(const char *dateiname)
{
 struct stat buf;
 return (lstat(dateiname,&buf)>=0);
}

FILE *fopenzielname()
{
 //Aufgerufen wenn argflag['X']
 int i,j,c,ok;
 char *s,*t;
 FILE *fp;
 char antw[40];
 if(*zielname==0)
  {for(i=j=0,s=zielname,t=filename;(c= *t++)!=0;i++)
    {*s++ = c;
     if(c=='.') j=i;
    }
   if(j==0) j=i;
   strcpy(&zielname[j],".xy");
  }
 if(vorhanden(zielname))
  {printf("'%s' already exists - ok to overwrite?",zielname);
   scanf("%s",&antw); c= *antw;
   ok=(c=='J' || c=='Y' || c=='j' || c=='y');
  }
 else ok=1;
 if(ok)
  {fp=fopen(zielname,"w");
   if(fp==NULL) printf("cant create '%s'\n",zielname);
  }
 else fp=NULL;
 return fp;
}

/*************************** user_prog ***********************************/
char *mody2str(int mody)  /* aus mody Klartext machen */
{
 char *s;
 if(mody==EPSILON) s="Epsilon";
 else if(mody==LOGEPSILON) s="log(Epsilon)";
 else if(mody==TRANSMISSION) s="% Transmission";
 else s="OD";
 return s;
}

char *machgross(char *s)
{
 char *t;
 int c;
 t=s;
 while(c= *t)  *t++ = toupper(c);
 return s;
}

/********* Erweiterung 16.8.2010 zum Lesen vom UVPC-SPC-Format **********/
#ifndef true
#define true 1
#define false 0
#endif
bool hatendung(char *s,char *e)
{
 int c,i;
 while(c= *s++)
   if(c==e[0])
    {for(i=1;e[i]!=0 && s[i-1]!=0 && e[i]==s[i-1];i++) ;
     if(e[i]==0 && s[i-1]==0) return true;
    }
 return false;
}
float floatlesen(int* pj,FILE *fp1,int h,char* he)
{
 int j= *pj,k;
 union {char c[4]; float y;} y;
 for(k=0;k<4;k++,j++)
   y.c[k] = (j<h) ? he[j] : getc(fp1);
 *pj=j;
 if(y.y!=y.y) printf("Error in floatlesen: y.y=%f\n",y.y);//test
 return y.y;
}
double doublelesen(int* pj,FILE *fp1,int h,char* he)
{
 int j= *pj,k;
 union {char c[8]; double y;} y;
 for(k=0;k<8;k++,j++)
   y.c[k] = (j<h) ? he[j] : getc(fp1);
 *pj=j;
 if(y.c[6]==0 || y.c[7]==0 || y.y!=y.y) y.y= 1e20;//ungueltige Zahl
 return y.y;
}
int textsuchen(int* pj,FILE *fp,char *text)
{
 int i=0,j= *pj,c,c0;
 int position=j;
 while((c0=text[i])!=0)
  {if((c=getc(fp))==EOF) return 0;//nicht gefunden
   j++;
   if(c==c0)
    {i++;}
   else
    {position=j;
     if(i>0)
       {if(c==text[0]) {position=j-1; i=1;}
	else {i=0;}
       }
    }
  }
 *pj=j;
 return position;//gefunden
}
void textblocklesen(int *pj,FILE *fp,char *zeile)
{
 int j= *pj,i,c,n,imax=80-1;
 n=getc(fp); j++;
 for(i=0;i<n;i++)
  {c=getc(fp); j++;
   if(i<imax) *zeile++ = c;
  }
 *zeile=0;
 *pj=j;
}

/********************** Anpassung an Format 'UVOD2   ' ******************/
#define VERTAUSCHE(x,y) h=x; x=y; y=h
#define WRITE "wb"
#define READ  "rb"
LONG idfix(double x)
{if(x>=0.) return (LONG)(x+0.5); else return (LONG)(x-0.5);}

static struct uv_kopf kopf;

void uvshow(char *filename,char *substanzname)
{
 FILE *fp,*fp2;
 char format[10],zeile[80],*s;
 int i,c;
 int nfehler=0;
 LONG x,y,j;
 int modus2,npkt;
 float start,ende,ymin,ymax,*py,*yfeld,*yhfeld;
 double yfakt,konz,h;
 fp=fopen(filename,"r");
 c=getc(fp); ungetc(c,fp);
 //if(isdigit(c)) strcpy(format,"XY      ");
 if(hatendung(filename,".spc")) strcpy(format,"SPC     ");
 else
  for(i=0;i<8;i++) format[i]=getc(fp);
 format[8]=0;
 if(testflag) printf("Format=%s\n",format);
 if(strcmp(format,"UVOD2   ")==0)
	{printf("Format=UVOD2\n");
	 for(s=substanzname;(c=getc(fp))>=' ';)  *s++ = c;
	 *s=0;
	 kopf.start=longlesen(fp); kopf.ende=longlesen(fp);
	 kopf.delta=longlesen(fp); kopf.slit=longlesen(fp);
	 kopf.period=wordlesen(fp); kopf.multi=wordlesen(fp);
	 kopf.conz=longlesen(fp); konz=kopf.conz/1e9;
	 kopf.yfaktor=longlesen(fp); yfakt=(double)kopf.yfaktor;
	 start=kopf.start/1e3; ende=kopf.ende/1e3;
	 npkt=(kopf.start-kopf.ende)/kopf.delta+1;
	 printf("'%s'\n",substanzname);
	 printf("gescannter Bereich : %.2lf bis %.2lf nm\n",start,ende);
	 printf("Scanrate: %.2lf nm/s   Anzahl Scans: %d\n",
		kopf.delta/1e3,kopf.multi);
	 printf("Slit: %.3lf nm    Period: %.1lf s\n",
		kopf.slit/1e3,kopf.period/1e3);
	 if(konz==0.)	{printf("conz*d: unbekannt\n");
			}
	 else printf("conz*d: %lg cm*Mol/Liter\n",konz);
	 if(argflag['X'] && (fp2=fopenzielname())!=NULL)
	   {int j;
	    double xy[npkt];
	    for(i=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,++i)
	      {if(gepacktlesen(fp,&y)==EOF) nfehler++;
	       xy[i]=((double)y)/yfakt;
	      }
	    for(x=kopf.ende; x<=kopf.start; x+=kopf.delta)
	      {fprintf(fp2,"%lg\t%lg\n",x*0.001,xy[--i]);}
	    fclose(fp2);
	    printf("unter '%s' gespeichert\n",zielname);
	   }
	 else
	 {printf("entpackte Daten:\n");
	  for(i=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,++i)
	   {if(gepacktlesen(fp,&y)==EOF) nfehler++;
	    if(i<20 || i>npkt-12 || argflag['A'])
	      {printf("%6ld ",(long)y);
	       if((i+1)%10==0) printf("\n");
	      }
	    else if(i==20) printf("....\n");
	   }
	  printf("\n");
	 }
	 if(nfehler) printf("ERROR:'%s' hat %d Lesefehler\n",filename,nfehler);
	 for(j=0;getc(fp)!=EOF;j++)  ;
	 if(j) printf("WARNUNG:'%s' hat %d ueberfluessige Bytes\n",filename,j);
	 fclose(fp);
	}
 else if(strcmp(format,"SPEX2   ")==0)
	{LONG period;
	 printf("Format=SPEX2\n");
	 kopf.conz=0;
	 while((c=getc(fp))!=0xFF && c!=EOF)
	   spex_parameter_lesen(c,fp);
	 period = (kopf.period<0) ? -1000*kopf.period : kopf.period;
	 kopf.yfaktor=1000*period*kopf.multi;
	 yfakt=(double)kopf.yfaktor;
	 //printf("yfakt=%lf\n",yfakt);//test
	 konz=kopf.conz/1e9;
	 start=kopf.start/1e3; ende=kopf.ende/1e3;
	 npkt=(kopf.start-kopf.ende)/kopf.delta+1;
	 if(argflag['X'] && (fp2=fopenzielname())!=NULL)
	   {int j;
	    double xy[npkt];
	    for(i=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,++i)
	      {if(gepacktlesen(fp,&y)==EOF) nfehler++;
	       xy[i]=(double)y;
	      }
	    for(x=kopf.ende; x<=kopf.start; x+=kopf.delta)
	      {fprintf(fp2,"%lg\t%lg\n",x*0.001,xy[--i]);}
	    fclose(fp2);
	    printf("unter '%s' gespeichert\n",zielname);
	   }
	 else
	 {printf("entpackte Daten:\n");
	  for(i=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,++i)
	   {if(gepacktlesen(fp,&y)==EOF) nfehler++;
	    if(i<20 || i>npkt-12 || argflag['A'])
	      {printf("%6ld ",(long)y);
	       if((i+1)%10==0) printf("\n");
	      }
	    else if(i==20) printf("....\n");
	   }
	  printf("\n");
	 }
	 if(nfehler) printf("ERROR:'%s' hat %d Lesefehler\n",filename,nfehler);
	 for(j=0;getc(fp)!=EOF;j++)  ;
	 if(j) printf("WARNUNG:'%s' hat %d ueberfluessige Bytes\n",filename,j);
	 fclose(fp);
	}
 else if(strcmp(format,"SPC     ")==0)
       {double xw,yw,xstart,xende,dx;
	int j;
	const int h2=512;
	char he[h2];
	for(i=0;i<h2;i++) he[i]=getc(fp);
	if(c==0)
	{printf("UVPC-SPC Format\n");
	 printf("comment = \"");
	 for(i=0x27,s=substanzname;i<h2 && (c=he[i])!=0;i++)
	   {if(i<0x27+120-1) *s++ = c;//max. 120 Zeichen speichern
	    putc(c,stdout);
	   }
	 *s=0;
	 putc('\"',stdout); putc('\n',stdout);
	 printf("time date = ");
	 for(i=0x64;i<h2 && (c=he[i])!=0;i++)
	   putc(he[i],stdout);
	 putc(' ',stdout);
	 for(i++;i<h2 && (c=he[i])!=0;i++)
	   putc(c,stdout);
	 putc('\n',stdout);
	 npkt=he[0x76]+(he[0x77]<<8); //Anzahl Messpunkte
	 j=10; xstart=floatlesen(&j,fp,h2,he);
	 xende=floatlesen(&j,fp,h2,he);
	 dx=(xende-xstart)/(npkt-1);
	 printf("Start=%lf Ende=%lf   Anzahl Messpunkte = %d  (Step=%lf)\n",
		xstart,xende,npkt,dx);
	 kopf.start=(LONG)(xstart*1e3+0.5);
	 kopf.ende=(LONG)(xende*1e3+0.5);
	 kopf.delta=(kopf.start-kopf.ende)/(npkt-1);
	 kopf.conz=0; konz=kopf.conz/1e9;
	 kopf.slit=0; kopf.period=0; kopf.multi=1; kopf.yfaktor=1; //test
	 start=kopf.start/1e3; ende=kopf.ende/1e3;
	 if(argflag['X'] && (fp2=fopenzielname())!=NULL)
	   {double xy[npkt];
	    for(i=0,j=0x78; i<npkt; i++)
	      {yw=floatlesen(&j,fp,h2,he);
	       xy[i]=yw;
	      }
	    for(x=kopf.ende; x<=kopf.start; x+=kopf.delta)
	      {fprintf(fp2,"%lg\t%lg\n",x*0.001,xy[--i]);}
	    fclose(fp2);
	    printf("unter '%s' gespeichert\n",zielname);
	   }
	 else
	 {printf("gelesene Daten:\n");
	  for(i=0,j=0x78; i<npkt; i++)
	   {yw=floatlesen(&j,fp,h2,he);
	    if(i<20 || i>npkt-18 || argflag['A'])
	      {printf("%lf",yw);
	       if((i+1)%8==0 || i==19) printf("\n"); else printf("  ");
	      }
	    else if(i==20) printf("....\n");
	   }
	  printf("\n");
	 }
	}
	else if(c==0xD0 && (he[1]&0xFF)==0xCF)
	{int jmax;
	 printf("UV2450-SPC Format\n");
	 for(j=h2;j<0x2000;j++) getc(fp);//Schrott ueberlesen
	 jmax=textsuchen(&j,fp,"Wavelength Range");
	 if(jmax==0)
	  {printf("spc-Format-Error: \"Wavelength Range\" not found.\n");
	   fclose(fp); return;
	  }
	 while(++j && (c=getc(fp))!=':' && c!=EOF) ;//naechster Doppelpunkt
	 textblocklesen(&j,fp,zeile);
	 sscanf(zeile,"%lf to %lf",&xende,&xstart);
	 if(testflag) printf("'%s' xstart=%lf xende=%lf\n",zeile,xstart,xende);
	 for(;;)
	  {textblocklesen(&j,fp,zeile);
	   if(*zeile==0) break;
	   if(strcmp(zeile,"Sampling Interval:")==0)
	    {textblocklesen(&j,fp,zeile);
	     sscanf(zeile,"%lf",&dx);
	     if(testflag) printf("dx=%lf\n",dx);//test
	     break;
	    }
	  }
	 jmax=(j+0xFF)&0xFFFFFF00; //auf runde Adresse aufrunden
	 double yw4[4];
	 for(i=0;i<100;i++)
	  {int ok,k;
	   for(;j<jmax;j++) getc(fp);
	   for(k=0;k<4;k++) yw4[k]=doublelesen(&j,fp,h2,he);
	   if(testflag) printf("%04X: yw=%lf\n",j-4*8,yw4[0]);
	   for(k=0,ok=1;k<4;k++)
	    {if(!(yw4[k]<=4.0 && yw4[k]>= -1.0)) ok=0;}
	   if(ok) break;
	   //jmax=(j+0x0F)&0xFFFFFFF0; //auf runde Adresse aufrunden
	  }
	 if(i>=100)
	  {printf("spc-Format-Error: keine vernuenftigen Werte gefunden.\n");
	   fclose(fp); return;
	  }
	 if(testflag) printf("j=0x%04X\n",j);//test
	 if(xstart>xende && dx>0) dx = -dx;
	 npkt=(int)((xende-xstart)/dx+1.5);
	 printf("Start=%lf Ende=%lf   Anzahl Messpunkte = %d  (Step=%lf)\n",
		xstart,xende,npkt,dx);
	 kopf.start=(LONG)(xstart*1e3+0.5);
	 kopf.ende=(LONG)(xende*1e3+0.5);
	 kopf.delta=(kopf.start-kopf.ende)/(npkt-1);
	 kopf.conz=0; konz=kopf.conz/1e9;
	 kopf.slit=0; kopf.period=0; kopf.multi=1; kopf.yfaktor=1; //test
	 start=kopf.start/1e3; ende=kopf.ende/1e3;
	 if(argflag['X'] && (fp2=fopenzielname())!=NULL)
	   {double xy[npkt];
	    for(i=0,xw=xstart;i<npkt;i++,xw+=dx)
	      {if(i<4) yw=yw4[i]; else yw=doublelesen(&j,fp,h2,he);
	       if(yw!=yw) printf("Error in double-float number: yw=%lf\n",yw);
	       xy[i]=yw;
	      }
	    for(x=kopf.ende; x<=kopf.start; x+=kopf.delta)
	      {fprintf(fp2,"%lg\t%lg\n",x*0.001,xy[--i]);}
	    fclose(fp2);
	    printf("unter '%s' gespeichert\n",zielname);
	   }
	 else
	   {printf("gelesene Daten:\n");
	    for(i=0,xw=xstart;i<npkt;i++,xw+=dx)
	      {if(i<4) yw=yw4[i]; else yw=doublelesen(&j,fp,h2,he);
	       if(yw!=yw) printf("Error in double-float number: yw=%lf\n",yw);
	       if(i<20 || i>npkt-18 || argflag['A'])
		{printf("%lf",yw);
		 if((i+1)%8==0 || i==19) printf("\n"); else printf("  ");
		}
	       else if(i==20) printf("....\n");
	      }
	    printf("\n");
	   }
	 printf("gelesene x-Werte:\n");
	 for(xw=0;xw<xende-1 || xw>xstart+1;)
	   xw=doublelesen(&j,fp,h2,he);
	 for(i=0;i<npkt;i++)
	   {if(i>0) xw=doublelesen(&j,fp,h2,he);
	    while((xw<xende-1 || xw>xstart+1) && (c=getc(fp))!=EOF)
	      {ungetc(c,fp); xw=doublelesen(&j,fp,h2,he);}
	    if(i<12 || i>npkt-12 || argflag['A'])
	      {printf("%lf",xw);
	       if((i+1)%6==0 || i==11) printf("\n"); else printf("  ");
	      }
	    else if(i==20) printf("....\n");
	   }
	 printf("\n");
	}
	else
	{printf("unbekanntes SPC-Format: 0x%02X %02X\n",c,he[1]&0xFF);
	}
	fclose(fp);
       }
 else
	{printf("unbekanntes Format: ");
	 for(i=0;i<8;i++) if(format[i]<' ' || format[i]>'z') break;
	 if(i==8) printf("'%s'",format);
	 else for(i=0;i<8;i++) printf("%02X ",format[i]&0xFF);
	 printf("\n");
	 fclose(fp);
	}
}
int wordlesen(FILE *fp)
{
 int c1,c2; WORD x;
 c1=getc(fp); c2=getc(fp);
 x=(c1<<8)+c2;
 return x;
}
LONG longlesen(FILE *fp)
{
 LONG c1,c2,c3,c4,x;
 c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
 x=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 return x;
}

int gepacktlesen(FILE *fp,LONG *y)
{
 /* Wenn erstes Bit gesetzt (c & 0x80 == 0x80), dann sind die restlichen 7 Bits
    die Differenz zum vorherigen Wert.
    Wenn das erste Bit nicht, aber das 2.Bit gesetzt ist (c & 0xC0 == 0x40),
    dann sind die restlichen 6 Bits + das naechste Byte die Differenz zum
    vorherigen Wert.
    Wenn weder das erste noch das 2. Bit gesetzt sind (c & 0xC0 == 0), dann
    sind die restlichen 6 Bits + die naechsten 3 Bytes ein absoluter Wert.
 */
 static LONG letzterwert=0;
 LONG dy;
 int c,c2,c3,c4;
 if((c=getc(fp))==EOF) {*y=0; return EOF;}
 if(c & 0x80)
	{dy=c & 0x7F; if(dy & 0x40) dy |= 0xFFFFFF80;
	 *y=letzterwert+=dy;
	}
 else if(c & 0x40)
	{c2=getc(fp);
	 dy=((c & 0x3F)<<8)+c2; if(dy & 0x2000) dy |= 0xFFFFC000;
	 *y=letzterwert+=dy; c=c2;
	}
 else
	{c2=getc(fp); c3=getc(fp); c4=getc(fp);
	 dy=(c<<24)+(c2<<16)+(c3<<8)+c4; if(dy & 0x20000000) dy |= 0xC0000000;
	 *y=letzterwert=dy; c=c4;
	}
 return c;
}

double Log10a(double x)
{
 if(x<=0.) return -5.;
 return log10(x);
}

static int packflag=0;

/************************ kleinkram **************************/
double powi(double x,int i)  /* Potenzieren einer Fliesszahl mit Integer */
{
 double z;
 if(i<0) return 1./powi(x,-i);
 for(z=1.;i>0;)
	{if(i & 1) z*=x;
	 if(i>>=1) x*=x;
	}
 return z;
}

void zeilelesen(char *str,int max)
{
 int c;
 if((c=getc(stdin))=='\n') c=getc(stdin);
 while(c!='\n' && --max) {*str++=c; c=getc(stdin);}
 *str=0;
 while(c!='\n') c=getc(stdin);
}

int hatpunkt(char *s)
{
 int c;
 while(c= *s++) if(c=='.') return 1;
 return 0;
}
void ohnepunkt(char *s)
{
 while(*s && *s!='.') s++;
 *s=0;
}

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n' && c!=0)
	*s++ = c;
 *s='\0';
 if(lim==0)
   while(c!='\n' && c!=0 && c!=EOF) c=getc(fp);
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/************************ ab Version 2.04 ********************************/
void anhaengen(char *str,char *s,int max)
{
 char *t;
 int i;
 if(s==NULL) return;
 for(i=1,t=str;*t!=0;t++,i++) ;
 if(++i<max) *t++ = '\n';
 while(i<max && (*t++ = *s++)) ;
 if(i==max) *t=0;
}

void error(int n)
{
 switch(n)
  {case ZU_WENIG_RAM: printf("ERROR: zu wenig RAM\n"); exit(n);
   case CANT_OPEN_NEW_FILE: printf("ERROR: cant open new file\n"); return;
   default: printf("ERROR: %d\n",n); exit(0);
  }
}

FILE *super_fopen(char *name,char *zugriff)
{
 FILE *fp;
 char *liste[]={".uv",".uvx",".spex",NULL}, **s;
 if(fp=fopen(name,zugriff)) return fp;
 if(!hatpunkt(name))
   for(s=liste;*s!=NULL;s++)
        {strcat(name,*s);
         if(fp=fopen(name,zugriff)) return fp;
         ohnepunkt(name);
        }
 return NULL;
}

int istvorhanden(char *name)
{
 FILE *fp;
 fp=super_fopen(name,"r");
 if(fp==NULL) {printf("'%s' nicht gefunden\n",name); return 0;}
 fclose(fp);
 return 1;
}

/*************************** SPEX2-Format ********************************/
LONG picometer(char *zeile)
{
 char *s;
 int c,c2;
 double x;
 for(s=zeile;(c= *s++) && (isdigit(c) || c=='.' || c==' ');) ;
 if(c!=0) {c=toupper(c); c2=toupper(*s);}
 sscanf(zeile,"%lf",&x);
 if(c=='A' && c2=='U') x*=0.1; //von Angstrom in nm umrechnen
 else if(c=='C' && c2=='M') x=1e7/x; //von cm-1 in nm umrechnen
 return (LONG)(1000*x+0.5);
}
double xlesen(char *zeile)
{
 double x;
 sscanf(zeile,"%lf",&x);
 return x;
}
long nlesen(char *zeile)
{
 long x;
 sscanf(zeile,"%ld",&x);
 return x;
}

#include "spex2.h"

void spex_parameter_lesen(int c,FILE *fp)
{
 char *s,zeile[120];
 double x;
 getline(fp,zeile,120);
 if(c<0 || c>=30) printf("Fehler: spexstring %d ungueltig\n",c);
 else printf("%2d %s  %s\n",c,ptext[c],zeile);//test
 switch(c)
  {case 2: strcpy((char*)substanzname,zeile);
   CASE 20: kopf.start=picometer(zeile);
   CASE 21: kopf.ende=picometer(zeile);
   CASE 22: kopf.delta=picometer(zeile);
   CASE 16: kopf.slit=picometer(zeile);//provi.
   CASE 28: x=xlesen(zeile);
	    kopf.period=idfix((x>32.767)?-x:1000*x);
   CASE 24: kopf.multi=nlesen(zeile);
   CASE 8:  kopf.conz=(int)(1e9*xlesen(zeile));
  }
}
