/* inkat.C				letzte Aenderung: 20.9.1993 */
#define VERSION "Version 0.0"
/* UV oder IR Datei in Katalog aufnehmen
Uebersetzen:
 CX inkat
@LINK inkat,SYS$INPUT/OPT
SYS$SHARE:DECW$DWTLIBSHR/SHARE
Autor: RPf
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#define VAX 1
#ifdef VAX
#include "h:ulong.h"
#else
#include <ulong.h>
#endif
#define MAXARG 1

/*************************** globale Parameter ************************/
char filename[80],argflag['Z'+1];

setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

/***************************** Hauptprogramm **************************/
main(int argc,char *argv[])
{
 int i,j;
 FILE *fp;
 for(filename[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(filename,argv[i]); break;
         default:break;
        }
 if(j>MAXARG+1 || filename[0]=='?')
	{printf("inkat  %s\n",VERSION);
/*	 printf("Anwendung: inkat Datei [-Flags]\n"); */
	 printf("Anwendung: inkat Datei\n");
	 exit(0);
	}
 if(filename[0]==0) {printf("UV oder IR-Datei:"); scanf("%s",filename);}
/*** alle Argumente gelesen ***/
 if(!(fp=fopen(filename,"r"))) {printf("'%s' nicht gefunden\n"); exit(0);}
 if(index(filename,".uv")>=0)		uvdatei(fp);
 else if(index(filename,".ir")>=0)	irdatei(fp);
 else		printf("'%s' Fehlendes .uv oder .ir\n",filename);
 fclose(fp);
}/* ende von main */

/*************************** UV-Datei lesen **************************/
struct uv_kopf
{       LONG    start,ende,delta,slit;   /* Werte in PicoMeter (0.001nm) */
        WORD    period;   /* Daempfung in Millisekunden */
        WORD    multi;    /* Daten aber bereits dividiert */
        LONG    conz;     /* Konzentration * Schichtdicke in NanoMol/l*cm */
        LONG    yfaktor;  /* Die y-Werte sind um diesen Faktor vergroessert */
};
static struct uv_kopf kopf;

uvdatei(FILE *fp)
{
 char format[10],*s,substanzname[120];
 int i,c;
 LONG x,y,j,modus2,npkt;
 float start,ende,h,ymin,ymax,*py,*yfeld,*yhfeld;
 for(i=0;i<8;i++) format[i]=getc(fp);
 format[8]=0;
 if(strcmp(format,"UVOD2   ")==0)
	{for(s=substanzname;(c=getc(fp))>=' ';)  *s++ = c;
	 *s=0;
	 kopf.start=longlesen(fp); kopf.ende=longlesen(fp);
	 kopf.delta=longlesen(fp); kopf.slit=longlesen(fp);
	 kopf.period=wordlesen(fp); kopf.multi=wordlesen(fp);
	 kopf.conz=longlesen(fp);
	 kopf.yfaktor=longlesen(fp);
	 uvinkatalog(filename,substanzname,&kopf);
	}
 else	{substanzname[0]=' '; substanzname[1]=0;/* provi. */
	 uvinkatalog(filename,substanzname,NULL);
	}
 return;
}
wordlesen(FILE *fp)
{
 int c1,c2; WORD x;
 c1=getc(fp); c2=getc(fp);
 x=(c1<<8)+c2;
 return x;
}
longlesen(FILE *fp)
{
 LONG c1,c2,c3,c4,x;
 c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
 x=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 return x;
}

uvinkatalog(char *filename,char *substanzname,struct uv_kopf *kopf)
{
 FILE *fp;
 double konz;
 fp=fopen("uvkatalog.dat","a"); if(fp==NULL) return;
 fprintf(fp,"%s\t'%s'\n",filename,substanzname);
 if(kopf)
	{fprintf(fp,"\t\t%.2lf bis %.2lf nm  ",kopf->start/1e3,kopf->ende/1e3);
	 fprintf(fp,"%.2lf nm/s  %d Scans\n",kopf->delta/1e3,kopf->multi);
	 fprintf(fp,"\t\tSlit: %.3lf nm   Period: %.1lf s\n",
		kopf->slit/1e3,kopf->period/1e3);
	 konz=kopf->conz/1e9;
	 if(konz==0.) fprintf(fp,"\t\tconz*d: unbekannt\n");
	 else fprintf(fp,"\t\tconz*d: %lg cm*Mol/Liter\n",konz);
	}
 fclose(fp);
 return;
}

/*************************** IR-Datei lesen **************************/
#define CR 13
#define LF 10
#define SONDER 12  /* Sonderzeichen zur Darstellung von verbotenen Zeichen */
		   /* Der Atari macht aus einem LF ein CR LF. Beim Lesen   */
		   /* ignoriert er alle CRs.				   */
char snam[40];
struct kopf_1 {float start,ende,delta,amode; WORD npkt,nmulti;} irkopf;
struct kopf_2
        {UWORD startH,startL,endeH,endeL,deltaH,deltaL,amodeH,amodeL;
         WORD npkt,nmulti;} kopf2;

irdatei(FILE *fp)
{
 WORD y[10];
 int i,j;
 char format[10],name[80];
 byteslesen(fp,format,8); format[8]=0;
 if(strcmp(format,"IRTRANS2")==0)
  {byteslesen(fp,snam,40); snam[39]=0;
   wordslesen10(fp,&kopf2);
   kopfkopieren2(&kopf2,&irkopf);
   irinkatalog(filename,snam,&irkopf);
  }
 else if(strcmp(format,"IRTRANS1")==0)
  {byteslesen(fp,snam,40); snam[39]=0;
   wordslesen10(fp,&kopf2);
   kopfkopieren2(&kopf2,&irkopf);
   irinkatalog(filename,snam,&irkopf);
  }
 else {printf("Format '%8s' unbekannt\n",format); exit(0);}
}

byteslesen(fp,s,n)
FILE *fp; char *s; int n;
{
 int i;
 for(i=0;i<n;i++)   *s++=getc(fp);
 return;
}

wordslesen10(fp,s)       /* 10 Words lesen */
FILE *fp; WORD *s;
{
 int i,c,c2;
 for(i=0;i<10;i++)
   {c=getc(fp); c2=getc(fp); *s++=(c<<8)+(c2&0xFF);}
 return;
}

packedwordslesen10(fp,s)       /* 10 gepackte Words lesen */
FILE *fp; WORD *s;
{
 char c,c2;
 static WORD ywert;
 int i;
 if(fp==NULL) {ywert=0; return;}
 for(i=0;i<10;i++)
   {c=getc(fp);
    if(c== -128) {c=getc(fp); c2=getc(fp); ywert=(c<<8)+(c2&0xFF);}
    else ywert+=c;
    *s++=ywert;
   }
 return;
}

kopfkopieren2(k2,k1)		/* kopf2 nach kopf1 kopieren */
struct kopf_2 *k2; struct kopf_1 *k1;
{
 k1->start = k2->startH + (double)k2->startL/0x10000;
 k1->ende = k2->endeH + (double)k2->endeL/0x10000;
 k1->delta = k2->deltaH + (double)k2->deltaL/0x10000;
 k1->amode = k2->amodeH + (double)k2->amodeL/0x10000;
 k1->npkt=k2->npkt; k1->nmulti=k2->nmulti;
 return;
}

double slitberechnen(double amode)
{
 static double slits[11]={10.,6.8,5.3,3.0,2.3,1.8,1.4,0.85,0.7,0.5,0.4};
 double sli;
 int modus,ab;
 modus=(int)amode;
 ab=(int)(10.*amode+0.5)%10;
 sli=slits[modus];
 if(ab==1) sli/=2.;
 else if(ab==2) sli/=4.;
 return sli;
}

irinkatalog(char *filename,char *substanzname,struct kopf_1 *kopf)
{
 FILE *fp;
 fp=fopen("irkatalog.dat","a"); if(fp==NULL) return;
 fprintf(fp,"%s\t'%s'\n",filename,substanzname);
 if(kopf)
	{fprintf(fp,"\t\t%.0lf bis %.0lf cm-1  ",kopf->start,kopf->ende);
	 fprintf(fp,"Delta=%.2lf cm-1   Mode=%.1lf   %d Scans\n",
		 kopf->delta,kopf->amode,kopf->nmulti);
	 fprintf(fp,"\t\tSlit:%.2lf cm-1   %d Messpunkte\n",
		 slitberechnen(kopf->amode),kopf->npkt);
	}
 fclose(fp);
 return;
}

/*************************** Kleinkram *****************************/
index(s1,s2)    /* Sucht den String s2 innerhalb von s1 und  */
char *s1,*s2;   /* gibt die Position zurueck (nicht gefunden = -1) */
{
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
        {if((c= *s1++)==0) return -1; /* nicht gefunden */
         if(c== *s2)
                {for(p1=s1,p2=s2; c= *++p2;)
                        if(*p1++!=c) break; /* noch nicht gefunden */
                 if(c==0) break; /* gefunden */
                }
        }
 return i;
}
