/* uvs.c                        letzte Aenderung: 23.6.1993 */
/*
Uebersetzen auf IBM
;> CL/AH uvs.c
*/
#define IBM 1

#include <stdio.h>
#include <stdlib.h>
#include <ulong.h>
#include <tekplot.c>
#ifdef IBM
#include <malloc.h>
#endif
#define cfree(x) free(x)
#define WRITE "wb"
#define READ  "rb"
long idfix();

#ifdef IBM
/** test
void huge *lcalloc(unsigned long n,unsigned long size)
{return (void huge *)halloc(n,(unsigned int)size);}
**/
void *lcalloc(unsigned long n,unsigned long size)
{return (void *)halloc(n,(unsigned int)size);}
#endif

static int testflag=0;
struct uv_kopf
{       char    snam[120];
        LONG    start,ende,delta,slit;   /* Werte in PicoMeter (0.001nm) */
        WORD    period;   /* Daempfung in Millisekunden */
        WORD    multi;    /* Daten aber bereits dividiert */
        LONG    conz;     /* Konzentration * Schichtdicke in NanoMol/l*cm */
        LONG    yfaktor;  /* Die y-Werte sind um diesen Faktor vergroessert */
};
static struct uv_kopf kopf,kopf2;
static char filename[40],filename2[40],antw[80];
static LONG inf_start=400000,inf_ende=190000,
            inf_delta=100,inf_slit=500; /* Picometer */
static WORD inf_period=2500,inf_multi=1;
static double ymini=0., ymaxi=1.0;
static int nfehler=0;
static int hires_flag=0,npulse;
LONG wertscannen(LONG,int);
static char argflag['Z'+1];

setargflags(char *s)
{
 int c;
 while(c= *s++)
   {if(c>'Z') c=toupper(c);
    if(c<='Z') argflag[c]=1;
   }
}

datei_lesen(char *name)
{
 FILE *fp;
 char str[40],*p;
 double zahl;
 int c;
 fp=fopen(name,"r");
 if(fp==NULL) return;
 while((c=getc(fp))!=EOF)
   {ungetc(c,fp); fscanf(fp,"%s",str);
    for(p=str; c= *p; p++) if(c=='=') {*p++=0; break;}
    if(c==0) continue;
    sscanf(p,"%lf",&zahl);
    for(p=str;*p;p++) *p=toupper(*p);
    switch(str[0])
        {case 'S': if(str[1]=='T') inf_start=zahl*1000.;
                   else inf_slit=zahl*1000.;
                   break;
         case 'E': inf_ende=zahl*1000.; break;
         case 'D': inf_delta=zahl*1000.; break;
         case 'P': inf_period=zahl*1000.; break;
         case 'M': inf_multi=zahl; break;
         case 'Y': if(str[3]=='I') ymini=zahl;
                   else ymaxi=zahl;
                   break;
         default: printf("Fehler in '%s': '%s=%lf'\n",str,zahl);
   }    }
 fclose(fp);
 return;
}

datei_schreiben(char *name)
{
 FILE *fp;
 char str[40];
 double zahl;
 fp=fopen(name,"w");
 if(fp==NULL) return;
 fprintf(fp,"START=%.1lf  ENDE=%.1lf  ",kopf.start/1000.,kopf.ende/1000.);
 fprintf(fp,"DELTA=%.2lf\n",kopf.delta/1000.);
 fprintf(fp,"SLIT=%.2lf  ",kopf.slit/1000.);
 fprintf(fp,"PERIOD=%.1lf\n",kopf.period/1000.);
 fprintf(fp,"MULTI=%d\n",kopf.multi);
 fprintf(fp,"YMIN=%lf  YMAX=%lf\n",ymini,ymaxi);
 fclose(fp);
 return;
}

WORD wordlesen(FILE *fp)
{
 int c1,c2; WORD x;
 c1=getc(fp); c2=getc(fp);
 x=(c1<<8)+c2;
 return x;
}
LONG longlesen(FILE *fp)
{
 LONG c1,c2,c3,c4,x;
 c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
 x=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 return x;
}

LONG *spektrum_einlesen(char *filename,struct uv_kopf *kopf)
{
 LONG *yfeld,*py,j,x;
 FILE *fp;
 char format[10],*s;
 int i,nfehler=0,c;
 fp=fopen(filename,READ);
 if(fp==NULL)
   {sprintf(filename,"%s.uv",filename); fp=fopen(filename,READ);
    if(fp==NULL) {printf("'%s' nicht gefunden\n",filename); return NULL;}
   }
 for(i=0;i<8;i++) format[i]=getc(fp);
 format[8]=0;
 if(strcmp(format,"UVOD2   ")!=0)
        {printf("'%s' hat Falsches Fileformat\n",filename); return NULL;}
 for(s=kopf->snam;(c=getc(fp))>=' ';)  *s++ = c;
 *s=0;
 kopf->start=longlesen(fp); kopf->ende=longlesen(fp);
 kopf->delta=longlesen(fp); kopf->slit=longlesen(fp);
 kopf->period=wordlesen(fp); kopf->multi=wordlesen(fp);
 kopf->conz=longlesen(fp); kopf->yfaktor=longlesen(fp);
 yfeld=lcalloc((kopf->start-kopf->ende)/kopf->delta+1L,(long)sizeof(long));
 if(yfeld==NULL)
    {printf("zu wenig Speicher! - RESET druecken und neu starten\n"); exit(0);}
 for(py=yfeld,x=kopf->start; x>=kopf->ende; x-=kopf->delta,py++)
           if(gepacktlesen(fp,py)==EOF) nfehler++;
 if(nfehler) printf("ERROR:'%s' hat %d Lesefehler\n",filename,nfehler);
 for(j=0;getc(fp)!=EOF;j++)  ;
 if(j) printf("WARNUNG:'%s' hat %d ueberfluessige Bytes\n",filename,j);
 fclose(fp);
 return yfeld;
}

main(int argc,char *argv[])
{
 int n,i,pen,k;
 LONG j,x,*yfeld,*yfeld2=NULL;
 double yod,konz,yfakt;
 datei_lesen("uv.inf");
 if(argc>=2) sscanf(argv[1],"%s",filename);
 else {printf("Dateiname:"); scanf("%s",filename);}
 if(filename[0]=='?')
   {printf("Anwendung: UVS Name1.uv [Name2.uv] [-Optionen]\n");
    printf(" Optionen: D=Dump = Darstellung als Zahlentabelle\n");
    printf("           S=Subtrahieren  Q=ohne Rueckfrage\n");
    return 0;
   }
 yfeld=spektrum_einlesen(filename,&kopf); if(yfeld==NULL) exit(0);
 konz=kopf.conz/1e9; yfakt=(double)kopf.yfaktor;
 if(argc==3 && *argv[2]=='-') setargflags(argv[2]);
 else if(argc>=3)
   {sscanf(argv[2],"%s",filename2);
    yfeld2=spektrum_einlesen(filename2,&kopf2);
   }
 if(argc>=4 && *argv[3]=='-') setargflags(argv[3]);
 ymini=ymaxi=0.;
 for(j=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        {yod=yfeld[j]/yfakt;
         if(yod<ymini) ymini=yod;
         if(yod>ymaxi) ymaxi=yod;
        }
 if(yfeld2)
   for(j=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        {yod=yfeld2[j]/yfakt;
         if(yod<ymini) ymini=yod;
         if(yod>ymaxi) ymaxi=yod;
        }
 ymaxi+=0.01; if(ymini>0.) ymini-=0.01;
 inital(kopf.ende/1000.,ymini,kopf.start/1000.,ymaxi);
 printf("'%s'\n",kopf.snam);
 printf("gescannter Bereich : %.2lf bis %.2lf nm\n",
                        kopf.start/1000.,kopf.ende/1000.);
 printf("Scanrate: %.2lf nm/s   Anzahl Scans: %d\n",kopf.delta/1e3,kopf.multi);
 printf("Slit: %.3lf nm    Period: %.1lf s\n",kopf.slit/1e3,kopf.period/1e3);
 if(konz==0.) printf("conz*d: unbekannt\n");
 else printf("conz*d: %lg cm*Mol/Liter\n",konz);
 printf("ymin=%lf  ymax=%lf\n",ymini,ymaxi);
 for(j=0,pen=UP,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        {yod=yfeld[j]/(double)kopf.yfaktor;
         plot(x/1000.,yod,pen); pen=DOWN;
        }
 if(yfeld2)
   for(j=0,pen=UP,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        {yod=yfeld2[j]/(double)kopf.yfaktor;
         plot(x/1000.,yod,pen); pen=DOWN;
        }
/* printf("weiter mit RETURN"); getc(stdin); /* fuer Window-Version */
 term();
 if(argflag['D'])
   {for(j=0,k=12,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        {printf("%8ld",yfeld[j]);
         if(j%8==7) {printf("\n"); k++;} else printf(" ");
         if(k==24) {printf("weiter mit RETURN"); getc(stdin); k=0;}
        }
    printf("\n");
   }
 if(argflag['S'] && yfeld2 && kopf.start==kopf2.start && kopf.ende==kopf2.ende
    && kopf.delta==kopf2.delta)
   {inital(kopf.ende/1000.,ymini,kopf.start/1000.,ymaxi);
    for(j=0,pen=UP,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        {yod=yfeld[j]/(double)kopf.yfaktor-yfeld2[j]/(double)kopf2.yfaktor;
         yfeld[j]=idfix(yod*(double)kopf.yfaktor);
         plot(x/1000.,yod,pen); pen=DOWN;
        }
    term();
    if(!argflag['Q']) {printf("neue Datei:"); scanf("%s",filename);}
    if(filename[1]!=0 || (*filename!='n' && *filename!='N'))
      spektrum_speichern(yfeld);
   }
 cfree(yfeld);
 if(yfeld2) cfree(yfeld2);
 return;
} /* Ende des Hauptprogramms */

gepacktlesen(FILE *fp,LONG *y)
{
 /* Wenn erstes Bit gesetzt (c & 0x80 == 0x80), dann sind die restlichen 7 Bits
    die Differenz zum vorherigen Wert.
    Wenn das erste Bit nicht, aber das 2.Bit gesetzt ist (c & 0xC0 == 0x40),
    dann sind die restlichen 6 Bits + das naechste Byte die Differenz zum
    vorherigen Wert.
    Wenn weder das erste noch das 2. Bit gesetzt sind (c & 0xC0 == 0), dann
    sind die restlichen 6 Bits + die naechsten 3 Bytes ein absoluter Wert.
 */
 static long letzterwert=0;
 long dy,c,c2,c3,c4;
 if((c=getc(fp))==EOF) {*y=0; return EOF;}
 if(c & 0x80)
        {dy=c & 0x7F; if(dy & 0x40) dy |= 0xFFFFFF80;
         *y=letzterwert+=dy;
        }
 else if(c & 0x40)
        {c2=getc(fp);
         dy=((c & 0x3F)<<8)+c2; if(dy & 0x2000) dy |= 0xFFFFC000;
         *y=letzterwert+=dy; c=c2;
        }
 else
        {c2=getc(fp); c3=getc(fp); c4=getc(fp);
         dy=(c<<24)+(c2<<16)+(c3<<8)+c4; if(dy & 0x20000000) dy |= 0xC0000000;
         *y=letzterwert=dy; c=c4;
        }
 return c;
}

static int packflag=0;

spektrum_speichern(long *yfeld)
{
 long x,y,j;
 FILE *fp;
 fp=fopen(filename,WRITE);
 if(fp==NULL) {printf("Fehler beim oeffnen von '%s'\n",filename); exit(0);}
 fprintf(fp,"UVOD2   "); /* Dateiformat = UV Optische Dichte Version 2 */
 fprintf(fp,"%s\n",kopf.snam);
 longspeichern(fp,kopf.start); longspeichern(fp,kopf.ende);
 longspeichern(fp,kopf.delta); longspeichern(fp,kopf.slit);
 intspeichern(fp,kopf.period); intspeichern(fp,kopf.multi);
 longspeichern(fp,kopf.conz);  longspeichern(fp,kopf.yfaktor);
 packflag=0;
 for(j=0,x=kopf.start; x>=kopf.ende; x-=kopf.delta,j++)
        gepacktspeichern(fp,yfeld[j]);
 fclose(fp);
 return;
}
intspeichern(FILE *fp,int y) {putc(y>>8,fp);  putc(y,fp); return;}
longspeichern(FILE *fp,LONG y)
{
 putc((int)(y>>24),fp); putc((int)(y>>16),fp);
 putc((int)(y>>8),fp);  putc((int)(y),fp);
 return;
}
gepacktspeichern(FILE *fp,LONG y)
{
 /* Wenn erstes Bit gesetzt (c & 0x80 == 0x80), dann sind die restlichen 7 Bits
    die Differenz zum vorherigen Wert.
    Wenn das erste Bit nicht, aber das 2.Bit gesetzt ist (c & 0xC0 == 0x40),
    dann sind die restlichen 6 Bits + das naechste Byte die Differenz zum
    vorherigen Wert.
    Wenn weder das erste noch das 2. Bit gesetzt sind (c & 0xC0 == 0), dann
    sind die restlichen 6 Bits + die naechsten 3 Bytes ein absoluter Wert.
 */
 static LONG letzterwert=0;
 LONG dy;
 dy=y-letzterwert;
 if(packflag==0 || dy>0x1FFF || dy<(-0x2000))
        {/* absoluter Wert */
         if(y>0x1FFFFFFF || y<(-0x1FFFFFFF))
                 printf("y zu gross:%ld\n",y);/* test */
         putc((int)((y>>24)&0x3F),fp); putc((int)(y>>16),fp);
         putc((int)(y>>8),fp);  putc((int)(y),fp);
        }
 else if(dy>0x3F || dy<(-0x40))
        {/* relativ 14 Bits */
         putc((int)((dy>>8)&0x3F)+0x40,fp); putc((int)(dy),fp);
        }
 else
        {/* relativ 6 Bits */
         putc((int)(dy&0x7F)+0x80,fp);
        }
 letzterwert=y; packflag=1;
 return;
}

/************ kleinkram **************/
long idfix(double x)            /* korrekte Rundung */
{
 long n;
 if(x>=0.) n=x+0.5;
 else n=x-0.5;
 return n;
}
