/* olga-eichkurve.c */

/* Einheitswert fuer Eichfaktor: */
#define EICH_EINS 1e6

/* Maximale Anzahl Punkte in der Eichkurve: */
#define N1000 1024

/* die folgende (alte) Eichkurve scheint ueberhaupt nicht zu stimmen:
#define EICH_EINS 401.5
static double olga_eichkurve[] = {
180	, 255,
285.714	, 362,
287.77	, 364,
289.855	, 367,
291.971	, 369.5,
294.118	, 371.8,
296.296	, 374,
298.507	, 376,
300.752	, 378,
303.03	, 380.5,
305.344	, 382.8,
307.692	, 385,
310.078	, 387,
312.5	, 389,
314.961	, 390.6,
317.46	, 392.3,
320	, 394,
322.581	, 395.5,
325.203	, 397,
327.869	, 398.1,
330.579	, 399.5,
333.333	, 400.1,
336.134	, 401,
338.983	, 401.2,
341.88	, 401.5,
344.828	, 401.2,
347.826	, 400,
350.877	, 399,
353.982	, 397.5,
357.143	, 395,
360.36	, 392.5,
363.636	, 389.9,
366.972	, 386.1,
370.37	, 382.3,
373.832	, 378,
377.358	, 373.5,
380.952	, 368.5,
384.615	, 363.3,
388.35	, 358,
392.157	, 353,
396.04	, 347.4,
400	, 341.5,
404.04	, 336,
408.163	, 330,
412.371	, 324.4,
416.667	, 318,
421.053	, 312,
425.532	, 306,
430.108	, 300,
434.783	, 294.4,
439.56	, 288,
444.444	, 281,
449.438	, 273,
454.545	, 264,
459.77	, 253.5,
465.116	, 243,
470.588	, 233,
476.19	, 221.5,
481.928	, 211.5,
487.805	, 201.5,
493.827	, 192,
500	, 182.5,
506.329	, 172.6,
512.821	, 163.6,
519.481	, 154,
526.316	, 144.9,
533.333	, 136,
540.541	, 127.5,
547.945	, 120,
555.556	, 112,
563.38	, 104.8,
571.429	, 97,
579.71	, 90,
588.235	, 83.2,
597.015	, 77,
606.061	, 71.5,
615.385	, 66.5,
625	, 62,
634.921	, 57.5,
645.161	, 53.2,
655.738	, 49,
666.667	, 45,
677.966	, 41,
689.655	, 37.7,
701.754	, 33.5,
714.286	, 30.5,
727.273	, 27.6,
740.741	, 24.9,
754.717	, 22,
769.231	, 19.9,
784.314	, 17.5,
800	, 14.9,
816.327	, 12.2,
833.333	, 9.8,
851.064	, 6,
869.565	, 2.5,
888.889	, 1.7,
909.091	, 1.5,
1000	, 1.1,
0, 0
};
*/
/* deshalb nachladbare Eichkurve: */
static double *olga_eichkurve=NULL;

extern int tekplot_initalflag;//provi.

void eichkurve_nachladen(char *s)
{
 char name[200];
 FILE *fp;
 int c,i;
 double x,y,*p,*p0;
 p0=p=(double*)calloc(2*N1000,sizeof(double));
 if(p==NULL) {printf("zu wenig RAM in eichkurve_nachladen()\n"); return;}
 if(s==NULL)
   {s=getenv("OLGAEICHKURVE");
    if(s==NULL)
      {strcpy(name,".olga-eichkurve");
       if(tekplot_initalflag) nachfilenamefragen("lade Eichkurve",name,200);
       else {printf("lade Eichkurve.  Dateiname:"); scanf("%s",name);}
      }
    else strcpy(name,s);
   }
 else strcpy(name,s);
 if(!(fp=fopen(name,"r")))
   {printf("'%s' not found\n",name); cfree(p0); return;}
 for(i=1;(c=getc(fp))!=EOF && i<N1000;i++)
   {ungetc(c,fp); x=y=0;
    fscanf(fp,"%lf %lf",&x,&y);
    if(x==0 && y==0) break;
    //printf("x=%lf y=%lg\n",x,y);//test
    *p++ = x; *p++ = y;
   }
 *p++ = 0; *p++ = 0;
 fclose(fp);
 if(i>1)
   {if(testflag) printf("Eichkurve '%s' geladen: %d Punkte\n",name,i-1);
    olga_eichkurve=p0;
   }
 else
   {printf("Fehler in '%s' - keine Eichkurve geladen\n",name);
    cfree(p0);
   }
}

static int corrflag=0;

double correct(double x,double y)
{
 double *p,faktor,x1,x2,y1,y2;
 double ymax=EICH_EINS;
 while(olga_eichkurve==NULL) eichkurve_nachladen(NULL);
 for(p=olga_eichkurve,x2=y2=0.0;*p!=0.0;)
   {x1=x2; x2= *p++;
    y1=y2; y2= *p++;
    if(x>=x1 && x<=x2)
      {faktor=ymax/(y1+(y2-y1)*(x-x1)/(x2-x1)); return y*faktor;}
   }
 if(testflag)
   printf("correct(%lf,%lf): nicht im Bereich! x1=%lf y1=%lf\n",x,y,x1,y1);
 return y;
}
