/* voed.cc			letzte nderung: 21.3.2000 */
#define VERSION "Version 0.1"
/*
Uebersetzen:
;AVAX> cx voed
;AVAX> blink voed,[pfister.obj]xtekplot1
;AVAX> pur voed.exe

 voed == Vectmal-Objekt-EDitor
 Damit lassen sich die von Vectmal erzeugten Objekte leichter verndern.
 Idealerweise sollte man es ins vectmal.cc einbauen, weiss aber noch nicht wie.

History:
9.3.2000	Erstellung (RPf)
21.3.00  0.1	erste einigermassen brauchbare Version

*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <xtekplot1.h>
//#include <math.h>
#include <atan2.cc>

//Werte fuer modus in Fenster:
#define MOTSEL 1
#define MAUSPRE 2
#define DRAG 0x10
#define SIZE 0x20
#define ROTA 0x30
#define MODCHA 0x30

const char *TMPNAME="tmp.ps";
const double GRAD=PI/180;
const int SCHWARZ=0,WEISS=1;

/************************* Vordeklarationen ***************************/
void m_exit(),m_about(),m_load(),m_save(),m_saveas();
void m_oundo(),m_oname(),m_osize(),m_oscale(),m_oedit(),m_gost();
class Fenster;

/************************ globale Variablen ***************************/
static int exitflag=0;
static Fenster *aktivesfenster=NULL;

/**************************** Kleinkram *******************************/
double abs(double x) {return x<0?-x:x;}
//bool isspace(int c) {return c==' ' || c=='\t' || c=='\n';}
inline double sq(double x) {return x*x;}
inline void exch(double& x,double& y) {double h=x; x=y; y=h;}

bool ungleich1(double x,double y)
{
 const double d=1e-6,mehrals1=1+d,wenigerals1=1-d;
 return (x>mehrals1 || x<wenigerals1 || y>mehrals1 || y<wenigerals1);
}

void system2(const char *s,const char *p1,const char *p2)
{
 char *str=new char[strlen(s)+strlen(p1)+strlen(p2)+1];
 sprintf(str,s,p1,p2);
 system(str);
 delete str;
}

char *strkopie(const char *s1)
{
 if(s1==NULL || *s1==0) return NULL;
 char *s=new char[strlen(s1)+1], *t;
 for(t=s;*t++ = *s1++;)  ;
 return s;
}

char *nextline(char *txt)
{
 int c;
 while((c= *txt++)!='\n')
   {if(c==0) return NULL;}
 return txt;
}

char *nampars(char *txt)
{
 int c,i;
 if(*txt=='%' && txt[1]=='!') return "PS-head";
 if((c= *txt++)==0 || c=='\n') return NULL;
 while((c= *txt++)!='%')
   {if(c==0 || c=='\n') return NULL;}
 char *s,*t,*name=new char[80];
 for(i=1,s=txt,t=name;i<80 && (c= *s++) && c!='\n';i++)
	*t++ = c;
 *t=0;
 return name;
}

/********************* einfache Grafik-Routinen ***********************/
void eckemarkieren(double x,double y,double d)
{
 fillbox(x-d,y-d,x+d,y+d);
}
void eckemarkier(double x,double y,double d)
{
 drawbox(x-d,y-d,x+d,y+d);
}

void drehe(double ca,double sa,double x1,double y1,double xm,double ym,
	   double& x2,double& y2)
{
 x1-=xm; y1-=ym;
 x2=ca*x1-sa*y1+xm;
 y2=sa*x1+ca*y1+ym;
}

void linie(double x1,double y1,double x2,double y2,double x3,double y3)
{
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN); plot(x3,y3,PENDOWN);
}

void drawcirc(double a,double b,double x0,double y0,double r)
{
 double alfa,da;
 int i,n, pen=PENUP;
 if(b<a) {da=b; b=a; a=da;}
 n=int((b-a)/GRAD); if(n<20) n=20;
 for(i=0,da=(b-a)/n;i<=n;i++,pen=PENDOWN)
   {alfa=a+i*da;
    plot(x0+cos(alfa)*r,y0+sin(alfa)*r,pen);
   }
}

void drawboxgedreht(double alfa,double xa,double ya,double xb,double yb)
{
 double ca=cos(alfa),sa=sin(alfa),xm=(xa+xb)/2,ym=(ya+yb)/2;
 double x1,y1,x2,y2,x3,y3,x4,y4,r,a;
 drehe(ca,sa,xa,ya,xm,ym,x1,y1);
 drehe(ca,sa,xa,yb,xm,ym,x2,y2);
 drehe(ca,sa,xb,yb,xm,ym,x3,y3);
 drehe(ca,sa,xb,ya,xm,ym,x4,y4);
 drawbox(xa,ya,xb,yb);//ungedrehte Box
 linie(xb,yb,xm,ym,x3,y3);//winkel
 r=sqrt(sq(x3-xm)+sq(y3-ym))/2, a=atan2(yb-ym,xb-xm);
 drawcirc(a,a+alfa,xm,ym,r);
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN); plot(x3,y3,PENDOWN);
 plot(x4,y4,PENDOWN); plot(x1,y1,PENDOWN);
}

/*************************** PS-Analyse *******************************/
const int PS_TRANSLATE=1,PS_SCALE=2,PS_ROTATE=3,PS_SETRGBCOLOR=4,
          PS_SAVE=5,PS_GSAVE=6, PS_MAX=7;

char *getbef(int bef)
{
 switch(bef)
   {case PS_SAVE: return "save";
    CASE PS_GSAVE: return "gsave";
    CASE PS_TRANSLATE: return "translate";
    CASE PS_SCALE: return "scale";
    CASE PS_ROTATE: return "rotate";
    CASE PS_SETRGBCOLOR: return "setrgbcolor";
   }
 return "ERROR_in_getbef()";
}

int parsworte(char *s,char *w1,char *w2,char *w3,char *w4,char*koment)
{
 int c=' ',j,i,imax=40;
 char *t,scratch[imax];
 *koment=0;
 for(j=0;j<5 && c!='\n' && c!='%';j++)
   {switch(j) {case 0: t=w1; CASE 1: t=w2; CASE 2: t=w3; CASE 3: t=w4;
	       DEFAULT: t=scratch;
	      }
    while((c= *s++) && isspace(c)) ;
    for(i=1;c!=' ' && c!='\t' && c!='\n';)
      {if(c=='%')
	 {while(c>=' ') {*koment++ = c; c= *s++;}
	  *koment=0; return j;
	 }
       if(c==0 || ++i==imax) return j;
       *t++ =c; c= *s++;
      }
    *t=0;
   }
 return j;
}

int anni(char *zeile,double*p1,double*p2,double*p3,char*koment)
{   //Analyse einer PS-Zeile
 char w1[40],w2[40],w3[40],w4[40];
 int n=parsworte(zeile,w1,w2,w3,w4,koment);
 switch(n)
   {case 1:
      if(strcmp(w1,"save")==0) return PS_SAVE;
      else if(strcmp(w1,"gsave")==0) return PS_GSAVE;
    CASE 3:
      sscanf(w1,"%lf",p1); sscanf(w2,"%lf",p2);
      if(strcmp(w3,"translate")==0) return PS_TRANSLATE;
      else if(strcmp(w3,"scale")==0) return PS_SCALE;
      else if(strcmp(w3,"rotate")==0) return PS_ROTATE;
    CASE 4:
      sscanf(w1,"%lf",p1); sscanf(w2,"%lf",p2); sscanf(w3,"%lf",p3);
      if(strcmp(w4,"setrgbcolor")==0) return PS_SETRGBCOLOR;
   }
 return 0;
}

/***************************** Klassen ********************************/
class Farbe
{
 bool immer;
public:
 double red,green,blue;
 Farbe() {red=green=blue=0; immer=0;}
 void setrgb(double r,double g,double b,bool i=false)
	{red=r; green=g; blue=b; if(i) immer=true;}
 bool gesetzt() {return (immer || red!=0 || green!=0 || blue!=0);}
};

inline void exch(Farbe& x,Farbe& y) {Farbe h=x; x=y; y=h;}

class Statuszeile
{
 double x,y;
public:
 double hoehe,breite;
 Statuszeile() {hoehe=20; breite=10*hoehe; x=0; y= -2-hoehe;}
 void write(char*,double p1=0);
 void clear() {color(WEISS); fillbox(x,y,x+breite,y+hoehe);}
};
static Statuszeile status;
void Statuszeile::write(char *s,double p1)
{
 char str[200];
 sprintf(str,s,p1);
 schrift(x,y,str);
}

class Unendstring
{
 char *str;
 long len,max;
public:
 Unendstring(long max0=1024) {str=new char[max=max0]; len=0;}
 ~Unendstring() {delete str;}
 char& operator[](long i);
 int get(long i) {return i>=len?EOF:str[i]&0xFF;}
 void clear() {len=0;}
};
char& Unendstring::operator[](long i)
{
 if(i>=max)
   {long k;
    while(i>=max) max+=max;
    char *neu=new char[max];
    for(k=0;k<len;k++) neu[k]=str[k];
    delete str;
    str=neu;
   }
 if(i>=len) {len=i+1; str[i]=0;}
 return str[i];
}

class Undowerte
{
 double x1,y1,x2,y2;
 char *name;
public:
 Farbe farbe;
 double winkel; //in Grad
 Undowerte() {name=NULL; winkel=0;}
 ~Undowerte() {if(name) delete name;}
 void setbox(double px1,double py1,double px2,double py2)
	{x1=px1; y1=py1; x2=px2; y2=py2;}
 void getbox(double *px1,double *py1,double *px2,double *py2)
	{*px1=x1; *py1=y1; *px2=x2; *py2=y2;}
 void pushname(char *nam) {if(name) delete name;  name=nam;}
 void pushnamekopie(char *nam) {if(name) delete name;  name=strkopie(nam);}
 void tausche(double& xa,double& ya,double& xb,double& yb,double& w,
	      Farbe& f,char **nam)
	{exch(xa,x1); exch(ya,y1); exch(xb,x2); exch(yb,y2); exch(f,farbe);
	 exch(w,winkel);
	 char* s=name; name= *nam; *nam=s;
	}
};

class Vobjekt
{
 double x1,y1,x2,y2; //Box
 double x01,y01,x02,y02; //Urspruengliche Box
 char *start;
 int ecke,kante,modus;
 double winkel; //in Grad
 Farbe farbe;
 int savemethode;
 char *koments[PS_MAX];
 Undowerte undo;
 int lastsel;
public:
 char *name;
 Vobjekt *next;
 Vobjekt() {name=NULL; winkel=0; savemethode=0; modus=0; lastsel=0;
	    for(int i=0;i<PS_MAX;) koments[i++]=NULL;
	   }
 ~Vobjekt() {if(next) delete next;  if(name) delete name;}
 void init(double px1,double py1,double px2,double py2,char *nam,char *star)
	{x1=x01=px1; y1=y01=py1; x2=x02=px2; y2=y02=py2; name=nam; start=star;
	 undo.setbox(x1,y1,x2,y2); undo.pushnamekopie(name);
	}
 void set(double px1,double py1,double px2,double py2)
	{undo.setbox(x1,y1,x2,y2); x1=px1; y1=py1; x2=px2; y2=py2;}
 void get(double *px1,double *py1,double *px2,double *py2,double *alfa)
	{*px1=x1; *py1=y1; *px2=x2; *py2=y2; *alfa=winkel;}
 void getscale(double*,double*,double*,double*);
 void setscale(double,double,double,double);
 double nah(double,double);
 void change(int m) {modus=m&MODCHA;}
 void change(int m,double x,double y);
 void print(FILE*);
 void getfarbe(double*r,double*g,double*b)
	{*r=farbe.red; *g=farbe.green; *b=farbe.blue;}
 void setfarbe(double r,double g,double b)
	{undo.farbe=farbe; farbe.setrgb(r,g,b);}
 void setfarbe(double r,double g,double b,char*koment,char*star=NULL);
 void setsave(int bef,char*koment,char*star)
	{koments[savemethode=bef]=strkopie(koment); start=star;}
 double getwinkelingrad() {return winkel;}
 void   setwinkelingrad(double a) {undo.winkel=winkel; winkel=a;}
 void setname(char *nam) {if(name) undo.pushname(name);  name=strkopie(nam);}
 void oundo() {undo.tausche(x1,y1,x2,y2,winkel,farbe,&name);}
 void undosave()
	{undo.setbox(x1,y1,x2,y2); undo.pushnamekopie(name);
	 undo.winkel=winkel; undo.farbe=farbe;
	}
  // void zeichnen();
 void zeichnen(bool selected);
 void zeichnen(bool selected,int fa);
 void loeschen() {zeichnen(true,WEISS);}
};
void Vobjekt::setfarbe(double r,double g,double b,char*koment,char*star)
{
 farbe.setrgb(r,g,b,koment!=NULL);
 koments[PS_SETRGBCOLOR]=strkopie(koment);
 start=star;
 undo.farbe=farbe;
}
void Vobjekt::print(FILE *fp)
{
 char *s,*endstring,*ko; int c;
 double xf,yf,xsh,ysh;
 bool veraendert, istkopf=(*start=='%' && start[1]=='!');
 getscale(&xf,&yf,&xsh,&ysh);
 if(!istkopf) fprintf(fp,"%%Objektbox: %lg %lg %lg %lg\n",x1,y1,x2,y2);
 veraendert=(xsh!=0 || ysh!=0 || xf!=1 || yf!=1 || winkel!=0);
 if(savemethode || veraendert)
   {s=(savemethode!=0)?getbef(savemethode):"save"; //"save" oder "gsave"
    if(name!=NULL) fprintf(fp,"%s %%%s\n",s,name);
    else fprintf(fp,"%s\n",s);
   }
 if(veraendert)
   {if(winkel!=0)
      {double xt=(x1+x2)/2, yt=(y1+y2)/2;
       fprintf(fp,"%lg %lg translate %lg rotate %lg %lg translate\n",
	       xt,yt, winkel, -xt,-yt);
      }
    if(ungleich1(xf,yf))
      {double xt=x1, yt=y1;
       fprintf(fp,"%lg %lg translate %lg %lg scale %lg %lg translate\n",
	       xt,yt, xf,yf, -xt,-yt);
      }
    if(xsh!=0 || ysh!=0) fprintf(fp,"%lg %lg translate\n",xsh,ysh);
   }
 if(farbe.gesetzt())
   {if(ko=koments[PS_SETRGBCOLOR])
         fprintf(fp,"%lg %lg %lg setrgbcolor %s\n",
		    farbe.red,farbe.green,farbe.blue,ko);
    else fprintf(fp,"%lg %lg %lg setrgbcolor\n",
		    farbe.red,farbe.green,farbe.blue);
   }
 if(istkopf) endstring="Objektbox:"; else endstring="Objektende";
 for(s=start;(c= *s++)!=0 && (c!='%' || strncmp(s,endstring,10)!=0);)
      putc(c,fp);
 if(veraendert && savemethode==0) fprintf(fp,"restore\n");
 if(!istkopf) fprintf(fp,"%%Objektende\n");
}
double Vobjekt::nah(double x,double y)
{
 double xa=abs(x-x1),ya=abs(y-y1);
 ecke=0;
 if(abs(x-x2) < xa) {xa=abs(x-x2); ecke+=1;}
 if(abs(y-y2) < ya) {ya=abs(y-y2); ecke+=2;}
 if(xa>20 && ya<10) kante=1;
 else if(xa<10 && ya>20) kante=2;
 else kante=0;
 return xa+ya;
}
void Vobjekt::change(int m,double x,double y)
{
 static double alfa0=0;
 static int alfa0gueltig=0;
 loeschen();
 if((modus=m&MODCHA)!=ROTA) alfa0gueltig=0;
 switch(modus)
   {case DRAG:	x1+=x; x2+=x; y1+=y; y2+=y;
    CASE SIZE:	if((kante&1)==0) {if(ecke&1) x2+=x; else x1+=x;}
		if((kante&2)==0) {if(ecke&2) y2+=y; else y1+=y;}
    CASE ROTA: {double alfa, x0=(x1+x2)/2, y0=(y1+y2)/2;
		alfa=atan2(y-y0,x-x0)/GRAD;
		if(alfa0gueltig) winkel=alfa-alfa0;
		else {alfa0=alfa; alfa0gueltig=1;}
	       }
   }
}
void Vobjekt::getscale(double* xf,double* yf,double* xsh,double* ysh)
{
 *xsh=x1-x01; *ysh=y1-y01;
 if(x02==x01) x02+=1;
 *xf=(x2-x1)/(x02-x01);
 if(y02==y01) y02+=1;
 *yf=(y2-y1)/(y02-y01);
}
void Vobjekt::setscale(double xf,double yf,double xsh,double ysh)
{
 undo.setbox(x1,y1,x2,y2);
 x1=x01+xsh; x2=x1+xf*(x02-x01);
 y1=y01+ysh; y2=y1+yf*(y02-y01);
}

/*
void Vobjekt::zeichnen()
{
 inital_new();
 zeichnen(false);
 term_refresh();
}
*/
void Vobjekt::zeichnen(bool selected)
{
 const int fa=2;
 if(farbe.gesetzt())
   {int r=int(255*farbe.red),g=int(255*farbe.green),b=int(255*farbe.blue);
    if(r>240 && g>240 && b>240) r=g=b=220;//aus weiss mach hellgrau
    setcolor(fa,r,g,b);
   }
 else setcolor(fa,0,0,0);
 zeichnen(selected,fa);
}
void Vobjekt::zeichnen(bool selected,int fa)
{
 color(fa);
 if(winkel==0) drawbox(x1,y1,x2,y2);
 else drawboxgedreht(winkel*GRAD,x1,y1,x2,y2);
 if(selected)
   {double h=(abs(y2-y1)-4)/4, h2=(abs(x2-x1)-4)/4, d=4;
    if(h2<h) h=h2;
    if(h<d) d=h<1?1:h;
    eckemarkieren(x1,y1,d); eckemarkieren(x1,y2,d);
    eckemarkieren(x2,y1,d); eckemarkieren(x2,y2,d);
    eckemarkieren(h=(x1+x2)/2,y1,d); eckemarkieren(h,y2,d);
    eckemarkieren(x1,h=(y1+y2)/2,d); eckemarkieren(x2,h,d);
    if(fa<0)
      {color(SCHWARZ);
       switch(modus)
	 {case ROTA: eckemarkier(x2,y2,d);
	  CASE SIZE: eckemarkier(x1,y1,d);
	 }
      }
   }
 lastsel=selected;
}

class Fenster
{
 int maxcol,modus;
 double mausx,mausy; //letzte Mausposition
 bool mauswurdebewegt;
 int breite,hoehe,tiefe,visklasse; //Fenstergroesse
 double xmin,ymin,xmax,ymax; //Userkoordinaten
 double bx,hy; //Schriftgroessen
 Unendstring inhalt;
 Vobjekt *objlist; //Liste der Objekte
public:
 bool gesaved;
 char *aktuellerdateiname;
 Vobjekt *oselect; //selektiertes Objekt
 Fenster(char*,int b=12500,int h=10000,int t=24);
 ~Fenster();
 int run(char *text=NULL);
 void load(char *name);
 void save(const char *name);
 void save() {save(aktuellerdateiname);}
 void saveas();
 void asksave();
 void zeichnen(bool all=true,bool inital=true);
 void press();
 void releas();
 void motion();
 void expun();
 void addobjekt(double x1,double y1,double x2,double y2,char *star);
};
void pre() {if(aktivesfenster) aktivesfenster->press();}
void rel() {if(aktivesfenster) aktivesfenster->releas();}
void mot() {if(aktivesfenster) aktivesfenster->motion();}
void expu() {if(aktivesfenster) aktivesfenster->expun();}
Fenster::Fenster(char *name,int br,int ho,int ti)
{
 exitflag=0; aktuellerdateiname=NULL; gesaved=true;
 oselect=objlist=NULL; modus=MOTSEL;
 mausx=mausy= -1; mauswurdebewegt=false;
 xmin= -50; ymin= -(status.hoehe+5); xmax=596+50; ymax=841.;
 bx=(xmax-xmin)/100; hy=(ymax-ymin)/40;
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(hoehe>ho) hoehe=ho;
 br=int(hoehe/(ymax-ymin)*(xmax-xmin)+0.5); if(breite>br) breite=br;
 if(tiefe>ti) tiefe=ti;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(3,"File",     "Edit",    "Show");
 setmenu(3,"About ...","undo",    "ghostview",&m_about,&m_oundo,&m_gost);
 setmenu(2,"Load ...", "Name ...",&m_load,&m_oname);
 setmenu(2,"Save",     "Size & Position ...",&m_save,&m_osize);
 setmenu(2,"Save as ...","Scale & Shift ...",&m_saveas,&m_oscale);
 setmenu(2,"Exit",     "text editor",&m_exit,&m_oedit);
 set_funktions(pre,rel,expu,mot);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 set_tektitel(name);
 screenclear(1); color(0);
 term_refresh();
}
Fenster::~Fenster()
{
 term_exit();
}
void Fenster::addobjekt(double x1,double y1,double x2,double y2,char *star)
{
 Vobjekt *neu=new Vobjekt[1];
 Vobjekt *obj;
 neu->next=NULL; neu->init(x1,y1,x2,y2,nampars(star),star);
 if(objlist==NULL) objlist=neu;
 else
   {for(obj=objlist;obj->next!=NULL;obj=obj->next) ;
    obj->next=neu;
   }
 int bef,c,j;
 double p1,p2,p3;
 char koment[80];
 for(j=0;(bef=anni(star,&p1,&p2,&p3,koment))!=0;j++)
   {//printf("anni() --> '%s' koment='%s'\n",getbef(bef),koment);//test
    while((c= *star++) && c!='\n') ;//nchste Zeile
    if(bef==PS_SETRGBCOLOR) neu->setfarbe(p1,p2,p3,koment,star);
    else if(bef==PS_SAVE || bef==PS_GSAVE)
      {if(j==0) neu->setsave(bef,koment,star); else break;}
    else break;
   }
}

/************************* Men Behandlung ****************************/
void m_exit() {exitflag=1;}
void m_about()
{
 char str[80];
 sprintf(str,"voed %s\nAutor: Rolf Pfister",VERSION);
 janeinrequester(str);
}
void m_load()
{
 char name[80]; name[0]=0;
 int ok=nachfilenamefragen("lade PostScript-Datei",name,80);
 if(ok) aktivesfenster->load(name);
}
void m_save()
{
 aktivesfenster->save();
}
void m_saveas()
{
 aktivesfenster->saveas();
}
void m_oname()
{
 Vobjekt *obj;
 if((obj=aktivesfenster->oselect)==NULL)
   janeinrequester("first select an object","ok");
 else
   {char name[200];
    int ok;
    if(obj->name==NULL) *name=0;
    else strcpy(name,obj->name);
    ok=requester_input(1,"name of active object","%s","%s",name);
    if(ok)
      {if(*name==0) obj->setname(NULL);
       else
	 {obj->setname(name);
	  aktivesfenster->gesaved=false;
	 }
      }
   }
 aktivesfenster->zeichnen();
}
void m_osize()
{
 Vobjekt *obj;
 if((obj=aktivesfenster->oselect)==NULL)
   janeinrequester("first select an object","ok");
 else
   {char name[200];
    double br,ho,x1,y1,x2,y2,alfa,red,gre,blu;
    int ok;
    if(obj->name==NULL) *name=0;
    else strcpy(name,obj->name);
    obj->get(&x1,&y1,&x2,&y2,&alfa);
    obj->getfarbe(&red,&gre,&blu);
    br=x2-x1; ho=y2-y1;
    ok=requester_input(9,"name of active object","%s","%s\n",name,
		         "  Breite  ","%.3lf","%lf",&br,
		         "  Hoehe   ","%.3lf","%lf\n",&ho,
		         "Position x","%.3lf","%lf",&x1,
		         "Position y","%.3lf","%lf\n",&y1,
		         " Rotation / DEG ","%lg","%lf\n",&alfa,
		         "Color: R  ","%lf","%lf",&red,
		         "    G  ","%lf","%lf",&gre,
		         "    B  ","%lf","%lf",&blu);
    if(ok)
      {obj->setname(name);
       x2=x1+br; y2=y1+ho;
       obj->set(x1,y1,x2,y2);
       obj->setfarbe(red,gre,blu);
       obj->setwinkelingrad(alfa);
       aktivesfenster->gesaved=false;
      }
   }
 aktivesfenster->zeichnen();
}
void m_oscale()
{
 Vobjekt *obj;
 if((obj=aktivesfenster->oselect)==NULL)
   janeinrequester("first select an object","ok");
 else
   {char name[200];
    double xf,yf,xsh,ysh,red,gre,blu,alfa;
    int ok;
    if(obj->name==NULL) *name=0;
    else strcpy(name,obj->name);
    obj->getscale(&xf,&yf,&xsh,&ysh);
    obj->getfarbe(&red,&gre,&blu);
    alfa=obj->getwinkelingrad();
    ok=requester_input(9,"name of active object","%s","%s\n",name,
		         "  x scale  ","%.3lf","%lf",&xf,
		         "  y scale  ","%.3lf","%lf\n",&yf,
		         "  x shift  ","%.3lf","%lf",&xsh,
		         "  y shift  ","%.3lf","%lf\n",&ysh,
		         " Rotation / DEG ","%lg","%lf\n",&alfa,
		         "Color: R  ","%lf","%lf",&red,
		         "    G  ","%lf","%lf",&gre,
		         "    B  ","%lf","%lf\n",&blu);
    if(ok)
      {obj->setname(name);
       obj->setscale(xf,yf,xsh,ysh);
       obj->setfarbe(red,gre,blu);
       obj->setwinkelingrad(alfa);
       aktivesfenster->gesaved=false;
      }
   }
 aktivesfenster->zeichnen();
}
void m_oedit()
{
 if(!aktivesfenster->gesaved) aktivesfenster->asksave();
 char *ed=getenv("EDITOR");
 if(ed==NULL)
   {printf("Warning: EDITOR not defined - defaults to emacs\n"); ed="emacs";}
 system2("%s %s",ed,aktivesfenster->aktuellerdateiname);
}
void m_oundo()
{
 Vobjekt *obj;
 if((obj=aktivesfenster->oselect)==NULL)
   janeinrequester("first select an object","ok");
 else
   obj->oundo();
 aktivesfenster->zeichnen();
}
void m_gost()
{
 aktivesfenster->save(TMPNAME);
 system2("%s %s","ghostview",TMPNAME);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int ok;
 char fenstername[80],dateiname[80];
 if(argc>1 && *argv[1]=='?')
	{printf("voed  %s\n",VERSION);
	 exit(0);
	}
 sprintf(fenstername,"voed  %s",VERSION);
 if(argc>1)
   strcpy(dateiname,argv[1]);
 else
   {printf("PostScript-Datei:"); scanf("%s",dateiname);}
/* test
 {
  Fenster klein("kleines Fenster",320,256);
  aktivesfenster= &klein;
  ok=klein.run("Hallo Welt");
 }
*/
 {
  Fenster gross(fenstername,1024,768,4);
  aktivesfenster= &gross;
  ok=gross.run(dateiname);
 }
 return ok;
}/* ende von main */

int Fenster::run(char *text)
{
 int ok=1;
 if(text) load(text);
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
 if(!gesaved) asksave();
 return ok;
}

void Fenster::load(char *name)
{
 FILE *fp;
 int i,j,c;
 double x1,y1,x2,y2;
 if(!gesaved) asksave();
 if(objlist) {delete objlist; oselect=objlist=NULL;}
 inhalt.clear();
 if((fp=fopen(name,"r"))==NULL)
   {printf("cant find '%s'\n",name); return;}
 for(i=0;(c=getc(fp))!=EOF;)
   inhalt[i++]=c;
 fclose(fp);
 if(aktuellerdateiname!=NULL) delete aktuellerdateiname;
 aktuellerdateiname=strkopie(name); gesaved=true;
 addobjekt(0,0,596,841,&inhalt[0]);
 for(j=0;(c=inhalt.get(j++))!=EOF;)
   {if(c!='%' || strncmp(&inhalt[j],"Objektbox:",10)!=0) continue;
    sscanf(&inhalt[j+10],"%lf %lf %lf %lf",&x1,&y1,&x2,&y2);
    addobjekt(x1,y1,x2,y2,nextline(&inhalt[j+10]));
   }
 zeichnen();
}

void Fenster::zeichnen(bool all,bool inital)
{
 Vobjekt *obj;
 double x1,y1,x2,y2,alfa;
 if(inital) inital_new();
 if(all)
  {screenclear(WEISS);
   plot(0.,0.,PENUP); plot(0.,841.,PENDOWN); plot(596.,841.,PENDOWN);
   plot(596.,0.,PENDOWN); plot(0.,0.,PENDOWN); // Hintergrundbild zeichnen
  }
 else status.clear();
 for(obj=objlist;obj!=NULL;obj=obj->next)
   obj->zeichnen(obj==oselect);
 switch(modus&MODCHA)
   {case DRAG: status.write("DRAG");
    CASE SIZE: status.write("SIZE");
    CASE ROTA: status.write("ROTA");
   }
 if(inital) term_refresh();
}

void Fenster::save(const char *name)
{
 FILE *fp;
 int i,c;
 Vobjekt *obj;
 if(name==NULL) name=aktuellerdateiname;
 if(fp=fopen(name,"r")) {fclose(fp); system2("cp %s %s.bak",name,name);}
 if((fp=fopen(name,"w"))==NULL)
   {printf("cant crate '%s'\n",name); return;}
 for(obj=objlist;obj!=NULL;obj=obj->next)
   {obj->print(fp);
   }
 fclose(fp);
 if(strcmp(name,TMPNAME)!=0)
   {gesaved=true; if(aktuellerdateiname) delete aktuellerdateiname;
    aktuellerdateiname=strkopie(name);
   }
 zeichnen();
}
void Fenster::saveas()
{
 char name[80]; strcpy(name,aktuellerdateiname);
 int ok=nachfilenamefragen("save as ...",name,80);
 if(ok) save(name);
}
void Fenster::asksave()
{
 int ok=janeinrequester(
	  "aktuelle Datei wurde veraendert\nSoll sie gesichert werden ?",
	  "ja","nein");
 if(ok) saveas();
}

void Fenster::motion()
{
 double x,y,a,abest=10;
 static double lastx,lasty;
 static int lastf=0;
 Vobjekt *obj,*obest=NULL;
 mausposition(&x,&y);
 if(abs(x-mausx)>2 && abs(y-mausy)>2)
   {if(!mauswurdebewegt && oselect!=NULL && (modus&MAUSPRE)!=0)
      {lastx=mausx; lasty=mausy; lastf=1; oselect->undosave();}
    mauswurdebewegt=true;
   }
 inital_new();
 switch(modus)
  {case MOTSEL:
     for(obj=objlist;obj!=NULL;obj=obj->next)
       {a=obj->nah(x,y);
        if(a<abest) {obest=obj; abest=a;}
       }
     if(obest!=NULL && obest!=oselect)
       {if(oselect) oselect->loeschen();
        oselect=obest;
       }
     lastf=0;
   CASE MOTSEL+MAUSPRE:
     if(mauswurdebewegt) modus=DRAG+MAUSPRE;
   CASE DRAG+MAUSPRE: case SIZE+MAUSPRE:
     if(lastf && oselect!=NULL)
		{oselect->change(modus,x-lastx,y-lasty); gesaved=false;}
     lastx=x; lasty=y; lastf=1;
   CASE ROTA+MAUSPRE:
     if(lastf && oselect!=NULL) {oselect->change(modus,x,y); gesaved=false;}
     lastx=x; lasty=y; lastf=1;
   DEFAULT:
     lastf=0;
     if(oselect && oselect->nah(x,y)>200)
       {modus=MOTSEL; oselect->change(modus);}
  }
 zeichnen(0,0);
 term_refresh();
}
void Fenster::expun()
{
 //printf("expun()\n");//test
 zeichnen();
}
void Fenster::press()
{
 double x,y;
 mausposition(&x,&y);
 // printf("Mausknopf gedrueckt x=%.1lf y=%.1lf\n",x,y);//test
 modus |= MAUSPRE;
 mausx=x; mausy=y; mauswurdebewegt=false;
 if(oselect!=NULL) oselect->nah(x,y); //Ecke selektieren
 zeichnen(0);
}
void Fenster::releas()
{
 double x,y,a;
 modus &= ~MAUSPRE;
 mausposition(&x,&y);
 if(abs(x-mausx)>2 && abs(y-mausy)>2) mauswurdebewegt=true;
 if(!mauswurdebewegt)
   {a=(oselect!=NULL)?oselect->nah(mausx,mausy):1000;
    if(a>20)
      {modus=MOTSEL;}
    else
      switch(modus)
       {case MOTSEL: modus=DRAG;
	CASE DRAG: modus=SIZE;
	CASE SIZE: modus=ROTA;
	CASE ROTA: modus=MOTSEL;
	DEFAULT: printf("unknown modus=%d in Fenster::releas()\n",modus);
       }
   }
 zeichnen(0);
}
