#include <stdio.h>
#include <math.h>
#include <xtekplot1.h>
#define NS 16 /* Anzahl 'Speichen' des Rades */
#define PI 3.14159265358979
static int exitflag=0; void menu_exit() {exitflag=1;}

int main()
{
 double xmin= -1.3, ymin= -1., xmax=1.3,ymax=1., bigrad=0.7,radius=0.15,w;
 int i,j,j0=0,r[NS],g[NS],b[NS],step,gstep,rot,gruen,blau,ticks;
 setmenu(1,"File"); setmenu(1,"Exit",&menu_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 step=255/NS; gstep=2*step; rot=255; gruen=0; blau=0;
 for(i=0;i<NS;i++)
  {r[i]=rot; if((rot-=step)<0) rot=0;
   g[i]=gruen; if((gruen+=gstep)>=255) {gruen=255; gstep= -step;}
               else if(gruen<0) gruen=0;
   b[i]=blau; blau+=step;
   setcolor(i+2,r[i],g[i],b[i]);
  }
 ticks=50/NS; /* Wartezeit fuer 1 Umdrehung pro Sekunde */
 if(ticks==0) ticks=1;
 while(exitflag==0 && waitmenu(0)==0)
  {for(i=0,j=j0;i<NS;i++)              /* Aendern der Farbzuordnungen */
	{setcolor(i+2,r[j],g[j],b[j]); /* hat nur mit PseudoColor die */
	 if(++j==NS) j=0;              /* gewuenschte Wirkung.        */
	}
   if(++j0==NS) j0=0;
   for(i=0,w=0.;i<NS;i++,w+=2*PI/NS) /* 'Speichen' zeichnen */
    {color(i+2); fillcircle(bigrad*sin(w),bigrad*cos(w),radius,radius);}
   Delay(ticks); /* soviele 1/50 Sekunden warten */
  }
 term_exit();
 return 0;
}
