/* xtekplot1.cc             letzte Aenderungen: 21.8.2012, 23.1.2014
neuste Verbesserungen:
 - Leerstellen und Umlaute in Dateinamen, UTF8-Texte
 - Testausdrucke falls in menu_font_anfordern() keine Fonts gefunden werden
*/
const char *tekplot_version =     "Version 2.94";
#define FENSTERNAME "  XTEKPLOT1   Version 2.94"

//#define ALPHA
//#define VAX
#define UNIX
//#define MACOSX

//auskommentieren wenn keine Umlaute gebraucht werden:
#define MITUMLAUTEN

/*
  Uebersetzen unter VMS:
;ALPHA> cx xtekplot1
;ALPHA> cp xtekplot1.obj [pfister.obj]
;VAX> gx2 xtekplot1
  Einbindung beim Linken:
$ LINK ...,XTEKPLOT1,SYS$INPUT/OPT
sys$share:decw$xlibshr/share
^Z

 Uebersetzen auf Unix:
;UNIX> c++ -lm -lX11 -I$h -c xtekplot1.cc

History:
27.1.1995 V2.0  Erstellung aus tekplot.cc Version 1.9 und xmenu.cc
7.2.95     2.1  Astprog und inital1flag wegkommentiert
                loeschsymbol(), clear(), qgclear(), qesc() gelscht
                qselect() und quickflag gelscht
9.2.95          PLOTC wegoptimiert, in tek_pen() pattern korrigiert,
                kleine Korrekturen in bildplot() post-Teil
10.2.95                Funktionen umbenannt:
                  nur fr Fortran:   inital plot line grein
                  fr Fortran und C: plotsave (line grein pen fr Tests)
                  nur fr C:         qinital q2plot tek_line tek_grein
                                     tek_pen
                Grsse der Farbtabelle auf 256 fixiert und Fehler beseitigt.
5.4.95          plotsave verbessert
29.6.95         tek_punkt()
19.9.95         Winkel in ischrift() eingefgt. Geht aber erst beim Speichern
                unter Postscript.
29.9.95         Funktionen eingefgt: nachfilenamefragen() noch provi.
16.10.95   2.2  keyget() fr Tastaturabfrage, Delay() UNIX-Version,
                automenu fr noch einfacheren Einstieg in Grafikprogrammierung
10.11.95        Einige fehlende PLOT_FLUSH() eingefgt
                und neue Funktion tek_flush()
(falls Tabelle ab hier falsch eingerueckt: Tabulatorlaenge auf 8 einstellen)
30.11.95	provisorische nderungen fr VECTMAL
10.1.96		Fontanpassung fr eXodus auf MAC
7.2.96		Verbesserung im xmenu-Teil: Abgrenzungen zeichnen
19.2.96	  2.3	zustzlicher Parameter max in getmenuids()
28.5.96		hintergrundflag fr VECTMAL lesbar gemacht
25.7.96   2.4   Variablen neu extern zugaenglich:
			tekplot_fpbild  tekplot_fenstername
		nur unter XWindows zugaenglich:
			tekplot_rambild  _initalflag _rambildflag _refreshflag
		set_funktions() angefuegt.
8.1.97		janeinrequester() fuer mehrzeilige Meldungen angepasst
		Menuaufruf mit Amigataste vorbereitet
17.1.97		setzergbtabelle() angefuegt.
		In screenclear() optionaler Parameter definiert.
12.2.97		UNIX-Anpassung in Getenv() und Setenv()
6.3.97		tekplot1xtras.cc eingefuegt
13.5.97		drawmode(COMPLEMENT) korrigiert
2.2.98		Fehler mit usleep mit __linux__ nicht vorhanden.
26.8.98		Provisorische Loesung des Problems mit DELL und DELR
		In eingabekursor() "if(reqhigrund!=0)" eingefuegt.
23.9.98   2.5	Filerequester: nachfilenamefragen() neu programmiert,
		dazu grssere nderungen in xrequester_start()
27.10.98	Verbesserungen in xrequester_start()
8.1.99	  2.6	neue Funktionen: getaspect() setaspect() get_tekplot_version()
		screenmode_file_open()
1.3.99		kleiner Fehler in eingabekursor(): maxwert statt minwert.
28.4.99	  2.7	Klasse Menuaufklapper um Menus tastaturgesteuert zu benutzen
		auch Requester tastaturgesteuert benutzbar (neuerfokus)
18.5.99		Menuaufruf mit Amigataste (class Amigatast)
		Bei Submenus werden die id-Nummern noch nicht richtig gesetzt,
		das heisst man kann Untermenus die veraendert werden sollen
		(z.B. Haken setzen) keine Amigataste zuweisen.
19.5.		Bessere Tastaturunterstuetzung bei Requestern (doppelbox())
3.12.2001  2.8	Ein Flimmerproblem behoben. Mit setxsync() kann altes
		Verhalten im Bedarfsfall weiterhin verwendet werden.
8.3.2002        Provisorische Variante von changebuffer()
16.12.2002	rgbtabelle auf 32 voreingestellte Farben erhoeht (vorher 18)
31.3.2003	bei %%!PS-Adobe berflssiges % gelscht (gibt Fehler mit
		neuer Version von fprintf)
24.2.2004  2.81	Anpassung an MacOSX (Panther 10.3.2)
11.4.2004	In plot() ERROR -> WARNING und auf 5 mal beschraenkt
20.10.06	Beim setzen von menubalkenhoehe nur setzen wenn ein
		Menu vorhanden [if(menuvorhanden()) ...]
		Neues Unterprogramm: void setmaxfarben(int max)
18.12.06   2.82 Erste funktionierende Variante von changebuffer()
		einfaches Doublebuffering geht somit.
           2.83 an ein paar Stellen tekplot_win durch win1 ersetzt,
	        in maustasten() win1 durch tekplot_win ersetzt.
8.2.07     2.84 Vollbildmodus: fullscreen_modus(1)
19.2.07    2.85 Vermeidung der Farbtabelle bei Farbtiefe==24
		Neue Funktion: void rgbcolor(int r,int g,int b)
20.2.07         requester_datei() verbessert:
		Filter wird jetzt ausgwertet (Trick mit g_filter),
		xrequester_start jetzt neue Variante verwendet
		Schliesssymbol geht jetzt auch (waitmenu() Rueckgabewert)
1.3.07	   2.86	xrequester_start stark verbessert
4.3.07          mydept=24 als Voreinstellung,
                drawmode() fuer 24-Bit-Farbtiefe angepasst
11.3.07    2.87 Fehler, der Absturz in Requestern verursacht hat, korrigiert:
                in term_exit() requester_font_flag=0
		Absturz in waitmenu() wenn gar kein Menu vorhanden war:
		nach if(firstflag) noch if(menuvoranden()) eingefuegt.
22.5.2007	Zeilen mit getenv(), setenv() in xtekplot1.h auskommentiert.
                Diese Funktionen sollten inzwischen in stdlib vorhanden sein,
		so dass es Umlenkung auf Getenv(), Setenv() nicht mehr braucht.
31.5.2007  2.88 Fehlerkorrekturen in nachfilenamefragen() und requester_datei()
		Einfuehrung von MAXP damit genug Platz fuer Pfade
9.6.2007        Fehlende Funktion bpencolor() eingefuegt.
26.6.           Rechte Shifttaste 0xE2 in xrequester_start() auch abgefangen.
12.12.2008 2.89 An einigen Stellen "const char *" statt "char *"
15.12.          sortieren() verbessert
11.1.2010  2.90 Dateien und Ordner mit Leerstellen im Namen unterstuetzen.
		Neue Funktion strcpybisx() statt strcpybis()
15.1.10		Fehler in requester_datei() korrigiert: gadgetstr[j].max wurde
		nicht gesetzt und war deshalb nach requester_input_() Aufrufen 
		falsch.
23.1.10		kleine Fehler korrigiert (wegen Compiler-Warnungen).
24.1.10    2.91 Bufferoverflow in ngnewdir(): MAXS durch MAXP ersetzt.
25.1.10		Auskommentiertes astprog() u. alte Sortiervar. ganz entfernt.
		fenstername2 verbessert (nur noch in tek_grein() definiert).
		Anpassung von Umlauten: Unterstuetzung von UTF8-Dateinamen in
		requester_datei(). Dazu in ngxdrawauswahlbox() umlaut() benutzt
27.1.10	   2.92	Eingabe von Umlauten zulassen:
		in requester_start() "uchar txt[10];" (uchar statt char)
		Unterstuetzung von UTF8-Umlauten: utf8_to_isolatin1()
                ischrift_utf8(), schrift_utf8(), janeinrequester_utf8()
		Fehlende delete[] und alle "delete " durch "delete[] " ersetzt.
27.1.10		Erweiterung von nachfilenamefragen(...,int nfilt=0)
		wenn filter!=NULL und nfilt>0 wird durch den Benutzer
		veraenderter Filter zurueckgegeben.
28.1.10		Fuer MACOSX besondere Umlaute in utf8_to_isolatin1()
30.1.10		kleiner Fehler in ischrift(): XDrawImageString war falsch
		es muss XDrawString heissen.
12.12.2011      Startprobleme auf schnellen Rechnern: Delay(2) in qinital() eingefuegt.
16.12.11   2.93 Versionsnummer angepasst, und weiteres Delay(2) in opengrafik().
23.2.2012       Kommentare in nachfilenamefragen() eingesetzt um klar zu stellen
                dass filter vom Typ (char *) sein muss und nfilt entsprechend
                des maximal vorhandenen Platzes gesetzt werden soll.
21.8.2012  2.94 menu_font_anfordern() verbessert: Fehler korrigiert und Testausdrucke eingefuegt

*/

#ifdef unix
#define UNIX
#undef ALPHA
#undef VAX
#endif

#ifdef VAX
#define VAX_OR_ALPHA
#endif

#ifdef ALPHA
#define VAX_OR_ALPHA
#endif

typedef unsigned char uchar;

#ifndef SHOWIT
typedef unsigned int uint;
typedef unsigned long ulong;
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
//#include <time.h>
#include <stdarg.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#define COMPILINGXTEKPLOT

//#ifdef UNIX
//ALPHA scheint dies jetzt auch zu benoetigen
#include <unistd.h>
#define cfree free
//#endif

#ifdef VAX
#include "h:ulong.h"
#include "h:xtekplot1.h"
#else
#include <ulong.h>
#include <xtekplot1.h>
#endif

#define fpbild tekplot_fpbild
#define rambild tekplot_rambild
#define iffflag tekplot_iffflag
#define postflag tekplot_postflag
#define initalflag tekplot_initalflag
#define rambildflag tekplot_rambildflag
#define bildname tekplot_bildname
#define bildname_default tekplot_bildname_default

#ifndef VECTMAL
#define refreshflag tekplot_refreshflag
#define fenstername tekplot_fenstername
#define vordergrundfarbe tekplot_vordergrundfarbe
#define hintergrundfarbe tekplot_hintergrundfarbe
#define xmin tekplot_xmin
#define ymin tekplot_ymin
#define xmax tekplot_xmax
#define ymax tekplot_ymax
#define xs tekplot_xs
#define ys tekplot_ys
#define dx tekplot_dx
#define dy tekplot_dy
#endif

//#define NORMLIN '`'
#define NORMLIN 0x40
#define BOLDLIN 0x0100
#define DUENNELINIE 1
#define DICKELINIE 3
#define GESTRICHMASK 7

const char * TEKPLOT_SCREENDATEN="xtekplot.screens";
struct screendaten {const char *name; short br,ho,ti,xb,yb,xr,yr;};

typedef int (*prediczeiger)(Display *display,XEvent *event,char* args);

/********************* globale Variablen **************************/
int tek_mausx=0,tek_mausy=0,maustasten_flag=0,maustasten_zustand=0;
static int keyget_i=0,keyget_flag=0;
static char keyget_txt[16];
static KeySym keyget_key;
static int fullscreenmodus=0;
static char *g_filter=NULL;
static int requester_font_flag=0;

/********************* Vordeklarationen: **************************/
static int inital2();
void bildclose();
static void opengrafik();
void bmhd_speichern();
static int enthaelt(const char *s,const char *t);
int menuvorhanden();
void menu_reset();
#ifdef MITUMLAUTEN
static char *umlaut(const char *txt);//von utf8 nach isolatin1 umrechnen
#endif

#ifdef __cplusplus
extern "C"
{
#endif
#ifdef VAX_OR_ALPHA
int	lib$get_ef(long*),lib$signal(long),
	sys$setimr(long,long*,void*,long,long),
	sys$clref(long), sys$waitfr(long),
	lib$free_ef(long *);
#endif
void inital(float *xmi,float *ymi,float *xma,float *yma);
void plot(float* x,float* y,short* pen);
#ifdef __cplusplus
}
#endif

void qesc(char* x);
void setpattern(int c);
double psxkor(double x);
double psykor(double y);
void bildopen(const char* name);
static void anschreiben(FILE* fp,double wert,int x,int y,int strokeflag=1);
void bildplot(double x,double y,int pen);
static void textfile_creat(const char* name);
void ffwrite(char* adr,int size,int n,FILE* fp);
void setzehintergrundweiss();
FILE *screenmode_file_open();
void menu_klappen(int x,int y);
/** Ende Vordeklarationen **/

static Display *dpy;
static Window win10/*,win0,child0,win_meldungen=0*/;
/*** provi. fuer doublebuffering: ***/
Drawable dpuffer=0,leerpuffer=0;
#define win1 (dpuffer==0 ? win10 : dpuffer)
/*** :provi. fuer doublebuffering ***/
static Screen *screen=0;
static GC gc=0;
Window tekplot_win;
Display *tekplot_dpy;
Screen *tekplot_screen;
GC tekplot_gc;
static XSetWindowAttributes xswa;
Drawable rambild=0;
//static XEvent event;
XEvent tekplot_event;
#define EVENT tekplot_event
int vordergrundfarbe,hintergrundfarbe; /* Pixelwerte */
static int winbreite=1001,winhoehe=701; /* Grsse des gesamten Windows */
static uint breite=1000,hoehe=700;	/* Grsse des nutzbaren Bereichs */
static uint border=0,dept=1,mydept=24;
uint menubalkenhoehe=0;			/* Verbrauchter Platz von Menubalken */
int tekplot_breite=0,tekplot_hoehe=0,tekplot_tiefe; /* wie breite,hoehe,dept */
						    /* aber extern benutzbar */
const int MAXFE=200;//maximale Laenge fuer fenstername
#ifdef VAX_OR_ALPHA
static long /*ef_astprog,ef2,*/ vms_status,
	    zeit02[2]={-2000000,-1},
	    zeit04[2]={-4000000,-1},
	    zeit05[2]={-5000000,-1}; /* = 0.5 Sec. */
#endif
#ifdef VECTMAL
char fenstername[MAXFE]=
	" VectMal                                                           ";
int fenstername1_len=9;
#else
char fenstername[MAXFE]=FENSTERNAME;
#endif
static int modus=1,
	 qsaveflag=0, //plotsave eingeschaltet
	 qsave1flag=0;//plotsave bei inital() einschalten
int	 iffflag=0,postflag=0,
	 initalflag=0,rambildflag=0,refreshflag=0;
static int xsync_modus=0;
static int debug=0;
FILE *fpbild=NULL;
char *bildname, *bildname_default="BILD.TMP"; //bildname_default[] geht nicht!
//muesste eigentlich "const char *" sein, kann aber nicht geaendert 
//werden sonst gehen einige aeltere Programme nicht mehr!
static int ncurv;
double xmin,ymin,xmax,ymax,xs,ys,dx,dy;
static short pattern=NORMLIN;

#define DEBUG(n,x) if(debug>=(n)) x
#ifdef VAX_OR_ALPHA
#define CHECK(x) if(((vms_status=(x))&7)!=1) lib$signal(vms_status)
#endif

static int plo_i=0, /* Variable in q2plot() */
	   plo_i_a=0,
	   plo_i_alt=0, zwei=2, drei=3;

inline void PLOT_FLUSH() {if(plo_i>1) q2plot(0.,0.,4);}

static int predicate(Display* display,XEvent* event,long args)
{
 return (event->xexpose.window==args && event->type==MotionNotify);
}
static int predicate2(Display* display,XEvent* event,long args)
{
 return (event->xexpose.window==args && event->type==Expose);
}

/*************** geniale Hilfsprogramme ******************/
static struct descr *machdescr(const char* str,struct descr* x)
{
 //benoetigt fuer Zusammenarbeit mit Fortran
 if(str[0]>=' ') /* ist str schon eine 'descr Struktur' ? */
	{/* nein: descr Struktur aufbauen */
	 x->pad=0x010E; x->n=strlen(str); x->s=str;
	}
 else	x=(struct descr *)str;
 return x;
}

void err_exit(const char *s) {printf("%s",s); exit(0);}

/************ globale Unterprogramme ******************/
static int
	scxrand=6,	/* 2*Screenrandbreite */
	scyrand=26;	/* Geraeteabhaengig ! (nicht verwechseln mit border) */
int	tekplot_borderflag=0,/* wird gesetzt wenn Randgrssen ermittelt sind */
	tekplot_xborder=0, /* Diese Randgrssen sind nur in Wirklichkeit da, */
	tekplot_yborder=0; /* existieren aber fr XWindows nicht. */
/* tekplot_xborder = linker + rechter FensterRand */
/* tekplot_yborder = oberer + unterer FensterRand */

static char displayname[80];

Display *meinXOpenDisplay(const char *name)
{
 Display *mydpy;
 mydpy=XOpenDisplay(name);
 if(!mydpy) mydpy=XOpenDisplay(":0.0");
 if(!mydpy)
    {char antw[80];
     if(*displayname==0)
          {printf("Display ? (z.B. name:0.0) :"); scanf("%s",displayname);}
     mydpy=XOpenDisplay(displayname);
     if(!mydpy) printf("kann Display '%s' nicht oeffnen\n",displayname);
    }
 return mydpy;
}

void getmaxsize(int *breite,int *hoehe,int *tiefe,int *visualklasse)
{
 Display *mydpy;
 Visual *vis;
 FILE *fp;
 int myscreen;
 Screen *screen;
 int br,ho,ti,gefunden=0,i;
 char screenname[80]="screenname";
 double asp=0.0;
#ifdef MACOSX
 char *s1=":0.0"; strcpy(displayname,s1);
#else
 char *s1=XDisplayName(""); strcpy(displayname,s1);
#endif
 if(debug)
	{//printf("(%d) border:",border); scanf("%d",&border);
	 printf("Display='%s'\n",s1);
	}
 mydpy=meinXOpenDisplay("");
 if(!mydpy)
    err_exit("getmaxsize() can't open Display\n");
 myscreen=DefaultScreen(mydpy);
 screen=XDefaultScreenOfDisplay(mydpy);
 *tiefe=ti=DefaultDepth(mydpy,myscreen);
 vis=DefaultVisual(mydpy,myscreen);
 *visualklasse=vis->c_class;
 br=XWidthOfScreen(screen);
 ho=XHeightOfScreen(screen);
 XCloseDisplay(mydpy);
/**
; $h/xtekplot.screens
;Jeder Eintrag besteht aus 2 Zeilen:
; "Screen-Name" breite hoehe tiefe   (Beispiel: "Linux" 1024 768 8)
; xborder yborder xrand yrand aspect (Beispiel: 8 32 6 24 1.0)
;Verhaeltnis von Breite zu Hoehe eines Pixels: aspect = (B/breite)/(H/hoehe)
;breite und hoehe sind in Pixel, B und H sind Breite und Hoehe in cm.
**/
 if(fullscreenmodus==0)
 {
  if((fp=screenmode_file_open())!=NULL)
   {int screenbr,screenho,screenti,xb,yb,xr,yr,c;
    while((c=getc(fp))!=EOF)
     {while(isspace(c) || c==';')
       {if(c==';')
	 {while((c=getc(fp))!='\n' && c!=EOF) ;} //Kommentare ueberlesen
        c=getc(fp);
       }
      if(c!='"') break;
      for(i=0;i<79 && (c=getc(fp))!='"';) screenname[i++]=c;
      screenname[i]=0;
      if(c!='"') break;
      fscanf(fp,"%d %d %d",&screenbr,&screenho,&screenti);
      fscanf(fp,"%d %d %d %d %lf",&xb,&yb,&xr,&yr,&asp);
      if(br==screenbr && ho==screenho && ti==screenti)
	{tekplot_xborder=xb; tekplot_yborder=yb;
	 scxrand=xr; scyrand=yr;
	 gefunden=1; break;
	}
     }
    fclose(fp);
   }
  if(!gefunden)
   {static screendaten scr[]={
	// name			br   ho  ti  xb yb xr yr
	{"Exodus auf MAC 6100",	832,604, 8,  8,32, 6,24},//erprobt mit 6.0.1
	{"VAXstation 3100",	1024,864,1,  1,8,  6,24},//erprobt
	{"ALPHA Zuse",		1280,1024,8, 8,32, 0,0}, //erprobt
	{"UNIX-ALPHA Leibniz",	1024, 768,8, 8,32, 0,0}, //noch nicht erprobt
	{"eXceed auf IBM-PC",	 800,581,24, 8,32, 20,50},//noch nicht erprobt
	{"unknown Screen",	0,0,0, 0,0, 0,0}};
    for(i=0;scr[i].br>0;i++)
     if(br==scr[i].br && ho==scr[i].ho && ti==scr[i].ti)
	{tekplot_xborder=scr[i].xb; tekplot_yborder=scr[i].yb;
	 scxrand=scr[i].xr; scyrand=scr[i].yr;
	 strcpy(screenname,scr[i].name);
	 gefunden=1; break;
	}
   }
  if(!gefunden)
	{printf("unbekannter Screen: Breite=%d Hoehe=%d Tiefe=%d\n",br,ho,ti);
	 strcpy(screenname,"unknown screen");
	 tekplot_xborder=8; tekplot_yborder=32;
	 printf("angenommene FensterRandbreiten: 8 und 32\n");
	 printf("angenommene ScreenRandbreiten: %d und %d\n",scxrand,scyrand);
	 if(debug>=2)
		{printf("tekplot_xborder:"); scanf("%d",&tekplot_xborder);
		 printf("tekplot_yborder:"); scanf("%d",&tekplot_yborder);
		 printf("scxrand:"); scanf("%d",&scxrand);
		 printf("scyrand:"); scanf("%d",&scyrand);
		}
	 printf("Setzen Sie in \"%s\" neue Werte fuer diesen Screen!\n",
		TEKPLOT_SCREENDATEN);
	}
 }
 else //if(fullscreenmodus>=1)
 {scxrand=scyrand=0;
  tekplot_xborder=tekplot_yborder=0;
  if(debug) printf("fullscreenmodus=%d --> alle Raender=0\n",fullscreenmodus);
 }
 if(debug)
   printf("Screen='%s' Breite=%d Hoehe=%d Tiefe=%d\n",screenname,br,ho,ti);
 *breite=br-scxrand;
 *hoehe=ho-scyrand;
 tekplot_borderflag=1;
 if(gefunden && asp>0.0) setaspect(asp);
}
void getsize(int *breite,int *hoehe,int *tiefe,int *visualklasse)
{
 Visual *vis;
 *breite=tekplot_breite;
 *hoehe=tekplot_hoehe;
 *tiefe=tekplot_tiefe;
 vis=DefaultVisual(tekplot_dpy,DefaultScreen(tekplot_dpy));
 *visualklasse=vis->c_class;
}

#ifdef VECTMAL
int hintergrundflag=0, hintergrundistschwarz=1;
#else
static int hintergrundflag=0, hintergrundistschwarz=1;
#endif

void setsize(int width,int height,int dep)
{
 breite=width; hoehe=height;
 if(dep>32000) {dep-=32000; hintergrundflag=1;} else hintergrundflag=0;
 if(dep>1000) {debug=dep/1000; dep=dep%1000;}
 if(width==0 || height==0) {winbreite=width; winhoehe=height;}
 else	{winbreite=breite+1; winhoehe=hoehe+1+menubalkenhoehe;}
 mydept=dep;
 DEBUG(1,printf("setsize() menubalkenhoehe=%d hoehe=%d breite=%d tiefe=%d\n",
		menubalkenhoehe,hoehe,breite,dep));
}

#ifdef AUTOMENU
static int automenu_exitflag=0;
void automenu_exit() {automenu_exitflag=1;}
void automenu_loop()
{
 if(initalflag) term_refresh();
 while(automenu_exitflag==0 && waitmenu(1)==0) ;
 automenu_exitflag=0;
}
#endif

void qinital(int mod,double xmi,double ymi,double xma,double yma)
{
 modus=mod; xmin=xmi; ymin=ymi; xmax=xma; ymax=yma;
 if(!dpy) opengrafik();
 if(dpy) inital2();
 else	 err_exit("inital() can't open Display\n");
 xs = (breite-1)/(xma-xmi);
 ys = (hoehe-1)/(yma-ymi);
 dx=1.0/xs;
 dy=1.0/ys;
 tekplot_win=win1; tekplot_dpy=dpy; tekplot_screen=screen; tekplot_gc=gc;
 tekplot_breite=breite; tekplot_hoehe=hoehe; tekplot_tiefe=mydept;
 if(qsave1flag) {qsaveflag=1; bildopen(bildname);}
 if(tekplot_tiefe==24)
   {if(hintergrundistschwarz) color(0xFFFFFF); //Weiss als Defaultfarbe
    else color(0); //Schwarz als Defaultfarbe auf weissem Hintergrund
   }
 else color(1);
 Delay(2); //12.12.2011, ab Version 2.93
}
void inital(float *xmi,float *ymi,float *xma,float *yma)
{  /* fr Aufruf von Fortran */
 qinital(1,*xmi,*ymi,*xma,*yma);
}

void inital_new(double xmi,double ymi,double xma,double yma)
{
// DEBUG(1,printf("inital_new()\n"));//test
 if(xmi!=xma && ymi!=yma)
  {xmin=xmi; ymin=ymi; xmax=xma; ymax=yma;
   xs = (breite-1)/(xma-xmi);
   ys = (hoehe-1)/(yma-ymi);
   dx=1.0/xs;
   dy=1.0/ys;
  }
 initalflag=1;
 if(qsave1flag) {qsaveflag=1; bildopen(bildname);}
}

void term_refresh()
{
 static long pmask=1;
 static int iform=XYBitmap; /* oder XYPixmap oder ZPixmap */
// DEBUG(1,printf("term_refresh()\n"));//test
 if(plo_i>1) q2plot(0.,0.,4);
 if(initalflag)
  {if(rambild==0)
	 rambild=XCreatePixmap(dpy,win1,(uint)winbreite,(uint)winhoehe,dept);
   XCopyArea(dpy,win1,rambild,gc,0,0,(uint)winbreite,(uint)winhoehe,0,0);
   XSync(dpy,0);
   refreshflag=1;
   rambildflag=1;
   if(qsaveflag) {bildclose(); qsave1flag=1; qsaveflag=0;} //neu 4.4.95
  }
 else printf("WARNING: term_refresh() without inital()\n");
 if((modus&3)==2) XLowerWindow(dpy,win1);
 XSync(dpy,0);
 initalflag/*=inital1flag*/=0;
}
void term() {term_refresh();}

void plot(float* x,float* y,short* pen)
{
 q2plot(*x,*y,*pen);
}

#define XPMAX 200

void q2plot(double x,double y,int pen)
{
 static XPoint feld[XPMAX];
 static int x1,y1,x2,y2;
 static int warn=5;
 static float x0,y0;
 int hi;
 if(pen==2)
	{koorduser2pix(x,y,&x2,&y2);
	 if(qsaveflag) bildplot(x,y,pen);
	 feld[plo_i].x=x2; feld[plo_i++].y=y2;
	 if(plo_i==XPMAX) pen=4;
	}
 if(pen==3)
	{koorduser2pix(x,y,&x2,&y2);
	 if(qsaveflag) bildplot(x,y,pen);
	}
 if(pen>=3)
	{
/*	 DEBUG(2,printf("PLOT(%d)\n",pen)); */
	 if(plo_i>1)
		{/*while(!initalflag) /* warten */;
		 if(!initalflag)//test
		   {printf("WARNING in plot(): zuerst inital() aufrufen\n");
		    --warn;
		   }
		 hi=plo_i; plo_i=0;
		 if(hi<=1) printf("Fehler in q2plot(): hi=%d\n",hi);
		 if(hi==2)
		   XDrawLine(dpy,win1,gc,feld[0].x,feld[0].y,
			     feld[1].x,feld[1].y);
		 else
		   XDrawLines(dpy,win1,gc,feld,hi,CoordModeOrigin);
		 if(xsync_modus>=2) XSync(dpy,0);
		}
	 if(xsync_modus>=2) XFlush(dpy);
	 feld[0].x=x2; feld[0].y=y2; plo_i=1;
	}
}

void tek_flush()
{
 if(plo_i>1) q2plot(0.,0.,4);
 else	XFlush(dpy);
}

void qpunkt(float* x,float* y)
{
 int x2,y2;
 if(plo_i>1) q2plot(0.,0.,4);
 if(qsaveflag) {q2plot(*x,*y,3); q2plot(*x,*y,2); return;}
 koorduser2pix(*x,*y,&x2,&y2);
 XDrawPoint(dpy,win1,gc,x2,y2);
 if(xsync_modus>=2) XSync(dpy,0);
}

#define NPMAX 1000

void tek_line(int n,double* xf,double* yf)
{
 XPoint xp[NPMAX];
 int ix,iy,np,i,j;
 if(plo_i>1) q2plot(0.,0.,4);
 j=0;
 if(qsaveflag)
   {q2plot(xf[0],yf[0],3);
    for(i=1;i<n;i++) q2plot(xf[i],yf[i],2);
    return;
   }
 do
   {if(n>NPMAX) np=NPMAX;
    else	np=n;
    for(i=0; i<np; i++,j++)
	{koorduser2pix(xf[j],yf[j],&ix,&iy);
	 xp[i].x = ix;  xp[i].y = iy;
	}
    while(!initalflag) /* warten */;
    XDrawLines(dpy,win1,gc,xp,np,CoordModeOrigin);
    n=n-np+1; j--;
   }
 while(n>1);
 if(xsync_modus>=2) XSync(dpy,0);
}
void line(short* n,float* xf,float* yf)
{
 int i;
 q2plot(xf[0],yf[0],3);
 for(i=1;i< *n;i++) q2plot(xf[i],yf[i],2);
}

#ifdef __cplusplus
inline 
#endif
void grein_faden_zeichnen(GC mygc,int x,int y)
{
 XDrawLine(tekplot_dpy,tekplot_win,mygc,x,0,x,hoehe+menubalkenhoehe);
 XDrawLine(tekplot_dpy,tekplot_win,mygc,0,y,breite,y);
}

void grein_fadenkreuz(int x,int y)
{
 static int x0,y0,flag=0;
 static GC mygc=0;
 if(flag) grein_faden_zeichnen(mygc,x0,y0);/* alte Position aus */
 if(x<0 && y<0) {flag=0; return;}
 if(flag==0)
	{if(mygc==0)
		{mygc=XCreateGC(tekplot_dpy,tekplot_win,0,NULL);
		 XSetBackground(tekplot_dpy,mygc,hintergrundfarbe);
		 XSetForeground(tekplot_dpy,mygc,vordergrundfarbe);
		 XSetFunction(tekplot_dpy,mygc,
				(vordergrundfarbe==0)?GXequiv:GXxor);
		 if(x==0 && y==0) {x=breite/2; y=hoehe/2;}
		}
	 flag=1;
	}
 /* neue Position zeichnen */
 grein_faden_zeichnen(mygc,x0=x,y0=y);
}

void tek_grein(double* x,double* y)
{
 static XEvent event;
 char fenstername2[160];
 sprintf(fenstername2,"%-120.120s           Grafikeingabe !",fenstername);
 if(plo_i>1) q2plot(0.,0.,4);
 grein_fadenkreuz(tek_mausx,tek_mausy);/* Fadenkreuz einschalten */
 DEBUG(1,printf("grein()  ButtonPress=%d\n",ButtonPress));
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername2, strlen(fenstername2));
 for(;;)
  {XNextEvent(dpy,&event);
   if(event.type==ButtonPress && event.xexpose.window==win1)
	{koordpix2user(tek_mausx=event.xbutton.x,tek_mausy=event.xbutton.y,x,y);
	 DEBUG(1,printf("grein: 1000x=%d 1000y=%d\n",
		(int)(1000. * *x),(int)(1000. * *y)));
	 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername, strlen(fenstername));
	 break;
	}
   else if(event.type==MotionNotify)
	{while(XCheckIfEvent(dpy,&event,(prediczeiger)predicate,(char *)win1))
                                ; /* aktuellste Position ermitteln */
	 grein_fadenkreuz(event.xbutton.x,event.xbutton.y);
	}
   else	DEBUG(1,printf("event.type=%d  ..window=%d (win1=%d)\n",
	      event.type, (int)event.xexpose.window, (int)win1)); /* test */
  }
 grein_fadenkreuz(-1,-1);/* Fadenkreuz ausschalten */
}
void grein(float* x,float* y)
{
 double fx,fy;
 tek_grein(&fx,&fy);
 *x=fx; *y=fy;
}

void plotsave(const char* x0)
{
 int c;
 struct descr x2,*x;
 const char *s;
 x=machdescr(x0,&x2);
 if(plo_i>1) q2plot(0.,0.,4);
 s=x->s;
 DEBUG(1,printf("plotsave('%s')\n",s));//test
 if(((c= *s++)=='A' && *s=='U') || (c=='O' && *s=='F'))
	{if(qsaveflag) bildclose();
	 qsaveflag=qsave1flag=0;
	}
 else
	{qsaveflag=1;
	 if((bildname=Getenv("PLOTSAVE"))==NULL) bildname=bildname_default;
	 iffflag=strncmp(x->s,"IFF",3)==0;
	 postflag=strncmp(x->s,"POST",4)==0;
	 if(initalflag) bildopen(bildname);
	 else {qsave1flag=1; qsaveflag=0;} //neu 4.4.95
	}
}

#define PUNKTIERT 'a'
#define PUNKTSTRI 'b'
#define KSTRICH 'c'
#define LSTRICH 'd'
#define PPSTRICH 'e'
#define LPSTRICH 'f'
#define MSTRICH 'g'
//#define DELETE 1

static char patt_tabelle[]=
	{'N','O',NORMLIN,
	 'P','U',PUNKTIERT,	'D','O',PUNKTIERT,
	 'P','S',PUNKTSTRI,	'D','D',PUNKTSTRI,
	 'K','S',KSTRICH,	'S','D',KSTRICH,
	 'P','P',PPSTRICH,	'L','P',LPSTRICH,
	 'M','S',MSTRICH,
	 'L',0,LSTRICH,		//'D','E',DELETE,
	 0 /* Ende der Tabelle */
	};

void tek_pen(const char* q)
{
 int c;
 const char *p;
 if(plo_i>1) q2plot(0.,0.,4);
 if((q[0]=='F' && q[1]=='E') || (q[0]=='B' && q[1]=='O')) /* FETT oder BOLD */
	{//if((c=pattern)<'h') setpattern(c+8); /* else FETT schon gesetzt */
	 setpattern(pattern|BOLDLIN);
	 return;
	}
 c=NORMLIN;
 for(p=patt_tabelle; *p; p+=3)
	if(*p== *q && (p[1]==0 || p[1]==q[1]))
		{c=p[2]; break;}
 if(c!=NORMLIN) c|=(pattern&BOLDLIN);
 setpattern(c);
}
void pen(const char* x0)
{
 struct descr x2,*x;
 x=machdescr(x0,&x2);
 tek_pen(x->s);
}

/******************* lokale Unterprogramme ******************/
/**durch koord... ersetzt:
static void umrech(double x,double y,int* i,int* j)
{
 x=(x-xmi)*xs;
 y=(y-ymi)*ys;
 if(x>0.) {*i=(int)(x+0.5); if(*i>=breite) *i=breite-1;}
 else	  *i=0;
 if(y>0.) {*j=(int)(y+0.5); if(*j>=hoehe) *j=hoehe-1;}
 else	  *j=0;
 *j=hoehe-1-*j + menubalkenhoehe;
}
static void rechum(int i,int j,double* x,double* y)
{
 j = hoehe-1-j + menubalkenhoehe;
 *x = xmi + i/xs;
 *y = ymi + j/ys;
}
**/

static int inital2()
{
/* extern int astqio2(); */
// XRaiseWindow(dpy,win1); /* Fenster nach vorne holen */
// DEBUG(1,printf("inital2()\n"));
 XSync(dpy,0);
 setpattern(NORMLIN);
// inital1flag=1;
// sys$clref(ef2);
// CHECK(sys$setimr(ef2,zeit05,NULL,2,0)); /* astqio2 ueberfluessig ! */
//	/* 0.5 Sekunden warten um Refresh zu ermoeglichen */
// sys$waitfr(ef2);
 initalflag=1; /* inital fertig */
}

void show_defaultvisual()
{
 Visual *vis;
 vis=XDefaultVisualOfScreen(screen);
 printf("visualid=%ld  ",vis->visualid);
 printf("c_class=%d",vis->c_class);
 switch(vis->c_class)
	{case PseudoColor: printf("=PseudoColor\n");
	 CASE DirectColor: printf("=DirectColor\n");
	 CASE GrayScale: printf("=GrayScale\n");
	 CASE StaticColor: printf("=StaticColor\n");
	 CASE TrueColor: printf("=TrueColor\n");
	 CASE StaticGray: printf("=StaticGray\n");
	 DEFAULT: printf("\n");
	}
 if(vis->c_class==DirectColor || vis->c_class==TrueColor || debug>=2)
	printf("red_mask=%02lX green_mask=%02lX blue_mask=%02lX\n",
		vis->red_mask,vis->green_mask,vis->blue_mask);
 printf("bits_per_rgb=%d  map_entries=%d\n",vis->bits_per_rgb,vis->map_entries);
}

static void doCreateWindow()
{
 int w1x=0,w1y=0; /* Fenster ganz links oben */
 int maxhoehe=XHeightOfScreen(screen)-scyrand;
 int maxbreite=XWidthOfScreen(screen)-scxrand;
 DEBUG(1,printf("winbreite=%d maxbreite=%d\nwinhoehe=%d  maxhoehe=%d\n",
	winbreite,maxbreite, winhoehe,maxhoehe));/* test */
 if(winbreite==0 || winbreite>maxbreite)
	{winbreite=maxbreite; breite=winbreite-1;
	 if(winhoehe<0)
		{winhoehe=winbreite*(-winhoehe)/10000+menubalkenhoehe;
		 hoehe=winhoehe-1-menubalkenhoehe;
		}
	/* printf("winhoehe=%d\n",winhoehe);/* test */
	}
 if(winhoehe==0 || winhoehe>maxhoehe)
	{winhoehe=maxhoehe; hoehe=winhoehe-1-menubalkenhoehe;
	 if(winbreite<0)
		{winbreite=(winhoehe-menubalkenhoehe)*(-winbreite)/10000;
		 breite=winbreite-1;
		}
	/* printf("winbreite=%d\n",winbreite);/* test */
	 if(winbreite>maxbreite) {winbreite=maxbreite; breite=winbreite-1;
			 printf("winbreite=maxbreite=%d\n",winbreite);/* test */
			}
	}
 w1x=(XWidthOfScreen(screen)-winbreite)>>1; /* Fenster in der Mitte */
 xswa.event_mask=ExposureMask|ButtonPressMask|
		 ButtonReleaseMask|PointerMotionMask|
		 KeyPressMask; /* fr keyget() Tastaturabfrage */
 xswa.background_pixel = hintergrundfarbe;
 xswa.border_pixel = vordergrundfarbe;
 dept=XDefaultDepthOfScreen(screen);
 DEBUG(1,printf("XDefaultDepthOfScreen()=%d  mydept=%d\n",dept,mydept));
 if(dept<mydept) mydept=dept;
 win1=XCreateWindow(dpy,XRootWindowOfScreen(screen),
	w1x,w1y,(uint)winbreite,(uint)winhoehe,border,dept,InputOutput,
	XDefaultVisualOfScreen(screen),CWEventMask|CWBackPixel|CWBorderPixel,
	&xswa);
 if(debug) show_defaultvisual();
}

void fullscreen_modus(int modus)
{
 fullscreenmodus=modus;
 if(modus==0) {scxrand=6; scyrand=26;}//alte Voreinstellungen
 else {scxrand=scyrand=0;}
}

//#include <mwm.h>
#define MWM_HINTS_DECORATIONS (1L << 1)

void setfullscreen(Display* display,Window window)
{
 Atom wm_hints;
 struct {long flags,functions,decorations,inputMode,status;
        } MWMHints = {MWM_HINTS_DECORATIONS, 0, 0, 0, 0};
 /* Remove Window Border and Title Bar */
 /* First try for MWM Hints */
 wm_hints = XInternAtom(display, "_MOTIF_WM_HINTS", True);
 if(wm_hints != None)
   {if(debug) printf("setfullscreen: MOTIF\n");
    XChangeProperty(display, window, wm_hints, wm_hints, 32,
		    PropModeReplace, (unsigned char *)&MWMHints,
		    sizeof(MWMHints)/sizeof(long));
    return;
   }
 /* Now try to set KWM hints */
 wm_hints = XInternAtom(display, "KWM_WIN_DECORATION", True);
 if(wm_hints != None) {if(debug) printf("setfullscreen: KWM\n");}
 else
   {wm_hints = XInternAtom(display, "_WIN_HINTS", True);
    if(wm_hints != None) {if(debug) printf("setfullscreen: GNOME\n");}
   }
 if(wm_hints != None)
   {long Hints=0;
    XChangeProperty(display, window, wm_hints, wm_hints, 32,
		    PropModeReplace, (unsigned char *)&Hints,
		    sizeof(Hints)/sizeof(long));
   }
}

static Atom WM_PROTOCOLS, WM_DELETE_WINDOW; //fuer Schliesssymbol

static void opengrafik()
{
 int x0,y0,x1,y1;
 Delay(2); //ab Version 2.93
 tekplot_dpy = dpy = meinXOpenDisplay(displayname);
 if(!dpy)  return;
 menu_font_anfordern();
 if(menuvorhanden()) menubalkenhoehe=get_menuleistenhoehe();
 DEBUG(1,printf("opengrafik() menubalkenhoehe=%d\n",menubalkenhoehe));
 if(winhoehe>0) winhoehe+=menubalkenhoehe;
 screen = XDefaultScreenOfDisplay(dpy);
 if(hintergrundflag==1)
	{vordergrundfarbe = BlackPixel(dpy, DefaultScreen(dpy));
	 hintergrundfarbe = WhitePixel(dpy, DefaultScreen(dpy));
	 setzehintergrundweiss();
	}
 else	{vordergrundfarbe = WhitePixel(dpy, DefaultScreen(dpy));
	 hintergrundfarbe = BlackPixel(dpy, DefaultScreen(dpy));
	}
 doCreateWindow();
 gc=XDefaultGC(dpy,DefaultScreen(dpy));
 if(fullscreenmodus==0)
   {XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		    PropModeReplace, (uchar*)fenstername, strlen(fenstername));
    //zur Abfrage des Schliesssymbols:
    WM_PROTOCOLS = XInternAtom(dpy, "WM_PROTOCOLS", False);
    WM_DELETE_WINDOW = XInternAtom(dpy, "WM_DELETE_WINDOW", False);
    XChangeProperty(dpy, win1, WM_PROTOCOLS, XA_ATOM, 32,
		    PropModeReplace, (unsigned char *) &WM_DELETE_WINDOW, 1);
   }
 else
   setfullscreen(dpy,win1);
 XSetForeground(dpy,gc,vordergrundfarbe);
 XSetBackground(dpy,gc,hintergrundfarbe);
 XMapWindow(dpy, win1); XSync(dpy,0);
 //XMapRaised(dpy,win1);//test
/*test
 uint state;
 XQueryPointer(dpy,win1,&win0,&child0,&x0,&y0,&x1,&y1,&state);
 XRaiseWindow(dpy,win0);
 XSync(dpy,0);
test*/
 tekplot_win=win1;
 if(fullscreenmodus==0) menu_setzen();
}

void term_exit()
{
 if(dpuffer!=0) changebuffer(0,0);
 if(rambild!=0)
        {XFreePixmap(dpy,rambild); rambild=0;}
 rambildflag=0;
 XDestroyWindow(dpy,win1); 
 XCloseDisplay(dpy);
 dpy=NULL;
// lib$free_ef(&ef2);
// lib$free_ef(&ef_astprog);
 if(/*inital1flag &&*/ qsaveflag)  bildclose();
 initalflag/*=inital1flag*/=0;
 menu_reset();
 requester_font_flag=0;
}

static char normaleLinie[8]={0,0,0,0,0,0,0,0},
	/* {Listenlaenge, Flag, Liste...} */
	dotted[8]   =   {2,1, 2,5,0,0,0,0}, /* punktiert */
	dotdash[8]  =   {4,1, 8,5,2,5,0,0}, /* Strichpunkt */
	shortdash[8]=   {2,1, 8,3,0,0,0,0}, /* kurz gestrichelt */
	longdash[8] =   {2,1,12,4,0,0,0,0}, /* lang gestrichelt */
	dotdotdash[8]=  {6,1, 8,5,2,5,2,5}, /* Strich Punkt Punkt */
	ldotdash[8] =   {4,1,10,5,4,5,0,0}, /* lang PunktStrich */
	mdash[8]    =   {2,1,10,3,0,0,0,0}; /* mittel gestrichelt */
char *gestrichelt[7]={dotted,dotdash,shortdash,longdash,
		      dotdotdash,ldotdash,mdash};

void setpattern(int c)
{
 char *p;
 int bold,style,listlen,dicke,offset,neupatt=c;
 if(c==pattern) return;
 DEBUG(1,printf("setpattern(%04X)\n",c));
// bold = c & 8;
 bold=c&BOLDLIN;
/* int transparent = c & 16; /* wird (noch) nicht unterstuetzt */
 if(bold) dicke=DICKELINIE;
 else  dicke=DUENNELINIE;
 c&=GESTRICHMASK;
 if(c>=1) p=gestrichelt[c-1];
 else  p=normaleLinie;
 listlen= *p++;
 if(*p++)
	{style=LineOnOffDash;
	 XSetDashes(dpy,gc,offset=0,p,listlen);
	}
 else   style=LineSolid;
 XSetLineAttributes(dpy,gc,dicke,style,CapRound,JoinRound);
 if(qsaveflag)
  {bildplot(0.,0.,4);
   if(postflag)
	{if(bold) {if(!(pattern&BOLDLIN)) fprintf(fpbild,"3 setlinewidth ");}
	 else	  {if(pattern&BOLDLIN) fprintf(fpbild,"1 setlinewidth ");}
	 if(c>=1)
		{p=gestrichelt[c-1];
		 fprintf(fpbild,"[");
		 listlen= *p++; p++;
		 while(listlen--) fprintf(fpbild,"%d ",*p++);
		 fprintf(fpbild,"] 0 setdash\n");
		}
	 else if((pattern&GESTRICHMASK)>=1) fprintf(fpbild,"[] 0 setdash\n");
	}
   //else if(anderesFormat)
  }
 pattern=neupatt;
}

/*************** Farben ********************/
#ifdef VECTMAL /*provi.*/
#define RGBMAXVOR 32
UBYTE rgbtabelle[RGBMAXVOR][3]=
 {255,255,255, /* weiss */
    0,  0,  0, /* schwarz */
   36, 36, 36,
   73, 73, 73, /* die ersten 8 Farbnummern werden in VectMal */
  109,109,109, /* nur fuer Grauwerte verwendet                  */
  146,146,146, /* Bei schwarzem Hintergrund werden diese invertiert. */
  182,182,182,
  219,219,219, /* hellgrau */
  255,  0,  0, /* rot */
    0,255,  0, /* gruen */
    0,  0,255, /* dunkelblau */
  255,255,  0, /* gelb */
  255,  0,255,
    0,255,255,
  255,194,194, /* pink */
  255,159, 63, /* gold */
   63,191,255, /* himmelblau */
  191,255, 63, /* gelbgruen */
  255,200,200, /* hellrot */
  142, 35,107, /* Maroon */
  204, 50, 50, /* orange */
  173,234,234, /* tuerkis */
  255,128,  0,
  255,  0,128,
  255,128,128,
  128,255,  0,
    0,255,128,
  128,255,128,
  128,  0,255,
    0,128,255,
  128,128,255,
  255,100,100
 };
#else
//Farbtabelle mit einigen voreingestellten Farben,
//mit setzergbtabelle() koennen eigene Farben verwendet werden.
#define RGBMAXVOR 32
static UBYTE rgbtabelle[RGBMAXVOR][3]=
  {  0,  0,  0, /* schwarz = Hintergrundfarbe */
   255,255,255, /* weiss = Vordergrundfarbe */
   255,  0,  0, /* rot */
     0,255,  0, /* gruen */
     0,  0,255, /* blau */
   255,  0,255, /* violet */
   255,255,  0, /* gelb */
   127,127,127, /* grau */
     0,255,200, /* tuerkis */
   200,200,200, /* hellgrau */
   255,100,100, /* hellrot */
   100,255,100, /* hellgruen */
   100,100,255, /* hellblau */
   255,100,255, /* hellviolet */
   255,255,100, /* hellgelb */
    80, 80, 80, /* dunkelgrau */
     0,255,255, /* helltuerkis */
  255,194,194, /* pink */
  255,159, 63, /* gold */
   63,191,255, /* himmelblau */
  191,255, 63, /* gelbgruen */
  255,200,200, /* hellrot */
  142, 35,107, /* Maroon */
  204, 50, 50, /* orange */
  173,234,234, /* tuerkis */
  255,128,  0,
  255,  0,128,
  255,128,128,
  128,255,  0,
    0,255,128,
  128,255,128,
  128,  0,255
 };
#endif

#ifdef VECTMAL /* provi. */
int tek_farbe= -1;
XColor *colortabelle=NULL;
#else
static int tek_farbe= -1; //hintergrundistschwarz jetzt weiter vorne;
static XColor *colortabelle=NULL;
#endif

void setzehintergrundweiss()
{
 rgbtabelle[0][0]=rgbtabelle[0][1]=rgbtabelle[0][2]=255;
 rgbtabelle[1][0]=rgbtabelle[1][1]=rgbtabelle[1][2]=0;
 hintergrundistschwarz=0;
}

void setzergbtabelle(int n,UBYTE neuetabelle[][3])
{
 int i,j;
 if(n>RGBMAXVOR) {printf("setzergbtabelle(%d..): auf %d beschraenkt\n",
			 n,RGBMAXVOR); n=RGBMAXVOR;}
 for(i=0;i<n;i++)
   for(j=0;j<3;j++)
	rgbtabelle[i][j]=neuetabelle[i][j];
 hintergrundistschwarz=(rgbtabelle[0][0]==0 && rgbtabelle[0][1]==0
			&& rgbtabelle[0][2]==0);
}

int mul257(int x) {return (x<<8)+x;}
inline int div257(int x) {return x>>8;}
static int maximaleanzahlfarben=1<<12;//zur Vermeidung zu grosser Farbtabellen

void setmaxfarben(int max)
{
 maximaleanzahlfarben=max;
}

void farbtabelle_erstellen()
{
 int i=0,anzfarben=256,ro,gr,bl,warnflag=0;
 Colormap cmap;
 XColor *co;
 DEBUG(1,printf("farbtabelle_erstellen()\n"));
// colortabelle=(XColor *)calloc(anzfarben=(1<<mydept),sizeof(XColor));
 if(mydept>8) anzfarben=(1<<mydept);
 if(anzfarben>maximaleanzahlfarben) {anzfarben=maximaleanzahlfarben;}
 do if(!(colortabelle=(XColor *)calloc(anzfarben,sizeof(XColor))))
	{printf("zu wenig Speicher fuer %d Farben\n",anzfarben);
	 anzfarben=(anzfarben>256)?256:(anzfarben/2);
	 if(anzfarben<8) exit(0);
	 warnflag=1;
	}
 while(colortabelle==NULL);
 if(warnflag) printf("nur %d Farben verfuegbar.\n",anzfarben);
/*
 if(mydept==1)
	{for(i=0;i<2;i++)
		{colortabelle[i].red=mul257(rgbtabelle[i][0]);
		 colortabelle[i].green=mul257(rgbtabelle[i][1]);
		 colortabelle[i].blue=mul257(rgbtabelle[i][2]);
		}
	 colortabelle[0].pixel=hintergrundfarbe;
	 colortabelle[1].pixel=vordergrundfarbe;
	// return;
	}
*/
 cmap=XDefaultColormapOfScreen(screen);
 for(;i<anzfarben;i++)
  {static int warnnr=0;
   co = &colortabelle[i];
   if(i<RGBMAXVOR)
	{co->red=ro=mul257(rgbtabelle[i][0]);
	 co->green=gr=mul257(rgbtabelle[i][1]);
	 co->blue=bl=mul257(rgbtabelle[i][2]);
	}
   else	{co->red=co->green=co->blue=ro=gr=bl=0x8000;
	}
   if(XAllocColor(dpy,cmap,co)==0
      && ++warnnr<=3)
		printf("XAllocColor() kann Farbe %d nicht erhalten\n",i);
//   DEBUG(1,printf(" colortabelle[%d].pixel=%d\n",i,co->pixel));
   co->red=ro;  /* XAllocColor verndert offenbar	*/
   co->green=gr;/* unsere Farbwerte,		*/
   co->blue=bl; /* deshalb nochmals gesetzt.	*/
  }
 DEBUG(1,printf("farbtabelle_erstellen() fertig\n"));
}

void color(int farbe)
{
 if(tekplot_tiefe<24 || (colortabelle!=NULL && farbe<maximaleanzahlfarben))
 {
  if(colortabelle==NULL) farbtabelle_erstellen();
  if(plo_i>1) q2plot(0.,0.,4);
  XSetForeground(dpy,gc,colortabelle[farbe].pixel);
#define DMAXCOL 65535. /* 0xFFFF und nicht 0xFF00 */
  if(qsaveflag)
   {if(postflag)
	{XColor *co;
	 bildplot(0.,0.,4);
	 co = &colortabelle[farbe];
	 if(hintergrundistschwarz && co->red==co->green && co->red==co->blue)
	      fprintf(fpbild,"%lf %lf %lf setrgbcolor\n", 1.0-co->red/DMAXCOL,
			1.0-co->green/DMAXCOL, 1.0-co->blue/DMAXCOL);
	 else fprintf(fpbild,"%lf %lf %lf setrgbcolor\n",
			co->red/DMAXCOL, co->green/DMAXCOL, co->blue/DMAXCOL);
	}
    /* else if(iffflag) { } */
   }
 }
 else //if(tekplot_tiefe==24)
 {
  if(plo_i>1) q2plot(0.,0.,4);
  XSetForeground(dpy,gc,farbe);
  if(qsaveflag && postflag)
        {int r=(farbe>>16)&0xFF,g=(farbe>>8)&0xFF,b=farbe&0xFF;
	 bildplot(0.,0.,4);
	 if(hintergrundistschwarz && r==g && r==b)
	      fprintf(fpbild,"%lf %lf %lf setrgbcolor\n", 1.0-r/DMAXCOL,
			1.0-g/DMAXCOL, 1.0-b/DMAXCOL);
	 else fprintf(fpbild,"%lf %lf %lf setrgbcolor\n",
			r/DMAXCOL, g/DMAXCOL, b/DMAXCOL);
	}
 }
 tek_farbe=farbe;
}

void rgbcolor(int r,int g,int b)
{
 color((r<<16)+(g<<8)+b);
}

void setcolor(int farbe,int r,int g,int b)
{
 static int warnnr=0;
 Colormap cmap=XDefaultColormapOfScreen(screen);
 XColor *co;
// if(mydept<=1) return;
 if(!screen) {printf("setcolor geht erst nach 'inital()'\n"); return;}
 DEBUG(2,printf("setcolor(%d,r=%d,g=%d,b=%d)\n",farbe,r,g,b));/* test */
 if(colortabelle==NULL) farbtabelle_erstellen();
/* XFreeColors(dpy,cmap,&colortabelle[farbe].pixel,1,0); test*/
 co = &colortabelle[farbe];
 co->red=mul257(r);
 co->green=mul257(g);
 co->blue=mul257(b);
 co->flags=co->pad=0;
 if(XAllocColor(dpy,cmap,&colortabelle[farbe])==0
      && ++warnnr<=3)
   printf("in setcolor(): XAllocColor() kann Farbe %d nicht erhalten\n",farbe);
/* DEBUG(2,printf(" XAllocColor() --> colortabelle[%d].pixel=%02X\n",
	farbe,co->pixel));/* test */
 co->red=mul257(r);  /* XAllocColor verndert offenbar	*/
 co->green=mul257(g);/* unsere Farbwerte,		*/
 co->blue=mul257(b); /* deshalb nochmals gesetzt.	*/
 if(farbe==0) hintergrundistschwarz=(r==0 && g==0 && b==0);
}
void getcolor(int farbnr,int *r,int *g,int *b) /*nur zu testzwecken*/
{
 XColor* co = &colortabelle[farbnr];
 *r=div257(co->red); *g=div257(co->green); *b=div257(co->blue);
}

void tek_punkt(double x,double y,int farbe)
{
 int x2,y2;
 if(farbe!=tek_farbe) color(farbe);
 else if(plo_i>1) q2plot(0.,0.,4);
 if(qsaveflag) {q2plot(x,y,3); q2plot(x,y,2); return;}
 koorduser2pix(x,y,&x2,&y2);
 XDrawPoint(dpy,win1,gc,x2,y2);
}

/*************** Bilder speichern ******************/
/* Umrechnung von Inch in cm. */
#define INCHX 2.288
#define INCHY 2.305
/* Normalerweise ist 1 Inch 2.54 cm, in 'TELLAGRAF' ist der
   Umrechnungsfaktor jedoch in x und y-Richtung verschieden.
*/
/* minimale und maximale Laengen der Achsen (L=x-Achse  H=y-Achse) */
#define LMIN 15.
#define LMAX 22.
#define HMIN 12.
#define HMAX 18.
#define MAXFARB 16
#define MAXFARB3 52

static UWORD nullword=0, uxmax=65000, uymax=49512;
			/* Bildgroesse: 1024 * 780 */
static double xminsav,yminsav,xssav,yssav;
static ULONG laenge1,laenge2=MAXFARB3,laenge3;

struct bmhd_struktur
       {UWORD breite,hoehe;
	WORD x,y;
	UBYTE nplanes,mask,compr,pad;
	UWORD transcolor;
	UBYTE xaspect,yaspect;
	WORD scrbreite,scrhoehe;
       } bmhd;

static double psxcal,psycal,psxmin,psymin;
double psxkor(double x) {return (x-psxmin)*psxcal;}
double psykor(double y) {return (y-psymin)*psycal;}
//static char *xlabeltext="x-Achse",*ylabeltext="y-Achse";

#ifndef SHOWIT
void bildopen(const char* name)
{
 FILE *fp,*fp1;
 double x1=xmin,y1=ymin,x2=xmax,y2=ymax,dx,dy,laenge,hoehe;
 double ymini,ymaxi,xmini,xmaxi,ystep;
 char str[80];
 int i;
 DEBUG(1,printf("bildopen('%s')\n",name));//test
 if(iffflag | postflag)
	fpbild=fopen(name,"w");
 else
	{textfile_creat(name);
	 fpbild=fopen(name,"a");
	}
 if((fp=fpbild)==NULL)
	{printf("Fehler beim Oeffnen von '%s'\n",name);
	 qsaveflag=0; return;
	}
 if(iffflag)
	{xminsav=x1; yminsav=y1;
	 xssav=uxmax/(x2-x1); yssav=uymax/(y2-y1);
	 fprintf(fp,"FORM");
	 laenge1=20+laenge2; laenge3=0;
	 ffwrite((char *)(&laenge1),4,1,fp);
	 fprintf(fp,"VECTCMAP");
	 ffwrite((char *)(&laenge2),4,1,fp);
	 fwrite(rgbtabelle,1,MAXFARB3,fp);
	 bmhd_speichern();
	 fprintf(fp,"VBDY");
	 ffwrite((char *)(&laenge3),4,1,fp);
	 ffwrite((char *)(&uxmax),2,1,fp);
	 ffwrite((char *)(&uymax),2,1,fp); laenge3+=4; laenge1+=4;
	 return;
	}
 if(postflag)
   {fprintf(fp,"%%!PS-Adobe-2.0 EPSF-1.2\n");
    fprintf(fp,"%%%%Creator: xtekplot1 %s\n",tekplot_version);
#define BBXMAX 558
#define BBYMAX 750
#define BBU 10
#define BBL 38
#define BBR 19
#define BBO 6
#define BBDY 3
#define BBUCHSTABENBREITE 4
#define GH 16
    psxcal=BBYMAX/(x2-x1); psxmin=x1;
    psycal=BBXMAX/(y2-y1); psymin=y1;
    fprintf(fp,"%%%%BoundingBox: %d %d %d %d\n",
				-BBU,-BBR,BBXMAX+BBO,BBYMAX+BBL);
    fprintf(fp,"save\n");
    fprintf(fp,"/m /moveto load def\n");
    fprintf(fp,"/d /lineto load def\n");
    fprintf(fp,"/s /stroke load def\n");
    fprintf(fp,"/dsm {2 copy lineto stroke moveto} bind def\n");
    fprintf(fp,"/Helvetica findfont 15 scalefont setfont\n");
    fprintf(fp,"0 %d translate  -90 rotate\n",BBYMAX);
    return;
   }
 if((fp1=fopen("TELLA.INI","r"))!=NULL)
       {printf("TELLA.INI ");
	while(fgets(str,160,fp1))
		fputs(str,fp);
	fclose(fp1);
	printf("eingelesen\n");
       }
 else
       {fprintf(fp,"PAGE LAYOUT IS HRH.\n");
	fprintf(fp,"GEN PLOT.\n");
	fprintf(fp,"NO PAGE BORDER.\n");
	fprintf(fp,"EVERY CURVE SOLID SYMBOL COUNT 0, THICKNESS 0.01.\n");
	fprintf(fp,"NO LEGEND.\n");
	fprintf(fp,"Y DETACH 90.\n");
	fprintf(fp,"X LABEL TEXT 'x-Achse'.\n");
	fprintf(fp,"Y LABEL TEXT 'y-Achse'.\n");
	fprintf(fp,"TITLE STYLE SERIF, TEXT 'Titel', HEIGHT 0.347.\n");
							/*  =0.8cm  */
	fprintf(fp,"TITLE BOX 20 100 100 130.\n");
			/*    x1  x2  y1  y2  */
	fprintf(fp,"MESSAGE HEIGHT 0.217, FRAME OFF,\n");
	fprintf(fp," UNITS COORDINATE, TEXT 'Message'.\n");
	fprintf(fp,"MESSAGE X %lg, MESSAGE Y %lg.\n",
			(x1+x2)/2.,     y1+(y2-y1)*0.94);
	fprintf(fp,"GRACE 10.\n");
	fprintf(fp,"X ORIGIN 0.87, Y ORIGIN 0.65.\n");
/*			     2cm	    1.5cm */
       }
 dx=(x2-x1)*0.01;
 xmini=rundezahl(x1,x1+dx);
 xmaxi=rundezahl(x2,x2-dx);
 dx=xmaxi-xmini;
 laenge=dx*rundezahl(LMIN/dx,LMAX/dx);
 dy=(y2-y1)*0.01;
 if(y2>0. && y1<0.) ymini=0.;
 else ymini=rundezahl(y1,y1+dy);
 ymaxi=rundezahl(y2,y2-dy);
 dy=ymaxi-ymini;
 hoehe=dy*rundezahl(HMIN/dy,HMAX/dy);
 printf("X MINIMUM %lg MAXIMUM %lg.\n",xmini,xmaxi); /* test */
 printf("Y MINIMUM %lg MAXIMUM %lg.\n",ymini,ymaxi); /* test */
 printf("laenge=%lfcm  hoehe=%lfcm\n",laenge,hoehe); /* test */
 fprintf(fp,"X AXIS LENGTH %.4lf.\n",laenge/INCHX);
 fprintf(fp,"Y AXIS LENGTH %.4lf.\n",hoehe/INCHY);
 fprintf(fp,"X MINIMUM %lg MAXIMUM %lg.\n",xmini,xmaxi);
 fprintf(fp,"Y MINIMUM %lg MAXIMUM %lg.\n",ymini,ymaxi);
 fprintf(fp,"INPUT DATA.\n");
 ncurv=1;
}

static void anschreiben(FILE* fp,double wert,int x,int y,int strokeflag)
{				 /* Werte in Postscriptbild anschreiben */
 char str[10];
 int dx;
 if(wert<10.) sprintf(str,"%.3lf",wert);
 else  sprintf(str,"%.2lf",wert);
 dx=(BBUCHSTABENBREITE*strlen(str))/2;
 if(strokeflag) putc('s',fp);
 fprintf(fp," %d %d m (%s) show\n",x-dx,y-BBDY,str);
}

void bildplot(double x,double y,int pen)
{
 static int ncount=0, pen2count=0;
 static UWORD ux,uy,ufeld[512];
 int h;
/* DEBUG(1,printf("bildplot(%lf,%lf,%d)\n",x,y,pen)); */
 if(iffflag)
   {static UBYTE farbe=1, npu=0;
    static int npu2=0;
    /* DEBUG(1,printf("npu=%d npu2=%d\n",npu,npu2)); */
    if(npu>1 && (pen==3 || npu==255))
	{fwrite(&npu,1,1,fpbild); fwrite(&farbe,1,1,fpbild);
	 h=2+npu2+npu2; laenge3+=h; laenge1+=h;
/*	 DEBUG(1,printf("ffwrite((char *)ufeld,2,npu2,fp);\n")); */
	 ffwrite((char *)ufeld,2,npu2,fpbild); npu2=0;
	 ufeld[npu2++]=ux; ufeld[npu2++]=uy; npu=1;
	}
    if(pen==3)
	{/*if(pattern==DELETE) farbe=0;
	 else {farbe=pattern-'`'+1; if(farbe>MAXFARB) farbe=MAXFARB;} */
	 farbe=tek_farbe;
	 npu=npu2=0;
	}
    x=(x-xminsav)*xssav;
    y=(y-yminsav)*yssav;
    if(x<=0.) ux=0; else ux=(int)(x+0.5);
    if(y<=0.) uy=0; else uy=(int)(y+0.5);
    ufeld[npu2++]=ux;
    ufeld[npu2++]=uy;
/*    DEBUG(1,printf("ux=%d uy=%d\n",ux,uy)); */
    npu++;
    return;	
   }
 if(postflag)
   {static int lzugi=0;
    if(pen==2)
	{fprintf(fpbild," %.2lf %.2lf d",psxkor(x),psykor(y));
	 if(++pen2count>=100)  {pen2count=0; fprintf(fpbild,"sm");}
	 ++lzugi;
	}
    else
	{if(lzugi>1) {fprintf(fpbild," s\n"); lzugi=1; ncount= -1;}
	 if(pen==3) fprintf(fpbild," %.2lf %.2lf m ",psxkor(x),psykor(y));
	 pen2count=0;
	}
    if(++ncount>=4)  {ncount=0; fprintf(fpbild,"\n");}
    return;
   }
/* sonst Tellagraf: */
 if(pen!=2)
	{fprintf(fpbild,"\n\"%d\"\n",ncurv);
	 ncurv++;
	 ncount=0;
	}
 if(ncount==0) fprintf(fpbild,"\n");
 fprintf(fpbild,"%lg %lg ",x,y);
 if(++ncount>=5) ncount=0;
}

void bildclose()
{
 DEBUG(1,printf("bildclose()\n"));//test
 if(iffflag)
	{bildplot(xminsav,yminsav,3);
	 fseek(fpbild,4,0); ffwrite((char *)&laenge1,4,1,fpbild);
	 fseek(fpbild,laenge2+16+sizeof(bmhd)+8,1);
	 ffwrite((char *)&laenge3,4,1,fpbild);
	}
 else if(postflag)
	{bildplot(0.,0.,4);
	 fprintf(fpbild," showpage\nrestore\n");
	}
 else
	{fprintf(fpbild,"\nEOD.\n");
	 fprintf(fpbild,"GO.\n");
	}
 fclose(fpbild); fpbild=NULL;
 qsaveflag=0;
}
#endif /*SHOWIT*/

static void textfile_creat(const char* name)
{
 FILE *fp;
 char str[80];
 fp=fopen("tella.fdl","w");
 fclose(fp);
 sprintf(str,"creat/fdl=tella.fdl %s",name);
 system(str);
 system("del tella.fdl;");
}

void ffwrite(char* adr,int size,int n,FILE* fp)
{				 /* korrigiert fehlerhaftes fwrite */
 char h;
 int i,j,k;
 for(k=0;k<n;k++)
   {i=k*size;
    for(j=i+size-1;i<j;i++,j--)
	{h= adr[i]; adr[i]=adr[j]; adr[j]=h;}
   }
 fwrite(adr,1,size*n,fp);
 for(k=0;k<n;k++)
   {i=k*size;
    for(j=i+size-1;i<j;i++,j--)
	{h= adr[i]; adr[i]=adr[j]; adr[j]=h;}
   }
}

/************************* kleinkram ******************************/
double rundezahl(double x,double y)
{
 static double rund[]={5.,8.,6.,4.,2.,9.,7.,3.,1.,-1.};
 double z1,z2,z3;
 int i;
 if(x<0.) return -rundezahl(-x,-y);
 if(y<0.) return 0.;
 if(x<y) {z1=x; x=y; y=z1;}
 if(x>=1.) /* 1 10 100 1000 ... */
  {for(z1=1.;z1<=x; z1*=10.)  if(z1>=y) return z1;
   z1/=10.;
  }
 else      /* 0.1 0.01 0.001 .... */
  {for(z1=0.1;z1>=y; z1*=0.1)  if(z1<=x) return z1;
  }
 for(i=0;(z2=rund[i])>1.;i++) /* Test auf Gleichheit der ersten Ziffer */
	if((z2*=z1)<=x && z2>=y) return z2;
 for(z2=z1+z1;z2<x;z2+=z1)
	;
 z2-=z1; /* z2 = erste Ziffer */
 while(z1>0.)
  {z1/=10.;
   for(i=0;(z3=rund[i])>0.;i++)
	if((z3=z3*z1+z2)<=x && z3>=y) return z3;
   for(z3=z1;z2+z3<x;z3+=z1) ;
   z2+=z3-z1;//Erweiterung wie in showit.c
  }
 return y; /* Fehler: x==y */
}

void bmhd_speichern()
{
 LONG n;
 char *p;
 fprintf(fpbild,"BMHD");
 bmhd.breite=breite; bmhd.hoehe=hoehe;
 bmhd.x=bmhd.y=0;
 bmhd.nplanes=1; bmhd.mask=0; bmhd.compr=0; bmhd.pad=0;
 bmhd.transcolor=0;
 bmhd.xaspect=1; bmhd.yaspect=1;
 bmhd.scrbreite=breite; bmhd.scrhoehe=hoehe;
 n=sizeof(bmhd);
 ffwrite((char *)&n,4,1,fpbild); laenge1+=n+8;
 p= (char *) &bmhd;
 ffwrite((char *)p,2,4,fpbild); p+=8;
 ffwrite((char *)p,1,4,fpbild); p+=4;
 ffwrite((char *)p,2,1,fpbild); p+=2;
 ffwrite((char *)p,1,2,fpbild); p+=2;
 ffwrite((char *)p,2,2,fpbild);
}

/***************** neu gegenueber Quickplot ********************/
void ipunkt(int x,int y,int farbe)
{
 if(farbe!=tek_farbe) color(farbe);
 XDrawPoint(dpy,win1,gc,x,y);
}
void ipunkte(XPoint *pu,int np,int farbe)
{
 color(farbe);
 XDrawPoints(dpy,win1,gc,pu,np,CoordModeOrigin);
}
void ipunkte(void *p,int np,int farbe)
{
 ipunkte((XPoint*)p,np,farbe);
}
void iplotline(int x1,int y1,int x2,int y2,int farbe)
{
 if(farbe!=tek_farbe) color(farbe);
 XDrawLine(dpy,win1,gc,x1,y1,x2,y2);
}
int imausposition(int *x,int *y)
{
 int n=maustasten();
 *x=tek_mausx; *y=tek_mausy;
 return n;
}

/*************** Menu aufgeklappt halten ******************/
class Menuaufklapper
{
 int offen,x,y;
public:
 Menuaufklapper() {offen=0; x=y= -1;}
 void einaus();
 void setoffen(int n) {offen=n;}
 int istoffen() {return offen!=0;}
 void setxy(int,int);
 void auswahl();
 int key(KeySym k);
};
static Menuaufklapper klappr;

struct Amigatab {Amigatab *next; int taste; funkzeiger funk; long j;};

class Amigatast
{
 int aktiv;
 Amigatab *tabelle;
public:
 Amigatast() {aktiv=0; tabelle=NULL;}
 bool doit(KeySym k);
 void benutzen(int k);
 int geta(char*);
 void put(int t,funkzeiger f,long j);
 void put(int k,long j);
 void subput(int k);
};
static Amigatast amigatast;

/********************** Maus ************************/
#ifdef VAX_OR_ALPHA
void Delay(int sec50tel)
{
 long ef2, zeit[2]={-200000,-1};/* 0.02 sec */
 if(sec50tel>1)
	{zeit[0] *= sec50tel;
	 if(sec50tel>=12 && initalflag) tek_flush();
	}
 CHECK(lib$get_ef(&ef2));
 sys$clref(ef2);
 CHECK(sys$setimr(ef2,zeit,NULL,2,0));
 sys$waitfr(ef2);
 lib$free_ef(&ef2);
}
#endif
#ifdef UNIX
#ifndef __linux__
#ifndef MACOSX
extern "C" {			  //provisorisch:
extern void usleep(unsigned int); //sollte eigentlich schon in unistd.h
}				  //definiert sein.
#endif
#endif
void Delay(int sec50tel)
{
 long n=20000;
 if(sec50tel>1)
	{n *= sec50tel;
	 if(sec50tel>=12 && initalflag) tek_flush();
	}
 usleep(n);
}
#endif

funkzeig	funk_buttonpress=NULL, funk_buttonrelease=NULL,
		funk_expose=NULL, funk_motion=NULL;

void set_funktions(funkzeig pre,funkzeig rel,funkzeig exp,funkzeig mot)
{
 funk_buttonpress=pre; funk_buttonrelease=rel;
 funk_expose=exp; funk_motion=mot;
}

int maustasten()
{
// XEvent event;
 long emask=ExposureMask|ButtonPressMask|ButtonReleaseMask|PointerMotionMask|
		KeyPressMask; /* fr keyget() Tastaturabfrage */
 if(XCheckWindowEvent(dpy,tekplot_win,emask,&EVENT))
   switch(EVENT.type)
	{case ButtonPress:
		if(klappr.istoffen()) //Mausklicks fuer Menu abfangen
		  {break;}
		tek_mausx=EVENT.xbutton.x;
		tek_mausy=EVENT.xbutton.y;
		switch(EVENT.xbutton.button)
			{case 2: maustasten_zustand |= MIMAUS;
			 CASE 3: maustasten_zustand |= REMAUS;
			 DEFAULT: maustasten_zustand |= LIMAUS;
			}
/*		printf("ButtonPress:: mauszustand=%04X\n",
				maustasten_zustand);/* test */
		if(funk_buttonpress!=NULL) (*funk_buttonpress)();
	 CASE Expose:
		if(funk_expose!=NULL)
		 {while(XCheckIfEvent(dpy,&EVENT,(prediczeiger)predicate2,
						(char *)tekplot_win))  ;
		  (*funk_expose)();
		 }
		else
		 {if(rambildflag && refreshflag && !initalflag)
			{DEBUG(1,printf("Bildrefresh\n"));
			 while(XCheckIfEvent(dpy,&EVENT, // test
						(prediczeiger)predicate2,
						(char *)win1))  ;
			 XCopyArea(dpy,rambild,win1,gc,0,0,
				(uint)winbreite,(uint)winhoehe,0,0);
			 //refreshflag=0;
			}
		  else if(rambildflag) refreshflag=1;
		  XSync(dpy,0);
		 }
	 CASE ButtonRelease:
		if(klappr.istoffen()) //Mausklicks fuer Menu abfangen
		  {klappr.auswahl(); break;}
		tek_mausx=EVENT.xbutton.x;
		tek_mausy=EVENT.xbutton.y;
		switch(EVENT.xbutton.button)
			{case 2: maustasten_zustand &= ~MIMAUS;
			 CASE 3: maustasten_zustand &= ~REMAUS;
			 DEFAULT: maustasten_zustand &= ~LIMAUS;
			}
/*		printf("ButtonRelease:: mauszustand=%04X\n",
				maustasten_zustand);/* test */
		if(funk_buttonrelease!=NULL) (*funk_buttonrelease)();
	 CASE MotionNotify:
		if(klappr.istoffen()) //Mausbewegung fuer Menu abfangen
		  {while(XCheckIfEvent(dpy,&EVENT,(prediczeiger)predicate,
						(char *)tekplot_win))  ;
		   klappr.setxy(EVENT.xbutton.x,EVENT.xbutton.y);
		   break;
		  }
		tek_mausx=EVENT.xbutton.x;
		tek_mausy=EVENT.xbutton.y;
		if(funk_motion!=NULL)
		  {while(XCheckIfEvent(dpy,&EVENT,(prediczeiger)predicate,
						(char *)tekplot_win))  ;
		   (*funk_motion)();
		  }
	 CASE MappingNotify: /* Abbildungsnderung fr keyget() */
		XRefreshKeyboardMapping(&EVENT.xmapping);
	 CASE KeyPress: /* Tastatureingabe verarbeiten */
		keyget_i=XLookupString(&EVENT.xkey,keyget_txt,10,&keyget_key,0);
		if(keyget_key==MENUTASTE)
		  {klappr.einaus(); keyget_flag=0;}
		else if(klappr.istoffen() && klappr.key(keyget_key))
		  keyget_flag=0; //Tastatur fuer Menu abfangen
		else if(amigatast.doit(keyget_key))
		  keyget_flag=0; //Tastatur fuer Menu Schnellwahl abfangen
		else
		  keyget_flag=1;
	}
 return maustasten_zustand;
}

void imausklick(int taste,int *x,int *y)
{
 int updown=taste&MAUSUDMASKE;
 taste &= ~MAUSUDMASKE;
 if(!(taste & MAUSMASKE)) taste=MAUSMASKE;
/* printf("imausklick(): taste=%04X\n",taste);/* test */
 if(updown!=MAUSUP)
     while((maustasten() & taste)) Delay(2); /* warte auf Niederdrcken */
 if(updown!=MAUSDOWN)
     while(!(maustasten() & taste)) Delay(2); /* warte auf Loslassen */
 *x=tek_mausx;
 *y=tek_mausy;
}

void mausklick(int taste,double *x,double *y)
{
 int ix,iy;
 imausklick(taste,&ix,&iy);
// *x=ix/PLOTC.xsc+PLOTC.xmi; *y=PLOTC.yma-iy/PLOTC.ysc;
 koordpix2user(ix,iy,x,y);
}

int mausposition(double *x,double *y)
{
 int n;
 n=maustasten();
// *x=tek_mausx/PLOTC.xsc+PLOTC.xmi; *y=tek_mausy/PLOTC.ysc+PLOTC.yma;
 koordpix2user(tek_mausx,tek_mausy,x,y);
 return n;
}

/************************* ab Version 1.7 ********************************/
#define JAM1 1
#define JAM2 2
#define COMPLEMENT 3

void drawmode(int mode)
{
 static int pixelwert=0;
 if(colortabelle!=NULL)
 {if(mode==COMPLEMENT)
   {pixelwert=colortabelle[0].pixel;
    if(pixelwert==0) pixelwert=colortabelle[1].pixel;
    XSetForeground(dpy,gc,pixelwert);
    XSetFunction(dpy,gc,(pixelwert==0)?GXequiv:GXxor);
   }
  else
  {if(pixelwert != 0)
     {XSetForeground(dpy,gc,colortabelle[tek_farbe].pixel); pixelwert=0;}
   switch(mode)
     {case JAM1: XSetFunction(dpy,gc,GXcopy); break;
      case JAM2: XSetFunction(dpy,gc,GXcopy); break;//provi.
     }
  }
 }
 else //if(colortabelle==NULL) //24-Bit-Modus
 {if(mode==COMPLEMENT)
   {pixelwert=0xFFFFFF;
    XSetForeground(dpy,gc,pixelwert);
    XSetFunction(dpy,gc,GXxor);
   }
  else
   {if(pixelwert != 0)
     {XSetForeground(dpy,gc,tek_farbe); pixelwert=0;}
    switch(mode)
     {case JAM1: XSetFunction(dpy,gc,GXcopy); break;
      case JAM2: XSetFunction(dpy,gc,GXcopy); break;//provi.
      default: printf("Error in drawmode(): wrong mode=%d\n",mode);
     }
   }
 }
}

void iviereck(int x1,int y1,int x2,int y2,int farbe)
{
 if(y1>y2) {int h=y1; y1=y2; y2=h;}
 if(x1>x2) {int h=x1; x1=x2; x2=h;}
 if(farbe!=tek_farbe) color(farbe);
 XFillRectangle(dpy,win1,gc,x1,y1,x2-x1+1,y2-y1+1);
}

/************************* ab Version 1.8 ********************************/
void screenclear(int farbe)	/* fast gleich wie clear() */
{
 if(dpuffer!=0) //Doublebuffering-Variante
  {static int leerpufferfarbe=0;
   if(leerpuffer==0)
      {int f0=tek_farbe;
       leerpuffer=XCreatePixmap(dpy,win10,(uint)winbreite,(uint)winhoehe,dept);
       if(farbe>=0) leerpufferfarbe=farbe;
       color(farbe); ifillbox(0,0,breite,hoehe+menubalkenhoehe); color(f0);
       XCopyArea(dpy,dpuffer,leerpuffer,gc,0,0,(uint)winbreite,(uint)winhoehe,0,0);
      }
   else if(farbe>=0 && farbe!=leerpufferfarbe)
      {int f0=tek_farbe;
       color(farbe); ifillbox(0,0,breite,hoehe+menubalkenhoehe); color(f0);
      }
   else
      XCopyArea(dpy,leerpuffer,dpuffer,gc,0,0,(uint)winbreite,(uint)winhoehe,0,0);
   return;
  }
 //Altbewaehrte Variante:
 int x,y;
 Window geomid;
 DEBUG(1,printf("screenclear()\n"));
 if(plo_i>1) q2plot(0.,0.,4);
 refreshflag=0;
 XClearWindow(dpy,win1);
 XGetGeometry(dpy,win1,&geomid,&x,&y,
                (uint*)&winbreite,(uint*)&winhoehe,&border,&dept);
// DEBUG(1,printf("XGetGeometry --> breite=%d hoehe=%d border=%d dept=%d\n",
//                winbreite,winhoehe,border,dept));//test
// winbreite--; winhoehe--;
 tekplot_breite=breite=winbreite-1;
 tekplot_hoehe=hoehe=winhoehe-1-menubalkenhoehe;
 if(rambild!=0)
        {XFreePixmap(dpy,rambild); rambild=0;}
 rambildflag=0;
 if(xsync_modus>=1) XSync(dpy,0);
 if(farbe>=0)
   {int f0=tek_farbe; if(f0<0) f0=1;
    color(farbe); ifillbox(0,0,breite,hoehe+menubalkenhoehe);
    color(f0);
   }
}

/************************* ab Version 1.9 ********************************/

void iplot(int ix,int iy,int pen)
{ /* provisorisch */
 double x,y;
 koordpix2user(ix,iy,&x,&y);
 q2plot(x,y,pen);
}
void moveto(int x,int y) {iplot(x,y,PENUP);}
void lineto(int x,int y) {iplot(x,y,PENDOWN);}

void iline(int n,int *xf,int *yf)
{
 XPoint xp[NPMAX];
 int ix,iy,np,i,j;
 if(plo_i>1) q2plot(0.,0.,4);
 j=0;
 if(qsaveflag)
   {iplot(xf[0],yf[0],3);
    for(i=1;i<n;i++) iplot(xf[i],yf[i],2);
    return;
   }
 do
   {if(n>NPMAX) np=NPMAX;
    else	np=n;
    for(i=0; i<np; i++,j++)
	{xp[i].x = xf[j];  xp[i].y = yf[j];
	}
    while(!initalflag) Delay(1);
    XDrawLines(dpy,win1,gc,xp,np,CoordModeOrigin);
    n=n-np+1; j--;
   }
 while(n>1);
 if(xsync_modus>=2) XSync(dpy,0);
}

void idrawbox(int x1,int y1,int x2,int y2)
{
 if(y1>y2) {int h=y1; y1=y2; y2=h;}
 if(x1>x2) {int h=x1; x1=x2; x2=h;}
 XDrawRectangle(dpy,win1,gc,x1,y1,x2-x1,y2-y1);
}
void ifillbox(int x1,int y1,int x2,int y2)
{
 if(y1>y2) {int h=y1; y1=y2; y2=h;}
 if(x1>x2) {int h=x1; x1=x2; x2=h;}
 XFillRectangle(dpy,win1,gc,x1,y1,x2-x1+1,y2-y1+1);
}
void idrawcircle(int x,int y,int r1,int r2)
{
 XDrawArc(tekplot_dpy,win1,gc,x-r1,y-r2,r1+r1,r2+r2,0,360*64);
}
void ifillcircle(int x,int y,int r1,int r2)
{
 XFillArc(tekplot_dpy,win1,gc,x-r1,y-r2,r1+r1,r2+r2,0,360*64);
}

void waitTOF()
{
 if(menubalkenhoehe!=0) waitmenu(0);
 else maustasten();
 Delay(1);
}
void waitBOF()
{
 waitTOF();/* provisorisch */
}

/****************************** xmenu.cc *********************************/
static const char *xmenuVersion="xmenu Version 1.05";

#include <stdarg.h>

static funkzeiger menu_funkfeld[MAXMENU],menu_sub_funkfeld[MAXMENU];
int		menu_debug=0;
static int	menu_anzahl=0,menu_i=0,menu_isub=0,menu_k=0,
		menu_istsub[MAXMENU],menu_sub_ifu[MAXMENU];
static char	*menu_textfeld[MAXMENU];

void menu_reset() {menu_anzahl=menu_i=menu_isub=menu_k=0; menubalkenhoehe=0;}
int menuvorhanden() {return menu_anzahl>0;}

void setmenu(int n,...)
{
/* Beispiel:
/* setmenu(3,"File","Funktionen",     "Hilfe");	/* Menuleiste */
/* setmenu(3,"Quit","erste Funktion", "ber",   /* Menupunkte */
/*	      &quit, &erste,	      &ueber);  /* Zeiger auf Funktionen */
/* setmenu(2,"Exit","zweite Funktion",&exit,&zweite); */
/* setmenu(2,NULL,  "dritte Funktion",NULL,&dritte);  */
 int i,k;
 va_list ap;
 if(n<=0)
	{
#ifdef AUTOMENU
	 if(n==AUTOMENU) {setmenu(1,"File");setmenu(1,"Exit",&automenu_exit);}
	 else
#endif
	  printf("XMENU: menu_debug=%d\n",menu_debug= -n);
	 return;
	}
 if(menu_i+n > MAXMENU)
	{printf("maximale Menu-Anzahl ueberschritten\n"); return;}
 va_start(ap,n);
 if(menu_i==0)
	{menu_anzahl=n;
	 for(i=0;i<MAXMENU;i++) menu_istsub[i]=menu_sub_ifu[i]=0;
	 menu_isub=0; menu_k=0;
	 for(i=0;i<n;i++) menu_textfeld[menu_i++]=va_arg(ap,char*);
	}
 else	{for(k=menu_i,i=0;i<n;i++) menu_textfeld[k++]=va_arg(ap,char*);
	 for(k=menu_i-menu_isub,i=0;i<n;i++)
		{menu_funkfeld[k++]=va_arg(ap,funkzeiger);
		 amigatast.put(k-1,-k);
		}
	 for(i=n;i<menu_anzahl;i++)
		{menu_textfeld[menu_i+i]=NULL; menu_funkfeld[k++]=NULL;}
	 menu_i += menu_anzahl;
	 if(menu_sub_ifu[menu_k]) menu_k++;
	}
 va_end(ap);
}

void setsubmenu(int n,...)
{
/* Beispiel:
/* setmenu(3,"File","Funktionen",     "Hilfe");	/* Menuleiste */
/* setmenu(3,"Quit","erste Funktion", "ber", &quit, &erste, &ueber);
/* setsubmenu(2,"ohne Speichern","Subpunkt 1",&ohne, &subpunkt1);
/* setsubmenu(2,"mit Speichern", "Subpunkt 2",&mit,  &subpunkt2);
/* setsubmenu(2,NULL,		 "Subpunkt 3",NULL,  &subpunkt3);
/* setmenu(2,"Exit","zweite Funktion",&exit,&zweite); */
 int i,k;
 va_list ap;
 if(menu_i+n > MAXMENU)
	{printf("maximale Menu-Anzahl ueberschritten\n"); return;}
 va_start(ap,n);
 menu_sub_ifu[menu_k]++;
 for(k=menu_i,i=0;i<n;i++,k++)
	{menu_textfeld[k]=va_arg(ap,char*); menu_istsub[k]=1;}
 for(k=menu_isub,i=0;i<n;i++)
	{menu_sub_funkfeld[k++]=va_arg(ap,funkzeiger);
	 amigatast.subput(k-1);
	}
 for(i=n;i<menu_anzahl;i++)
	{menu_textfeld[menu_i+i]=NULL; menu_sub_funkfeld[k++]=NULL;
	 menu_istsub[menu_i+i]=1;
	}
 menu_i += menu_anzahl;
 menu_isub += menu_anzahl;
 va_end(ap);
}

/********************** xmenu **********************/
#define ZAUNRAND 2
static int pixprobuchst_x=6, pixprobuchst_y=8, zeilenabstand=12;

extern Display *tekplot_dpy;
extern Window tekplot_win;

typedef struct _xsubmenu
{
 Window win;		/* Fenster mit diesem Untermenu */
 int breite,x0,y0;	/* Breite, linke obere Ecke */
 char **text;		/* Texte der UnterMenupunkte */
 int ntext;		/* Anzahl UnterMenupunkte */
 int *xpos,*ypos;	/* Positionen der Texte */
 funkzeiger *funkfeld;	/* Funktionenzeiger der UnterMenupunkte */
} xsubmenu;

typedef struct _xmenu
{
 GC gc;
 Window win0,*win;	/* win0=Menuleiste, win[i]=i-tes Menu */
 long emask0,emask;
 int anzahl,nreihen;	/* Anzahl Menus, maximale anzahl Eintraege */
 int subanzahl;		/* Maximale Anzahl Submenus */
 int *x0,y0;		/* obere linke Ecke der Menuwindows */
 int *br;		/* breite der Menuwindows */
 char *text0;		/* Text der Menuleiste */
 char **text;		/* Texte der einzelnen Menupunkte */
 int *ntext;		/* Anzahl Menupunkte in den Menus */
 xsubmenu **sub;	/* Untermenuzeiger der einzelnen Menupunkte */
 int *xpos,*ypos;	/* Positionen der Texte in allen Menupunkten */
 int klappe;		/* Nummer des gerade aufgeklappten Menus (-1=keins) */
 int subklappe;		/* Nummer des gerade aufgeklappten UnterMenus */
 XFontStruct *fontstruct;
} xmenu;
static xmenu menu;
static int higrund,fogrund;
static int menu0_breite,menu0_hoehe;//ab V1.05

/** Vordeklarationen **/
void menu_font_anfordern();
void menu_markieren(int x,int y);
char *dublikat(const char *);
void straddblank(char *str,char *text);
int init1sub(int j1,int i,int ji,int *j1i,int subnr);
void init2sub(xsubmenu *su,int x00,int y00,int br00);
void submenu_klappen(Window win,int nr);
int subreihe_ermitteln(int subnr,int x,int y);
void submenu_markieren(int reihe);
void anschreibenwin(Window win,int xpos,int ypos,char *str,
			int x0,int breite,int j,int jmax);//ab V1.05
int pixtextlaenge(char *str);
/** Ende Vordeklarationen **/

void menu_setzen()
{
 int i,j,ji,j1,j1i,n,breite,hoehe,x0,y0,subnr,k;
 unsigned int bord,dep;
 Window geomid;
 char *str;
 menu.text0=NULL;
 if(menu_i==0) return;
 menu.klappe=menu.subklappe= -1;
 menu.anzahl=menu_anzahl;
 menu.nreihen=(menu_i-menu_isub)/menu_anzahl;
 menu.win=(Window *)calloc(menu_anzahl,sizeof(Window));
 menu.ntext=(int *)calloc(menu_anzahl,sizeof(int));
 menu.x0=(int *)calloc(menu_anzahl+1,sizeof(int));//eins mehr av V1.05
 menu.br=(int *)calloc(menu_anzahl,sizeof(int));
 menu.subanzahl=n=menu_i-menu_isub;
 menu.xpos=(int *)calloc(n,sizeof(int));
 menu.ypos=(int *)calloc(n,sizeof(int));
 menu.text=(char **)calloc(n,sizeof(char*));
 menu.sub=(xsubmenu **)calloc(n,sizeof(xsubmenu*));
/* menu_font_anfordern(); */
 for(n=1,i=0;i<menu_anzahl;i++) n+=strlen(menu_textfeld[i])+2;
 str=(char *)calloc(n,1);
 for(i=0,*str=0;i<=menu_anzahl;i++)
	{menu.x0[i]=pixtextlaenge(str);
	 if(i<menu_anzahl) straddblank(str,menu_textfeld[i]);
	}
 menu.text0=str;
/* breite=pixprobuchst_x*strlen(str); */
 XGetGeometry(tekplot_dpy,tekplot_win,
		&geomid,&x0,&y0,(uint*)&breite,(uint*)&hoehe,&bord,&dep);
 hoehe=pixprobuchst_y*3/2;
 menu0_breite=breite; menu0_hoehe=hoehe;//ab V1.05
 for(i=0;i<menu.anzahl;i++)
  for(j1=1,j=1,subnr=i,k=0; j<menu.nreihen; j++,j1++)
	{ji=i+j*menu.anzahl;
	 j1i=i+j1*menu.anzahl;
	 if(menu_istsub[j1i])
		{j1=init1sub(j1,i,ji-menu.anzahl,&j1i,subnr);
		 subnr+=menu_sub_ifu[k++]*menu.anzahl;
		}
	 else	menu.sub[ji-menu.anzahl]=NULL;
	 menu.text[ji]=dublikat(menu_textfeld[j1i]);
	}
 higrund=WhitePixel(tekplot_dpy,DefaultScreen(tekplot_dpy));
 fogrund=BlackPixel(tekplot_dpy,DefaultScreen(tekplot_dpy));
 menu.win0=XCreateSimpleWindow(tekplot_dpy,tekplot_win,0,0,
				breite,hoehe,0,fogrund, higrund);
 menu.gc=XCreateGC(tekplot_dpy,menu.win0,0,NULL);
 XSetBackground(tekplot_dpy,menu.gc,higrund);
 XSetForeground(tekplot_dpy,menu.gc,fogrund);
 XSetFont(tekplot_dpy,menu.gc,menu.fontstruct->fid);
 menu.emask=ExposureMask;
 menu.emask0=ExposureMask|ButtonPressMask|ButtonReleaseMask|PointerMotionMask;
 XSelectInput(tekplot_dpy,menu.win0,menu.emask0);
 XMapRaised(tekplot_dpy,menu.win0);
 menu.y0=zeilenabstand;
 for(i=0;i<menu.anzahl;i++)
  {char *s;
   breite=(strlen(menu_textfeld[i])+2)*pixprobuchst_x;
   hoehe=1;
   for(j=1; j<menu.nreihen && (s=menu.text[ji=i+j*menu.anzahl]); j++)
	{hoehe+=zeilenabstand;
	 n=strlen(s)*pixprobuchst_x+pixprobuchst_x/2+2;
	 if(n>breite) breite=n;
	 menu.xpos[ji]=pixprobuchst_x; menu.ypos[ji]=hoehe-pixprobuchst_y/4;
  	}
   menu.ntext[i]=j; menu.br[i]=breite;
   menu.win[i]=XCreateSimpleWindow(tekplot_dpy,tekplot_win,menu.x0[i],menu.y0,
			breite,hoehe+pixprobuchst_y/5,0,fogrund,higrund);
   XSelectInput(tekplot_dpy,menu.win[i],menu.emask);
  }
 for(i=0;i<menu.anzahl;i++)
  for(j=1;j<menu.nreihen;j++)
   {ji=i+j*menu.anzahl;
    if(menu.sub[ji])
	init2sub(menu.sub[ji],menu.x0[i],menu.y0+menu.ypos[ji],menu.br[i]);
   }
}

void menu_clear()
{
 int i,j,ji;
 char *s;
 if(menu_i==0 || menu.text0==NULL) return;
 for(i=0;i<menu.anzahl;i++)
  for(j=0;j<menu.nreihen;j++)
	{ji=i+j*menu.anzahl; s=menu.text[ji];
	 if(s!=menu_textfeld[ji]) cfree(s);
	 if(menu.sub[ji]) cfree(menu.sub[ji]);
	}
 cfree(menu.text0); cfree(menu.win); cfree(menu.ntext);
 cfree(menu.xpos); cfree(menu.ypos);
 cfree(menu.x0); cfree(menu.br); cfree(menu.text); cfree(menu.sub);
 XFreeFont(tekplot_dpy,menu.fontstruct);
 menu_i=0; menu.text0=NULL;
}

void straddblank(char *s,char *t)
{
 while(*s) s++;
 *s++ = ' ';
 while(*s++ = *t++)  ;
 *--s = ' ';
 *++s = 0;
}

char *dublikat(const char *str)
{
 char *s,*s0;
 if(str==NULL || (s0=s=(char *)calloc(strlen(str)+3,1))==NULL) return NULL;
 *s++ = ' ';
 while(*s++ = *str++) ;
 *--s=' '; *++s=0;
 return s0;
}

void menu_klappen(int x,int y)
{
 int i;
 if(menu.subklappe > -1)
	{XUnmapWindow(tekplot_dpy,menu.sub[menu.subklappe]->win);
	 menu.subklappe= -1;
	}
 if(x<0 && y<0)
  {
   if(menu.klappe!= -1)
	{XUnmapWindow(tekplot_dpy,menu.win[menu.klappe]); menu.klappe= -1;}
   return;
  }
 for(i=0; i<menu.anzahl-1; i++)
	if(x<=menu.x0[i+1]) break;
 if(menu.klappe!=i && menu.klappe!= -1)
	XUnmapWindow(tekplot_dpy,menu.win[menu.klappe]);
 XMapWindow(tekplot_dpy,menu.win[menu.klappe=i]);
}
int reihe_ermitteln(int spalte,int x,int y)
{
 int ji,reihe,n=menu.ntext[spalte];
 if((x-=menu.x0[spalte])<0 || x>menu.br[spalte]) return 0;
 y-=menu.y0;
 for(ji=spalte,reihe=0; reihe<n; ji+=menu.anzahl,reihe++)
	if(y<=menu.ypos[ji]+pixprobuchst_y/4) break;
 if(reihe==n) reihe=0;
 return reihe;
}

void menuleiste_anschreiben()
{
 XDrawImageString(tekplot_dpy,menu.win0,menu.gc,pixprobuchst_x,
		  pixprobuchst_y*5/4,menu.text0,strlen(menu.text0));
 XDrawLine(tekplot_dpy,menu.win0,menu.gc, //Menuleiste abgrenzen
		0,menu0_hoehe-1,menu0_breite,menu0_hoehe-1);//ab V1.05
}

int myXCheckEvent(Display *dpy,int mask,XEvent* ev) //fuer Schliesssymbol
{
 XEvent event;
 int ok=0,n;
 if((n=XEventsQueued(tekplot_dpy,QueuedAfterFlush))>0)
   {XPeekEvent(dpy,&event);
    //printf("event.type=%d mask=%d\n",event.type,mask);//test
    if(event.type==mask) {XNextEvent(dpy,ev); ok=1;}
    else if(n>2) {XNextEvent(dpy,&event); ok=0;}
   }
 return ok;
}

int waitmenu(int flag)
{
 int ret=0,i,j,ji,spalte,reihe,et;
 static int x=0,y=0,menu_am_aufklappen=0;
 static short firstflag=1;
 XEvent event;
 funkzeiger funk;
 xsubmenu *su;
 do
 {if(XCheckWindowEvent(tekplot_dpy,menu.win0,menu.emask0,&event)
     || myXCheckEvent(tekplot_dpy,ClientMessage,&event))
   switch(et=event.type)
   {case Expose:
	if(event.xexpose.count==0)
		menuleiste_anschreiben();
    CASE ButtonPress:
	if(!klappr.istoffen())
	  {x=event.xbutton.x; y=event.xbutton.y;
	   menu_klappen(x,y); menu_am_aufklappen=1;
	  }
    CASE ButtonRelease:
	if(menu_am_aufklappen)
	  {klappr.setoffen(1); menu_am_aufklappen=0;
	   break; //sofort wieder losgelassen --> Menu offen lassen
	  }
	x=event.xbutton.x; y=event.xbutton.y; spalte=menu.klappe;
	if((j=menu.subklappe) > -1)
	  {reihe=subreihe_ermitteln(j,x,y);
	   menu_klappen(-1,-1); klappr.setoffen(0);
	   if(reihe>=0 && (funk=menu.sub[j]->funkfeld[reihe])!=NULL)
			(*funk)(j+(reihe<<16)+1);
	  }
	else
	  {reihe=reihe_ermitteln(spalte,x,y);
	   menu_klappen(-1,-1); klappr.setoffen(0);
	   funk=menu_funkfeld[j=spalte+reihe*menu.anzahl];
	   if(reihe>=1 && funk!=NULL) (*funk)(-j-1);
	  }
	/* ret=flag; nur bei betaetigung des Fensterschliessknopfes setzen */
	/* 	     da mit XWindows nicht vorhanden also nie setzen.	   */
	flag=0;
    CASE MotionNotify:
        menu_am_aufklappen=0;
	if(menu.klappe!= -1)
	 {while(XCheckIfEvent(tekplot_dpy,&event,(prediczeiger)predicate,
							(char *)menu.win0))
				; /* aktuellste Position ermitteln */
	  x=event.xbutton.x; y=event.xbutton.y;
	  if(y<zeilenabstand) menu_klappen(x,y);
	  menu_markieren(x,y);
	 }
    //Abfrage des Schliesssymbols:
    CASE ClientMessage:
        {ret=1; flag=0; //printf("Test1: ClientMessage\n");//test
	}
    /* Tests von weiteren Events: *  /
    CASE DestroyNotify:    printf("Test1: DestroyNotify\n");//test
    CASE ConfigureNotify:  printf("Test1: ConfigureNotify\n");//test
    CASE MapNotify:        printf("Test1: MapNotify\n");//test
    CASE CirculateNotify:  printf("Test1: CirculateNotify\n");//test
    CASE GravityNotify:    printf("Test1: GrafityNotify\n");//test
    CASE ReparentNotify:   printf("Test1: ReparentNotify\n");//test
    CASE UnmapNotify:      printf("Test1: UnmapNotify\n");//test
    CASE VisibilityNotify: printf("Test1: VisibilityNotify\n");//test
    DEFAULT:
      printf("Test1: Unbekanntes Event: 0x%X\n",et);//test
      //siehe auch /usr/X11R6/include/X11/X.h
    /* Ende der Events-Tests */
   }
 else if(firstflag) /* zum ersten mal Menuleiste anschreiben */
       {if(menuvorhanden())
	{menuleiste_anschreiben();
	 firstflag=0;
       }}
 else
  {for(i=0;i<menu.anzahl;i++)
     if(XCheckWindowEvent(tekplot_dpy,menu.win[i],menu.emask,&event))
	switch(event.type)
	  {case Expose:
		if(event.xexpose.count==0)
		{int x0=menu.x0[i+1]-menu.x0[i];//ab V1.05
		 for(j=1;j<menu.ntext[i];j++)
		  {ji=i+j*menu.anzahl;
		   anschreibenwin(menu.win[i],menu.xpos[ji],
				menu.ypos[ji],menu.text[ji],
				x0,menu.br[i],j,menu.ntext[i]-1);
		} }
/**	   CASE MotionNotify:
		while(XCheckIfEvent(tekplot_dpy,&event,(prediczeiger)predicate,
						(char *)menu.win0))  ;
		x=event.xbutton.x; y=event.xbutton.y;
		printf("Zeiger in Menu: x=%d y=%d\n",x,y);/* test **/
	  }
   for(i=0;i<menu.subanzahl;i++)
     if((su=menu.sub[i]) &&
	XCheckWindowEvent(tekplot_dpy,su->win,menu.emask,&event))
	switch(event.type)
	  {case Expose:
		if(event.xexpose.count==0)
		 for(j=0;j<su->ntext;j++)
		    anschreibenwin(su->win,su->xpos[j],
				su->ypos[j]-zeilenabstand/5,su->text[j],
				0,su->breite,j+1,su->ntext);//ab V1.05
	  }
   if(flag) Delay(1); /* fuer besseren Refresh */
  }
  maustasten();
 } while(flag);
 return ret;
}

void menu_markieren(int x,int y)
{
 static int markiert= -1,klapp= -1,x1,y1,br,ho;
 int reihe,ji;
 if(menu.subklappe != -1)
	{reihe=subreihe_ermitteln(menu.subklappe,x,y);
	 if(reihe < -1) submenu_klappen(menu.sub[menu.subklappe]->win,-1);
	 else	{submenu_markieren(reihe); return;}
	}
 reihe=reihe_ermitteln(menu.klappe,x,y);
 if(klapp==menu.klappe)
   {if(markiert==reihe) return;/* schon markiert */
    if(klapp!= -1 && markiert!= -1)
	{/* alte Markierung loeschen */
	 XSetForeground(tekplot_dpy,menu.gc,higrund);
	 XDrawRectangle(tekplot_dpy,menu.win[klapp],menu.gc,x1,y1,br,ho);
	 XSetForeground(tekplot_dpy,menu.gc,fogrund);
   }	}
 klapp=menu.klappe;
 if(reihe==0 || menu.klappe== -1) markiert= -1;
 else	{ji=klapp+reihe*menu.anzahl;
	 x1=ZAUNRAND; y1=menu.ypos[ji]-(zeilenabstand*4/5-ZAUNRAND);
	 br=menu.br[klapp]-2*ZAUNRAND; ho=zeilenabstand-2*ZAUNRAND;
	 XDrawRectangle(tekplot_dpy,menu.win[klapp],menu.gc,x1,y1,br,ho);
	 markiert=reihe;
	 if(menu.sub[ji]) submenu_klappen(menu.sub[menu.subklappe=ji]->win,ji);
	}
}

static char *menu_fontliste[]=
  {
   "-adobe-courier-medium-r-normal--14-140-75-75-m-90-iso8859-1",//MAC eXodus
   "-adobe-helvetica-medium-r-normal--20-140-100-100-p-100-iso8859-1",
/*   "-adobe-helvetica-medium-r-normal--17-120-100-100-p-88-iso8859-1", */
   "-Adobe-Helvetica-Medium-R-Normal--14-140-75-75-P-77-ISO8859-1",
   NULL
  };

void menu_font_anfordern()
{
 int count,i;
 char **list,**zs;
 const char *s;
 XCharStruct bonds;
 int fontrichtung,ascent,descent;
 if(menu_debug>=2)
  {int maxnames=50; char name[120];
   do
    {printf("suche nach Fontnamen:"); scanf("%s",name);
     list=XListFonts(tekplot_dpy,name,maxnames,&count);
     for(i=0;i<count;i++) printf("Font %d:'%s'\n",i,list[i]);
     if(count<1) printf("keine Fonts gefunden - anderer Fontname eingeben (z.B. \"*helv*\")\n");
    }
   while(count<1);
   printf("Fontauswahl:"); scanf("%d",&i);
   if(i>=0 && i<count)
	menu_fontliste[0]=list[i];
   XFreeFontNames(list);
  }
 for(count=0,zs=menu_fontliste; count==0 && (s= *zs); zs++)
	list=XListFonts(tekplot_dpy,s,1,&count);
 if(count!=0) DEBUG(1,printf("Font aus vorgegebener Liste gefunden: %s\n",list[0]));//test
 if(count==0)
  {/* nach einem Helvetica Font der Hoehe 14 suchen */
   char s[]="*helv*--14*";
   DEBUG(1,printf("suche nach folgendem Fontmuster:\"%s\"\n",s));//test
   for(i=1;count==0 && i>0;)
     {list=XListFonts(tekplot_dpy,s,1,&count);
      if(count==0 && (i=strlen(s)-1)>0)
        {s[i]=0;
	 s[i-1]='*';
	 if(i<6) printf("keine Fonts mit gewuenschtem Namen gefunden. Name gekuerzt auf \"%s\"\n",s);
	} /* verkuerzen bis Font auffindbar */
     }
   if(count==0) printf("ueberhaupt keine Fonts gefunden.\n");
   else DEBUG(1,printf("benutzter Font: %s\n",list[0]));//test
  }
 menu.fontstruct=XLoadQueryFont(tekplot_dpy,list[0]);
 XFreeFontNames(list);
 XTextExtents(menu.fontstruct,"AbcdefghijKlmnopqRstuvwxyZ",26,
			&fontrichtung,&ascent,&descent,&bonds);
 pixprobuchst_x=bonds.width/26;
 pixprobuchst_y=bonds.ascent + bonds.descent;
 zeilenabstand=pixprobuchst_y*3/2;
 if(menu_debug)
	printf("pixprobuchst_x=%d pixprobuchst_y=%d zeilenabstand=%d\n",
		pixprobuchst_x,pixprobuchst_y,zeilenabstand);
}

int pixtextlaenge(char *str)
{
 XCharStruct bonds;
 int fontrichtung,ascent,descent;
 XTextExtents(menu.fontstruct,str,strlen(str),
		&fontrichtung,&ascent,&descent,&bonds);
 return bonds.width+pixprobuchst_x/2;
}

int get_menuleistenhoehe()
{
 return zeilenabstand+ZAUNRAND;
}

/************** Untermenus ab XmenuVersion 1.01 *********************/
int init1sub(int j1,int i,int ji,int *j1i,int subnr)
{			/* erste Initialisierung eines Submenus */
 xsubmenu *su;
 int n1,ntext=0;
 for(n1=(*j1i); menu_istsub[n1] && menu_textfeld[n1]; n1+=menu.anzahl,ntext++)
	 ;
 if(ntext>0)
  {su=menu.sub[ji]=(xsubmenu *)calloc(1,sizeof(xsubmenu));
   su->ntext=ntext;
   su->text=(char **)calloc(ntext,sizeof(char*));
   su->xpos=(int *)calloc(ntext,sizeof(int));
   su->ypos=(int *)calloc(ntext,sizeof(int));
   su->funkfeld=(funkzeiger *)calloc(ntext,sizeof(funkzeiger));
   for(n1=0;
	menu_istsub[*j1i] && menu_textfeld[*j1i];
	j1++,(*j1i)+=menu.anzahl,n1++,subnr+=menu.anzahl)
		{su->text[n1]=dublikat(menu_textfeld[*j1i]);
		 su->funkfeld[n1]=menu_sub_funkfeld[subnr];
		}
  }
 while(menu_istsub[*j1i]) {j1++; (*j1i)+=menu.anzahl;}
 return j1;
}

void init2sub(xsubmenu *su,int x00,int y00,int br00)
{			/* zweite Initialisierung eines Submenus */
 int i,hoehe,n;
 su->breite=0; hoehe=1;
 for(i=0;i<su->ntext;i++)
	{hoehe+=zeilenabstand;
	 n=strlen(su->text[i])*pixprobuchst_x+pixprobuchst_x/2+2;
	 if(n>su->breite) su->breite=n;
	 su->xpos[i]=pixprobuchst_x; su->ypos[i]=hoehe-pixprobuchst_y/4;
  	}
 su->y0=y00-zeilenabstand*3/4;
 su->x0=x00+br00-pixprobuchst_x;
 su->win=XCreateSimpleWindow(tekplot_dpy,tekplot_win,su->x0,su->y0,
					su->breite,hoehe,0,fogrund,higrund);
 XSelectInput(tekplot_dpy,su->win,menu.emask);
}

void submenu_klappen(Window win,int nr)
{
 if(nr > -1) {XSync(tekplot_dpy,0); XMapWindow(tekplot_dpy,win);}
 else	{XUnmapWindow(tekplot_dpy,win); XSync(tekplot_dpy,0);}
 menu.subklappe=nr;
}

int subreihe_ermitteln(int subnr,int x,int y)
	/* Rueckgabewert: Reihe 0 bis n wenn innerhalb Untermenu
			  -1 wenn innerhalb Menupunkt der Untermenu erfordert
			  -2 wenn ganz ausserhalb			*/
{
 xsubmenu *su=menu.sub[subnr];
 int n=su->ntext,reihe;
 x -= su->x0;
 y -= su->y0;
 if(x>su->breite || y < -zeilenabstand/2) return -2;
 for(reihe=0; reihe<n; reihe++)
	if(y <= su->ypos[reihe]+pixprobuchst_y/4) break;
 if(reihe==n) return -2;
 if(x<0) {if(reihe==0) return -1; else return -2;}
 return reihe;
}

void submenu_markieren(int reihe)
{
 static int markiert= -1,subnr,x1,y1,br,ho;
 xsubmenu *su;
 if(markiert>=0 && markiert!=reihe)
	{/* alte Markierung loeschen */
	 XSetForeground(tekplot_dpy,menu.gc,higrund);
	 XDrawRectangle(tekplot_dpy,menu.sub[subnr]->win,menu.gc,x1,y1,br,ho);
	 XSetForeground(tekplot_dpy,menu.gc,fogrund);
	 markiert= -1;
	}
 if(reihe<0 || reihe==markiert) return;
 if((subnr=menu.subklappe)== -1) {markiert= -1; return;}
/* neue Markierung zeichnen */
 su=menu.sub[subnr];
 x1=ZAUNRAND; y1=zeilenabstand*reihe+ZAUNRAND;
 br=su->breite-2*ZAUNRAND; ho=zeilenabstand-2*ZAUNRAND;
 XDrawRectangle(tekplot_dpy,su->win,menu.gc,x1,y1,br,ho);
 markiert=reihe;
}

void anschreibenwin(Window win,int xpos,int ypos,char *str,
			int x0,int breite,int j,int jmax)
{
 int dx=pixprobuchst_x;
 char *s=str, amigataste=0, s2[3];
 while(*s==' ') s++;
 while(*s=='%' && *++s!='%')
   {int x,y,dy=pixprobuchst_y*3/4,posflag=1;
    x=xpos+pixprobuchst_x/2; y=ypos-dy;
    if(*s=='o' || *s=='O') /* Kreise rund machen */
		if(dx<dy) dx=dy; else dy=dx;
    switch(*s++)
	{case 'q':XDrawRectangle(tekplot_dpy,win,menu.gc,x,y,dx,dy);
	 CASE 'Q':XFillRectangle(tekplot_dpy,win,menu.gc,x,y,dx,dy);
	 CASE 'O':XFillArc(tekplot_dpy,win,menu.gc,x,y,dx,dy, 0, 360*64);
	 case 'o':XDrawArc(tekplot_dpy,win,menu.gc,x,y,dx,dy, 0, 360*64);
	 CASE 'R':XDrawLine(tekplot_dpy,win,menu.gc,x,y+dy/2,x+dx/2,y+dy);
		  XDrawLine(tekplot_dpy,win,menu.gc,x+dx/2,y+dy,x+dx,y);
	 CASE '~':posflag=0;
	 CASE 'A':s2[0]='A'; s2[1]=amigataste= *s++; s2[2]=0; posflag=0;
	}
    if(posflag) xpos+=pixprobuchst_x+dx;
    str=s;
   }
 //printf("Testpunkt in anschreibenwin() str='%s'\n",str);//test
 XDrawImageString(tekplot_dpy,win,menu.gc,xpos,ypos,str,strlen(str));
 if(amigataste)
   XDrawImageString(tekplot_dpy,win,menu.gc,breite-dx*5/2,ypos,s2,2);
 if(j==jmax) //ab V1.05  Abgrenzungen zeichnen
  {if(x0==0)
	XDrawRectangle(tekplot_dpy,win,menu.gc,0,0,breite-1,jmax*zeilenabstand);
   else
	{int ymax=jmax*zeilenabstand+pixprobuchst_y/5;
	 XDrawLine(tekplot_dpy,win,menu.gc,x0,0,breite-1,0);
	 XDrawLine(tekplot_dpy,win,menu.gc,breite-1,0,breite-1,ymax);
	 XDrawLine(tekplot_dpy,win,menu.gc,0,0,0,ymax);
	 XDrawLine(tekplot_dpy,win,menu.gc,0,ymax,breite-1,ymax);
	}
  }
}

void changemenu(long idnr,const char *neuertext)
{
 int nr;
 char *s;
 if(idnr<0)
	{s=menu.text[nr= -idnr-1];
	 menu.text[nr]=dublikat(neuertext);
	 cfree(s);
	}
 else if(idnr>0)
	{xsubmenu *su=menu.sub[(idnr-1)&0xFFFF];
	 int reihe=(idnr-1)>>16;
	 s=su->text[reihe];
	 su->text[reihe]=dublikat(neuertext);
	 cfree(s);
	}
 else	{printf("ERR-XMENU: changemenu() needs a menu-id-number\n");
	 printf("           idnr=%ld neuertext='%s'\n",idnr,neuertext);
	}
}

void getmenuids(long idnr,long *idfeld,int max)
{
 int i,j,ji;
 long subnr;
 //static long *menu_idfeld=NULL;//test
 if(menu_debug) printf("getmenuids(idnr=%ld,long *idfeld)\n",idnr);
 if(idnr==0)	/* menu-id's */
  {//menu_idfeld=idfeld;//test
   if(max==0 || max>menu.anzahl) max=menu.anzahl;
   for(i=0;i<max;i++)
    for(j=1,ji=menu.anzahl+i; j<menu.ntext[i]; j++,ji+=menu.anzahl)
		idfeld[ji]= -ji-1;
  }
 else		/* submenu-id's */
  {long subnr;
   xsubmenu *su;
   if(idnr<0) subnr= -idnr-1; else subnr=(idnr-1)&0xFFFF;
   if(menu_debug) printf("getmenuids() subnr=%ld\n",subnr);
   su=menu.sub[subnr];
   if(menu_debug)
        {printf("su=%08lX\n",(long)su);
	 if(su!=NULL) printf("su->ntext=%d\n",su->ntext);
	}
   if(su==NULL)
	{printf("ERR-XMENU: getmenuids(id=%ld...)\n",idnr);
	 printf("     Hint: nur id von Untermenu verwenden\n");
	}
   else
	{if(max==0 || max > su->ntext) max=su->ntext;
	 for(i=0,subnr++; i<max; i++)
		idfeld[i]=subnr+(i<<16);
	}
  }
}

/********************** ab Tekplot1 Version 2.0 **************************/
void koordpix2user(int i,int j,double* x,double* y)
{
 *x = xmin + i/xs;
 *y = ymin + (hoehe-1-j+menubalkenhoehe)/ys;
}
void qkoorduser2pix(double x,double y,int *i,int *j)
{       //quick = ohne Ueberpruefung der Grenzen
 x=(x-xmin)*xs;
 y=(y-ymin)*ys;
 *i=(int)(x+0.5);
 *j = hoehe - 1 - (int)(y+0.5) + menubalkenhoehe;
}
void koorduser2pix(double x,double y,int *i,int *j)
{       //mit Ueberpruefung der Grenzen
 int z;
 x=(x-xmin)*xs;
 y=(y-ymin)*ys;
 if(x>0.) {*i=(int)(x+0.5); if(*i>=breite) *i=breite-1;}
 else	  *i=0;
 if(y>0.) {z=(int)(y+0.5); if(z>=hoehe) z=hoehe-1;}
 else	  z=0;
 *j=hoehe-1-z+menubalkenhoehe;
}
void deltakoorduser2pix(double x,double y,int *i,int *j)
{
 if((x*=xs)>0.) *i=(int)(x+0.5);
 else		*i=(int)(x-0.5);
 if((y*=ys)>0.) *j=(int)(y+0.5);
 else		*j=(int)(y-0.5);
}
void deltakoordpix2user(int i,int j,double *x,double *y)
{
 *x=i/xs;
 *y=j/ys;
}

/**************************** Beschriftungen *****************************/
class _tek_text
{
public:
 int hoehe,breite;
 int bpen; //Hintergrundfarbe (-1 = nicht benutzt)
 //Font font;
 XFontStruct *fontstruct;
 _tek_text() {hoehe=12; breite=8; bpen= -1;}
};
_tek_text tek_text;

void bpencolor(int farbnr)
{
 tek_text.bpen=farbnr;
}
void rgbbpencolor(int r,int g,int b)
{
 bpencolor((r<<16)+(g<<8)+b);
}

void ischrift(int x,int y,const char *str,double winkel)
{
 int ns=strlen(str);
 if(tek_text.bpen>=0)
     {int farbe=tek_farbe;
      color(tek_text.bpen);
      ifillbox(x,y,x+ns*tek_text.breite,y-tek_text.hoehe*2/3);
      color(farbe);
     }
 XDrawString(tekplot_dpy,win1,tekplot_gc, x,y,str,ns);
 if(qsaveflag)
  if(postflag)
	{double x1,y1;
	 bildplot(0.,0.,4);
	 koordpix2user(x,y,&x1,&y1);
	 if(winkel==0.)
		fprintf(fpbild," %.2lf %.2lf m (%s) show\n",
			psxkor(x1),psykor(y1),str);
	 else	fprintf(fpbild," gsave %.2lf %.2lf translate 0 0 m %.2lf rotate\
 (%s) show grestore\n",
			psxkor(x1),psykor(y1),winkel,str);
	}
}
static int fonthoehe(char *s)
{
 int c;
 while((c= *s++) && (c!='-' || *s!='-')) ;
 if(*s++ ==0) return 0;
 sscanf(s,"%d",&c);
 return c;
}

#define MAXNAMES 500

int itextsize(int bx,int hy,const char *font,int style)
{
 int count,i,ho,bestho=0,besti=0;
 char **list;
 XCharStruct bonds;
 int fontrichtung,ascent,descent;
 DEBUG(1,printf("itextsize(%d,%d,const char *font,style=%d)\n",bx,hy,style));//test
 tek_text.breite=bx;
 tek_text.hoehe=hy;
 if(font) list=XListFonts(tekplot_dpy,font,MAXNAMES,&count); else count=0;
 if(count==0) list=XListFonts(tekplot_dpy,"*helv*med*--*",MAXNAMES,&count);
 if(debug) for(i=0;i<count;i++) printf("itext-Font:'%s'\n",list[i]);
 if(count==0) {printf("ERROR in itextsize: keine Fonts gefunden\n"); return 0;}
 for(i=0;i<count;i++)
	{if((ho=fonthoehe(list[i]))>=hy) break;
	 if(ho>bestho) {bestho=ho; besti=i;}
	}
 if(i==count) {i=besti; ho=bestho;}
// printf("itextsize Font='%s' ho=%d\n",list[i],ho);//test
 tek_text.fontstruct=XLoadQueryFont(tekplot_dpy,list[i]);
 //tek_text.font=XLoadFont(tekplot_dpy,list[i]);
 //XSetFont(tekplot_dpy,tekplot_gc,tek_text.font);
 XFreeFontNames(list);
 XTextExtents(tek_text.fontstruct,"AbcdefghijKlmnopqRstuvwxyZ",26,
			&fontrichtung,&ascent,&descent,&bonds);
 ho=bonds.ascent;
 XSetFont(tekplot_dpy,tekplot_gc,tek_text.fontstruct->fid);
 if(qsaveflag && postflag)
	{const char *name; int iho,ibr;
	 if(plo_i>1) q2plot(0.,0.,4);
	 switch(style&(BOLD+ITALIC))
	  {case BOLD:  name="Helvetica-Bold";
	   CASE ITALIC:name="Helvetica-Oblique";
	   CASE BOLD+ITALIC: name="Helvetica-BoldOblique";
	   DEFAULT:	name="Helvetica";
	  }
	 ibr=bx*BBYMAX*3/2/tekplot_breite;
	 iho=ho*BBXMAX*3/2/tekplot_hoehe;
	 if(iho==0) iho=int(ibr*1.25);
	 else if(ibr==0) ibr=int(iho/1.25);
	 fprintf(fpbild,"/%s findfont [%d 0 0 %d 0 0] makefont setfont\n",
			name, ibr,iho);
	}
 return ho;
}

void fillpolygon(int n,double *xf,double *yf)
{
 int i,ix,iy;
 XPoint *pu=new XPoint[n];
 PLOT_FLUSH();
 for(i=0;i<n;i++)
	{koorduser2pix(*xf++,*yf++,&ix,&iy); pu[i].x=ix; pu[i].y=iy;}
 XFillPolygon(tekplot_dpy,win1,tekplot_gc,pu,n,Complex,CoordModeOrigin);
 delete[] pu;
}
void ifillpolygon(int n,int *xf,int *yf)
{
 int i,ix,iy;
 XPoint *pu=new XPoint[n];
 PLOT_FLUSH();
 for(i=0;i<n;i++)
	{pu[i].x = *xf++; pu[i].y = *yf++;}
 XFillPolygon(tekplot_dpy,win1,tekplot_gc,pu,n,Complex,CoordModeOrigin);
 delete[] pu;
}

void tek_setdebug(int x) {debug=x; menu_debug=x;}

/************************ Eingabefunktionen ******************************/
static int reqpixprobuchst_x=6,reqpixprobuchst_y=8;
#define PIXPROBUCHST_X reqpixprobuchst_x
#define PIXPROBUCHST_Y reqpixprobuchst_y
static Display *requester_dpy;
#define mydpy requester_dpy

const int MAXP=400; //maximale Laenge eines Pfades
const int MAXD=200; //maximale Laenge eines Dateinamens
#define MAXS 80
//typedef char STRING[MAXS];

class gadgetstring
{
public:
 char s[MAXP],*s0; //MAXP um ganze Pfade zu speichern
                   //MAXS wuerde sonst meistens reichen
 int offset,max;
 gadgetstring() {offset=0; s0=s; max=MAXP;}
 int inc(int);
 void set(char *t);
};
int gadgetstring::inc(int n)
{
 if((offset+=n)<0) offset=0;
 s0= &s[offset];
 return offset;
}
void gadgetstring::set(char *t)
{
 int c;
 offset=0; s0=s;
 for(int i=0;++i<max && (c= *t++)!=0;) *s0++ = c;
 *s0=0;
 s0=s;
}

typedef const char *CONSTAPTR;
typedef const char *CONSTCPTR;

struct TextAttr {
char    *Name;
UWORD   YSize;
BYTE    Style,Flags;
};
struct Gadget2;
struct NewGadget {
WORD    LeftEdge,TopEdge,Width,Height;
//CPTR    GadgetText;
CONSTCPTR GadgetText;//test
struct TextAttr *TextAttr;
UWORD   GadgetID;
ULONG   Flags;	//PLACETEXT_
APTR    VisualInfo,UserData;
Gadget2 *Gadget;
};
#define PIXPROZEILE (PIXPROBUCHST_Y*5/4)
#define PIXYRAND (PIXPROBUCHST_Y/3)
#define PIXXRAND (PIXPROBUCHST_X/4)

/** von Amiga:
struct Gadget {
Gadget *NextGadget;
WORD	LeftEdge,TopEdge,Width,Height,Flags,Activation,GadgetType;
APTR	GadgetRender,SelectRender;
APTR	GadgetText;
LONG	MutualExclude;
APTR	SpecialInfo;
WORD	GadgetID;
APTR	UserData;
};
**/
struct Gadget2 { //provi.
Gadget2 *NextGadget;
WORD	LeftEdge,TopEdge,Width,Height,Flags,GadgetType;
//APTR	GadgetText;
CONSTAPTR	GadgetText;//test
WORD	GadgetID;
char**	texte;
WORD	ntexte,itexte,maxzeil,dy;
//gadgetstring *gast;//um gadgetstr[] zu wegoptimieren
};
class Requester { //provi.
public:
 int typ,nrpath,nrfile;
 NewGadget *nglist;
 Gadget2 *gglist;
 Requester() {typ=0;}
};
static Requester aktiver_requester;

#define PLACETEXT_LEFT	1
#define PLACETEXT_RIGHT 2
#define PLACETEXT_ABOVE 4
#define PLACETEXT_BELOW 8
#define PLACETEXT_IN	16
#define PLACETEXT_NONE	15
#define PLACETEXT_AUSWAHL 17

#define GADTYP_STRING  1
#define GADTYP_IN      2
#define GADTYP_AUSWAHL 17
int get_ngtyp(int ngflags)
{
 switch(ngflags)
   {case PLACETEXT_AUSWAHL: return GADTYP_AUSWAHL;
    case PLACETEXT_IN: return GADTYP_IN;
   }
 return GADTYP_STRING;
}

#define REQTYP_INPUTREQUESTER 1
#define REQTYP_AUSWAHL_MASK 0x11
#define REQTYP_AUSWAHL_NO_FILTER 0x10
#define REQTYP_AUSWAHL_FILTER 0x11
inline bool IS_REQTYP_AUSWAHL(int typ)
{
 return ((typ&REQTYP_AUSWAHL_MASK) >= REQTYP_AUSWAHL_NO_FILTER);
}

static int DELL=0x7F, DELR=0x08;
#define MAXGADS 20
static struct NewGadget newgadgets[MAXGADS+2];
static gadgetstring gadgetstr[MAXGADS];
static int reqhigrund,reqfogrund;

/*** Vordeklarationen (fr Zeichensatz) ***/
static XFontStruct *requ_fontstruct;
void requester_font_anfordern(int test=0);
void zeicheninsert(int c,int einpos,char *str,int max=MAXS);
int xrequester_start(int n,NewGadget *,int gadhoehe,int gadabst,int br,int ho,
		     const char *titel="Input-Requester",
		     int reqtyp=REQTYP_INPUTREQUESTER);
/*** Ende Vordeklarationen ***/

int strlen_zeile(const char *s,int *nz) //ermittelt Laenge der laengsten Zeile
{				        //und Anzahl Zeilen
 int c,i,n;
 for(i=n=0,*nz=1;(c= *s++);i++)
   if(c=='\n')
     {(*nz)++; if(n<i) n=i;
      i= -1;
     }
 if(n<i) n=i;
 return n;
}

void doppelbox(bool flg,int vogrund,int higrund,
	       Display* dpy,Window win,GC gc,int x1,int y1,int br,int ho)
{
 XDrawRectangle(dpy,win,gc,x1,y1,br,ho);
 if(!flg) XSetForeground(mydpy,gc,higrund);
 XDrawRectangle(dpy,win,gc,x1-3,y1-3,br+6,ho+6);
 if(!flg) XSetForeground(mydpy,gc,fogrund);
}

int janeinrequester(const char *text,const char *jatext,const char *neintext)
{
 requester_font_anfordern();
 int hoehe,breite,ho,br,n1,n2,n3,x,y,x1,y1,x2,y2,x3,y3;
 int x2ul,x2or,y2ul,y2or,x3ul,x3or,y3ul,y3or;/* Grenzen der ja/nein-Boxen */
 int x0=200,y0=20,randbreite=5,reqfogrund,reqhigrund;
 int i,done,antwort,nzeilen,hoehe23;
 int vorselect=1;//doppelbox um "ja"
 const char *name="Requester";
 Window win;
 XEvent event;
 KeySym key;
 GC gc;
 char txt[10];
 n1=strlen_zeile(text,&nzeilen);
 if(!jatext) jatext="ok";
 n2=strlen(jatext);
 if(neintext) n3=strlen(neintext); else n3=0;
 br=(n2>n3)?n2:n3;
 i=br+br+6;/* je 2 Buchstaben fuer Rand in Box plus 2 fuer Abstand */
 if(n1>i) i=n1;
 breite=(i+2)*PIXPROBUCHST_X+randbreite+randbreite;
 br=(br+2)*PIXPROBUCHST_X;
 ho=2*PIXPROBUCHST_Y;
 x1=(breite-n1*PIXPROBUCHST_X)/2;
 if(nzeilen>1)  {y1=ho; hoehe=y1+nzeilen*ho*2/3+2*ho;
		 if(hoehe<breite*3/4) hoehe=breite*3/4;
		 hoehe23=hoehe-2*ho;
		}
 else		{hoehe=breite*3/4; hoehe23=hoehe*2/3;
		 y1=hoehe/3;
	        }
 x2ul=breite/4-br/2; x2or=x2ul+br;
 x3ul=breite*3/4-br/2; x3or=x3ul+br;
 y2ul=y3ul=hoehe23-ho/2; y2or=y3or=hoehe23+ho/2;
 if(!neintext) /* bei nur einer Antwort Box in Mitte */
	{x2ul += breite/4; x2or += breite/4;}
 x2=x2ul+PIXPROBUCHST_X; y2=y3=y2or-PIXPROBUCHST_Y/2;
 x3=x3ul+PIXPROBUCHST_X;
 reqhigrund=WhitePixel(mydpy,DefaultScreen(mydpy));
 reqfogrund=BlackPixel(mydpy,DefaultScreen(mydpy));
 win=XCreateSimpleWindow(mydpy,DefaultRootWindow(mydpy),
		x0, y0, breite, hoehe, randbreite, reqfogrund, reqhigrund);
 gc=XCreateGC(mydpy,win,0,NULL);
 XSetBackground(mydpy,gc,reqhigrund);
 XSetForeground(mydpy,gc,reqfogrund);
 XSetFont(mydpy,gc,requ_fontstruct->fid);
 XSelectInput(mydpy,win, ButtonPressMask|KeyPressMask|ExposureMask);
 XChangeProperty(mydpy, win, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar *)name, strlen(name));
 XMapRaised(mydpy,win);
 for(done=0;done==0;)
  {/*XNextEvent(mydpy,&event);
   /*if(event.xexpose.window==win) switch(event.type)*/
   XWindowEvent(mydpy,win,ButtonPressMask|KeyPressMask|ExposureMask,&event);
   switch(event.type)
    {case Expose:
	if(event.xexpose.count==0)
	 {if(nzeilen==1)
	    XDrawImageString(mydpy, win, gc,x1,y1,text,strlen(text));
	  else
	    {const char *s1,*s2; int c,n;  //Mehrzeilige Meldung
	     for(i=0,s1=s2=text;i<nzeilen;i++)
	      {for(n=0;(c= *s2++) && c!='\n';) n++;
	       XDrawImageString(mydpy,win,gc,x1,y1+i*ho*2/3,s1,n); s1=s2;
	      }
	    }
	  XDrawImageString(mydpy, win, gc,x2,y2,jatext,strlen(jatext));
	  doppelbox(vorselect==1,reqfogrund,reqhigrund,
		    mydpy,win,gc,x2ul,y2ul,br,ho);
	  if(neintext)
	    {XDrawImageString(mydpy,win,gc,x3,y3,neintext,strlen(neintext));
	     doppelbox(vorselect==0,reqfogrund,reqhigrund,
		       mydpy,win,gc,x3ul,y3ul,br,ho);
	    }
	 }
     CASE ButtonPress:
	x=event.xbutton.x; y=event.xbutton.y;
	if(x>x2ul && x<x2or && y>y2ul && y<y2or) {antwort=1; done=1;}
	else if(x>x3ul && x<x3or && y>y3ul && y<y3or) {antwort=0; done=1;}
     CASE MappingNotify: XRefreshKeyboardMapping(&event.xmapping);
     CASE KeyPress:
	i=XLookupString(&event.xkey,txt,10,&key,0);
	if(i==1)
	  {if(*txt== *jatext) {antwort=1; done=1;}
	   else if(neintext && *txt== *neintext) {antwort=0; done=1;}
	   else if(*txt=='\r') {antwort=vorselect; done=1;}
	   else if(neintext && *txt=='\t')
	     {vorselect=1-vorselect;
	      doppelbox(vorselect==1,reqfogrund,reqhigrund,
			mydpy,win,gc,x2ul,y2ul,br,ho);
	      doppelbox(vorselect==0,reqfogrund,reqhigrund,
			mydpy,win,gc,x3ul,y3ul,br,ho);
	     }
	  }
    }/* end switch */
  }/* Ende der Eventschlaufe */
 XFreeGC(mydpy,gc);
 XDestroyWindow(mydpy,win);
 XSync(mydpy,0);
 return antwort;
}

int requester_input(int n,...)
{
 requester_font_anfordern();
 int i,h,nzeich,erfolg,xbr;
 int xrand=12,xmax=200-12,ymax=100;
 int dy1=PIXPROBUCHST_Y*3/2,	//Gadgethoehe
     dy2=2*PIXPROBUCHST_Y,	//Gadgetabstand
     dx=PIXPROBUCHST_X;		//Buchstabenbreite
 if((dy1-PIXPROBUCHST_Y)&1)
	dy1++; //gradzahlige Anzahl Pixel mehr als Buchstabenhhe
 int minxbr=5*PIXPROBUCHST_X;
 int x=xrand,y=dy2,dy=dy1+dy2;
// printf("requester_input(%d,...)\n",n);//test
 va_list ap;
 struct NewGadget *ng;
 const char *cstr1,*cstr2[MAXGADS];
 if(n>MAXGADS) n=MAXGADS;
 va_start(ap,n);
 for(ng=newgadgets,i=0;i<n;i++,ng++)
        {ng->LeftEdge=x; ng->TopEdge=y;
         ng->GadgetText=va_arg(ap,char *);
         ng->GadgetID=i; ng->Flags=PLACETEXT_ABOVE;
         cstr1=va_arg(ap,char *);
         cstr2[i]=va_arg(ap,char *);
         ng->UserData=va_arg(ap,APTR);
         if(enthaelt(cstr1,"s"))
                sprintf(gadgetstr[i].s,cstr1,(LONG *)ng->UserData);
	 else if(enthaelt(cstr1,"d"))
		sprintf(gadgetstr[i].s,cstr1,*((LONG *)ng->UserData));
         else	sprintf(gadgetstr[i].s,cstr1,*((double*)ng->UserData));
	 nzeich=strlen(ng->GadgetText);
	 if((h=strlen(gadgetstr[i].s))>nzeich) nzeich=h;
	 gadgetstr[i].max=nzeich;
         xbr=(nzeich+1)*dx; if(xbr<minxbr) xbr=minxbr;
         ng->Width=xbr; ng->Height=dy1;
         if(xmax<x+xbr) xmax=x+xbr;
         if(cstr2[i][strlen(cstr2[i])-1]=='\n')
                {y+=dy; x=xrand;}
         else   {x+=xbr+xrand;}
        }
 y+=dy;
 xbr=9*dx;
 int ok_left=(xmax+xrand-2*xbr)/3,
     cancel_left=2*ok_left+xbr;
 for(;i<n+2;i++,ng++)
        {if(i==n) {ng->LeftEdge=ok_left; ng->GadgetText="   OK";}
         else     {ng->LeftEdge=cancel_left; ng->GadgetText=" CANCEL";}
         ng->TopEdge=y; ng->Width=xbr; ng->Height=dy1;
         ng->GadgetID=i; ng->Flags=PLACETEXT_IN;
         ng->UserData=NULL;
        }
 y+=dy; xmax+=xrand;
 va_end(ap);
 if(y>ymax) ymax=y;
 erfolg=xrequester_start(n+2,newgadgets,dy1,dy2,xmax,ymax);
 if(erfolg) for(ng=newgadgets,i=0;i<n;i++,ng++)
		{if(strncmp(cstr2[i],"%s",2)==0)
			strcpy(ng->UserData,gadgetstr[i].s);
		 else	sscanf(gadgetstr[i].s,cstr2[i],ng->UserData);
		}
 return erfolg;
}

bool schlechte_tastatur(KeySym key) //provi.
{
 // Schlechten Tastaturen (PC-Tastatur am Spex) liefern andre Codes als gute.
 // schlechte Tastatur :  DELL: key=0xFF08  DELR: key=0xFFFF
 // gute Tastatur (MAC):  DELL: key=0xFFFF  DELR: key=0xFF60
 static int gut=1;
 if(key==0xFF08) gut=0;
 return gut==0;
}

void zeicheninsert(int c,int einpos,char *str,int max)
{
 char *s,*t;
 int c2;
// printf("zeicheninsert(c=%02X,einpos=%d...)\n",c,einpos);//test
 if(c==DELL || c==DELR) /* Zeichen lschen */
	{if(c==DELL) einpos--;
	 if(einpos>=0 && str[einpos]!=0)
		for(s= &str[einpos],t= &str[einpos+1];*s++ = *t++;) ;
	}
 else /* Zeichen einfgen */
 	{for(s= &str[einpos];c!=0 && einpos<max;einpos++)
		{c2= *s; *s++ = c; c=c2;}
	 *s=0;
	}
}

/*************************** Zeichensatz **********************************/
static char *requ_fontliste[]=
        {"-adobe-helvetica-medium-r-normal--20-140-100-100-M-100-iso8859-1",
	 "-Adobe-Courier-Medium-R-Normal--14-140-75-75-M-90-ISO8859-1",
         NULL
        };

char *newstring(char *s)
{
 char* s2=new char[strlen(s)+1];
 strcpy(s2,s);
 return s2;
}

void requester_font_anfordern(int test)
{
 if(requester_font_flag) return;//schon angefordert
 requester_font_flag=1;
 int count=0,i;
 char **list,**zs,*s;
 static char defaultfontname[20]="*Cour*14*-M-*";
 XCharStruct bonds;
 int fontrichtung,ascent,descent;
 if(tekplot_dpy) requester_dpy=tekplot_dpy;
 else	requester_dpy = meinXOpenDisplay("");
 if(!mydpy) printf("ERROR: kann Display nicht oeffnen!\n");
 if(test)
  {if(test>2)
	{sprintf(defaultfontname,"*Cour*%d*-M-*",test);
	 requ_fontliste[0]=defaultfontname;
	}
   else
	{int maxnames=50; char name[120];
	 printf("suche nach Fontnamen:"); scanf("%s",name);
	 list=XListFonts(mydpy,name,maxnames,&count);
	 for(i=0;i<count;i++) printf("Font %d:'%s'\n",i,list[i]);
	 printf("Fontauswahl:"); scanf("%d",&i);
	 if(i>=0 && i<count) requ_fontliste[0]=newstring(list[i]);
	 XFreeFontNames(list);
  }	}
 for(count=0,zs=requ_fontliste; count==0 && (s= *zs); zs++)
        list=XListFonts(mydpy,s,1,&count);
 if(count==0)
  {/* nach einem Courier Font der Hoehe 14 suchen */
   for(s=defaultfontname;count==0;)
     {list=XListFonts(mydpy,s,1,&count);
      if(count==0)
        {s[i=strlen(s)]=0; s[i-1]='*';} /* verkuerzen bis Font auffindbar */
  }  }
 if(test) printf("XLoadQueryFont(mydpy,'%s')\n",list[0]);//test
 requ_fontstruct=XLoadQueryFont(mydpy,list[0]);
 XFreeFontNames(list);
 XTextExtents(requ_fontstruct,"AbcdefghijKlmnopqRstuvwxyZ",26,
                        &fontrichtung,&ascent,&descent,&bonds);
 PIXPROBUCHST_X=bonds.width/26;
 PIXPROBUCHST_Y=bonds.ascent + bonds.descent;
// zeilenabstand=PIXPROBUCHST_Y*3/2;
 if(test) printf("PIXPROBUCHST_X=%d PIXPROBUCHST_Y=%d\n",
                PIXPROBUCHST_X,PIXPROBUCHST_Y);//test
}

/**
int altes_nachfilenamefragen(char *str,char *name,int max)
{	// provisorisch
 char *buf,*s;
 int i,n1=strlen(str),n2;
 if((n2=n1+4)<40) n2=40;
 buf=new char[n2+1];
 for(s=buf,i=n2-n1;i>0;i-=2) *s++ = ' ';
 while(*s++ = *str++) ;
 i=requester_input(1,buf,"%s","%s",name);
 delete buf;
 return i;
}
**/

int keyget(int *n,int *asci,ULONG *rawcode) /* Tastaturabfrage */
{
 if(!keyget_flag) return 0;
 *n=keyget_i; *asci= *keyget_txt; *rawcode=keyget_key;
 keyget_flag=0;
 *asci &= 0xFF;
 return 1;
}

/****************** Ersatz fehlender Systemfunktionen *******************/
void Setenv(const char *name,const char *inhalt)
{
 FILE *fp;
 int c;
 if(name==NULL) return;
#ifdef unix
 char str[200];
 char *envname=getenv("ENV");
 if(envname==NULL)
   {printf("kann $ENV nicht finden (in .profile setzen!)\n"); return;}
 sprintf(str,"%s/%s",envname,name);
#else
 char str[80];
 sprintf(str,"ENV:%s",name);
#endif
 if(!(fp=fopen(str,"w"))) {printf("kann '%s' nicht erstellen\n",str); return;}
 if(inhalt!=NULL)
  while(c= *inhalt++) putc(c,fp);
 putc('\n',fp);
 fclose(fp);
#ifndef unix
 sprintf(str,"PUR ENV:%s",name);
 system(str);
#endif
}
char *Getenv(const char *name)
{
#ifdef unix
 const int max=200;
#else
 const int max=80;
#endif
 static char str[max];
 char *s;
 FILE *fp;
 int c,i;
#ifdef unix
 char *envname=getenv("ENV");
 if(envname==NULL) return getenv(name);
 sprintf(str,"%s/%s",envname,name);
#else
 sprintf(str,"ENV:%s",name);
#endif
 if(!(fp=fopen(str,"r"))) return getenv(name);
 for(s=str,i=max;--i>0 && (c=getc(fp))!=EOF;) *s++ = c;
 *s=0;
 if(s>str && *--s == '\n') *s=0; //letztes Zeichen eventuell loeschen
 fclose(fp);
 return str;
}

#define NEEDS_FLUSHS 1
#include "tekplot1xtras.cc"

#ifdef SHOWIT
#define plot q2plot
#endif

/******************************** Titel *********************************/
#ifndef VECTMAL
void set_tektitel(const char *s)
{
#ifdef MITUMLAUTEN
 utf8_to_isolatin1(fenstername,s,MAXFE);
#else
 strncpy(fenstername,s,MAXFE); fenstername[MAXFE-1]=0;
#endif
 //printf("fenstername='%s' s='%s'\n",fenstername,s);//test
 XChangeProperty(dpy, win1, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (uchar*)fenstername, strlen(fenstername));
}
#endif

/************************** Filerequester *******************************/
/** Vordeklarationen: **/
char *getfileliste(const char *pfad,const char *filter,int maxz=40);
static char *sortieren(char *liste);

/************************* neuer Kleinkram *******************************/
inline bool istinnerhalb(int x,int x1,int x2)
{
 return (x2>x1)?(x>=x1 && x<=x2):(x>=x2 && x<=x1);
}
inline bool istinnerhalb(int x,int y,int x1,int y1,int x2,int y2)
{
 return istinnerhalb(x,x1,x2) && istinnerhalb(y,y1,y2);
}

void stradd(const char *s,const char *t,char *z)	/*  s + t --> z */
{
 char c;
 while(c = *s++) *z++ = c;
 while(*z++ = *t++)	;
}

void strjoin(const char *s1,int c2,const char *s3,char *ziel,int max)
{
 char c0=0,c;
 while(--max>0 && (c = *s1++)) *ziel++ = c0 = c;
 if(c0!=c2 && --max>0) *ziel++ = c2;
 while(--max>0 && (*ziel++ = *s3++))  ;
 if(max<=0) *ziel=0;
}

int strncmpgross(const char *s,const char *g,int n)
{
 int c,cg;
 while(*s==' ') s++;
 while(--n>=0 && (cg= *g++) && (c= *s++))
   {if((c=toupper(c))!=cg) return c-cg;
   }
 return 0;
}

int anzahlzeilen(const char *s)
{
 int i,c;
 if(s==NULL || *s==0) return 0;
 for(i=1;c= *s++;)
   if(c=='\n') i++;
 --s; if(*--s=='\n') --i;
 return i;
}

/** um es wirklich portabel zu machen: **/
#define index gutes_index
static
/**/

int index(const char *s1,const char *s2) /* Sucht den String s2 innerhalb von s1 und  */
{			 /* gibt die Position zurueck (nicht gefunden = -1)*/
 int i,c;
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

int index2(const char *s1,const char *s2) /* wie index(), sucht aber nur bis '\n' in s1 */
{
 int i,c;
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0 || c=='\n') return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

/* veraltet:
void strcpybis(char *ziel,const char *von,int cstop,int max)
{
 char *t=ziel; int c;
 while((c= *von++) && c!=cstop && --max>0) *t++ = c;
 *t=0;
}
*/

void strcpybisx(char *ziel,const char *von,int max)
{
 char *t=ziel; int c,j=0;
 while((c= *von++) && --max>0) {*t++ = c; j++;}
 --t;
 while(j>0 && isdigit(*t)) {--t; --j;} //hintere Zahl weglassen
 while(j>0 && *t==' ') {--t; --j;} //hinterste Leerstellen weglassen
 if(j>5 && strncmp(t-4,"(dir)",5)==0) {t-=5; j-=5;} //(dir) weglassen
 else if(j>5 && strncmp(t-4,"(lnk)",5)==0) {t-=5; j-=5;} //(lnk) weglassen
 while(j>0 && *t==' ') {--t; --j;} //hinterste Leerstellen weglassen
 t++;
 *t=0;
}

inline bool ISTPUNKTPUNKT(const char *s)
{
 return (*s=='.' && s[1]=='.' && s[2]==0); //schneller als strcmp(s,"..")==0
}

int maxwert(int a,int b) {return (a>b) ? a : b;}

int minwert(int a,int b) {return (a<b) ? a : b;}

int minmax(int x,int ug,int og)
{
 if(x<ug) return ug;
 if(x>og) return og;
 return x;
}

char *strf(char *cstr,long p1)
{
 char *str=new char[80];
 sprintf(str,cstr,p1);
 return str;
}

/************************ Vordeklarationen: *****************************/
void ngxdrawauswahlbox(Window win,GC gc,NewGadget *ng);
int ngnextmark(Window win,GC gc2,NewGadget *ng,int inc);
int ngnextdir(Window win,GC gc2,NewGadget *ng,int eingabepos,int undo=0);
int ngnewdir(Window win,GC gc2,NewGadget *ng,int j,char c1=0);
void ngnewpath(NewGadget *ng);
int neuerdateitext(Window win,GC gc2,int gadhoehe,
		   NewGadget *ng,int eingabepos,int n,int x= -1,int y= -1);
void fileliste_aktualisieren(Gadget2 *gg,char *pfad);
/*** Ende Vordeklarationen ***/

void ngxdrawstr(Window win,GC gc,NewGadget *ng,const char *text,int dy,
		int flag,int fokusflg=0)
{
 char *txt,*s;
 int c,max;
 txt=new char[max=strlen(text)+3];
 for(s=txt;c= *text++;)
	*s++ = (c==0x09)?' ':c; //Tabulator als Leerzeichen darstellen
 if(flag!=2) {*s++ =' '; *s++ =' ';}
 *s=0;
#ifdef MITUMLAUTEN
 utf8_to_isolatin1(txt,txt,max);
#endif
 c=strlen(txt);
 if(c>(max=gadgetstr[ng->GadgetID].max+1)) c=max;
 XSetForeground(mydpy,gc,reqhigrund);
 XFillRectangle(mydpy,win,gc,ng->LeftEdge+1,ng->TopEdge+1,
		ng->Width-1,ng->Height-1);
 XSetForeground(mydpy,gc,reqfogrund);
 //printf("Testpunkt in ngxdrawstr() txt='%s'\n",txt);//test
 if(flag==2) //PLACETEXT_LEFT
  {int x=ng->LeftEdge-PIXPROBUCHST_X*c;
   if(x<0) x=0;
   XDrawImageString(mydpy,win,gc,x,
//		  ng->TopEdge+PIXPROBUCHST_Y*4/3+dy,txt,c);
		  ng->TopEdge+PIXPROZEILE+dy,txt,c);
  }
 else
  {XDrawImageString(mydpy,win,gc,ng->LeftEdge+PIXPROBUCHST_X/2,
//		  ng->TopEdge+PIXPROBUCHST_Y*4/3+dy,txt,c);
		  ng->TopEdge+PIXPROZEILE+dy,txt,c);
   if(flag || fokusflg)
//  XDrawRectangle(mydpy,win,gc,ng->LeftEdge,ng->TopEdge,ng->Width,ng->Height);
    doppelbox(fokusflg,reqfogrund,reqhigrund,
	      mydpy,win,gc,ng->LeftEdge,ng->TopEdge,ng->Width,ng->Height);
  }
 delete[] txt;
}

#define NEEDS_MAUSBEWEGUNG (-5)

class Schiebebalken {
 Gadget2 *gg;
 int maxy,maxy2,hoehe,y0,yoffset;
 double proz,dy;
public:
 int rr,a4,a5;
 Schiebebalken() {proz=1.00; maxy=hoehe=1; maxy2=0; rr=0;
		  a4=a5=0; dy=0.0; yoffset=0;}
 int ineu(int dy);
 void reset() {rr=0;}
 void calc(Gadget2* g,int *phoehe,int *py0);
};
static Schiebebalken schiebebalken;

void Schiebebalken::calc(Gadget2* g,int *phoehe,int *py0)
{
 gg=g;
 int i=gg->ntexte, minimale_hoehe=gg->dy/2;
 maxy=gg->Height-2*gg->dy; maxy2=maxy/2;
 dy=maxy/(double)i;
 if(gg->maxzeil >= i) proz=1.00; //1.00=100%
 else proz=gg->maxzeil/(double)i;
 if((hoehe=idfix(maxy*proz)) < minimale_hoehe) hoehe=minimale_hoehe;
 *phoehe=hoehe;
 *py0=int(gg->itexte*dy+0.5);
 a5=gg->TopEdge+(*py0);
 a4=a5+hoehe;
}
int Schiebebalken::ineu(int y) //berechne neue Schiebeposition
{
 if(rr==0) {y0=y; yoffset=y-int(gg->itexte*dy+0.5); rr=NEEDS_MAUSBEWEGUNG;
	    return gg->itexte;
	   }
 int imax=gg->ntexte-gg->maxzeil;
 int ineu = (y>=y0) ? gg->itexte + (gg->ntexte*(y-y0)+maxy2)/maxy
 		    : gg->itexte - (gg->ntexte*(y0-y)+maxy2)/maxy;
 if(ineu>imax) ineu=imax;
 if(ineu<0) ineu=0;
 y0=yoffset+int(ineu*dy+0.5);
 return ineu;
}

int eingabekursor(Window win,GC gc,NewGadget *ng,
		  int x= -1,int y= -1,int einpos= -1)
{
 static int x0=0,y0=0, xdopp=0,ydopp=0;
 int x1,max,max1,max2,j=ng->GadgetID;
 int maxy,dy,ytop=ng->TopEdge,doppelklick=0;
 const int dy2=PIXYRAND;
 int width=(ng->Flags==PLACETEXT_AUSWAHL)?ng->Gadget->Width:ng->Width;
 max1=ng->LeftEdge+PIXPROBUCHST_X/2+strlen(gadgetstr[j].s0)*PIXPROBUCHST_X;
 max2=ng->LeftEdge+width-PIXPROBUCHST_X/2-1;
 max=(max1<max2)?max1:max2;
 if(ng->Flags==PLACETEXT_AUSWAHL)
   {Gadget2* gg=ng->Gadget;
    dy=gg->dy;
    maxy = minmax(gg->ntexte - gg->itexte - 1, 1, gg->maxzeil-1);
    maxy = maxy*dy + dy2 + ytop;
    if(y>0)
      {if(x >= max2) xdopp=ydopp=0;
       if(x >= gg->LeftEdge+gg->Width)
	 {int a1=gg->TopEdge+gg->Height, a2=a1-dy, a3=a2-dy;
	  int a4=schiebebalken.a4, a5=schiebebalken.a5;
	  int imax=maxwert(gg->ntexte-gg->maxzeil,0);
	  if(schiebebalken.rr || istinnerhalb(y,a4,a5)) //auf Schieber geklickt
		gg->itexte=schiebebalken.ineu(y);
	  else if(istinnerhalb(y,a3,a4)) //unterhalb des Schiebers geklickt
		gg->itexte=minwert(gg->itexte+gg->maxzeil,imax);
	  else if(istinnerhalb(y,a5,ytop)) //oberhalb des Schiebers
		gg->itexte=maxwert(gg->itexte-gg->maxzeil,0);
	  else if(istinnerhalb(y,a2,a3)) //rauf-Box angeklickt
	       {if(gg->itexte > 0) gg->itexte--;}
	  else //if(istinnerhalb(y,a1,a2)) //runter-Box angeklickt
	       {if(gg->itexte < imax) gg->itexte++;}
	  y0=minmax(y0,ytop+dy2,maxy);
	 }
       else
	 {doppelklick=(xdopp>0 && ydopp>0 &&
		       istinnerhalb(x,y,xdopp-2,ydopp-2,xdopp+2,ydopp+2));
	  xdopp=x; ydopp=y;
	  y0=minwert(y-(y-ytop-dy2)%dy, maxy);
	 }
      }
    else if(einpos>=0)
      y0=minwert(ytop+dy2+einpos*dy, maxy);
   }
 else
   {if(x>0)
     x0=x1=minwert(x-(x-ng->LeftEdge-PIXPROBUCHST_X/2)%PIXPROBUCHST_X-1, max);
    else if(einpos>=0)
	{int newoffset=0;
	 einpos -= gadgetstr[j].offset;
	 while(einpos<0) {gadgetstr[j].inc(-1); einpos++; newoffset=1;}
	 x1=ng->LeftEdge + PIXPROBUCHST_X/2 - 1 + einpos*PIXPROBUCHST_X;
	 if(x1>max)
		{if(max1>max2) {gadgetstr[j].inc(1); newoffset=1;}
		 x1=max;
		}
	 if(newoffset) ngxdrawstr(win,gc,ng,gadgetstr[j].s0,0,1);
	 x0=x1;
	}
    else x1=x0;
   }
#ifdef VAX_OR_ALPHA
// XSetFunction(mydpy,gc,GXinvert);//geht auf der ALPHA nicht richtig!
 XSetBackground(mydpy,gc,reqfogrund);
 XSetForeground(mydpy,gc,reqhigrund);
 XSetFunction(mydpy,gc,GXxor);//geht auf ALPHA und auf VAX
#else
 if(reqhigrund!=0)
   {XSetBackground(mydpy,gc,reqfogrund);
    XSetForeground(mydpy,gc,reqhigrund);
   }
 XSetFunction(mydpy,gc,GXxor);
#endif
 if(ng->Flags==PLACETEXT_AUSWAHL)
  {XFillRectangle(mydpy,win,gc,ng->LeftEdge+1,y0,width-2,dy);
   einpos=(y0+1-ytop-dy2)/dy;
   if(einpos<0) einpos= -1;//provi
  }
 else
  {XFillRectangle(mydpy,win,gc,x1,ytop+1,PIXPROBUCHST_X+1,ng->Height-1);
   einpos=(x1+1-ng->LeftEdge-PIXPROBUCHST_X/2)/PIXPROBUCHST_X
		+ gadgetstr[j].offset;
  }
 XSetFunction(mydpy,gc,GXcopy);
 XSetBackground(mydpy,gc,reqhigrund);
 XSetForeground(mydpy,gc,reqfogrund);
 if(doppelklick) {ngnextdir(win,gc,ng,einpos); xdopp=ydopp=0;}
 return einpos;
}
void eingabekursor_off(int *fokus)
{
 gadgetstr[*fokus].inc(-MAXS);
 *fokus = -1;
}
void gadgets_anschreiben(Window win,GC gc2,int n,int gadhoehe,int n0=0,
			 int fokus= -1)
{
 int i;
 NewGadget *ng;
 for(ng=newgadgets,i=n0;i<n;i++,ng++) //jedes Gadget anschreiben
   switch(ng->Flags)
	{case PLACETEXT_NONE:
		ngxdrawstr(win,gc2,ng,gadgetstr[i].s0,0,1);
	 CASE PLACETEXT_LEFT:
		ngxdrawstr(win,gc2,ng,ng->GadgetText,0,2);
		ngxdrawstr(win,gc2,ng,gadgetstr[i].s0,0,1);
	 CASE PLACETEXT_ABOVE:
		ngxdrawstr(win,gc2,ng,ng->GadgetText,-gadhoehe-1,0);
		ngxdrawstr(win,gc2,ng,gadgetstr[i].s0,0,1);
	 CASE PLACETEXT_AUSWAHL:
		ngxdrawauswahlbox(win,gc2,ng);
	 CASE PLACETEXT_IN: default:
		//printf("i=%d fokus=%d\n",i,fokus);//test
		ngxdrawstr(win,gc2,ng,ng->GadgetText,0,1,fokus==i);
	 }
}

int xrequester_start(int nn,NewGadget *newgadgets,int gadhoehe,int gadabst,
		     int breite,int hoehe,const char *titel,int reqtyp)
{
 int x0=100,y0=20,randbreite=5,done,erfolg=0,fokus= -1;
 int i,x,y,eingabepos;
 int neuerfokus= -2,shift=0;
 int xklick,yklick;
 Window win;
 XEvent event;
 KeySym key;
 GC gc2;
 uchar txt[10];
 NewGadget *ng,*ngklick;
 const char *name=titel;
 reqhigrund=WhitePixel(mydpy,DefaultScreen(mydpy));
 reqfogrund=BlackPixel(mydpy,DefaultScreen(mydpy));
 win=XCreateSimpleWindow(mydpy,DefaultRootWindow(mydpy),
		x0, y0, breite, hoehe, randbreite, reqfogrund, reqhigrund);
 gc2=XCreateGC(mydpy,win,0,NULL);
 XSetBackground(mydpy,gc2,reqhigrund);
 XSetForeground(mydpy,gc2,reqfogrund);
 XSetFont(mydpy,gc2,requ_fontstruct->fid);
 XSelectInput(mydpy,win, ButtonPressMask|ButtonReleaseMask|PointerMotionMask|
	      KeyPressMask|KeyReleaseMask|ExposureMask|ResizeRedirectMask);
 XChangeProperty(mydpy, win, XA_WM_NAME, XA_STRING, 8,
		 PropModeReplace, (UBYTE*)name, strlen((char *)name));
 XMapRaised(mydpy,win);
 for(done=0;done==0;)
  {XNextEvent(mydpy,&event);
   if(event.xexpose.window==win) switch(event.type)
    {case Expose:
	if(event.xexpose.count==0)
	  {gadgets_anschreiben(win,gc2,nn,gadhoehe);
	   if(fokus>=0) eingabekursor(win,gc2,&newgadgets[fokus]);
	  }
     CASE ResizeRequest:
       if(debug) printf("ResizeRequest: Fenstergroesse geaendert\n");//test
    // Hier sollte man noch bei Aenderung der Fenstergroesse einige
    // Einstellungen in der Gadget-Struktur aktualisieren.
     CASE PropertyNotify:
        printf("PropertyNotify: Fenstergroesse geaendert ?\n");//test
     CASE MappingNotify: // Abbildungsnderung der Tastatur verarbeiten
	XRefreshKeyboardMapping(&event.xmapping);
     CASE KeyPress: // Tastatureingabe verarbeiten
	i=XLookupString(&event.xkey,(char*)txt,10,&key,0);
	if(fokus>=0)
	 {ng= &newgadgets[fokus];
	  int ngtyp=get_ngtyp(ng->Flags);
	  if(ngtyp!=GADTYP_IN) eingabekursor(win,gc2,ng);//alter Kursor lschen
	  if(schlechte_tastatur(key)) {DELL=0x08; DELR=0x7F;}
	  if(key==0xFF60) {i=1; *txt=DELR;}
	  if(i==1) //gewoehnliche Taste gedrueckt
	   {if(*txt<' ' && *txt!=DELL && *txt!=DELR) //Spezialzeichen abfangen
		{if(*txt==0x09) //Tabulator soll nur den Fokus verschieben
		   {neuerfokus=(shift==0)?fokus+1:fokus-1;}
		 else if(ngtyp==GADTYP_AUSWAHL)
		   {if(*txt==0x0D //Return-Taste
		       && ngnextdir(win,gc2,ng,eingabepos)==0)
			{eingabekursor_off(&fokus);
			 gadgets_anschreiben(win,gc2,nn,gadhoehe);
			}
		   }
		 else if(ngtyp==GADTYP_IN)
		   {if(*txt==0x0D) //Return-Taste
		     {i=fokus; //wie "Klick aufs Gadget i"
		      eingabekursor_off(&fokus);
		      if(i>=nn-2) {erfolg=(i==nn-2); done=1;}
		      else if(IS_REQTYP_AUSWAHL(reqtyp) && i>=nn-4)
			{if(ngnewdir(win,gc2,newgadgets,i))
			  gadgets_anschreiben(win,gc2,nn,gadhoehe);
			}
		     }
		   }
		 else //if(ngtyp==GADTYP_STRING)
		   {eingabekursor_off(&fokus);
		    if(IS_REQTYP_AUSWAHL(reqtyp))
			{ngnewpath(newgadgets);
			 gadgets_anschreiben(win,gc2,nn,gadhoehe);
			}
		   }
		}
	    else if(ngtyp==GADTYP_STRING)
		{zeicheninsert(*txt,eingabepos,gadgetstr[fokus].s);
		 if(*txt==DELR) ;//Zeichen unter Kursor gelscht
		 else if(*txt==DELL) //Zeichen vor Kursor gelscht
			{if(eingabepos>0) eingabepos--;}
		 else  eingabepos++;
		}
	    if(fokus>=0) gadgets_anschreiben(win,gc2,nn,gadhoehe);
	   }
	  else //spezielle Taste gedrueckt
	   {int flg=(ngtyp==GADTYP_AUSWAHL);
	    switch(key&0xFF)
		{case 0x51:if(!flg)  //Kursor nach links
				{if(eingabepos>0) eingabepos--;}
			   else {if(ngnewdir(win,gc2,ng,0,'P'))
				   gadgets_anschreiben(win,gc2,nn,gadhoehe);
				}
		 CASE 0x53:if(!flg) eingabepos++;  //Kursor nach rechts
			   else {if(ngnextdir(win,gc2,ng,eingabepos))
				   gadgets_anschreiben(win,gc2,nn,gadhoehe);
				}
		 CASE 0x52:if(flg)  //Pfeil rauf
				{if(eingabepos>0) eingabepos--;
				 else ngnextmark(win,gc2,ng,-1);
				}
		 CASE 0x54:if(flg)  //Pfeil runter
				{if(eingabepos == ng->Gadget->maxzeil-1)
				   ngnextmark(win,gc2,ng,1);
				 else eingabepos++;
				}
		 CASE 0xE1: case 0xE2: shift=1;
		//keine Reaktion auf folgende Tasten:
		 CASE 0xE5: case 0xE3://CapsLock, ctrl
		DEFAULT: printf("unbekannter TastenCode key=0x%02X\n",(int)key);
		}
	   }
	  if(fokus>=0)
	   {
	    if(ngtyp==GADTYP_AUSWAHL && eingabepos>=0)
	      neuerdateitext(win,gc2,gadhoehe,ng,eingabepos,nn);
	    else if(ngtyp!=GADTYP_IN)
	      eingabepos=eingabekursor(win,gc2,ng,-1,-1,eingabepos);
	   }
	 }
	else //fokus== -1  also Tastendruck wenn noch nichts selektiert
	 {if(key==TABTASTE) neuerfokus=(shift==1)?nn-1:0;
	  else if(key==SHIFTTASTE) shift=1;
	  //keine Reaktion auf alle andern Tasten
	 }
	if(neuerfokus != -2)
	 {if(neuerfokus<0) neuerfokus+=nn;
	  else if(neuerfokus>=nn) neuerfokus-=nn;
	  fokus=neuerfokus;
	  neuerfokus= -2;
	  ng= &newgadgets[fokus];
	  eingabepos=eingabekursor(win,gc2,ng,-1,-1,0);
	  gadgets_anschreiben(win,gc2,nn,gadhoehe,0,fokus);
	  if(ng->Flags==PLACETEXT_AUSWAHL)
	       neuerdateitext(win,gc2,gadhoehe,ng,eingabepos,nn);
	  else if(ng->Flags==PLACETEXT_IN)
	    ;
	  else eingabekursor(win,gc2,ng);
	 }
     CASE KeyRelease: //Taste losgelassen
	i=XLookupString(&event.xkey,(char*)txt,10,&key,0);
	if(key==SHIFTTASTE) shift=0;
     CASE ButtonPress: //Mausknopf gedrckt
	x=event.xbutton.x; y=event.xbutton.y;
	if(fokus>=0)	{eingabekursor(win,gc2,&newgadgets[fokus]);
			 eingabekursor_off(&fokus);
			 gadgets_anschreiben(win,gc2,nn,gadhoehe);
			}
	for(ng=newgadgets,i=0;i<nn;i++,ng++)
		if(x>ng->LeftEdge && x<ng->LeftEdge+ng->Width
		   && y>ng->TopEdge && y<ng->TopEdge+ng->Height) break;
	if(i<nn) //Klick aufs Gadget i erkannt
	  {if(i>=nn-2) {erfolg=(i==nn-2); done=1;}
	   else if(IS_REQTYP_AUSWAHL(reqtyp) && i>=nn-4)
		 {if(ngnewdir(win,gc2,newgadgets,i))
			gadgets_anschreiben(win,gc2,nn,gadhoehe);
		 }
	   else eingabepos=eingabekursor(win,gc2,&newgadgets[fokus=i],x,y);
	   if(schiebebalken.rr==NEEDS_MAUSBEWEGUNG)
	     {xklick=x; yklick=y; ngklick= &newgadgets[fokus];}
	  }
	if(fokus>=0 && newgadgets[fokus].Flags==PLACETEXT_AUSWAHL
	   && eingabepos>=0)
	  neuerdateitext(win,gc2,gadhoehe,&newgadgets[fokus],eingabepos,nn);
     CASE ButtonRelease: //Mausknopf losgelassen
	schiebebalken.reset();
	if(fokus>=0 && newgadgets[fokus].Flags==PLACETEXT_AUSWAHL
	   && eingabepos>=0)
	  neuerdateitext(win,gc2,gadhoehe,&newgadgets[fokus],eingabepos,nn);
     CASE MotionNotify:
       //while(XCheckIfEvent(mydpy,&event,(prediczeiger)predicate,(char *)win))
       //			; // aktuellste Position ermitteln
        if(schiebebalken.rr==NEEDS_MAUSBEWEGUNG)
	   eingabepos=neuerdateitext(win,gc2,gadhoehe,ngklick,eingabepos,nn,
				     xklick, event.xbutton.y);
     DEFAULT:
	printf("unknown event.type=0x%X\n",event.type);//test
    }// end switch
  }// Ende der Hauptschlaufe
 XFreeGC(mydpy,gc2);
 XDestroyWindow(mydpy,win);
 XSync(mydpy,0);
 return erfolg;
} // Ende xrequester_start()

static Gadget2 *tek_gadgetliste=NULL;

void fileliste_ins_gadget_kopieren(const char *liste,Gadget2 *gg)
{
 int i,n;
 char *s, *str;
 if((n=strlen(liste)+1) < 8) n=8; //genug Platz fuer ".." reservieren
 str=new char[n];
 if((n=anzahlzeilen(liste)) < 1)
   {n=1; *str=str[1]='.'; str[2]=0;} //schneller als strcpy(str,"..")
 else strcpy(str,liste);
 if(gg->ntexte > 1) {delete[] gg->texte[0]; delete[] gg->texte;}
 gg->texte=new char*[n];
 for(s=str,i=0;i<n;i++)
   {gg->texte[i]=s;
    while(*s && *s!='\n') s++;
    *s++ = 0;
   }
 gg->ntexte=n; gg->itexte=0;
 //for(i=0;i<n;i++) printf("gg->texte[%d]='%s'\n",i,gg->texte[i]);//test
}

void machgadget(NewGadget *ng,int maxzeilen)
{
// erzeuge und vervollstaendige Gadget-Struktur
 Gadget2 *gg;
 ng->Gadget=gg=new Gadget2[1];
 gg->NextGadget=tek_gadgetliste;//als erstes in bisherige Kette einfuegen
 tek_gadgetliste=gg;
 gg->LeftEdge=ng->LeftEdge;
 gg->TopEdge=ng->TopEdge;
 gg->Width=ng->Width;
 gg->Height=ng->Height;
 gg->Flags=0;//provi.
 gg->GadgetType=(ng->Flags & 0xFFFF);//provi.
 gg->GadgetText=ng->GadgetText;
 gg->GadgetID=ng->GadgetID;
 gg->ntexte=gg->itexte=0;//Zaehler fuer aktuelles texte[i]
 if(gg->GadgetType==GADTYP_AUSWAHL)
   {fileliste_ins_gadget_kopieren(ng->GadgetText,gg);
    ng->Width += PIXPROBUCHST_X*3/2;//etwas breiter fuer Schieber
   }
 else
   {gg->texte=new char*[1];
    gg->texte[0]=ng->UserData;
    gg->ntexte=1;
   }
 gg->maxzeil=maxzeilen;
 gg->dy=PIXPROZEILE;
}

int ngnextmark(Window win,GC gc2,NewGadget *ng,int inc)
{
 int i=ng->Gadget->itexte+inc, delta;
 if(i<0) i=0;
 else if(i > ng->Gadget->ntexte - ng->Gadget->maxzeil)
	 i = ng->Gadget->ntexte - ng->Gadget->maxzeil;
 delta = i - ng->Gadget->itexte;
 if(delta!=0)
   {ng->Gadget->itexte=i;
    ngxdrawauswahlbox(win,gc2,ng);
   }
 return delta;
}
int ngnextdir(Window win,GC gc2,NewGadget *ng,int eingabepos,int undo)
{
// Wenn ein Directory markiert ist dann in dieses wechseln.
 static char olddirname[MAXP]; static int olddirflag=0;
 char dirname[MAXP],str[MAXP];
 const char *s,*z;
 Gadget2 *gg=ng->Gadget;
 int i=gg->itexte+eingabepos,j,diskflag=0;
 if(undo)
  {if(olddirflag==0) return 0;//kein undo-Pfad eingetragen
   strcpy(dirname,olddirname); olddirflag=0;
   z="\000";
  }
 else
  {if(eingabepos<0 || i>=gg->ntexte) return 0;//kein gueltiger Eintrag markiert
   s=gg->texte[i];
   if(ISTPUNKTPUNKT(s)) {return ngnewdir(win,gc2,ng,0,'P');}
   diskflag=(index(s,"(disk)") >= 0);
   if(index(s," (dir) ") < 0 && index(s," (lnk) ") < 0 && !diskflag)
		return 0;//Eintrag ist kein Directory und keine Disk
   //strcpybis(dirname,gg->texte[i],' ',MAXP);
   strcpybisx(dirname,gg->texte[i],MAXP);
   z=gadgetstr[aktiver_requester.nrpath].s;
   strcpy(olddirname,z); olddirflag=1;
  }
 if(diskflag)
   {if((s=getenv(dirname))==NULL || *s==0)
      {if(strcmp(dirname,"ROOT")==0) s="/";
       else if(strcmp(dirname,"CDROM")==0) s="/cdrom";
       else s=dirname;
      }
    strcpy(str,s);
   }
 else if(*z==0) strcpy(str,dirname);
 else strjoin(z,'/',dirname,str,MAXP);
 gadgetstr[aktiver_requester.nrpath].set(str);
 //printf("ngnextdir() --> neuer Pfad: '%s'\n", gadgetstr[aktiver_requester.nrpath].s);//test
 fileliste_aktualisieren(gg,str);
 return 1;//erfolgreich in neues Dir. gewechselt
}
int ngnewdir(Window win,GC gc2,NewGadget *ng,int j,char c1)
{
 int erfolg=0,c;
 const char *s;
 char c0=c1, str[MAXP],*t,*t0; //MAXS hier war falsch!
 if(c0==0)
   {s=ng[j].GadgetText;
    while(*s && *s==' ') s++; //suche ersten Buchstabe
    c1 = *s;
    ng= &ng[aktiver_requester.nrpath-1];
   }
 if(c1=='P') //wurde "Parent" angeklickt ?
  {s=gadgetstr[aktiver_requester.nrpath].s; //bisheriges Verzeichnis
   if((*s==0 || (*s=='.' && s[1]==0)) && c0==0)
     {//auf uebergeordneten Pfad mit unbekanntem Namen wechseln
      system("pwd >pwd.tmp");//provi.
      FILE *fp=fopen("pwd.tmp","r");
      if(fp==NULL) strcpy(str,"../x");
      else	{fscanf(fp,"%s",str); fclose(fp);}
      system("rm pwd.tmp");
      s=str;
     }
   for(t0=t=str;c = *t = *s++;t++) if(c=='/') t0=t;
   if(*t0=='/')
      {*t0=0; //Pfad kuerzen
       if(t0==str) {*t0++ ='/'; *t0=0;}//Wurzelverzeichnis aber immer behalten
      }
   else
       *t0=0; //Pfad kuerzen (leerer Pfad bedeutet aktuelles Verzeichnis)
   //printf("ngnewdir() neues Verzeichnis: '%s'\n",str);//test
   gadgetstr[aktiver_requester.nrpath].set(str); //neues Verzeichnis setzen
   fileliste_aktualisieren(ng->Gadget,str);
   erfolg=1;
  }
 else if(c1=='D') //wurde "Disks" angeklickt ?
  {const char *diskliste="ROOT        (disk)\n\
HOME        (disk)\nPWD         (disk)\nCDROM       (disk)";//provi.
   strcpy(str,"$DISKS");
   gadgetstr[aktiver_requester.nrpath].set(str); //neues Verzeichnis setzen
   fileliste_ins_gadget_kopieren(diskliste,ng->Gadget);
   erfolg=1;
  }
 else
  printf("Error in ngnewdir(): c1=0x%02X='%c' GadgetText='%s'\n",
	 c1, (c1>=' ' && c1<='z')?c1:' ', ng->GadgetText);
 return erfolg;
}

void ngnewpath(NewGadget *ng)
{
 char *str=gadgetstr[aktiver_requester.nrpath].s; //neues Verzeichnis
 fileliste_aktualisieren(ng[aktiver_requester.nrpath-1].Gadget,str);
}

int neuerdateitext(Window win,GC gc2,int gadhoehe,
		    NewGadget *ng,int eingabepos,int n,int x,int y)
{
 Gadget2 *gg=ng->Gadget;
 int i=gg->itexte+eingabepos; if(i>=gg->ntexte) i=gg->ntexte-1;
 //printf("neuerdateitext() '%s' --> ",gg->texte[i]);//test
 //strcpybis(gadgetstr[aktiver_requester.nrfile].s,gg->texte[i],' ',MAXS);
 strcpybisx(gadgetstr[aktiver_requester.nrfile].s,gg->texte[i],MAXS);
 //printf("'%s'\n",gadgetstr[aktiver_requester.nrfile].s);//test
 eingabekursor(win,gc2,ng);//alter Kursor lschen
 gadgets_anschreiben(win,gc2,n,gadhoehe);
 return eingabekursor(win,gc2,ng,x,y);//Kursor neu zeichnen
}

static int darstellungsbreite=40;

void textkuerzen(char *quelle,char *ziel,int a,int max)
{
 //von z.B. "%-80.80s %5s %9d" umformattieren auf "%-a.as%5s %9d"
 //also a Zeichen am Anfang und 15 Zeichen am Ende behalten.
 if(max<a+16) a=max-16;
 char cstr[16];
 sprintf(cstr,"%%-%d.%ds",a,a);
 sprintf(ziel,cstr,quelle);
 int n=strlen(quelle);
 if(n>a && n>15) strcpy(&ziel[a],&quelle[n-15]);
}

void ngxdrawauswahlbox(Window win,GC gc,NewGadget *ng)
{
 char **pz,*text,kurz[120];
 int c,i,j,y0,dx=PIXPROBUCHST_X*3/2,xmit,ymit;
 Gadget2* gg=ng->Gadget;
 const int dy2=PIXYRAND, dx2=PIXXRAND, dy=gg->dy;
 if(dx&1) dx++;//mache dx durch 2 teilbar
 //for(pz=gg->texte,i=0;i<gg->ntexte;i++) printf("'%s'\n",*pz++);//test
 y0=gg->TopEdge+dy2+PIXPROBUCHST_Y-dy;
 XSetForeground(mydpy,gc,reqhigrund);
 XFillRectangle(mydpy,win,gc, //Gadget-Bereich loeschen
		ng->LeftEdge+1,ng->TopEdge+1,ng->Width-1,ng->Height-1);
 XSetForeground(mydpy,gc,reqfogrund);
 for(pz= &gg->texte[j=gg->itexte],i=0;i<gg->maxzeil && j<gg->ntexte;i++,j++)
   {text= *pz++;
#ifdef MITUMLAUTEN
    textkuerzen(umlaut(text),kurz,darstellungsbreite,120);
#else
    textkuerzen(text,kurz,darstellungsbreite,120);
#endif
    XDrawImageString(mydpy,win,gc,gg->LeftEdge+dx2,y0+=dy,kurz,strlen(kurz));
   }
 XDrawRectangle(mydpy,win,gc,gg->LeftEdge,gg->TopEdge,gg->Width,gg->Height);
 XDrawRectangle(mydpy,win,gc,gg->LeftEdge+gg->Width,gg->TopEdge,dx,gg->Height);
 XDrawRectangle(mydpy,win,gc,xmit=gg->LeftEdge+gg->Width,
		ymit=gg->TopEdge+gg->Height-dy,dx,dy); //Runter-Knopf
 XDrawRectangle(mydpy,win,gc,xmit,ymit-dy,dx,dy); //Rauf-Knopf
//Pfeile in Rauf-Runter-Knpfe zeichnen:
 XPoint po[4],pu[4],*pp;
 int mode=CoordModeOrigin, dx3=dx/4,dy3=dy/4, br=(dx-2*dx3+1)/2;
 xmit+=dx/2;
 po[0].x = pu[0].x = xmit-br;  po[0].y = po[1].y = ymit-dy3;
 po[1].x = pu[1].x = xmit+br;
 po[2].x = pu[2].x = xmit;  po[2].y = ymit-dy+dy3;
 for(j=0;j<3;j++)  pu[j].y = 2*ymit - po[j].y; //unterer Pfeil an ymit spiegeln
 po[3]=po[0]; pu[3]=pu[0];
 XDrawLines(mydpy,win,gc,po,4,mode); XDrawLines(mydpy,win,gc,pu,4,mode);
//Schieber zeichnen:
 int shib_hoehe,shib_y;
 schiebebalken.calc(gg,&shib_hoehe,&shib_y);
 if(gg->TopEdge+shib_y+shib_hoehe > ymit-dy)
   shib_hoehe=ymit-dy-gg->TopEdge-shib_y;//Spezialfall
 XFillRectangle(mydpy,win,gc,gg->LeftEdge+gg->Width+2,gg->TopEdge+shib_y,
		dx-3,shib_hoehe);
}

int requester_datei(char *pfad,char *file,int max1,int max2,int maxzeilen,int flgs,
		    const char *titeltext,char *filter,
		    const char *oktext,const char *canceltext,
		    const char *parenttext,const char *diskstext,int nfilt)
{
 //max1 definiert Platz in pfad, max2 Platz in file
 requester_font_anfordern();
 int i,j,h,nzeich,ok,xbr,deltay,n4;
 int xrand=2,xmax=50,ymax=40;
 int dy1=PIXPROBUCHST_Y*3/2,	//Gadgethoehe
     dy2=2*PIXPROBUCHST_Y,	//Gadgetabstand
     dx=PIXPROBUCHST_X;		//Buchstabenbreite
 int yspace=(PIXPROBUCHST_Y>4)?PIXPROBUCHST_Y/2:2,
     yspace2=3*yspace;
 if((dy1-PIXPROBUCHST_Y)&1)
	dy1++; //gradzahlige Anzahl Pixel mehr als Buchstabenhhe
 int minxbr=5*PIXPROBUCHST_X;
 int xx=xrand,yy=yspace,dy=dy1+dy2;
 struct NewGadget *ng;
 const int n=4;
 //char *s;
 char *cstr2[n]={filter,"Files ",pfad,file};
 char *dateiliste=getfileliste(pfad,filter);
 char *cstr1[n]={" Filt:",dateiliste," Path:"," File:"};
 if(flgs&SPRACHE_DEUTSCH)
   {cstr1[0]=" Filt:"; cstr1[2]=" Pfad:"; cstr1[3]="Datei:";}
 xrand=dx*strlen(cstr1[n-1]);
 for(ng=newgadgets,j=i=0;i<n;i++)
        {if(cstr2[i]==NULL) continue;
	 ng->GadgetText = cstr1[i];
	 if(i==1) nzeich=strlen(cstr2[i]);
	 else nzeich=strlen(ng->GadgetText);
	 if(xx<xrand) xx=xrand;
         ng->LeftEdge=xx; ng->TopEdge=yy;
         ng->GadgetID=j; ng->Flags=(i==1)?PLACETEXT_AUSWAHL:PLACETEXT_LEFT;
         ng->UserData=cstr2[i];
	 strcpy(gadgetstr[j].s,cstr2[i]);
	 if((h=strlen(gadgetstr[j].s))>nzeich) nzeich=h;
	 if(nzeich<40) nzeich=40; //40 entspricht der Fensterbreite
	 //gadgetstr[j].max=nzeich; //war falsch! Im Gadget soll ganzer Text
         //  bleiben, nur beim Anzeigen soll er auf 40 beschraenkt sein.
	 if(j==2) gadgetstr[j].max = max1;//max. Laenge pfad
	 else if(j==3) gadgetstr[j].max = max2;//max. Laenge file
	 else gadgetstr[j].max = MAXP;//gesamte Groesse von s in gadgetstring
         xbr=(nzeich+1)*dx; if(xbr<minxbr) xbr=minxbr;
	 if(i==1) deltay=maxzeilen*PIXPROZEILE+2*PIXYRAND;
	 else	{deltay=dy1;
		 xbr+=PIXPROBUCHST_X*3/2;//etwas breiter um schoen zu passen
		}
         ng->Width=xbr; ng->Height=deltay;
         if(xmax<xx+xbr) xmax=xx+xbr;
         if(i==1) yy+=deltay+yspace2;
	 else yy+=deltay+yspace;
	 ng++; j++;
        }
 yy+=yspace2;
 xmax+=xrand;
 xbr=9*dx;
 int xspace=(xmax-4*xbr)/5;
 if(xspace<2) {xspace=2; xmax=4*xbr+5*xspace;}
 int ok_left=xspace, cancel_left=xmax-xspace-xbr,
     parent_left=2*xspace+xbr, disks_left=3*xspace+2*xbr;
 for(;i<n+4;i++,ng++,j++)
        {switch(i)
	  {case n:   ng->LeftEdge=parent_left; ng->GadgetText=parenttext;
	   CASE n+1: ng->LeftEdge=disks_left;  ng->GadgetText=diskstext;
	   CASE n+2: ng->LeftEdge=ok_left; ng->GadgetText=oktext;
	   CASE n+3: ng->LeftEdge=cancel_left; ng->GadgetText=canceltext;
	  }
         ng->TopEdge=yy; ng->Width=xbr; ng->Height=dy1;
         ng->GadgetID=j; ng->Flags=PLACETEXT_IN;
         ng->UserData=NULL;
        }
 yy+=dy;
 if(yy>ymax) ymax=yy;
 for(ng=newgadgets,i=(filter==NULL)?1:0; i<n; i++,ng++)
    machgadget(ng,(i==1)?maxzeilen:1);
 if(filter==NULL)
	{n4=n+3; aktiver_requester.typ=REQTYP_AUSWAHL_NO_FILTER;}
 else	{n4=n+4; aktiver_requester.typ=REQTYP_AUSWAHL_FILTER;
         g_filter=gadgetstr[0].s;
        }
 // aktiver_requester.nglist=ng;//provi.
 aktiver_requester.nrpath=n4-6;
 aktiver_requester.nrfile=n4-5;
 // aktiver_requester.gglist=tek_gadgetliste;//provi.
 ok=xrequester_start(n4,newgadgets,dy1,dy2,xmax,ymax,titeltext,
		     aktiver_requester.typ);
 if(filter!=NULL && nfilt>0) //filter zum Anwenderprogi zurueckkopieren
  {strncpy(filter,gadgetstr[0].s,nfilt);
   filter[nfilt-1]=0;
  }
 if(ok) for(ng= &newgadgets[i=n4-6];i<n4-4;i++,ng++)
		strcpy(ng->UserData,gadgetstr[i].s);
 delete[] dateiliste;
 g_filter=NULL;
 return ok;
}

char *strcpymax(char *zu,const char *von,int max)
{
 while(--max>0) if((*zu++ = *von++)==0) return zu;
 *zu++ = 0;
 return zu;
}

void splitpfad(const char *name,char *pfad,char *file,int max,int max2)
{
// name in pfad und file aufteilen
// in pfad und file muessen je max Bytes platz haben
 char *s1;
 int pfadleer;
 if(max2==0) max2=max;
 s1=strcpymax(pfad,name,max);
 while(s1!=pfad && *--s1!='/') ;
 if(s1==pfad) {if(*s1=='/') {pfadleer=2; s1++;} else pfadleer=1;}
 else {*s1++ = 0; max -= s1-pfad; pfadleer=0;}
 if(max<max2)  //sicher stellen dass nicht mehr als max Bytes
     max2=max; //aus name gelesen werden und dass
 strcpymax(file,s1,max2);//hoechstens max2 Bytes in file geschrieben werden.
 switch(pfadleer)
   {case 2: *pfad='/'; pfad[1]=0; break;
    case 1: *pfad=0;
   }
}
char *joinpfad(const char *pfad,const char *file,char *name,int max)
{
// pfad und file in einem String zusammenfuegen
 const char *s1;
 char *t;
 int c,c2,i;
 if(max==0) max=strlen(pfad)+strlen(file)+2;
 if(name==NULL) name=new char[max];
 for(t=name,s1=pfad,i=2; (c2= *s1++) && i<max;i++) *t++ = c = c2;
 if(c!='/' && t!=name) *t++ = '/';
 strcpymax(t,file,max-i);
 return name;
}

/* so in xtekplot1.h
int nachfilenamefragen(const char *str,char *name,int max,int flgs=0,
	char *filter=NULL, //hier darf kein const sein!
	const char *oktext=NULL,const char *canceltext=" CANCEL",
	const char *parenttext=" Parent",const char *diskstext="  Disks",
	int nfilt=0);
*/
int nachfilenamefragen(const char *str,char *name,int max,int flgs,
		       char *filter, //hier darf kein const sein!
		       const char *oktext,const char *canceltext,
		       const char *parenttext,const char *diskstext,
		       int nfilt //Maximale Laenge von filter
		       )
{
 const int NZEILEN=10;
 char pfad[MAXP],file[MAXD];
 int ok;
 splitpfad(name,pfad,file,MAXP,MAXD);
 if(oktext==NULL)
   {if(strncmpgross(str,"LOAD",4)==0 ||
       strncmpgross(str,"LADE",4)==0) oktext="  LOAD";
    else if(strncmpgross(str,"SAVE",4)==0 ||
	    strncmpgross(str,"SPEI",4)==0) oktext="  SAVE";
    else oktext="   OK";
   }
 ok=requester_datei(pfad,file,MAXP,MAXD,NZEILEN,flgs,str,
		    filter,oktext,canceltext,parenttext,diskstext,nfilt);
 if(ok) joinpfad(pfad,file,name,max);
 return ok;
}

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "ourhdr.h"

#ifdef VAX_OR_ALPHA
//#define PATH_MAX 2048
int lstat(char *fullpath,struct stat *statbuf)
{
 int ok=stat(fullpath,statbuf);
//provi.
 return ok;
}
#endif

#ifdef MACOSX
#define PATH_MAX 2048
#endif

bool filtervergleich1(const char *name,const char *filter)
{
 int c1,c2,star=0,frag=0;
 for(;(c1= *name)!=0 && (c2= *filter)!=0;)
   {while(c2=='*' || c2=='?')
     {if(c2=='?') frag++;
      else if(c2=='*') star=1;
      c2= *++filter;
     }
    if(c2==0) break;
    if(star>0)
      {for(;frag>0;--frag) {if((c1= *name++)==0) return 0;}
       while((c1= *name++)!=c2) {if(c1==0) return 0;}
       ++filter; star=0;
      }
    else
      {for(;frag>0;--frag) {if((c1= *name++)==0) return 0;}
       if((c1= *name++)!=c2) return 0;
       ++filter;
      }
   }
 if(c2==0)
   {for(;frag>0;--frag) {if((c1= *name++)==0) return 0;}
    return (star>0 || *name==0);
   }
 return (*filter==0 || (*filter=='*' && filter[1]==0));
}
void stringumkehren(const char *s1,char *s2)
{
 int n=strlen(s1);
 while(n>0) *s2++ = s1[--n];
 *s2=0;
}
bool filtervergleich(const char *name,const char *filter)
{
 if(*name=='.' &&
    (strncmp(filter,"*?.",3)==0
     || strncmp(filter,"?*.",3)==0)) return 0;//Spezialdatei nicht zeigen
 if(filtervergleich1(name,filter)) return true;
 int n=strlen(name),n2=strlen(filter);
 char name2[n+1],filter2[n2+1];
 stringumkehren(name,name2); stringumkehren(filter,filter2);
 return filtervergleich1(name2,filter2);
}

char *getfileliste(const char *pfad,const char *filter,int maxz)
{
 int nc=512,j,typ;
 //printf("PATH_MAX=%d\n",PATH_MAX);//test
 char fullpath[PATH_MAX+1],buf[120],*styp,*s;
 char *liste=new char[nc];
 char sctrl[40];
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 const int NORM=1,VERZ=2,SPEZ=3,LINK=4;
 if(pfad==NULL || *pfad==0) pfad=".";//aktueller Pfad
 if((dp=opendir(pfad))==NULL) {*liste=0; return liste;}
 for(j=0;(dirp=readdir(dp))!=NULL;)
   {if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    sprintf(fullpath,"%s/%s",pfad,dirp->d_name);
    typ=NORM;
    if(lstat(fullpath,&statbuf) < 0) typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    if(typ!=VERZ && typ!=LINK && filter!=NULL
       && filtervergleich(dirp->d_name,filter)==0) continue;
    switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: styp=strf("(%03lX)",typ);
      }
    int a=maxz-16; if(a<4) a=4;
    sprintf(sctrl,"%%-%d.%ds %%s %%9d",MAXS,MAXS); darstellungsbreite=a;
    //z.B. %-20.20s fuer Beschraenkung auf 20 Zeichen
    sprintf(buf,sctrl,dirp->d_name,styp,statbuf.st_size);
    //printf("sctrl='%s' buf='%s'\n",sctrl,buf);//test
    if(nc-j < strlen(buf)+2) //wenn Buffer zu klein:
      {s=new char[nc+=nc];  //groesserer Buffer anfordern
       liste[j]=0; strcpy(s,liste); delete[] liste; liste=s;
      }
    if(j!=0) liste[j++]='\n';
    for(s=buf;*s;) liste[j++] = *s++;
   }
 liste[j]=0;
 closedir(dp);
 return sortieren(liste);
}

void fileliste_aktualisieren(Gadget2 *gg,char *pfad)
{
 char *dateiliste=getfileliste(pfad,g_filter);
 fileliste_ins_gadget_kopieren(dateiliste,gg);
 delete[] dateiliste;
}

static char *nextzeile(char *s)
{
 int c;
 while((c= *s++) && c!='\n') ;
 if(c==0) --s;
 return s;
}
static char *zeilekopieren(char *s,const char *v)
{
 int c;
 while((c= *v++) && c!='\n') *s++ = c;
 *s++ = '\n';
 return s;
}

/** Sortieren-Variante mit Beruecksichtugung aller Zeichen der Dateinamen **/
static int namenvergleich(const char *s1,const char *s2)
{
 //Rueckgabewerte: 0 = beide gleich, <0 = s1 soll vor s2 kommen, >0 s2 vor s1
 int c1=2,c2=2;
 const int SOND=0x80;
 if(index2(s1,"(dir)")>=0 || index2(s1,"(lnk)")>=0) c1=1;//Dirs weit vorne
 if(index2(s2,"(dir)")>=0 || index2(s2,"(lnk)")>=0) c2=1;
 if(c1!=c2) return c1-c2;
 c1= *s1++; if(c1=='.') c1+=SOND; //mit Sonderzeichen beginnend weit hinten
 c2= *s2++; if(c2=='.') c2+=SOND;
 if(c1==0 || c1=='\n' || c2==0 || c2=='\n') return c1-c2;
 for(;c1==c2;)
   {c1= *s1++; c2= *s2++;
    if(c1==0 || c1=='\n' || c2==0 || c2=='\n') break;
   }
 return c1-c2;
}
static char *sortieren(char *liste)
{
 int i,j,max=anzahlzeilen(liste);
 if(max<2) return liste;//kein sortieren noetig
 char **tab,*s,*neu=new char[strlen(liste)+1];
 tab=new char*[max];
 //printf("sortieren()\nliste='%s'\n",liste);//test
 for(i= -1,s=liste;++i<max && *s!=0;)
   {tab[i]=s; s=nextzeile(s);}
 for(j=0;j<max-1;j++) //bubble-sort
   for(i=max;--i>j;)
     if(namenvergleich(tab[i-1],tab[i])>0)
       {s=tab[i-1]; tab[i-1]=tab[i]; tab[i]=s;} //Strings vertauschen
 for(i=0,s=neu;i<max;i++)
   s=zeilekopieren(s,tab[i]);
 if(s!=neu) --s;
 *s=0;
 delete[] liste; delete[] tab;
 return neu;
}

/************************* ab Version 2.6 ********************************/
static double tekplot_aspect=1.0; //Verhaeltnis von Pixelbreite/Pixelhoehe

/*
#define xmin tekplot_xmin
#define ymin tekplot_ymin
#define xmax tekplot_xmax
#define ymax tekplot_ymax
#define xs tekplot_xs
#define ys tekplot_ys
 *breite=tekplot_breite;
 *hoehe=tekplot_hoehe;
*/

void setaspect(double asp)
{
 tekplot_aspect=asp; //provisorisch
}

double getaspect()
{
 return tekplot_aspect; //provisorisch
}

double getraspect()
{
 return xs/ys/tekplot_aspect;
}

double get_tekplot_version()
{
 double version;
 const char *s=tekplot_version;
 while(!isdigit(*s)) s++;
 sscanf(s,"%lf",&version);
 return version;
}

FILE *screenmode_file_open()
{
 FILE *fp;
 if(fp=fopen(TEKPLOT_SCREENDATEN,"r")) return fp;
 char str[200];
 sprintf(str,"%s/%s",getenv("h"),TEKPLOT_SCREENDATEN);
 return fopen(str,"r");
}

/*************** Menu aufgeklappt halten ******************/
void Menuaufklapper::einaus()
{
 if(offen^=1) menu_klappen(x=menu.x0[0]+1,y=zeilenabstand/2);
 else menu_klappen(x= -1,y= -1);
}
void Menuaufklapper::setxy(int x1,int y1)
{
 XEvent event;
 x=x1; y=y1;
 //printf("Menuaufklapper::setxy(%d,%d)\n",x,y);//test
 if(menu.klappe!= -1)
   {if(y<zeilenabstand) menu_klappen(x,y);
    menu_markieren(x,y);
   }
}
void Menuaufklapper::auswahl()
{
 int j,reihe,spalte=menu.klappe;
 funkzeiger funk;
 //printf("klappr.auswahl(spalte=%d,x=%d,y=%d)\n",spalte,x,y);//test
 if((j=menu.subklappe) > -1)
   {reihe=subreihe_ermitteln(j,x,y);
    menu_klappen(-1,-1); setoffen(0);
    if(reihe>=0 && (funk=menu.sub[j]->funkfeld[reihe])!=NULL)
      (*funk)(j+(reihe<<16)+1);
   }
 else
   {reihe=reihe_ermitteln(spalte,x,y);
    menu_klappen(-1,-1); setoffen(0);
    funk=menu_funkfeld[j=spalte+reihe*menu.anzahl];
    if(reihe>=1 && funk!=NULL) (*funk)(-j-1);
   }
}
int Menuaufklapper::key(KeySym k)
{
 int j,ok=1,x0=x,y0=y,spalte=menu.klappe;
 static int subj=0,ymin=zeilenabstand/2;
 switch(k)
   {case 0xFF0D: case 0xFF8D: auswahl();
    CASE 0xFF53: //Pfeil rechts
		 if((j=menu.subklappe) > -1)
		   {if(++subj==1) setxy(x+menu.br[spalte],y);}
		 else
		   {setxy(x0,1);
		    if(spalte<menu.anzahl-1) x0=menu.x0[spalte+1]+1;
		    setxy(x0,1); setxy(x0,y0);
		    //printf("Pfeil rechts: setxy(%d,%d)\n",x0,y0);//test
		   }
    CASE 0xFF51: //Pfeil links
		 if(subj>0)
		   {setxy(x-menu.br[spalte],y); subj=0;}
		 else if(spalte>0)
		   {setxy(x0,1); x0=menu.x0[spalte-1]+1;
		    setxy(x0,1); setxy(x0,y0);
		   }
    CASE 0xFF52: //Pfeil rauf
		 y0-=zeilenabstand; setxy(x,y0<ymin?ymin:y0);
    CASE 0xFF54: //Pfeil runter
		 y0+=zeilenabstand;
		 if(subj>0)
		   {j=menu.subklappe;
		    if(j<0 || subreihe_ermitteln(j,x,y)== -1)
		      {x0-=menu.br[spalte]; subj=0; setxy(x0,y0);}
		    else if(j>=0 && subreihe_ermitteln(j,x,y0) != -2)
		      setxy(x0,y0);
		   }
		 else if(y0<2*zeilenabstand || reihe_ermitteln(spalte,x,y0)>0)
		   setxy(x,y0);
    DEFAULT: ok=0;
   }
 return ok;
}

/*************** schnelle Menu-Auswahl ueber Tastatur ******************/
bool Amigatast::doit(KeySym k)
{
 bool benutzt=false;
 if(k==AMIGATASTE)
   {aktiv^=1; benutzt=(aktiv!=0);}
 else if(aktiv)
   {benutzen(k);
    benutzt=true;
    aktiv=0;
   }
 return benutzt;
}

void Amigatast::benutzen(int k)
{
 Amigatab *p;
 if((k&0xFF00)!=0) return;
 k=toupper(k);
 for(p=tabelle;p!=NULL;p=p->next)
   if(p->taste==k)
     {(*(p->funk))(p->j);
      return;
     }
}

void Amigatast::put(int t,funkzeiger f,long j)
{
 Amigatab* neu=new Amigatab[1];
 neu->taste=t; neu->funk=f; neu->j=j;
 neu->next=tabelle; tabelle=neu;
}

int Amigatast::geta(char *s)
{
 if(s==NULL) return 0;
 if(s[0]=='%' && s[1]=='A') return toupper(s[2]);
 return 0;
}

void Amigatast::put(int k,long j)
{
 int taste;
 if(taste=geta(menu_textfeld[k+menu_isub]))
   put(taste,menu_funkfeld[k],j);
}

void Amigatast::subput(int k)
{
 int taste,j=0;//provi.
 if(taste=geta(menu_textfeld[k-menu_isub+menu_i]))
   put(taste,menu_sub_funkfeld[k],j);
}

/*** Behebung von Flimmerproblemen ***/
/*
 Einige XSync()-Aufrufe und ein XFlush() sind zuviel,
 zumindest fr bewegte Bilder.
*/
void setxsync(int m)
{
 xsync_modus=m;
}

/*** provisorisch fuer Double-buffering ***/
//static Drawable dpuffer=0; //schon weiter oben gemacht

int changebuffer(int shownr,int drawnr)
{
 //printf("changebuffer(%d,%d)\n",shownr,drawnr);//test
 if(shownr==drawnr)
   {if(dpuffer!=0)    {XFreePixmap(dpy,dpuffer); dpuffer=0;}
    if(leerpuffer!=0) {XFreePixmap(dpy,leerpuffer); leerpuffer=0;}
    //printf("Puffer geloescht\n");//test
    return 0;
   }
 if(dpuffer==0)
   {dpuffer=XCreatePixmap(dpy,win10,(uint)winbreite,(uint)winhoehe,dept);
    XCopyArea(dpy,win10,dpuffer,gc,0,0,(uint)winbreite,(uint)winhoehe,0,0);
    XSync(dpy,0);
    //printf("Puffer erstellt: %d\n",dpuffer);//test
    return 0;
   }
 XCopyArea(dpy,dpuffer,win10,gc,0,0,(uint)winbreite,(uint)winhoehe,0,0);
 XSync(dpy,0);
 return 0;
}

/*** Anpassung von Umlauten ***/
#ifdef MITUMLAUTEN
void utf8_to_isolatin1(char *ziel,const char *von,int max)
{  //Codierung von utf-8 nach iso-8859-1
 int i,c,a1;
 for(i=1;(c= *von++ & 0xFF) && i<max;i++)
   {if((c==0xC2 || c==0xC3) && ((a1= *von & 0xFF) & 0xC0)==0x80)
      {von++;
       c=(a1&0x3F)+((c&0x03)<<6);
      }
/** keine gute Idee: gibt seltsame Effekte bei der Eingabe in Requestern
    else if(c=='\\' && *von=='\\')
      {von++;
      }
    else if(c=='\\' && *von=='\"' &&
	    ((a1=von[1])=='a'||a1=='o'||a1=='u'||a1=='A'||a1=='O'||a1=='U'))
      {//Sequenzen der Form '\"a' auch in Umlaute wandeln
       von++; von++;
       switch(a1)
	{case 'a':c=0xE4; break;case 'o':c=0xF6; break;case 'u':c=0xFC; break;
	 case 'A':c=0xC4; break;case 'O':c=0xD6; break;case 'U':c=0xDC;
	}
      }
**/
#ifdef MACOSX
   else if(c>='A' && c<='z' && (von[0]&0xFF)==0xCC && (von[1]&0xFF)==0x88)
    {
     switch(c)
	{case 'a':c=0xE4; break;case 'o':c=0xF6; break;case 'u':c=0xFC; break;
	 case 'A':c=0xC4; break;case 'O':c=0xD6; break;case 'U':c=0xDC;
	}
     von++; von++;
    }
#endif
    *ziel++ = c;
   }
 *ziel=0;
}
static char *umlaut(const char *txt)
{
 static char str[MAXP];
 utf8_to_isolatin1(str,txt,MAXP);
 return str;
}
void ischrift_utf8(int x,int y,const char *str,double winkel)
{
 ischrift(x,y,umlaut(str),winkel);
}
void schrift_utf8(double x,double y,const char *str,double winkel)
{
 schrift(x,y,umlaut(str),winkel);
}
int janeinrequester_utf8(const char *t,const char *jatext,const char *neintext)
{
 int n;
 char *text=new char[n=strlen(t)+1];
 utf8_to_isolatin1(text,t,n);
 janeinrequester(text,jatext,neintext);
 delete[] text;
}
#endif
