/* imagetest.cc
  Testprogi um neue Funktion in xtekplot1 zu testen

History:
28.11.2017	Erstellung (RPf)

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <xtekplot1.h>

#define UNITYBUG 32  //Fehler in Unity umgehen: Hoehe des nicht abschaltbaren Balkens

typedef unsigned char uchar;
const int MAXP=MAX_PFADNAME_LAENGE, MAXD=MAX_DATEINAME_LAENGE;

uchar *bild_einlesen(const char *name,int *breite,int *hoehe)
{
 char bef[MAXD];
 const char *tmpppm="/tmp/tmp.ppm";
 sprintf(bef,"convert -auto-orient \"%s\" \"%s\"",name,tmpppm);
 system(bef);
 FILE *fp=fopen(tmpppm,"rb");
 if(fp==NULL) {printf("Fehler: Datei %s nicht gefunden\n",tmpppm); return NULL;}
 int c,c1,c2,ti;
 if((c1=getc(fp))!='P' || (c2=getc(fp))!='6')
    {printf("Fehler: Datei %s kein PPM\n",tmpppm); fclose(fp); return NULL;}
 while((c=getc(fp))!='\n' && c!=' ') ;
 while(c=='#') {while(getc(fp)!='\n') ;  c=getc(fp);}
 ungetc(c,fp);
 c=fscanf(fp,"%d %d %d",breite,hoehe,&ti);
 if(c!=3) {printf("Fehler in PPM-Datei\n"); fclose(fp); return NULL;}
 if((c=getc(fp))!='\n' && c!=' ') printf("fehlendes Leerzeichen in PPM\n");
 if(ti!=255 && ti!=65535) printf("falsche Farbtiefe %d in PPM\n",ti);
 int bytes_pro_pixel = 4;
 uchar *pmem = (uchar*)malloc((*breite)*(*hoehe)*bytes_pro_pixel);
 uchar r,g,b;
 if(pmem==NULL)
   {printf("kann keinen Speicher reservieren\n"); fclose(fp); return NULL;}
 uchar *p=pmem;
 printf("Farbtiefe=%d\n",ti);//test
 if(ti<=255)
  {
   for(int j=0;j<(*hoehe);j++)
    for(int i=0;i<(*breite);i++)
     {
      r=getc(fp); g=getc(fp); b=getc(fp);
      *p++ = r; *p++ = g; *p++ = b; *p++ = 0;
     }
  }
 else //if(ti==65535)
  {
   for(int j=0;j<(*hoehe);j++)
    for(int i=0;i<(*breite);i++)
     {
      r=getc(fp); getc(fp); g=getc(fp); getc(fp); b=getc(fp); getc(fp); 
      *p++ = r; *p++ = g; *p++ = b; *p++ = 0;
     }
  }
 fclose(fp);
 unlink(tmpppm);
 return pmem;
}

uchar *bild_verkleinern(uchar *pmem,int *bildbreite,int *bildhoehe,
			int maxbreite,int maxhoehe)
{
 int xmax= *bildbreite, ymax= *bildhoehe; //urspruengliche Bildgroesse
 double f1=maxbreite/(double)xmax;
 double f2=maxhoehe/(double)ymax;
 //printf("f1=%f f2=%f\n",f1,f2);//test
 if(f2<f1) f1=f2; //kleinerer der beiden Werte verwenden
 int breite, hoehe; //neue Bildgroesse
 *bildbreite = breite = (int)(xmax*f1);
 *bildhoehe  = hoehe = (int)(ymax*f1);
 //printf("alte breite=%d hoehe=%d\n",xmax,ymax);
 //printf("neue breite=%d hoehe=%d\n",breite,hoehe);
 uchar *pneu = (uchar*)malloc(breite*hoehe*4);
 uchar r,g,b,a, *p,*q;
 int ix,iy,x1,y1,x,y;
 const int bytes_pro_pixel=4;
 int bytes_pro_zeile=xmax*bytes_pro_pixel;
 for(p=pneu,iy=0,y1=0; iy<hoehe; iy++,y1+=ymax)
  for(ix=0,x1=0; ix<breite; ix++,x1+=xmax)
   {
    x=x1/breite; y=y1/hoehe; //nur 1 Pixel verwenden
    //TODO: Durchschnitt von mehreren Pixeln fuer bessere Bildqualitaet
    q = &pmem[y*bytes_pro_zeile+x*bytes_pro_pixel];
    r= *q++; g= *q++; b= *q++; a= *q++;
    *p++ = r; *p++ = g; *p++ = b; *p++ = a;
   }
 free(pmem);
 return pneu;
}

static int exitflag=0;
void m_exit() {exitflag=1;}

int main(int argc,char *argv[])
{
 double dxmin=0,dymin=0,dxmax=1.2,dymax=1.0;
 int breite,hoehe,tiefe,visklasse;
 char name[MAXP]="blume.jpg";
 char text[80]="Lade Datei";
 char filt[MAXD]="*.jpg";
 int sprache=SPRACHE_DEUTSCH;
 bool ok;
 //tek_setdebug(1);//test
 if(argc>=2) {strcpy(name,argv[1]); ok=true;}
 else
  {
   ok=nachfilenamefragen(text,name,MAXP,sprache,filt);
   if(!ok) return 0;
  }
 int bildbreite,bildhoehe;
 uchar *pmem=bild_einlesen(name,&bildbreite,&bildhoehe);
 if(pmem==NULL) return 0;
 printf("Bild eingelesen: bildbreite=%d bildhoehe=%d\n",bildbreite,bildhoehe);

 // Grafik-Fenster oeffnen:
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
#ifdef UNITYBUG
 hoehe -= UNITYBUG;
#endif
 if(tiefe>24) tiefe=24;
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Exit",m_exit);
 inital(dxmin,dymin,dxmax,dymax);
 printf("Grafik-Fenster geoeffnet: breite=%d hoehe=%d\n",breite,hoehe);
 printf(" menuleistenhoehe=%d\n",get_menuleistenhoehe());//test
 int ho=get_menuleistenhoehe();
 if(bildbreite>breite || bildhoehe>hoehe)
  {
   pmem=bild_verkleinern(pmem,&bildbreite,&bildhoehe,breite,hoehe-ho);
   printf("Bild verkleinert auf %d x %d\n",bildbreite,bildhoehe);
  }

 // Bild im Grafik-Fenster anzeigen:
 int xmax=bildbreite, ymax=bildhoehe; //rgb_grau=0x808080;
 uchar r,g,b; int rgb;
 XImage *image=tek_xcreateimage(xmax,ymax);
 uchar *p;
 int iy,ix;
 for(p=pmem,iy=0; iy<ymax; iy++)
  for(ix=0; ix<xmax; ix++)
   {
    r = *p++; g = *p++; b = *p++; p++;
    rgb = (r<<16)+(g<<8)+b;
    XPutPixel(image, ix, iy, rgb);
   }
 int offsetx=0,offsety=0;
 if(bildbreite<breite) offsetx=(breite-bildbreite)/2;
 if(bildhoehe<hoehe-ho) offsety=(hoehe-ho-bildhoehe)/2;
 tek_xputimage(image,0,0, 0+offsetx, ho+offsety, xmax,ymax);
 XDestroyImage(image); //speicher vom image wieder freigeben
 free(pmem); //mit malloc reservierter Speicher freigeben

 while(exitflag==0 && waitmenu(1)==0)
  {
   // auf Benutzereingaben warten
  }
 term_exit();
 return 0;
}
