/* vtimeb.h   Variante fr alle Maschinen */
#ifndef VTIMEB_H
#define VTIMEB_H

#ifdef VAXORALPHA
#include <file.h>
#ifndef __STDC__
#include <unixio.h>
#else
#include <timeb.h>
#endif
#include <time.h>
#define TIME_T
#define TM_T
#define TIMEB_T
#define FTIME_T
#endif /*VAXORALPHA*/

#ifdef unix
/** IBM AIX UNIX **
#include <time.h>
#define TIME_T
#define TM_T
#endif
/**/

/** DEC Alpha UNIX **/
#include <sys/time.h>
#define TIME_T
#define TM_T
/**/
#endif /*unix*/

/** Maschinenunabhngiger Teil: **/
#ifndef TIME_T /* ev. schon in <timeb.h> definiert */
typedef long time_t;
#endif

#ifndef TIMEB_T
struct timeb
        {time_t          time;
         unsigned short  millitm;
         short           timezone;
         short           dstflag;
        };
typedef struct timeb timeb_t;
#endif

#ifndef TM_T /* sollte schon in <time.h> definiert sein */
struct tm
        {int     tm_sec, tm_min, tm_hour;
         int     tm_mday, tm_mon, tm_year;
         int     tm_wday, tm_yday, tm_isdst;
        };
typedef struct tm tm_t;
#endif

#ifndef FTIME_T
int ftime(timeb_t*);
#endif

#endif /*VTIMEB_H*/
