/* vektor3dklasse.cc

 Rechnen mit 3D Vektoren
Anwendung: einfgen in C++ Programmen
*/

#ifndef VEKTOR3DKLASSE_CC
#define VEKTOR3DKLASSE_CC
#include <vektorklasse.cc>
#include <math3.h>
/*
#ifndef PI
#define PI 3.14159265358979323846
#endif
#ifndef ZWEIPI
#define ZWEIPI (2.*PI)
#endif
#ifndef PIHALBE
#define PIHALBE (0.5*PI)
#endif
#ifndef GRAD
#define GRAD (PI/180.)
#endif
double abs(double x);
double abs(double x) {return x<0?-x:x;}
*/

class Vektor3d
{
public:
 double x,y,z;
 Vektor3d() {x=y=z=0;}
 Vektor3d(double a,double b=0,double c=0) {x=a; y=b; z=c;}
 double get(int i) {if(i==0) return x; if(i==1) return y; if(i==2) return z;
		    return sqrt(x*x+y*y+z*z); //Betrag
		   }
 Vektor3d operator=(double a) {x=a; y=z=0; return *this;}
 Vektor3d operator=(vektor v) {x=v.x; y=v.y; z=0; return *this;}
 Vektor3d operator=(Vektor3d v) {x=v.x; y=v.y; z=v.z; return *this;}
 Vektor3d operator+=(Vektor3d v) {x+=v.x; y+=v.y; z+=v.z; return *this;}
 Vektor3d operator-=(Vektor3d v) {x-=v.x; y-=v.y; z-=v.z; return *this;}
 Vektor3d operator*=(double a) {x*=a; y*=a; z*=a; return *this;}
 Vektor3d operator/=(double a) {x/=a; y/=a; z/=a; return *this;}
 Vektor3d einheitsvektor()
	{double wu=sqrt(x*x+y*y+z*z); x/=wu; y/=wu; z/=wu; return *this;}
 double& operator[](int i) {return i==0?x:(i==1?y:z);}
 friend Vektor3d operator+(Vektor3d,Vektor3d);
 friend Vektor3d operator-(Vektor3d,Vektor3d);
 friend Vektor3d operator*(Vektor3d,double);
 friend Vektor3d operator*(double,Vektor3d);
 friend Vektor3d operator*(Vektor3d,Vektor3d);
 friend Vektor3d operator/(Vektor3d,double);
 friend Vektor3d operator/(Vektor3d,Vektor3d);//provi.
 friend Vektor3d operator-(Vektor3d);
 void drehenxy(double sw,double cw);
 void drehenyx(double sw,double cw);
 void drehenxy(double w) {drehenxy(sin(w),cos(w));}
 void drehenyx(double w) {drehenxy(-sin(w),cos(w));}
 void drehenzx(double sw,double cw);
 void drehenxz(double sw,double cw);
 void drehenzx(double w) {drehenzx(sin(w),cos(w));}
 void drehenxz(double w) {drehenzx(-sin(w),cos(w));}
 void drehenyz(double sw,double cw);
 void drehenzy(double sw,double cw);
 void drehenyz(double w) {drehenyz(sin(w),cos(w));}
 void drehenzy(double w) {drehenyz(-sin(w),cos(w));}
};

Vektor3d operator+(Vektor3d v1,Vektor3d v2)
{
 Vektor3d v; v.x=v1.x+v2.x; v.y=v1.y+v2.y; v.z=v1.z+v2.z;
 return v;
}
Vektor3d operator-(Vektor3d v1,Vektor3d v2)
{
 Vektor3d v; v.x=v1.x-v2.x; v.y=v1.y-v2.y; v.z=v1.z-v2.z;
 return v;
}
Vektor3d operator*(Vektor3d v1,double c)
{
 Vektor3d v; v.x=v1.x*c; v.y=v1.y*c; v.z=v1.z*c;
 return v;
}
Vektor3d operator*(double c,Vektor3d v1)
{
 Vektor3d v; v.x=v1.x*c; v.y=v1.y*c; v.z=v1.z*c;
 return v;
}
Vektor3d operator/(Vektor3d v1,double c)
{
 Vektor3d v; v.x=v1.x/c; v.y=v1.y/c; v.z=v1.z/c;
 return v;
}
Vektor3d operator-(Vektor3d v1)
{
 Vektor3d v; v.x= -v1.x; v.y= -v1.y; v.z= -v1.z;
 return v;
}

double abs(Vektor3d v)				//Betrag eines Vektors
{
 return sqrt(v.x*v.x+v.y*v.y+v.z*v.z);
}

double Vektor3dprodukt(Vektor3d v1,Vektor3d v2)	// v1*v2
{
 return v1.x*v2.x+v1.y*v2.y+v1.z*v2.z;
}

Vektor3d operator*(Vektor3d v1,Vektor3d v2)
{
 Vektor3d v; v.x=v1.x*v2.x; v.y=v1.y*v2.y; v.z=v1.z*v2.z;
 return v;
}
Vektor3d operator/(Vektor3d v1,Vektor3d v2) //provi.
{
 Vektor3d v; v.x=v1.x/v2.x; v.y=v1.y/v2.y; v.z=v1.z/v2.z;
 return v;
}

double xwinkel(Vektor3d v)		//Winkel zwischen Vektor und x-Achse
{return atan2(sqrt(v.z*v.z+v.y*v.y),v.x);}	//kommt im Bereich +-PI heraus

Vektor3d vektorkreuzprodukt(Vektor3d b,Vektor3d a)	//Kreuzprodukt
{
 Vektor3d v;
 v.x =  b.y*a.z-b.z*a.y;
 v.y = -b.x*a.z+b.z*a.x;
 v.z =  b.x*a.y-b.y*a.x;
 return v;
}

Vektor3d sin(Vektor3d a) {Vektor3d v(sin(a.x),sin(a.y),sin(a.z)); return v;}
Vektor3d cos(Vektor3d a) {Vektor3d v(cos(a.x),cos(a.y),cos(a.z)); return v;}
Vektor3d tan(Vektor3d a) {Vektor3d v(tan(a.x),tan(a.y),tan(a.z)); return v;}
Vektor3d asin(Vektor3d a) {Vektor3d v(asin(a.x),asin(a.y),asin(a.z));return v;}
Vektor3d acos(Vektor3d a) {Vektor3d v(acos(a.x),acos(a.y),acos(a.z));return v;}
Vektor3d atan(Vektor3d a) {Vektor3d v(atan(a.x),atan(a.y),atan(a.z));return v;}
Vektor3d sqrt(Vektor3d a) {Vektor3d v(sqrt(a.x),sqrt(a.y),sqrt(a.z));return v;}
Vektor3d log(Vektor3d a) {Vektor3d v(log(a.x),log(a.y),log(a.z));return v;}
Vektor3d log10(Vektor3d a)
	{Vektor3d v(log10(a.x),log10(a.y),log10(a.z));return v;}
Vektor3d exp(Vektor3d a) {Vektor3d v(exp(a.x),exp(a.y),exp(a.z));return v;}
Vektor3d pow(double b,Vektor3d a)
	{Vektor3d v(pow(b,a.x),pow(b,a.y),pow(b,a.z));return v;}
Vektor3d pow(Vektor3d b,Vektor3d a)
	{Vektor3d v(pow(b.x,a.x),pow(b.y,a.y),pow(b.z,a.z));return v;}

double vektorwinkel(Vektor3d v1,Vektor3d v2)	//Winkel zwischen 2 Vektoren
{
 double sina=abs(vektorkreuzprodukt(v1,v2))/(abs(v1)*abs(v2));
 return asin(sina);
}
double sinvektorwinkel(Vektor3d v1,Vektor3d v2)	//sin(Winkel) zw. 2 Vektoren
{
 double sina=abs(vektorkreuzprodukt(v1,v2))/(abs(v1)*abs(v2));
 return sina;
}

void Vektor3d::drehenxy(double sina,double cosa)
{					//Vektor in xy-Ebene
 double h=x*cosa-y*sina;		//im gegenuhrzeigersinn drehen
 y=x*sina+y*cosa; x=h;
}
void Vektor3d::drehenyx(double sina,double cosa)
{					//Vektor in xy-Ebene
 double h=x*cosa+y*sina;		//im uhrzeigersinn drehen
 y=y*cosa-x*sina; x=h;
}
void Vektor3d::drehenzx(double sina,double cosa)
{					//Vektor in zx-Ebene drehen
 double h=z*cosa-x*sina;
 x=z*sina+x*cosa; z=h;
}
void Vektor3d::drehenxz(double sina,double cosa)
{
 double h=z*cosa+x*sina;
 x=x*cosa-z*sina; z=h;
}
void Vektor3d::drehenyz(double sina,double cosa)
{					//Vektor in yz-Ebene drehen
 double h=y*cosa-z*sina;
 z=y*sina+z*cosa; y=h;
}
void Vektor3d::drehenzy(double sina,double cosa)
{
 double h=y*cosa+z*sina;
 z=z*cosa-y*sina; y=h;
}

/** weiss noch nicht wie machen:
double vektorwinkelv(Vektor3d v1,Vektor3d v2)	//Winkel zwischen 2 Vektoren
{						//mit Vorzeichen
}
vektor vektordrehen(Vektor3d v,double w,Vektor3d axe) //v um Winkel w drehen
{						//um die Drehachse axe
						//im Uhrzeigersinn
 Vektor3d vneu;
 return vneu;
}
**/

double sinwinkel_zwischen_vektor_und_flaeche
	(Vektor3d v,Vektor3d p2,Vektor3d p3)
{
 double sina,cosa,wu,wu2;
 // 1.Drehung so dass p2 auf xz-Ebene zu liegen kommt:
 wu=sqrt(wu2=p2.x*p2.x+p2.y*p2.y);
 sina=p2.y/wu; cosa=p2.x/wu;
 v.drehenyx(sina,cosa);
 p2.x=wu; p2.y=0;
 p3.drehenyx(sina,cosa);
 // 2.Drehung so dass p2 auf x-Achse zu liegen kommt:
 wu=sqrt(wu2+p2.z*p2.z);
 sina=p2.z/wu; cosa=p2.x/wu;
 v.drehenzx(sina,cosa);
 p3.drehenzx(sina,cosa);
 // 3.Drehung so dass p3 auf xy-Flaeche zu liegen kommt:
 wu=sqrt(p3.y*p3.y+p3.z*p3.z);
 sina=p3.z/wu; cosa=p3.y/wu;
 v.drehenzy(sina,cosa);
 // Der gesuchte Winkel ist jetzt der Winkel von v auf xy-Ebene:
 return abs(v.z)/abs(v);
}

double winkel_zwischen_vektor_und_flaeche
	(Vektor3d v,Vektor3d p1,Vektor3d p2,Vektor3d p3)
{
 return asin(sinwinkel_zwischen_vektor_und_flaeche(v-p1,p2-p1,p3-p1));
}
#endif
