/* xyshow.c					letzte Aenderung: 22.1.2007 */
#define VERSION "Version 1.4"
/* xy-Dateien anzeigen
Uebersetzen:
;AVAX> CX xyshow
;AVAX> BLINK xyshow,[PFISTER.OBJ]SHOWIT,XMENU
Linux, MacOSX, ...> make

History:
3.9.1992 Version 0.0	Erstellung (RPf)
4.5.94	1.0		Anpassung an neues Showit
16.5.95	1.01		Unterstuetzung von xy-Format ohne Kopf
			Umrechnung in cm-1 eingefgt
6.10.95	1.1		Format xydata11 angefgt
1.7.96	1.2		File-Ende Erkennung bei ^Z
			Abfrage nach Zwischenwert-methode bei primitivem Format
1.12.2003  1.3		Anpassung fuer absteigende x-Werte
			geht aber offensichtlich trotzdem nicht, Notloesung:
			> umkehr name.xy name2.xy
1.12.2004		get_punkt() jetzt ausgewertet (fuer Peaksuche)
6.1.2006		Verbose-Flag eingefuegt
16.1.2007  1.4		Fehlerkorrekturen: nx konsistent Anzahl x-Stuetzpunkte
			Ruekwaertsanordnung geht jetzt auch
			zustzliche Option fr TMS-Peak-Korrektur
19.1.07			Verbesserungen in incmumrechnen()
22.1.07			Korrekturen in Formaten mit Kopfdaten
*/

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#define MAXARG 1
long idfix(double x) {return (x>=0.)?x+0.5:x-0.5;}
#include <stdlib.h>
#include <string.h>
#define cfree free
#include <ulong.h>
#include <showit.h>

#define CONTROLZ 0x1A

/************************ Vordeklarationen *******************************/
int getline(FILE *fp,char *s,int lim);
int nextc(FILE *fp);
FILE *neuoeffnen(FILE *fp,char *name);
void incmumrechnen(float **feld,int *npkt,float *xmin,float *xmax);
int starkverschieden(double a,double b);
double tmspeaksuchen(FILE *fp);

/*************************** globale Parameter ************************/
char quelle[80],argflag['Z'+1];
int nspektren=1;
FILE *fpw=NULL;/* fuer ausgemessene Punkte und Integrale */

void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

/***************************** Hauptprogramm **************************/
main(int argc,char *argv[])
{
 int i,j,nx,c;
 FILE *fp;
 int npoints,modus,rueckflag=0,syist1=0;
 float xmin,ymin,xmax,ymax, *feld, *hilfsfeld,h,*fe;
 double dx,dy,sy,y0,x,y,shift=0.;
 char str[80];
 for(quelle[0]=0,j=0,i=1;i<argc;i++)
   {if((c= *argv[i])=='-' || c=='?') setflags(argv[i]);
    else {if(++j==1) strcpy(quelle,argv[i]);
    }    }
 if(argflag['?'] || j>MAXARG)
	{printf("xyshow  %s\n",VERSION);
	 printf("Anwendung: xyshow Datei [-Flags]\n");
	 printf("   Flags: R=Rckwrts  S=Skalierung\n");
	 printf("          C=von nm in cm-1 umrechnen\n");
	 printf("          G=Grenzen neu setzen\n");
	 printf("          A=alles Automatisch\n");
	 printf("          H=Hilfe fr Dateiformat\n");
	 printf("          V=Verbose, also mit Testausdrucken\n");
	 printf("          T=TMS-Peak suchen, Grenzen automatisch neu setzen\n");
	 exit(0);
	}
 if(argflag['H'])
  {printf("xyshow  %s\n",VERSION);
   printf("Bisher untersttzte Dateiformate:\n\n");
   printf(" Primitives Format:\n");
   printf("  x1 y1  x2 y2  ...\n\n");
   printf(" Primitives Format mit Grenzwertangabe:\n");
   printf("  xmin=.. xmax=.. nx=..\n");
   printf("  ymin=.. ymax=.. dy=..\n");
   printf("  x1 y1  x2 y2  ...\n");
   printf(" Fr ymax sollte eine Zahl grsser als maximaler Eingabewert,\n");
   printf(" fr ymin eine Zahl kleiner minimaler Eingabewert,\n");
   printf(" und fr dy die Differenz ymax-ymin gewhlt werden.\n");
   printf(" Wenn die y-Eingabewerte umgerechnet werden sollen, kann man ymin\n");
   printf(" und dy entsprechend verndern (z.B. bei eingescannten Kurven)\n");
   printf(" \n");
   printf(" Gekennzeichnetes Format:\n");
   printf("  xydata11   ;Kommentar hinter Strichpunkt\n");
   printf("  xmin=.. xmax=.. nx=..\n");
   printf("  ymin=.. ymax=.. dy=..\n");
   printf("  nkurven    ;Anzahl Kurven (ganze Zahl)\n");
   printf("  npu1       ;Anzahl Punktepaare\n");
   printf("  x1 y1  x2 y2  ...\n");
   printf("  npu2       ;Anzahl Punktepaare der zweiten Kurve\n");
   printf("  x1 y1  x2 y2  ...\n");
   printf("  ...\n");
   printf(" nx darf auch grsser sein als wirklich vorhandene Punkte.\n");
   exit(0);
  }
 if(quelle[0]==0) {printf("Datei:"); scanf("%s",quelle);}
 if((fp=fopen(quelle,"r"))==NULL)
        {printf("'%s' nicht gefunden\n",quelle); exit(1);}
 getline(fp,str,80);
 if(strncmp(str,"xmin=",5)==0) /* Datei mit Kopfdaten */
 {sscanf(str,"xmin=%f xmax=%f %*cx=%d",&xmin,&xmax,&nx);
  fscanf(fp,"\nymin=%f ymax=%f %*cy=%lf",&ymin,&ymax,&dy);
  if(nx<2 || dy==0) {printf("Fehlerhafte Kopfdaten.\n"); exit(1);}
  dx=(xmax-xmin)/(nx-1); sy=(ymax-ymin)/dy;
  if(!argflag['A'] || argflag['V'])
   {printf("xmin=%f xmax=%f ymin=%f ymax=%f\n",xmin,xmax,ymin,ymax);
    printf("nx=%d dy=%lg\n",nx,dy);
    if(argflag['V']) printf("dx=%lf sy=%lf\n",dx,sy);
   }
  feld=(float *)calloc(nx,sizeof(float));
  if(feld==NULL) {printf("zu wenig RAM\n"); fclose(fp); exit(1);}
  for(i=0;i<nx;i++) feld[i]=0.0;
  if(sy<1.001 && sy>0.999) syist1=1;
  for(c=getc(fp);c!=EOF && c!=CONTROLZ;)
	{ungetc(c,fp);
	 if(fscanf(fp,"%lf%*c%lf",&x,&y)!=2)
	   {printf("Fehler bei fscanf()\n"); break;}
	 if(!syist1) y=sy*(y-ymin);
	 j=idfix((x-xmin)/dx);
	 if(j>=0 && j<nx) feld[j]=y;
	 else printf("Fehler in Datensatz: x=%lf y=%lf\n",x,y);
	 //if(argflag['V']) printf("j=%d x=%lf y=%lf\n",j,x,y);//test
	 do {c=getc(fp); if(c==EOF) break;} while(isspace(c));
	}
  if(!syist1) {ymax=(ymax-ymin)*sy; ymin=0.0;}
 }
 else if(strncmp(str,"xydata11",8)==0) /* erweiterte Kopfdaten */
 {int npunktpaar,nxtotal,nsp,j1,n1,n2;
  double yvorher;
  getline(fp,str,80); sscanf(str,"xmin=%f xmax=%f %*cx=%d",&xmin,&xmax,&nx);
  getline(fp,str,80); sscanf(str,"ymin=%f ymax=%f %*cy=%lf",&ymin,&ymax,&dy);
/*  getline(fp,str,80); sscanf(str,"mark='%c'",&mark);*/
  if(nx<2 || dy==0) {printf("Fehlerhafte Kopfdaten.\n"); exit(1);}
  dx=(xmax-xmin)/(nx-1); sy=(ymax-ymin)/dy;
  if(!argflag['A'] || argflag['V'])
   {printf("xmin=%f xmax=%f ymin=%f ymax=%f\n",xmin,xmax,ymin,ymax);
    printf("nx=%d dy=%lg\n",nx,dy);
    if(argflag['V']) printf("dx=%lf sy=%lf\n",dx,sy);
   }
  do getline(fp,str,80); while(*str==';' || *str=='\n');
  sscanf(str,"%d",&nspektren);
  if(nspektren<1)
    {printf("Fehlerhafte Kopfdaten: nspektren muss >=1 sein.\n"); exit(1);}
  feld=(float *)calloc(nxtotal=nx*nspektren,sizeof(float));
  if(feld==NULL) {printf("zu wenig RAM\n"); fclose(fp); exit(1);}
  for(i=0;i<nxtotal;i++) feld[i]=0.0;
  if(sy<1.001 && sy>0.999) syist1=1;
  for(nsp=0;nsp<nspektren;nsp++)
   {do getline(fp,str,80); while(*str==';' || *str<' ');
    if(argflag['V']) printf("%s\n",str);/*test*/
    sscanf(str,"%d",&npunktpaar);
    if(argflag['V']) printf("nspektren=%d nsp=%d npunktpaar=%d\n",
			    nspektren,nsp,npunktpaar);/*test*/
    for(fe= &feld[nsp*nx],yvorher=0.,j1=i=0;i<npunktpaar;i++,yvorher=y)
	{do c=getc(fp); while(isspace(c));
	 ungetc(c,fp);
	 fscanf(fp,"%lf%*c%lf",&x,&y);
	 if(!syist1) y=sy*(y-ymin);
	 j=idfix((x-xmin)/dx);
	 //if(argflag['V']) printf("j=%d x=%lf y=%lf\n",j,x,y);//test
	 if(j>=0 && j<nx)
		{for(n2=1,n1=j-j1; j1<j; n2++,n1--)
			 fe[j1++]=(yvorher*n1+y*n2)/(n1+n2);
		 fe[j1++]=y;
		}
	 else printf("Ausserhalb des definierten Bereichs: x=%lf y=%lf\n",x,y);
	}
    //while(j1<nx) fe[j1++]=y; /*test*/
   }
  if(!syist1) {ymax=(ymax-ymin)*sy; ymin=0.0;}
 }
 else if(strncmp(str,"xydata",6)==0)
 {printf("xyshow untersttzt Format '%s' nicht. Siehe xyshow -h\n",str);
  exit(1);
 }
 else /* xy-Format ohne Kopfdaten */
 {double dx,deltax=0.0,sumdx=0.0,dxmin,dxmax;
  double firstx,newx;/* leichte optimierung */
  int methode=1,starkflag=0;
  fp=neuoeffnen(fp,quelle);
  for(nx=0;(c=nextc(fp))!=EOF && c!=CONTROLZ;nx++,newx=x)
	{ungetc(c,fp);
	 fscanf(fp,"%lf%*c%lf",&x,&y);
	 if(nx==0)
	  {xmin=xmax=x; ymin=ymax=y; firstx=x;}
	 else if(nx==1)
	  {dxmin=dxmax=x-firstx;}
	 else
	  {if(x<xmin) xmin=x; else if(x>xmax) xmax=x;
	   if(y<ymin) ymin=y; else if(y>ymax) ymax=y;
	   if((dx=x-newx)<dxmin) dxmin=dx;
	   else if(dx>dxmax) dxmax=dx;
	  }
	}
  if(nx<2) {printf("Datei enthaelt zu wenig Punktpaare.\n"); exit(1);}
  if(starkverschieden(dxmin,dxmax))
    {printf("Es werden konstante x-Abstaende vorausgesetzt. nx erhoehen.\n");
     starkflag=1;
    }
  sumdx=newx-firstx;
  if(sumdx<0) {sumdx= -sumdx; rueckflag=1;}
  deltax=sumdx/(nx-1);
  fp=neuoeffnen(fp,quelle);
  nx=idfix((xmax-xmin)/deltax)+1;
  if(!argflag['A'] || argflag['V'])
   {printf("xmin=%f xmax=%f  ymin=%f ymax=%f\n",xmin,xmax,ymin,ymax);
    printf("nx=%d\n",nx);
   }
  if(argflag['T'])
   {shift= -tmspeaksuchen(fp);
    if(argflag['V']) printf("TMS-Peak bei %lf\n",-shift);
    xmin += shift; xmax += shift;
    fp=neuoeffnen(fp,quelle);
   }
  else if(argflag['G'] && !argflag['C'])
   {printf("Verschieben in x-Richtung:"); scanf("%lf",&shift);
    if(!argflag['A'])
     {printf("neue Grenzen eingeben (Verschiebung beruecksichtigt)\n\txmin:");
      scanf("%f",&xmin);
      printf("\txmax:"); scanf("%f",&xmax);
     }
    else
     {xmin += shift; xmax += shift;}
    nx=idfix((xmax-xmin)/deltax)+1;
    if(argflag['V']) printf("neu berechnetes nx=%d\n",nx);
   }
  if(starkflag && !argflag['A'])
   {printf("neues nx:"); scanf("%d",&nx);
    printf("Methode fuer Berechnung von Zwischenwerten:\n");
    printf(" 0 = Zwischenwerte auf 0.0 setzen\n");
    printf(" 1 = lineare Interpolation\n");
    printf(" 2 = Treppen\n");
    printf("Methode:"); scanf("%d",&methode);
    if(methode<0 || methode>2) methode=1;//ungueltige Methode korrigieren
   }
  if(nx<2) {printf("Error nx=%d - should be >=2\n",nx); exit(1);}//test
  dx=(xmax-xmin)/(nx-1);
  if(argflag['V']) printf("dx=%lf\n",dx);/* test */
  feld=(float *)calloc(nx,sizeof(float));
  if(feld==NULL) {printf("zu wenig RAM\n"); fclose(fp); exit(1);}
  if(methode==0) for(i=0;i<nx;i++) feld[i]=0.;
  for(c=getc(fp),i=(rueckflag==1)?nx-1:0;c!=EOF && c!=CONTROLZ;)
	{ungetc(c,fp);
	 fscanf(fp,"%lf%*c%lf",&x,&y); x+=shift;
	 j=idfix((x-xmin)/dx);
	 if(methode==0)
		{if(j>=0 && j<nx) feld[j]=y;}
	 else if(methode==1)
	       {if(rueckflag==0)
		  {if(i!=j)
		    {y0=(i>0)?feld[i-1]:0.; dy=(y-y0)/(j-(i-1));
		     while(i<j && i<nx) {feld[i++]=(y0+=dy);}
		    }
		   if(i==j && i<nx) feld[i++]=y;
		  }
	        else /*if(rueckflag==1)*/
		  {if(i!=j)
		    {y0=(i<nx-1)?feld[i+1]:0.; dy=(y-y0)/((i+1)-j);
		     while(i>j && i>=0) {feld[i--]=(y0+=dy);}
		    }
		   if(i==j && i>=0) feld[i--]=y;
	       }  }
	 else /*if(methode==2)*/
	       {if(rueckflag==0)
			{while(i<=j && i<nx) feld[i++]=y;}
	        else	{while(i>=j && i>=0) feld[i--]=y;}
	       }
	 do c=getc(fp); while(isspace(c));
	}
 }
 fclose(fp);
 npoints=nx; modus=3;
 if((argflag['R'] && rueckflag==0) || (!argflag['R'] && rueckflag==1))
   {for(i=0,j=nx-1;i<j;i++,j--) {h=feld[i]; feld[i]=feld[j]; feld[j]=h;}
    h=xmin; xmin=xmax; xmax=h;
   }
 if(argflag['S'])
   {double faktor; float fakt;
    printf("Skalierungsfaktor:"); scanf("%lf",&faktor); fakt=faktor;
    if(faktor!=0. && faktor!=1.) yskalierung(&fakt);
   }
 if(argflag['C']) incmumrechnen(&feld,&npoints,&xmin,&xmax);
 if(nspektren>=2)
	{if(nspektren==2) modus=4; else modus=4+nspektren;
	 hilfsfeld = &feld[nx];
	}
 else	{modus=3; hilfsfeld=NULL;
	}
 showit(&xmin,&ymin,&xmax,&ymax,&npoints,&modus,feld,hilfsfeld);
}/* ende von main */

void file_exit()
{
 if(fpw!=NULL) fclose(fpw);
 exit(0);
}
void file_load() {}
void file_save() {}

FILE *fopen_xyshowdat()
{
 FILE *fp;
 fp=fopen("xyshow.dat","w");
 if(fp==NULL) printf("Fehler beim Oeffnen von 'xyshow.dat'\n");
 else fprintf(fp,"%s\n",quelle); //quelle ist aktueller Filename
 return fp;
}

void get_punkt(float *x,float *y)
{
 printf("GetPoint: x=%lg  y=%lg\n",*x,*y);
 if(fpw==NULL) {if((fpw=fopen_xyshowdat())==NULL) return;}
 fprintf(fpw,"x=%lg  y=%lg\n",*x,*y);
}

void int_save(float *z,float *xspitz,float *yspitz,float grenz[]) //float grenz[4];
{
 static int titelflag=1;
 printf("%lg bis %lg  Integral=%lg  Maximum: x=%lg  y=%lg\n",
	grenz[0],grenz[2],*z,*xspitz,*yspitz);
 printf("Integral: %lg\n",*z);
 if(fpw==NULL)
   {if((fpw=fopen_xyshowdat())==NULL) return;}
 if(titelflag)
   {fprintf(fpw," Integrierter Bereich      Integral     Spitze        y\n");
    titelflag=0;
   }
 fprintf(fpw,"%lg bis %lg    %lg    x=%lg    y=%lg\n",
	grenz[0],grenz[2],*z,*xspitz,*yspitz);
}

void texte_laden(titel,xachse,yachse) char **titel,**xachse,**yachse; {}
void get_delta(z,grenz) float *z,grenz[4]; {}

void user_prog(fun,p1,p2,p3,p4)  int *fun; POINTER p1,p2,p3,p4;
{
 switch(*fun)	{ case 1: case 2: int_save(p1,p2,p3,p4); break;
			  case 3: case 4: get_punkt(p1,p2); break;
			  case 5: texte_laden(p1,p2,p3); break;
			  case 6: get_delta(p1,p2); break;
		}
}

void incmumrechnen(float **feld,int *npkt,float *xmin,float *xmax)
{
 float *neufeld,*altfeld;
 int nx,j,i,i2;
 double x1,y1,x2,y2,a,b,d,x,A,B,D;
 altfeld= *feld;
 a= *xmin; b= *xmax; d=(a-b)/((*npkt)-1);
 if(argflag['V']) printf("a=%lf b=%lf d=%lf npkt=%d\n",a,b,d,*npkt);//test
 A=1e7/a; B=1e7/b;
 if(argflag['G'])
  {printf("Grenzen: xmin=%lf xmax=%lf\n",A,B);
   printf("neue Grenzen eingeben:\n\txmin:"); scanf("%lf",&A);
   printf("\txmax:"); scanf("%lf",&B);
  }
 if(a>b) D=1e7/(a-d)-1e7/a;
 else    D=1e7/b-1e7/(b+d);
 if(D>1.0 || D<-1.0) D=(int)D;
 nx=(int)((B-A)/D+0.5)+1;
 B=A+(nx-1)*D;
 if(argflag['V']) printf("A=%lf B=%lf D=%lf nx=%d\n",A,B,D,nx);//test
 neufeld=(float *)calloc(nx,sizeof(float));
 for(j=0;j<nx;j++)
        {i=x=(a-1e7/(A+j*D))/d; i2=i+1;
         if(i<0 || i2>=(*npkt)) neufeld[j]=0.;
         else neufeld[j]=altfeld[i]+(altfeld[i2]-altfeld[i])*(x-i);
        }
 *xmin=A;
 *xmax=B;
 *npkt=nx;
 cfree(altfeld);
 *feld=neufeld;
}

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{               /* liest eine Textzeile oder maximal lim Zeichen */
                /* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
        *s++ = c;
 *s='\0';
 return (c!=EOF);       /* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

int nextc(FILE *fp)
{
 int c;
 while((c=getc(fp))!=EOF && isspace(c)) ;
 return c;
}

FILE *neuoeffnen(FILE *fp,char *name)
{
 fclose(fp);
 if((fp=fopen(name,"r"))==NULL)
        {printf("kann '%s' nicht mehr finden\n",name); exit(1);}
 return fp;
}

int starkverschieden(double a,double b)
{
 double v;
 if(a==b) return 0;
 if(a==0 || b==0) return 1;
 if((v=a/b)<0.9 || v>1.1) return 1;
 return 0;
}

double tmspeaksuchen(FILE *fp)
{
 double x,y,ymax,xmax=0.0;
 int c,n;
 for(n=0;(c=nextc(fp))!=EOF && c!=CONTROLZ;)
	{ungetc(c,fp);
	 fscanf(fp,"%lf%*c%lf",&x,&y);
	 if(x> -0.5 && x<0.5)
	   {if(n==0 || y>ymax) {ymax=y; xmax=x;}
	    n++;
	   }
	}
 return xmax;
}
