/* iu.c			letzte Aenderung: 1.2.2006 */
#define VERSION "Version 0.0"
/*
 Kurzbeschreibung: von ISO-8859-1 nach UTF-8 konvertieren

History:
1.2.2006	Erstellung (RP)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/************************* Vordeklarationen ***************************/
void iu(FILE *fp1,FILE *fp2);
void iu2(FILE *fp1,FILE *fp2);
void ui(FILE *fp1,FILE *fp2);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("iu  %s\n",VERSION);
	 printf("Anwendung: iu Quelle [Ziel] [-Flags]\n");
	 printf(" Flags: R=Rueckwaerts, also utf-8 nach iso-latin1\n");
	 printf("        S=Simpler Algorithmus\n");
	 printf(" ohne Flags: bereits gueltige utf-8 Zeichen bleiben\n");
	 exit(0);
	}
 if(*quellname==0) {printf("Quellname:"); scanf("%s",quellname);}
 if(*zielname==0)  {printf("Zielname:"); scanf("%s",zielname);}
 if(fp1=fopen(quellname,"r")) ;
 else {printf("Datei '%s' nicht gefunden\n",quellname); exit(0);}
 if(fp2=fopen(zielname,"r"))
   {printf("Datei '%s' schon vorhanden\n",zielname);
    fclose(fp1); fclose(fp2); exit(0);
   }
 if((fp2=fopen(zielname,"w"))==NULL)
   {printf("konnte '%s' nicht erstellen\n",zielname); fclose(fp1); exit(0);}
 if(argflag['R']) ui(fp1,fp2);
 else if(argflag['S']) iu(fp1,fp2);
 else iu2(fp1,fp2);
 fclose(fp1);
 fclose(fp2);
 return 0;
}/* ende von main */

void iu(FILE *fp1,FILE *fp2) //simple Codierung von iso-8859-1 nach utf-8
{
 int c,c1,c2;
 while((c=getc(fp1))!=EOF)
   {if((c&0x80)==0) putc(c,fp2);
    else
      {c1=0xC0+((c&0xC0)>>6);
       c2=0x80+(c&0x3F);
       putc(c1,fp2); putc(c2,fp2);
      }
   }
}

void ui(FILE *fp1,FILE *fp2) //Codierung von utf-8 nach iso-8859-1
{
 int c,a1;
 while((c=getc(fp1))!=EOF)
   {a1=EOF;
    if((c==0xC2 || c==0xC3) && (a1=getc(fp1))!=EOF && (a1&0xC0)==0x80)
      {c=(a1&0x3F)+((c&0x03)<<6);
       putc(c,fp2);
      }
    else
     {if(a1!=EOF) ungetc(a1,fp1);
      putc(c,fp2);
     }
   }
}

/* Codierung von iso-8859-1 nach utf-8 unter
   Beibehaltung schon vorhandener utf-8 Zeichen */
void iu2(FILE *fp1,FILE *fp2)
{
 int c,c1,c2,a1,a2,a3;
 while((c=getc(fp1))!=EOF)
   {if((c&0x80)==0) putc(c,fp2); //gewoehnliches Zeichen unveraendert
    else //Sonderzeichen eventuell konvertieren
      {a1=a2=a3=EOF;
       c1=0xC0+((c&0xC0)>>6); c2=0x80+(c&0x3F); //schon mal konvertieren
       if((c&0xC0)!=0xC0)              //einzelnes Zeichen ist kein utf-8
	 {putc(c1,fp2); putc(c2,fp2);} //also konvertiertes speichern
       else if((a1=getc(fp1))==EOF || (a1&0xC0)!=0x80)               //kein gueltiges Folgezeichen
	 {putc(c1,fp2); putc(c2,fp2); if(a1!=EOF) ungetc(a1,fp1);}   //also konvertiertes speichern
       else if((c&0xE0)==0xC0)          //gueltiges 2 Byte utf-8 Zeichen
	 {putc(c,fp2); putc(a1,fp2);} //also unveraendert kopieren
       else if((c&0xF0)==0xE0 && (a2=getc(fp1))!=EOF && (a2&0xC0)==0x80) //gueltiges 3 Byte utf-8 Zeichen
	 {putc(c,fp2); putc(a1,fp2); putc(a2,fp2);}                    //also unveraendert kopieren
       else if((c&0xF8)==0xF0 && (a2=getc(fp1))!=EOF && (a2&0xC0)==0x80
	                      && (a3=getc(fp1))!=EOF && (a3&0xC0)==0x80) //gueltiges 4 Byte utf-8 Zeichen
	 {putc(c,fp2); putc(a1,fp2); putc(a2,fp2); putc(a3,fp2);}        //also unveraendert kopieren
       else //andernfalls kein gueltiges utf-8 Zeichen
	 {if(a3!=EOF) ungetc(a3,fp1); //allfaellige schon geholte Zeichen
	  if(a2!=EOF) ungetc(a2,fp1); //wieder zurueckgeben
	  if(a1!=EOF) ungetc(a1,fp1);
	  putc(c1,fp2); putc(c2,fp2); //konvertiertes Zeichen speichern
	 }
      }
   }
}
