/* mgcalculor.cpp (mg.cc)		letzte Aenderung: 26.1.2022 */
#define VERSION "2.06"
/*
Verwendung:
Nach Eingabe einer Formel wird das Molekulargewicht auf 3 Nachkommastellen
genau berechnet.
Beispiele:
> mg CH3-CH2-OH  -->  46.069
> mg -i CH3-CH2-OH  -->  46.042
> mg "CH3-(CH2)2-OH" --> 60.096
> mg Boc-Ala-Aib-OMe --> 288.344

History:
Datum      Version  Kommentar
15.9.1994  1.4	Erstellung (RPF)
25.9.2001	Anpassung zur Verwendung als cgi-Programm
31.5.2002  1.5	Filter um QUERY-STRING anzupassen (z.B. "%28" in "(" wandeln)
18.6.2003	Erkennung von Aminosaeuren-Abk. in Kette (Ala, Gly ...)
		aber Vorsicht bei Anwendung: z.B. Boc-Ala-Gly-OH
		oder fuer freies Alanin: H-Ala-OH
28.1.2004	auch noch Pz Schutzgruppe
16.2.2004  1.6  Z-Schutzgruppe
27.2.		Korrigiert fuer PZ (auch Schutzgruppe und nicht Phosphor-Z)
		und auch noch Mz-Schutzgruppe
18.8.04 	Schutzgruppe Z Kommentar korrigiert
19.8.04 	Neue Abkuerzungen: Bu, Fmoc
8.2.06 	   1.7	Fehlerkorrekturen: bei 35Cl (35.96885 --> 34.96885)
                bei 28Si (28.0855 --> 27.9769)
15.9.06    1.8  Peptidabkuerzungen 1-Buchstabenvarianten mit ~ (Tilde)
                dabei auch gleich noch allfaellige Leerzeichen geloescht.
		Neue Abkuerzung Ace fuer Acetyl.
20.9.06		Neu auch Test auf fehlende oeffnende Klammer.
3.10.06    1.9  Erkennung von Isotopenmarkierungen (z.B. ^13C ^18O)
		Trick um groessere Isotopenmarkierte Substanzen zu berechnen:
		z.B. in Boc-Ala-Gly-Ala*^13C-Aib-OMe soll das kein
		zusaetzliches C sein, sondern ein C im Ala ist markiert.
		Das Programm erkennt also die Sequenz *^
12.10.06	sterndach() neu geschrieben (z.B. ^6Li und ^206Pb geht jetzt)
		T=Tritium noch eingefuegt
4.10.10		Aha (Azidohomoalanin, Abk. J) wird jetzt auch erkannt
24.1.2012  2.0  Grosse Umstellungen in mgkern.c, so dass wir jetzt uebersichtliche
                Tabellen haben. Damit wird auch mol_wight_iso() ueberfluessig, statt 
		dessen noch in mol_weight() eine Variable isoflag eingefuegt.
		(Tippfehler wight statt weight korrigiert)
30.1.2012  2.01 Erweiterung fuer Summenformeln-Berechnungen. Nur verwendet wenn
                beim Compilieren -DSUMMENFORMELN mit angegeben wird.
1.2.2012   2.02 Verbesserungen vor allem in mgkern.c  Jetzt bis Element Cn (112)
                Option angefuegt zum auch Summenformeln berechnen
5.12.      2.03 Option angefuegt fuer Peptide mit Seitenketten-Schutzgruppen
19.11.2015 2.04 Fehlermeldungen in mgkern.c korrigiert
5.1.2022   2.05 Anpassungen fuer Benutzung auch mit Windows
8.1.2022   2.06 Anpassungen fuer Cmake-Projekt, fuer Windows mit "Visual Studio 2019"
                Neue Gruppen eingefuegt: Ampp, Bpy, Dmb
26.1.2022       Zeichen @ als Alternative zu ~

*/
#include "mgcalculator.h"

#ifdef SEITENKETTEN
extern int pflag; //Flag in mgkern.cc
#endif

/*************************** globale Parameter ************************/
char zeile[400],zeile2[1200];
char argflag['Z'+1];

void setflags(const char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  argflag[c]=1;}

void resetflags()
{
 for(int i=0;i<('Z'+1);i++) argflag[i]=0;
}

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void zeichen_ersetzen(char *str,char alt,char neu)
{
 for(;*str!=0;str++) {if(*str==alt) *str=neu;}
}

/***************************** Hauptprogramm **************************/
int main(int argc,const char *argv0[])
{
#ifdef _DEBUG
 printf("argc=%d argv[0]=\"%s\"\n",argc,argv0[0]);//test
#endif
 if(argc>1) return main2(argc,argv0);
 char str[400], *s;
 const char *argv[3];
 argv[0]=argv0[0];
 for(;;)
  {
   resetflags();
   printf("MG> "); getline(stdin,str,400);
   if(strcmp(str,"quit")==0 || strcmp(str,"exit")==0 || strcmp(str,"0")==0) return 0;
   if(strcmp(str,"help")==0 ||strcmp(str,"hilfe")==0) setflags("-h?");
   argc=2;
   argv[1]=str;
   for(s=str; *s>' '; s++) {}
   if(*s==' ')
    {
     while(*s==' ') {*s++ = 0;}
     if(*s!=0) {argv[2]=s; argc=3;}
    }
#ifdef _DEBUG
   printf("Testpunkt1: argv[0]=\"%s\" argv[1]=\"%s\" argv[2]=\"%s\"\n",argv[0],argv[1],argv[2]);//test
#endif
   main2(argc,argv);
  }
}

int main2(int argc,const char *argv[])
{
 double mg,mgiso=0;
 char *s,cstr[40];
 int i,j,nachkomma,n;
 for(zeile[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setflags(argv[i]);
   else switch(j++)
        {case 1:strcpy(zeile,argv[i]); break;
         default:break;
        }
 if(j>MAXARG+1 || zeile[0]=='?' || argflag['?'] || argflag['H'])
	{printf("mgcalculator Version %s\n",VERSION);
	 printf("Anwendung: mg [-Flags] [Formel]\n");
	 printf("  Flags: i=nur haeufigste Isotope verwenden\n");
	 printf("         d=nur Durchschnitt rechnen\n");
	 printf("         4=4 Nachkommastellen ausgeben\n");
#ifdef SUMMENFORMELN
	 printf("         s=Summenformel mit ausgeben\n");
#endif
#ifdef SEITENKETTEN
	 printf("         p=Peptide mit Seitenketten-Schutzgruppen\n");
#endif
	 if(argflag['H'])
	  {
	   //TODO: ausfuehrlichere Hilfe
	  }
	 return 0;
	}
 if(zeile[0]==0) {printf("Formel: ");scanf("%s",zeile);}
 zeichen_ersetzen(zeile,'@','~'); //falls Tilde fehlt kann auch @ verwendet werden
 for(i='9';i>'3';i--) if(argflag[i]) break;
 nachkomma=i-'0';
 if(argflag['I']) sprintf(cstr,"iso. Molgewicht=%%.%dlf\n",nachkomma);
 else if(argflag['D']) sprintf(cstr,"Molgewicht=%%.%dlf\n",nachkomma);
 else sprintf(cstr,"Molgewicht=%%.%dlf  (%%.%dlf Isotopenrein)\n",
	      nachkomma,nachkomma);
#ifdef SEITENKETTEN
 pflag=0;
 if(argflag['P']) setflags("S");
#endif
 for(;;)
  {
   char errstr[80],warnstr[80];
   error_reset(errstr,warnstr);
   formel_normieren(zeile,zeile2,400,1200);
   if(strcmp(zeile,zeile2)!=0) printf("Normierte Formel: %s\n",zeile2);
   if((n=klammertest(zeile2))!=0)
   printf("fehlende Klammer %s\n",n<0?"auf":"zu");
   if(argflag['I']) mg=mol_weight(zeile2,&s,ISO);
   else if(argflag['D']) mg=mol_weight(zeile2,&s,0);
   else {mg=mol_weight(zeile2,&s,0); mgiso=mol_weight(zeile2,&s,ISO);}
   if(get_actinium_warnung()!=0) printf("Hinweis: Ac = Actinium, Ace = Acetyl\n");
   if(*warnstr) printf("%s\n",warnstr);
   if(*errstr)  printf("Error: %s\n",errstr);
   printf(cstr,mg,mgiso);
#ifdef SUMMENFORMELN
   if(argflag['S'])
    {char *summenformel;
     error_reset(errstr,warnstr);
     summenformel=getsummenformel(zeile,NULL);
     if(*warnstr) printf("%s\n",warnstr);
     if(*errstr)  printf("Error: %s\n",errstr);
     printf("Summenformel: %s\n",summenformel);
     free(summenformel);
#ifdef SEITENKETTEN
     if(argflag['P'])
      {
       pflag=1;
       summenformel=getsummenformel(zeile,NULL);
       printf("Summenformel mit Seitenketten-Schutzgruppen: %s\n",summenformel);
       mg=mol_weight(summenformel,&s,0);
       mgiso=mol_weight(summenformel,&s,ISO);
       printf("MG mit Seitenketten-Schutzgruppen: "); printf(cstr,mg,mgiso);
       free(summenformel);
      }
#endif
    }
#endif
   if(j==1 && mg!=0.0)
    {
     printf("Formel: "); scanf("%s",zeile);
     zeichen_ersetzen(zeile,'@','~'); //falls Tilde fehlt kann auch @ verwendet werden
    }
   else break;
  }
 return 0;
}/* ende von main2 */
