// mgkern.h
#ifndef MGKERN_H
#define MGKERN_H

#define SEITENKETTEN  //Option fuer Peptide mit Seitenketten-Schutzgruppen
#define SUMMENFORMELN //Option fuer Summenformeln einfuegen

#ifndef __cplusplus
#ifndef bool
#define bool int
#endif
#endif

int klammertest(const char *text);
void formel_normieren(const char *quelle,char *ziel,int imax,int jmax);
double mol_weight(char* formel,char** zs,int isoflag);
double sterndach(char* formel,char** zs,int flags);
//erlaubte Werte fuer flags:
#define ISO 1
#define DACH 2

void error_reset(char *errstr,char *warnstr);
void fehler0(const char *text,int c);
void fehler1(const char *text);
void fehler2(const char *text1,const char *text2);
void set_actinium_warnung(void);
int get_actinium_warnung(void);
void warnung1(const char *text);

double calculate_mol_weight(const char *formel,int isoflag);

#ifdef SUMMENFORMELN
char *getsummenformel(const char *formel,const char **zs);
const char *getsummenformel_pep(const char *peptid);
void summesortieren(char *summenformel);
#endif

#endif
