/* sinus2.c  zweit-einfachstes Tekplot-Beispiel */

#include <stdio.h>
#include <math.h>
#ifdef WINDOWS
#include <wintekplot1.h>
#else
#include <xtekplot1.h>
#endif
#ifndef PI
//const double PI=4*atan(1.0);
#define PI (4.0*atan(1.0))
#endif

static int exitflag=0;
void m_exit() {exitflag=1;}
void m_fadenkreuz(),m_refresh(),m_hilfe();
void zeichnen(double xmin,double xmax,double dx,int flag);
static double gxmin,gxmax,gdx;//Globale Variablen

int main(int argc,char *argv[])
{
 double xmin=0, ymin= -1.0, xmax=3*PI, ymax=1.0, x,y,dx;
 int breite,hoehe,tiefe,visualklasse,i;
 setmenu(2,"File",      "Hilfe");
 setmenu(2,"Fadenkreuz","Hilfe",m_fadenkreuz,m_hilfe);
 setmenu(1,"Refresh",m_refresh);
 setmenu(1,"Exit",m_exit);
 getmaxsize(&breite,&hoehe,&tiefe,&visualklasse);
 //setsize(breite,hoehe,tiefe);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 dx=(xmax-xmin)/1000.;
 waitTOF();
 zeichnen(gxmin=xmin,gxmax=xmax,gdx=dx,0);
 term_refresh(); /* Zeichnen beenden */
 while(exitflag==0 && waitmenu(1)==0)
    ;//auf Benutzereingaben warten
 term_exit(); /* Grafikfenster schliessen */
}

void zeichnen(double xmin,double xmax,double dx,int flag)
{
 double x,y;
 if(flag) inital_new(0,0,0,0);
 rgbcolor(0x00,0x00,0x00);
 plot(xmin,sin(xmin),PENUP);
 for(x=xmin+dx;x<=xmax;x+=dx)
   {y=sin(x);
    plot(x,y,PENDOWN);
   }
 rgbcolor(0xFF,0x00,0x00);
 plot(xmin,cos(xmin),PENUP);
 for(x=xmin+dx;x<=xmax;x+=dx)
   {y=cos(x);
    plot(x,y,PENDOWN);
   }
 if(flag) term_refresh();
}

void m_refresh()
{
 zeichnen(gxmin,gxmax,gdx,1);
}

void m_hilfe()
{
 janeinrequester("Sinus und Cosinus-Kurven\n\
Mit Fadenkreuz sollte ein Punkt auslesbar sein.","ok",NULL);
}

void m_fadenkreuz()
{
 double x,y;
 tek_grein(&x,&y);
 printf("tek_grein() --> x=%lf y=%lf\n",x,y);
}
