/* wurfstatistik.cc			letzte nderung: 17.10.2005 */
#define VERSION "Version 0.01"
/*
 Kurzbeschreibung: Statistik beim Wuerfeln mit Zufallszahlen berechnen

History:
16.10.2005	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*********************** Zufallszahlen ***************************/
inline double random01()        // Zufallszahl zwischen 0. und 1.
{
 return (1. - rand()/(double)RAND_MAX);//Variante fuer VAX/ALPHA
}

double zufall(double y)  /* liefert Zufallszahl zwischen 0.0 und 1.0      */
{			 /* ergibt aber Streifen im Flchentest in rndcheck */
 static double x=1.3757;
 if(y!=0.) x=y;
 x=(100.+x)/(100.*(x-(long)(x))+0.7);
 y=10.*x;
 return (y-(long)(y));
}

double zufall3()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* ergibt aber Unregelmssigkeiten im Zombitest */
 static double x=1.7;
 double y;
 if(x==0.) x=1.7;
 if(x>100.) x=x/1163.;
 else x*=773.;
 y=10.*(x-(long)(x));
 return (y-(long)(y));
}

double zufall4()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double x=581;
 double y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

int wuerfeln()
{
 int k;
 k=int(zufall4()*6.0)+1;
 if(k==7) {k=6; printf("Test 7 abrunden\n");}
 return k;
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char anzwuerfel[80],anzversuche[80];
 FILE *fp1,*fp2;
 int i,j,c,nwuerfel,nversuche;
 anzwuerfel[0]=anzversuche[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(anzwuerfel,argv[i]);
		 else if(j==2) strcpy(anzversuche,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("wurfstatistik  %s\n",VERSION);
	 printf("Anwendung: wurfstatistik AnzahlWuerfel [AnzahlVersuche]\n");
	 exit(0);
	}
 printf("Es wird versucht mit n Wuerfeln in moeglichst wenig Wuerfen\n");
 printf("alles 6-er zu wuerfeln. Geworfene 6-er laesst man stehen,\n");
 printf("die andern Wuerfel wirft man nochmals.\n");
 if(*anzwuerfel==0) {printf("Anzahl Wuerfel:"); scanf("%s",anzwuerfel);}
 if(*anzversuche==0)  {printf("Anzahl Versuche:"); scanf("%s",anzversuche);}
 sscanf(anzwuerfel,"%d",&nwuerfel);
 sscanf(anzversuche,"%d",&nversuche);
 printf("Anzahl Wuerfel = %d\n",nwuerfel);
 printf("Anzahl Versuche= %d\n",nversuche);
 int wuerfel[nwuerfel],geworfen[6],flag,k,n;
 int anzahlgebrauchtewurfe[nversuche],nmin,nmax;
 int wurfhash[200];
 for(i=0;i<6;i++) geworfen[i]=0;
 for(i=0;i<200;i++) wurfhash[i]=0;
 for(j=0;j<nversuche;j++)
  {for(i=0;i<nwuerfel;i++)
     {wuerfel[i]=wuerfeln(); geworfen[wuerfel[i]-1]++;}
   for(n=0,flag=1;flag==1;n++)
     {for(k=0,flag=0;k<nwuerfel;k++)
	 if(wuerfel[k]!=6) {wuerfel[k]=wuerfeln(); flag=1;}
     }
   anzahlgebrauchtewurfe[j]=n;
   if(n<200) wurfhash[n]++;
  }
 for(j=0,n=0,nmin=1000,nmax=0;j<nversuche;j++)
   {n += anzahlgebrauchtewurfe[j];
    if(anzahlgebrauchtewurfe[j]<nmin) nmin=anzahlgebrauchtewurfe[j];
    if(anzahlgebrauchtewurfe[j]>nmax) nmax=anzahlgebrauchtewurfe[j];
   }
 printf("Minimaler Versuch: %d     Maximaler Versuch: %d\n",nmin,nmax);
 printf("Durchschnittliche Anzahl gebrauchte Wurfe fuer alles 6-er: %.2lf\n",
	double(n)/nversuche);
 for(i=0;i<100;i++)
   if(wurfhash[i]>0) printf("erfolgreich im %d.Versuch: %d = %.2lf\%\n",
			    i,wurfhash[i],wurfhash[i]*100.0/nversuche);
 printf("\nWuerfelstatistik:\n");
 for(i=0;i<6;i++)
     printf("%d: %02d mal geworfen\n",i,geworfen[i]);
 return 0;
}/* ende von main */
