/* yatzy.cc			letzte nderung: 24.10.2005 */
#define VERSION "Version 0.0"
/*
 Kurzbeschreibung: Yatzy-Spiel gegen den Computer

History:
23.10.2005	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>

/********************* Magische Zahlen ********************************/
const int BONUS1=65;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*********************** Zufallszahlen ***************************/
inline double random01()        // Zufallszahl zwischen 0. und 1.
{
 return (1. - rand()/(double)RAND_MAX);//Variante fuer VAX/ALPHA
}

double zufall(double y)  /* liefert Zufallszahl zwischen 0.0 und 1.0      */
{			 /* ergibt aber Streifen im Flchentest in rndcheck */
 static double x=1.3757;
 if(y!=0.) x=y;
 x=(100.+x)/(100.*(x-(long)(x))+0.7);
 y=10.*x;
 return (y-(long)(y));
}

double zufall3()	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* ergibt aber Unregelmssigkeiten im Zombitest */
 static double x=1.7;
 double y;
 if(x==0.) x=1.7;
 if(x>100.) x=x/1163.;
 else x*=773.;
 y=10.*(x-(long)(x));
 return (y-(long)(y));
}

double zufall4(double x0=0)	/* Zufallszahl zwischen 0.0 und 1.0 */
{			/* bisher bester Zufallsgenerator   */
 static double xreset=581,x=581;
 double y;
 if(x==0.) {x=xreset; printf("Warnung: Zufallsgenerator wurde rueckgesetzt\n");}
 if(x0!=0) x=x0;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

int wuerfeln()
{
 int k;
 k=int(zufall4()*6.0)+1;
 if(k==7) {k=6; printf("Test 7 abrunden\n");}
 return k;
}

/*************************** kleinkram ***************************/
void sortieren(int gew[],int hash[])
{
 int i,j,k,sortgew[6];
 for(i=1;i<=6;i++) hash[i]=0;
 for(i=0;i<5;i++) hash[gew[i]]++;
 for(i=6,j=0;i>=1;i--)
     for(k=0;k<hash[i];k++) gew[j++]=i;
}

/**************************** Klassen *********************************/
class Spielfeld
{
 char str1[40],str2[40];
public:
 char name1[20],name2[20];
 int men,com,punkte1[14],punkte2[14],bonus1,bonus2;
 Spielfeld() {for(int i=0;i<14;i++) punkte1[i]=punkte2[i]= -1;}
 void setnamen(char *n1,char *n2)
	{sprintf(name1,"%.19s",n1); sprintf(name2,"%.19s",n2);
	 if(name1[0]=='C') {com=1; men=2;} else {men=1; com=2;}
	}
 void zeichnen();
 char *txt1(int punkte)
   {if(punkte<0) return "..."; sprintf(str1,"%d",punkte); return str1;}
 char *txt2(int punkte)
   {if(punkte<0) return "..."; sprintf(str2,"%d",punkte); return str2;}
 void computerzug();
 void menschzug();
 void einsetzen(int wer,int nr,int gew[],int hash[],int nt);
 int eintragortsuchen(int wer,int gew[],int hash[],int *wert);
 void endauswertung();
};

void Spielfeld::zeichnen()
{
 int i,summe1,summe2;
 printf("Teil1            %20.20s %20.20s\n",name1,name2);
 printf("1. Einer         %20.3s %20.3s\n",txt1(punkte1[0]),txt2(punkte2[0]));
 printf("2. Zweier        %20.3s %20.3s\n",txt1(punkte1[1]),txt2(punkte2[1]));
 printf("3. Dreier        %20.3s %20.3s\n",txt1(punkte1[2]),txt2(punkte2[2]));
 printf("4. Vierer        %20.3s %20.3s\n",txt1(punkte1[3]),txt2(punkte2[3]));
 printf("5. Fuenfer       %20.3s %20.3s\n",txt1(punkte1[4]),txt2(punkte2[4]));
 printf("6. Sechser       %20.3s %20.3s\n",txt1(punkte1[5]),txt2(punkte2[5]));
 for(i=0,summe1=summe2=0;i<6;i++)
  {if(punkte1[i]>=0) summe1+=punkte1[i];if(punkte2[i]>=0) summe2+=punkte2[i];}
 printf("Zwischensumme    %20d %20d\n",summe1,summe2);
 if(summe1>=BONUS1) bonus1=35; else bonus1=0;
 if(summe2>=BONUS1) bonus2=35; else bonus2=0;
 printf("Bonus bei >=%d      35P.%13d %20d\n",BONUS1,bonus1,bonus2);
 printf("Teil2\n");
 printf("7. Dreier-Pasch  %20.3s %20.3s\n",txt1(punkte1[6]),txt2(punkte2[6]));
 printf("8. Vierer-Pasch  %20.3s %20.3s\n",txt1(punkte1[7]),txt2(punkte2[7]));
 printf("9. FullHouse        25P.%13.3s %20.3s\n",txt1(punkte1[8]),txt2(punkte2[8]));
 printf("10. Kleine Strasse  30P.%13.3s %20.3s\n",txt1(punkte1[9]),txt2(punkte2[9]));
 printf("11. Grosse Strasse  40P.%13.3s %20.3s\n",txt1(punkte1[10]),txt2(punkte2[10]));
 printf("12. Chance       %20.3s %20.3s\n",txt1(punkte1[11]),txt2(punkte2[11]));
 printf("13. Yatzy           50P.%13.3s %20.3s\n",txt1(punkte1[12]),txt2(punkte2[12]));
 printf("14. 2.Yatzy        100P.%13.3s %20.3s\n",txt1(punkte1[13]),txt2(punkte2[13]));
 for(i=6,summe1=summe2=0;i<14;i++)
  {if(punkte1[i]>=0) summe1+=punkte1[i];if(punkte2[i]>=0) summe2+=punkte2[i];}
 printf("Zweite Zwischensumme:%16d %20d\n",summe1,summe2);
}

int Spielfeld::eintragortsuchen(int wer,int gew[],int hash[],int *wert)
{
 int *pun,i,j;
 pun = (wer==1) ? punkte1 : punkte2;
 if(gew[0]==gew[1] && gew[0]==gew[2] && gew[0]==gew[3] && gew[0]==gew[4])
  {if(pun[12]<0) {*wert=50; return 13;} //Yatzy
   if(pun[13]<0) {*wert=100; return 14;} //2.Yatzy
   if(pun[gew[0]-1]<0) {*wert=5*gew[0]; return gew[0];} //5 gleich im 1.Teil
   if(pun[7]<0) {*wert=4*gew[0]; return 8;} //4er-Pasch
   if(pun[6]<0) {*wert=3*gew[0]; return 7;} //3er-Pasch
   *wert=0; return -1;
  }
 for(i=1;i<=6;i++)
    if(hash[i]==4)
      {if(pun[i-1]<0) {*wert=4*i; return i;}
       if(pun[7]<0) {*wert=4*i; return 8;}
      }
 for(i=1;i<=6;i++)
    if(hash[i]==3)
      {for(j=1;j<=6;j++)
	  if(hash[j]==2 && pun[8]<0) {*wert=25; return 9;} //Full House
       if(pun[i-1]<0) {*wert=3*i; return i;}
       if(pun[6]<0) {*wert=3*i; return 7;}
      }
 for(i=6;i>=1;i--)
    if(hash[i]==2)
      {if(pun[i-1]<0) {*wert=2*i; return i;}
      }
 if(gew[0]==6 && gew[1]==5 && gew[2]==4 && gew[3]==3 && gew[4]==2 && pun[10]<0)
   {*wert=40; return 11;} //Grosse Strasse
 if(gew[0]==5 && gew[1]==4 && gew[2]==3 && gew[3]==2 && gew[4]==1 && pun[9]<0)
   {*wert=30; return 10;} //Kleine Strasse
 *wert=0; return 0;
}

void Spielfeld::endauswertung()
{
 int i,total1=0,total2=0;
 for(i=0;i<14;i++)
  {if(i==6)
      {if(total1>=BONUS1) total1+=35;
       if(total2>=BONUS1) total2+=35;
      }
   total1+=punkte1[i]; total2+=punkte2[i];
  }
 if(total1==total2)
  printf("Es ist unentschieden. Beide haben total %d Punkte.\n",total1);
 else if(total1>total2)
  printf("%s hat mit %d Punkten gewonnen. %s hat %d Punkte.\n",name1,total1,name2,total2);
 else
  printf("%s hat mit %d Punkten gewonnen. %s hat %d Punkte.\n",name2,total2,name1,total1);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char antw[80];
 int i,j,c;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	}
 if(argflag['?'] || j>MAXARG)
	{printf("yatzy  %s\n",VERSION);
	 exit(0);
	}
 printf("Spielregeln anzeigen (ja/nein) ?"); scanf("%s",antw);
 if(*antw=='j' || *antw=='J' || *antw=='y' || *antw=='Y')
  {printf("Es wird jeweils 3 mal mit 5 Wuerfeln gewuerfelt. Im ersten Wurf\n");
   printf("muessen alle geworfen werden. Bei den nachfolgenden Wuerfen kann\n");
   printf("man gute Wuerfel stehen lassen, oder wenn alle gut sind auf weitere\n");
   printf("Wuerfe verzichten. Im 2. Teil gibt es 5 Zusatzpunkte pro\n");
   printf("verzichtetem Wurf.\n");
   printf("Wenn im 1. Teil mindestens %d Punkte erreicht werden gibt es\n",BONUS1);
   printf("noch 35 Bonuspunkte dazu.\n");
   printf("5 gleiche zu erreichen heiss Yatzy und wird mit 50 Punkten belohnt.\n");
   printf("Ein 2. Yatzy gibt 100 Punkte.\n");
   printf("Wenn man nichts vernuenftiges erreicht hat muss eine Aufgabe\n");
   printf("gestrichen werden. (Es werden 0 Punkte eingetragen.) Das 1. Yatzy kann\n");
   printf("man nur streichen wenn das 2. schon gestrichen ist.\n");
  }
 bool compbeginnt;
 Spielfeld brett;
 do {
  printf("Wer soll beginnen? (Comp/Mensch) ?"); scanf("%s",antw);
  c=toupper(*antw);
 } while(c!='C' && c!='M');
 compbeginnt = (c=='C');
 if(compbeginnt) brett.setnamen("Computer","Mensch");
 else {brett.setnamen("Mensch","Computer"); brett.zeichnen();}
 for(j=0;j<14;j++)
  {if(compbeginnt) {brett.computerzug(); brett.menschzug();}
   else {brett.menschzug(); brett.computerzug();}
  }
 brett.endauswertung();
 return 0;
}/* ende von main */

void Spielfeld::computerzug()
{
 int gew[5],hash[7],nr,pu,h,i,nt,wert;
 int *pun;
 pun = (com==1) ? punkte1 : punkte2;
 static int startflag=1;
 if(startflag)
  {double x0;
   FILE *fp=fopen("/dev/urandom","r");
   if(fp==NULL) fp=fopen("/dev/random","r");
   x0=getc(fp)*100+getc(fp)*10+getc(fp);
   fclose(fp);
   zufall4(x0);
   startflag=0;
  }
 for(i=0;i<5;i++) gew[i]=wuerfeln();
 sortieren(gew,hash);
 printf("Computer hat gewuerfelt:"); for(i=0;i<5;i++) printf(" %d",gew[i]); printf("\n");
 nr=eintragortsuchen(com,gew,hash,&wert);
 //printf("test1: eintragortsuchen() --> nr=%d wert=%d\n",nr,wert);
 if(nr>=7) nt=1;
 else
 {if(gew[0]==gew[1] && gew[2]==gew[3] && pun[8]<0) //fast Full House
   {printf("2.Wurf: wuerfle den %d-er nochmal:",gew[4]);
    gew[4]=wuerfeln();
   }
  else if(gew[0]==gew[1] && gew[3]==gew[4] && pun[8]<0)
   {printf("2.Wurf: wuerfle den %d-er nochmal:",gew[2]);
    gew[2]=wuerfeln();
   }
  else if(gew[1]==gew[2] && gew[3]==gew[4] && pun[8]<0)
   {printf("2.Wurf: wuerfle den %d-er nochmal:",gew[0]);
    gew[0]=wuerfeln();
   }
  else if(gew[0]==5 && gew[1]==4 && gew[2]==3 && gew[3]==2 && pun[9]<0 && pun[10]<0) //fast Strasse
   {printf("2.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
    gew[4]=wuerfeln();
   }
  else if(gew[0]==5 && gew[1]==4 && gew[2]==3 && gew[4]==2 && pun[9]<0 && pun[10]<0)
   {printf("2.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
    gew[3]=wuerfeln();
   }
  else if(gew[0]==5 && gew[1]==4 && gew[3]==3 && gew[4]==2 && pun[9]<0 && pun[10]<0)
   {printf("2.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
    gew[2]=wuerfeln();
   }
  else if(gew[0]==5 && gew[2]==4 && gew[3]==3 && gew[4]==2 && pun[9]<0 && pun[10]<0)
   {printf("2.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
    gew[1]=wuerfeln();
   }
  else if(nr>=1 && nr<=6) //Eintrag im 1.Teil noch moeglich
   {printf("2.Wurf: behalte die %d %d-er, wuerfle die andern nochmal:",hash[nr],nr);
    for(i=0;i<hash[nr];i++) gew[i]=nr;
    for(;i<5;i++) gew[i]=wuerfeln();
   }
  else if((pun[12]<0 || pun[13]<0) //ev auf Yatzy spielen
	  && (hash[6]>=2 || hash[5]>=2 || hash[4]>=2 || hash[3]>=2 || hash[2]>=2 || hash[1]>=2))
   {if(hash[6]==3) nr=6;
    else if(hash[5]==3) nr=5;
    else if(hash[4]==3) nr=4;
    else if(hash[3]==3) nr=3;
    else if(hash[2]==3) nr=2;
    else if(hash[1]==3) nr=1;
    else if(hash[6]>=2) nr=6;
    else if(hash[5]>=2) nr=5;
    else if(hash[4]>=2) nr=4;
    else if(hash[3]>=2) nr=3;
    else if(hash[2]>=2) nr=2;
    else nr=1;
    printf("2.Wurf: behalte die %d %d-er, wuerfle die andern nochmal:",hash[nr],nr);
    for(i=0;i<hash[nr];i++) gew[i]=nr;
    for(;i<5;i++) gew[i]=wuerfeln();
   }
  else if((pun[6]<0 || pun[7]<0) //ev auf Pasch spielen
	  && (hash[6]>=2 || hash[5]>=2 || hash[4]>=2 || hash[3]>=2))
   {if(hash[6]==3) nr=6;
    else if(hash[5]==3) nr=5;
    else if(hash[4]==3) nr=4;
    else if(hash[3]==3) nr=3;
    else if(hash[6]>=2) nr=6;
    else if(hash[5]>=2) nr=5;
    else if(hash[4]>=2) nr=4;
    else nr=3;
    printf("2.Wurf: behalte die %d %d-er, wuerfle die andern nochmal:",hash[nr],nr);
    for(i=0;i<hash[nr];i++) gew[i]=nr;
    for(;i<5;i++) gew[i]=wuerfeln();
   }
  else if(pun[6]>=0 && pun[7]>=0 && pun[8]>=0 && pun[9]>=0 && pun[10]>=0
	  && pun[11]>=0 && pun[12]>=0 && pun[13]>=0)
   {for(i=1,nr=0;i<=6;i++)
       if(hash[i]>=1 && pun[i-1]<0) {nr=i; break;}
    if(nr==0) printf("FEHLER1: kann keinen freien Eintrag mehr finden.\n");
    printf("2.Wurf: behalte den %d-er, wuerfle die andern nochmal:",i);
    gew[0]=i;
    for(i=1;i<5;i++) gew[i]=wuerfeln();
   }
  else
   {printf("2.Wurf: wuerfle mit allen nochmal:");
    for(i=0;i<5;i++) gew[i]=wuerfeln();
   }
  sortieren(gew,hash);
  for(i=0;i<5;i++) printf(" %d",gew[i]); printf("\n");
  nr=eintragortsuchen(com,gew,hash,&wert);
  //printf("test2: eintragortsuchen() --> nr=%d wert=%d\n",nr,wert);
  if(nr>=7) nt=2;
  else
   {if(gew[0]==gew[1] && gew[2]==gew[3] && pun[8]<0) //fast Full House
     {printf("3.Wurf: wuerfle den %d-er nochmal:",gew[4]);
      gew[4]=wuerfeln();
     }
    else if(gew[0]==gew[1] && gew[3]==gew[4] && pun[8]<0)
     {printf("3.Wurf: wuerfle den %d-er nochmal:",gew[2]);
      gew[2]=wuerfeln();
     }
    else if(gew[1]==gew[2] && gew[3]==gew[4] && pun[8]<0)
     {printf("3.Wurf: wuerfle den %d-er nochmal:",gew[0]);
      gew[0]=wuerfeln();
     }
    else if(gew[0]==5 && gew[1]==4 && gew[2]==3 && gew[3]==2 && pun[10]<0 && pun[11]<0) //fast Strasse
     {printf("3.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
      gew[4]=wuerfeln();
     }
    else if(gew[0]==5 && gew[1]==4 && gew[2]==3 && gew[4]==2 && pun[10]<0 && pun[11]<0)
     {printf("3.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
      gew[3]=wuerfeln();
     }
    else if(gew[0]==5 && gew[1]==4 && gew[3]==3 && gew[4]==2 && pun[10]<0 && pun[11]<0)
     {printf("3.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
      gew[2]=wuerfeln();
     }
    else if(gew[0]==5 && gew[2]==4 && gew[3]==3 && gew[4]==2 && pun[10]<0 && pun[11]<0)
     {printf("3.Wurf: behalte 5 4 3 2, wuerfle den andern nochmal:");
      gew[1]=wuerfeln();
     }
    else if(nr>=1 && nr<=6) //Eintrag im 1.Teil noch moeglich
     {printf("3.Wurf: behalte die %d %d-er, wuerfle die andern nochmal:",hash[nr],nr);
      for(i=0;i<hash[nr];i++) gew[i]=nr;
      for(;i<5;i++) gew[i]=wuerfeln();
     }
    else if((pun[12]<0 || pun[13]<0) //ev auf Yatzy spielen
	    && (hash[6]>=2 || hash[5]>=2 || hash[4]>=2 || hash[3]>=2 || hash[2]>=2 || hash[1]>=2))
     {if(hash[6]==3) nr=6;
      else if(hash[5]==3) nr=5;
      else if(hash[4]==3) nr=4;
      else if(hash[3]==3) nr=3;
      else if(hash[2]==3) nr=2;
      else if(hash[1]==3) nr=1;
      else if(hash[6]>=2) nr=6;
      else if(hash[5]>=2) nr=5;
      else if(hash[4]>=2) nr=4;
      else if(hash[3]>=2) nr=3;
      else if(hash[2]>=2) nr=2;
      else nr=1;
      printf("3.Wurf: behalte die %d %d-er, wuerfle die andern nochmal:",hash[nr],nr);
      for(i=0;i<hash[nr];i++) gew[i]=nr;
      for(;i<5;i++) gew[i]=wuerfeln();
     }
    else if((pun[6]<0 || pun[7]<0) //ev auf Pasch spielen
	    && (hash[6]>=2 || hash[5]>=2 || hash[4]>=2 || hash[3]>=2))
     {if(hash[6]==3) nr=6;
      else if(hash[5]==3) nr=5;
      else if(hash[4]==3) nr=4;
      else if(hash[3]==3) nr=3;
      else if(hash[6]>=2) nr=6;
      else if(hash[5]>=2) nr=5;
      else if(hash[4]>=2) nr=4;
      else nr=3;
      printf("3.Wurf: behalte die %d %d-er, wuerfle die andern nochmal:",hash[nr],nr);
      for(i=0;i<hash[nr];i++) gew[i]=nr;
      for(;i<5;i++) gew[i]=wuerfeln();
     }
    else if(pun[6]>=0 && pun[7]>=0 && pun[8]>=0 && pun[9]>=0 && pun[10]>=0
	    && pun[11]>=0 && pun[12]>=0 && pun[13]>=0)
     {for(i=1,nr=0;i<=6;i++)
         if(hash[i]>=1 && pun[i-1]<0) {nr=i; break;}
      if(nr==0) printf("FEHLER2: kann keinen freien Eintrag mehr finden.\n");
      printf("3.Wurf: behalte den %d-er, wuerfle die andern nochmal:",i);
      gew[0]=i;
      for(i=1;i<5;i++) gew[i]=wuerfeln();
     }
    else
     {printf("3.Wurf: wuerfle mit allen nochmal:");
      for(i=0;i<5;i++) gew[i]=wuerfeln();
     }
    sortieren(gew,hash);
    for(i=0;i<5;i++) printf(" %d",gew[i]); printf("\n");
    nr=eintragortsuchen(com,gew,hash,&wert);
    nt=3;
   }
 }
 printf("Computer hat also im %d. Wurf dies gewuerfelt:",nt);
 for(i=0;i<5;i++) printf(" %d",gew[i]); printf("\n");
 if(nr>=1 && nr<=14)
  printf("Computer traegt bei Nr %d ein.\n",nr);
 else if(pun[11]<0)
  {nr=12; printf("Computer traegt bei Nr %d ein.\n",nr);}
 else //eine Position streichen
  {do
   {if(pun[6]<0 || pun[7]<0 || pun[8]<0 || pun[9]<0 || pun[10]<0 || pun[12]<0 || pun[13]<0)
      nr=7+int(8.0*zufall4());//provi.
    else nr=1+int(6.0*zufall4());//provi.
    if(nr==13 && pun[13]<0) nr=14;//2.Yatzy muss vor dem 1.Yatzy gestrichen werden
    if(nr==11 && pun[9]<0) nr=10;//lieber zuerst kleine Strasse streichen
    h=pun[nr-1];
   } while(h>=0);
   printf("Computer streicht Nr %d.\n",nr);
  }
 einsetzen(com,nr,gew,hash,nt);
 zeichnen();
}

void Spielfeld::menschzug()
{
 int gew[5],hash[7],nr,nt,h;
 printf("Bitte wuerfeln und die 5 Zahlen eingeben:");
 scanf("%d %d %d %d %d",&gew[0],&gew[1],&gew[2],&gew[3],&gew[4]);
 do {
  printf("Wo eintragen ?"); scanf("%d",&nr);
  if(men==1) h=punkte1[nr-1]; else h=punkte2[nr-1];
  if(h>=0) printf("Dies ist nicht mehr frei\n");
 } while(h>=0);
 if(nr>6) {printf("Im wivielten Wurf erreicht? (1.2.3.) ?"); scanf("%d",&nt);}
 else nt=3;
 sortieren(gew,hash);
 einsetzen(men,nr,gew,hash,nt);
 zeichnen();
}

void Spielfeld::einsetzen(int wer,int nr,int gew[],int hash[],int nt)
{
 int i,j,pu=0;
 if(nr<=6)
  {for(i=0;i<5;i++)
      if(gew[i]==nr) pu+=gew[i];
  }
 else
  {if(nr==7)
    {for(i=1;i<=6;i++) if(hash[i]>=3) {pu=3*i; break;}
    }
   else if(nr==8)
    {for(i=1;i<=6;i++) if(hash[i]>=4) {pu=4*i; break;}
    }
   else if(nr==9) //Full House
    {for(i=1;i<=6;i++)
      if(hash[i]==3)
       {for(j=1;j<=6;j++)
	  if(hash[j]==2) {pu=25; break;}
       }
    }
   else if(nr==10)
    {if(gew[0]==5 && gew[1]==4 && gew[2]==3 && gew[3]==2 && gew[4]==1) pu=30;
    }
   else if(nr==11)
    {if(gew[0]==6 && gew[1]==5 && gew[2]==4 && gew[3]==3 && gew[4]==2) pu=40;
    }
   else if(nr==12)
    {for(i=0;i<5;i++) pu+=gew[i]; //Chance
    }
   else if(nr==13)
    {if(gew[0]==gew[1] && gew[0]==gew[2] && gew[0]==gew[3] && gew[0]==gew[4]) pu=50;
    }
   else if(nr==14)
    {if(gew[0]==gew[1] && gew[0]==gew[2] && gew[0]==gew[3] && gew[0]==gew[4]) pu=100;
    }
   if(nt==1) pu+=10; else if(nt==2) pu+=5;
  }
 if(wer==1) punkte1[nr-1]=pu; else punkte2[nr-1]=pu;
}
